/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meetingroom.service.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.meetingroom.entity.OtMeetingRoomEntity;
import com.bringspring.meetingroom.entity.OtMeetingRoomReservationEntity;
import com.bringspring.meetingroom.mapper.OtMeetingRoomReservationMapper;
import com.bringspring.meetingroom.model.otmeetingroomreservation.OtMeetingRoomReservationCrForm;
import com.bringspring.meetingroom.model.otmeetingroomreservation.OtMeetingRoomReservationListVO;
import com.bringspring.meetingroom.model.otmeetingroomreservation.OtMeetingRoomReservationPagination;
import com.bringspring.meetingroom.model.otmeetingroomreservation.OtMeetingRoomReservationUpForm;
import com.bringspring.meetingroom.service.OtMeetingRoomReservationService;
import com.bringspring.meetingroom.service.OtMeetingRoomService;
import com.bringspring.meetingroom.utils.DateUtils;
import com.bringspring.meetingroom.utils.MeetingConstants;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.visualdev.base.util.GeneraterSwapUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OtMeetingRoomReservationServiceImpl
extends ServiceImpl<OtMeetingRoomReservationMapper, OtMeetingRoomReservationEntity>
implements OtMeetingRoomReservationService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OtMeetingRoomService otMeetingRoomService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private GeneraterSwapUtil generaterSwapUtil;
    @Autowired
    private ServiceAllUtil serviceUtil;

    @Override
    public List<OtMeetingRoomReservationEntity> getList(OtMeetingRoomReservationPagination otMeetingRoomReservationPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int otMeetingRoomReservationNum = 0;
        QueryWrapper otMeetingRoomReservationQueryWrapper = new QueryWrapper();
        boolean otMeetingRoomNum = false;
        QueryWrapper otMeetingRoomQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty(otMeetingRoomReservationPagination.getRegularMeetingIdList())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().in(OtMeetingRoomReservationEntity::getId, otMeetingRoomReservationPagination.getRegularMeetingIdList());
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getEnabledMark())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)otMeetingRoomReservationPagination.getEnabledMark());
        } else {
            otMeetingRoomReservationQueryWrapper.lambda().and(query -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)query.eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.DRAFT_ENABLEDMARK)).eq(OtMeetingRoomReservationEntity::getContactsUserId, (Object)userId)).or()).ne(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.DRAFT_ENABLEDMARK));
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getMeetingTitle())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().like(OtMeetingRoomReservationEntity::getMeetingTitle, (Object)otMeetingRoomReservationPagination.getMeetingTitle());
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getHostingDepartment())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getHostingDepartment, (Object)otMeetingRoomReservationPagination.getHostingDepartment());
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getHostingUserId())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getHostingUserId, (Object)otMeetingRoomReservationPagination.getHostingUserId());
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getMeetingRoomId())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingRoomId, (Object)otMeetingRoomReservationPagination.getMeetingRoomId());
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getShowMeetingType())) {
            ++otMeetingRoomReservationNum;
            if (otMeetingRoomReservationPagination.getShowMeetingType().equals("1")) {
                otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.PASS_ENABLEDMARK);
            }
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getMeetingMode())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingMode, (Object)otMeetingRoomReservationPagination.getMeetingMode());
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getMeetingType())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingType, (Object)otMeetingRoomReservationPagination.getMeetingType());
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getRepetitiveStartTime())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().like(OtMeetingRoomReservationEntity::getRepetitiveStartTime, (Object)otMeetingRoomReservationPagination.getRepetitiveStartTime());
        }
        if (AllIdList.size() > 0) {
            otMeetingRoomReservationQueryWrapper.lambda().in(OtMeetingRoomReservationEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)otMeetingRoomReservationPagination.getSidx())) {
            otMeetingRoomReservationQueryWrapper.lambda().orderByDesc(OtMeetingRoomReservationEntity::getStartTime);
        } else {
            try {
                String sidx = otMeetingRoomReservationPagination.getSidx();
                OtMeetingRoomReservationEntity otMeetingRoomReservationEntity = new OtMeetingRoomReservationEntity();
                Field declaredField = otMeetingRoomReservationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                otMeetingRoomReservationQueryWrapper = "asc".equals(otMeetingRoomReservationPagination.getSort().toLowerCase()) ? (QueryWrapper)otMeetingRoomReservationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)otMeetingRoomReservationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(otMeetingRoomReservationPagination.getCurrentPage(), otMeetingRoomReservationPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingRoomReservationQueryWrapper);
            return otMeetingRoomReservationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return otMeetingRoomReservationPagination.setData(list, list.size());
    }

    @Override
    public List<OtMeetingRoomReservationEntity> getTypeList(OtMeetingRoomReservationPagination otMeetingRoomReservationPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int otMeetingRoomReservationNum = 0;
        QueryWrapper otMeetingRoomReservationQueryWrapper = new QueryWrapper();
        boolean otMeetingRoomNum = false;
        QueryWrapper otMeetingRoomQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getMeetingTitle())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().like(OtMeetingRoomReservationEntity::getMeetingTitle, (Object)otMeetingRoomReservationPagination.getMeetingTitle());
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getHostingDepartment())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getHostingDepartment, (Object)otMeetingRoomReservationPagination.getHostingDepartment());
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getHostingUserId())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getHostingUserId, (Object)otMeetingRoomReservationPagination.getHostingUserId());
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getMeetingType())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingType, (Object)otMeetingRoomReservationPagination.getMeetingType());
        }
        if (StringUtil.isNotEmpty((String)otMeetingRoomReservationPagination.getRepetitiveStartTime())) {
            ++otMeetingRoomReservationNum;
            otMeetingRoomReservationQueryWrapper.lambda().like(OtMeetingRoomReservationEntity::getRepetitiveStartTime, (Object)otMeetingRoomReservationPagination.getRepetitiveStartTime());
        }
        if (AllIdList.size() > 0) {
            otMeetingRoomReservationQueryWrapper.lambda().in(OtMeetingRoomReservationEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)otMeetingRoomReservationPagination.getSidx())) {
            otMeetingRoomReservationQueryWrapper.lambda().orderByDesc(OtMeetingRoomReservationEntity::getRepetitiveStartTime);
        } else {
            try {
                String sidx = otMeetingRoomReservationPagination.getSidx();
                OtMeetingRoomReservationEntity otMeetingRoomReservationEntity = new OtMeetingRoomReservationEntity();
                Field declaredField = otMeetingRoomReservationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                otMeetingRoomReservationQueryWrapper = "asc".equals(otMeetingRoomReservationPagination.getSort().toLowerCase()) ? (QueryWrapper)otMeetingRoomReservationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)otMeetingRoomReservationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(otMeetingRoomReservationPagination.getCurrentPage(), otMeetingRoomReservationPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingRoomReservationQueryWrapper);
                return otMeetingRoomReservationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return otMeetingRoomReservationPagination.setData(list, list.size());
        }
        return this.list((Wrapper)otMeetingRoomReservationQueryWrapper);
    }

    @Override
    public OtMeetingRoomReservationEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getId, (Object)id);
        return (OtMeetingRoomReservationEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OtMeetingRoomReservationEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OtMeetingRoomReservationEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OtMeetingRoomReservationEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public OtMeetingRoomEntity getOtMeetingRoom(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingRoomEntity::getId, (Object)id);
        return (OtMeetingRoomEntity)this.otMeetingRoomService.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void sendMessage(List<String> userId, String title, String content, String url) throws Exception {
        List collect = userId.stream().distinct().collect(Collectors.toList());
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(Integer.valueOf(20));
        sentMessageForm.setToUserIds(collect);
        try {
            sentMessageForm.setTemplateId(this.sysConfigService.getConfigByKeyName("meetingMessage").getKeyValue());
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        sentMessageForm.setTitle("\u7ad9\u5185\u4fe1\u6807\u9898");
        sentMessageForm.setContent("\u7ad9\u5185\u4fe1\u5185\u5bb9");
        sentMessageForm.setBodyText(new HashMap());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", title);
        map.put("content", content);
        try {
            map.put("AppUrl", this.sysConfigService.getConfigByKeyName("qyhMobileUrl").getKeyValue() + url);
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        sentMessageForm.setParameterMap(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
        this.serviceUtil.sendMessage(messageListAll);
    }

    @Override
    public List<OtMeetingRoomReservationEntity> getNotExpireListByMeetingRoomId(String meetingRoomId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("30");
        arrayList.add("20");
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingRoomId, (Object)meetingRoomId)).in(OtMeetingRoomReservationEntity::getEnabledMark, arrayList);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OtMeetingRoomReservationEntity> getNotExpireList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("30");
        arrayList.add("20");
        queryWrapper.lambda().in(OtMeetingRoomReservationEntity::getEnabledMark, arrayList);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OtMeetingRoomReservationEntity> getListByMeetingRoomId(String meetingRoomId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingRoomId, (Object)meetingRoomId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void scheduledupdateEnabledMark() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(query -> ((LambdaQueryWrapper)((LambdaQueryWrapper)query.eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)30)).or()).eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)20));
        queryWrapper.lambda().lt(OtMeetingRoomReservationEntity::getEndTime, (Object)DateUtil.getNow());
        List list = this.list((Wrapper)queryWrapper);
        if (StringUtil.isNotEmpty((Collection)list)) {
            for (OtMeetingRoomReservationEntity otMeetingRoomReservationEntity : list) {
                otMeetingRoomReservationEntity.setEnabledMark(50);
            }
            this.updateBatchById(list);
        }
    }

    @Override
    public void scheduledMeetingMessage() {
        Date dayBegin = DateUtil.getDayBegin();
        Date dayEnd = DateUtil.getDayEnd();
        OtMeetingRoomReservationPagination pagination = new OtMeetingRoomReservationPagination();
        ArrayList<String> dateList = new ArrayList<String>();
        dateList.add(String.valueOf(dayBegin.getTime()));
        dateList.add(String.valueOf(dayEnd.getTime()));
        pagination.setAllDateScoped(dateList);
        pagination.setCurrentPage(1L);
        pagination.setPageSize(100L);
        pagination.setEnabledMark(MeetingConstants.PASS_ENABLEDMARK);
        pagination.setMenuId(MeetingConstants.MENU_ID);
        List<OtMeetingRoomReservationListVO> listByDateScope = this.getListByDateScope(pagination);
        ArrayList<String> userIds = new ArrayList<String>();
        if (StringUtil.isNotEmpty(listByDateScope)) {
            for (OtMeetingRoomReservationListVO reservationListVO : listByDateScope) {
                String ids = reservationListVO.getParticipantsUserIds();
                ids = ids.replaceAll("\"", "").replace("[", "").replace("]", "");
                String[] split = ids.split(",");
                List jsonToList = JsonUtil.getJsonToList((Object)split, String.class);
                userIds.addAll(jsonToList);
            }
        }
        String url = "/#/pages/work-order/work-order-accept/index";
        this.sendMessage(userIds, "\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bae\u9700\u8981\u53c2\u52a0", "content", url);
    }

    public static void main(String[] args) {
    }

    @Override
    public List<OtMeetingRoomReservationListVO> getListByDateScope(OtMeetingRoomReservationPagination otMeetingRoomReservationPagination) {
        List<String> regularMeetingByTime;
        if (StringUtil.isNotEmpty(otMeetingRoomReservationPagination.getAllDateScoped()) && StringUtil.isNotEmpty(regularMeetingByTime = this.getRegularMeetingByTime(otMeetingRoomReservationPagination.getAllDateScoped()))) {
            otMeetingRoomReservationPagination.setRegularMeetingIdList(regularMeetingByTime);
        }
        List<OtMeetingRoomReservationEntity> list = this.getList(otMeetingRoomReservationPagination);
        List listVO = JsonUtil.getJsonToList(list, OtMeetingRoomReservationListVO.class);
        return listVO;
    }

    @Override
    public List<OtMeetingRoomReservationEntity> getNotExpireRegularList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getMeetingMode, (Object)MeetingConstants.MEETING_MODE)).ne(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.EXPIRE_ENABLEDMARK);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Boolean judgeOriginaryTimeConflict(OtMeetingRoomReservationEntity entity) {
        List<OtMeetingRoomReservationEntity> notExpireMeetingList = this.getNotExpireListByMeetingRoomId(entity.getMeetingRoomId());
        if (StringUtil.isEmpty(notExpireMeetingList)) {
            return false;
        }
        for (OtMeetingRoomReservationEntity otMeetingEntity : notExpireMeetingList) {
            if (MeetingConstants.MEETING_MODE.equals(otMeetingEntity.getMeetingMode())) {
                OtMeetingRoomReservationCrForm crForm = (OtMeetingRoomReservationCrForm)JsonUtil.getJsonToBean((Object)otMeetingEntity, OtMeetingRoomReservationCrForm.class);
                List<Date> dateList = this.getRegularMeetingTimeList(otMeetingEntity);
                if (!StringUtil.isNotEmpty(dateList)) continue;
                for (Date date : dateList) {
                    Date startTime = DateUtil.stringToDate((String)(DateUtil.daFormat((Date)date) + " " + crForm.getRepetitiveStartTime()));
                    Date endTime = DateUtil.stringToDate((String)(DateUtil.daFormat((Date)date) + " " + crForm.getRepetitiveEndTime()));
                    boolean b = DateUtils.hasOverlap(entity.getStartTime(), entity.getEndTime(), startTime, endTime);
                    if (!b) continue;
                    return true;
                }
                continue;
            }
            boolean b = DateUtils.hasOverlap(otMeetingEntity.getStartTime(), otMeetingEntity.getEndTime(), entity.getStartTime(), entity.getEndTime());
            if (!b) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean judgeRegularTimeConflict(OtMeetingRoomReservationEntity entity) {
        List<OtMeetingRoomReservationEntity> notExpireMeetingList = this.getNotExpireListByMeetingRoomId(entity.getMeetingRoomId());
        if (StringUtil.isEmpty(notExpireMeetingList)) {
            return false;
        }
        OtMeetingRoomReservationCrForm crForm = (OtMeetingRoomReservationCrForm)JsonUtil.getJsonToBean((Object)entity, OtMeetingRoomReservationCrForm.class);
        List<Date> dateList = this.getRegularMeetingTimeList(entity);
        if (StringUtil.isNotEmpty(dateList)) {
            for (Date date : dateList) {
                Date startTime = DateUtil.stringToDate((String)(DateUtil.daFormat((Date)date) + " " + crForm.getRepetitiveStartTime()));
                Date endTime = DateUtil.stringToDate((String)(DateUtil.daFormat((Date)date) + " " + crForm.getRepetitiveEndTime()));
                OtMeetingRoomReservationEntity entityOne = new OtMeetingRoomReservationEntity();
                entityOne.setStartTime(startTime);
                entityOne.setEndTime(endTime);
                entityOne.setRepetitiveStartTime(entity.getRepetitiveStartTime());
                entityOne.setRepetitiveEndTime(entity.getRepetitiveEndTime());
                entityOne.setMeetingMode(MeetingConstants.ORIGINARY_MEETING);
                Boolean aBoolean = this.judgeOriginaryTimeConflict(entityOne);
                if (!aBoolean.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Date> getRegularMeetingTimeList(OtMeetingRoomReservationEntity entity) {
        OtMeetingRoomReservationCrForm crForm = (OtMeetingRoomReservationCrForm)JsonUtil.getJsonToBean((Object)entity, OtMeetingRoomReservationCrForm.class);
        List<Date> dateList = new ArrayList<Date>();
        switch (entity.getRepetitiveMode()) {
            case "W": {
                List<String> dayOfWeekWithinDateInterval = DateUtils.getDayOfWeekWithinDateInterval(crForm.getStartTime(), crForm.getEndTime(), Integer.valueOf(crForm.getRepetitiveInterval()));
                for (String s : dayOfWeekWithinDateInterval) {
                    dateList.add(DateUtil.stringToDates((String)s));
                }
                break;
            }
            case "D": {
                dateList = DateUtils.dateAddDaysBetweenDate(crForm.getStartTime(), crForm.getEndTime(), Integer.valueOf(crForm.getRepetitiveInterval()));
                break;
            }
            case "M": {
                dateList = DateUtils.dateMonthBetweenDate(crForm.getStartTime(), crForm.getEndTime(), Integer.valueOf(crForm.getRepetitiveInterval()));
            }
        }
        return dateList;
    }

    @Override
    public List<String> getRegularMeetingByTime(List<String> allDateScoped) {
        List<OtMeetingRoomReservationEntity> notExpireRegularList = this.getNotExpireList();
        Date fir = new Date(Long.valueOf(allDateScoped.get(0)));
        Date sec = new Date(Long.valueOf(allDateScoped.get(1)));
        ArrayList<String> list = new ArrayList<String>();
        for (OtMeetingRoomReservationEntity reservationEntity : notExpireRegularList) {
            OtMeetingRoomReservationCrForm crForm = (OtMeetingRoomReservationCrForm)JsonUtil.getJsonToBean((Object)reservationEntity, OtMeetingRoomReservationCrForm.class);
            if (MeetingConstants.MEETING_MODE.equals(reservationEntity.getMeetingMode())) {
                List<Date> regularMeetingTimeList = this.getRegularMeetingTimeList(reservationEntity);
                for (Date date : regularMeetingTimeList) {
                    Date startTime = DateUtil.stringToDate((String)(DateUtil.daFormat((Date)date) + " " + crForm.getRepetitiveStartTime()));
                    if (!startTime.after(fir) || !startTime.before(sec)) continue;
                    list.add(reservationEntity.getId());
                }
                continue;
            }
            if (!reservationEntity.getStartTime().after(fir) || !reservationEntity.getStartTime().before(sec)) continue;
            list.add(reservationEntity.getId());
        }
        return list;
    }

    @Override
    public List<String> getMyselfMeetingList() {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getEnabledMark, (Object)MeetingConstants.PASS_ENABLEDMARK);
        List list = this.list((Wrapper)queryWrapper);
        ArrayList<String> userIds = new ArrayList<String>();
        for (OtMeetingRoomReservationEntity reservationEntity : list) {
            List jsonToList;
            if (!StringUtil.isNotEmpty((String)reservationEntity.getParticipantsUserIds()) || !(jsonToList = JsonUtil.getJsonToList((String)reservationEntity.getParticipantsUserIds(), String.class)).contains(userInfo.getId())) continue;
            userIds.add(reservationEntity.getId());
        }
        return userIds;
    }

    @Override
    public OtMeetingRoomReservationEntity approveMeeting(OtMeetingRoomReservationUpForm otMeetingRoomReservationUpForm) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingRoomReservationEntity::getId, (Object)otMeetingRoomReservationUpForm.getId());
        OtMeetingRoomReservationEntity one = (OtMeetingRoomReservationEntity)this.getOne((Wrapper)queryWrapper);
        one.setEnabledMark(Integer.valueOf(otMeetingRoomReservationUpForm.getEnabledMark()));
        return one;
    }
}

