/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsEmployeArchiveEducationEntity;
import com.bringspring.hrms.model.hrmsemployearchiveeducation.HrmsEmployeArchiveEducationCrForm;
import com.bringspring.hrms.model.hrmsemployearchiveeducation.HrmsEmployeArchiveEducationInfoVO;
import com.bringspring.hrms.model.hrmsemployearchiveeducation.HrmsEmployeArchiveEducationListVO;
import com.bringspring.hrms.model.hrmsemployearchiveeducation.HrmsEmployeArchiveEducationPagination;
import com.bringspring.hrms.model.hrmsemployearchiveeducation.HrmsEmployeArchiveEducationUpForm;
import com.bringspring.hrms.service.HrmsEmployeArchiveEducationService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5458\u5de5\u6863\u6848\u6559\u80b2"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaArchiveEducation"})
public class HrmsEmployeArchiveEducationController {
    private static final Logger log = LoggerFactory.getLogger(HrmsEmployeArchiveEducationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsEmployeArchiveEducationService hrmsEmployeArchiveEducationService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsEmployeArchiveEducationPagination hrmsEmployeArchiveEducationPagination) throws IOException {
        List<HrmsEmployeArchiveEducationEntity> list = this.hrmsEmployeArchiveEducationService.getList(hrmsEmployeArchiveEducationPagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsEmployeArchiveEducationListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsEmployeArchiveEducationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid HrmsEmployeArchiveEducationCrForm hrmsEmployeArchiveEducationCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsEmployeArchiveEducationEntity entity = (HrmsEmployeArchiveEducationEntity)JsonUtil.getJsonToBean((Object)hrmsEmployeArchiveEducationCrForm, HrmsEmployeArchiveEducationEntity.class);
        entity.setId(mainId);
        this.hrmsEmployeArchiveEducationService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsEmployeArchiveEducationInfoVO> info(@PathVariable(value="id") String id) {
        HrmsEmployeArchiveEducationEntity entity = this.hrmsEmployeArchiveEducationService.getInfo(id);
        HrmsEmployeArchiveEducationInfoVO vo = (HrmsEmployeArchiveEducationInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsEmployeArchiveEducationInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<HrmsEmployeArchiveEducationInfoVO> detailInfo(@PathVariable(value="id") String id) {
        HrmsEmployeArchiveEducationEntity entity = this.hrmsEmployeArchiveEducationService.getInfo(id);
        HrmsEmployeArchiveEducationInfoVO vo = (HrmsEmployeArchiveEducationInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsEmployeArchiveEducationInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid HrmsEmployeArchiveEducationUpForm hrmsEmployeArchiveEducationUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        HrmsEmployeArchiveEducationEntity entity = this.hrmsEmployeArchiveEducationService.getInfo(id);
        if (entity != null) {
            HrmsEmployeArchiveEducationEntity subentity = (HrmsEmployeArchiveEducationEntity)JsonUtil.getJsonToBean((Object)hrmsEmployeArchiveEducationUpForm, HrmsEmployeArchiveEducationEntity.class);
            this.hrmsEmployeArchiveEducationService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsEmployeArchiveEducationEntity entity = this.hrmsEmployeArchiveEducationService.getInfo(id);
        if (entity != null) {
            this.hrmsEmployeArchiveEducationService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

