/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.hrms.entity.HrmsEmployeArchiveEducationEntity;
import com.bringspring.hrms.entity.HrmsManagerEntryCompanyEntity;
import com.bringspring.hrms.model.hrmsemployearchiveeducation.HrmsEmployeArchiveEducationCrForm;
import com.bringspring.hrms.model.hrmsmanagerentrycompany.HrmsManagerEntryCompanyCrForm;
import com.bringspring.hrms.model.hrmsmanagerentrycompany.HrmsManagerEntryCompanyListVO;
import com.bringspring.hrms.model.hrmsmanagerentrycompany.HrmsManagerEntryCompanyPagination;
import com.bringspring.hrms.model.hrmsmanagerentrycompany.HrmsManagerEntryCompanyPaginationExportModel;
import com.bringspring.hrms.service.HrmsEmployeArchiveEducationService;
import com.bringspring.hrms.service.HrmsManagerEntryCompanyService;
import com.bringspring.hrms.util.EmployeeStatusEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5165\u804c\u7533\u8bf7\u8868"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaEntryCompany"})
public class HrmsManagerEntryCompanyController {
    private static final Logger log = LoggerFactory.getLogger(HrmsManagerEntryCompanyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsManagerEntryCompanyService hrmsManagerEntryCompanyService;
    @Autowired
    private HrmsEmployeArchiveEducationService hrmsEmployeArchiveEducationService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsManagerEntryCompanyPagination hrmsManagerEntryCompanyPagination) throws IOException {
        List<HrmsManagerEntryCompanyEntity> list = this.hrmsManagerEntryCompanyService.getList(hrmsManagerEntryCompanyPagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsManagerEntryCompanyListVO.class);
        for (HrmsManagerEntryCompanyListVO vo : listVO) {
            vo.setGender(this.baseDataUtil.getDictName(vo.getGender(), "sex"));
            vo.setOrganizeId(this.baseDataUtil.comSelectValues(vo.getOrganizeId()));
            vo.setPositionId(this.baseDataUtil.posSelectValues(vo.getPositionId()));
            vo.setEmployeeType(this.baseDataUtil.getDictName(vo.getEmployeeType(), "userType"));
            vo.setApproveLeader(this.baseDataUtil.userSelectValues(vo.getApproveLeader()));
            vo.setRecruitQuarter(this.baseDataUtil.getDictName(vo.getRecruitQuarter(), null));
            vo.setEntryType(this.baseDataUtil.getDictName(vo.getEntryType(), null));
            vo.setEntryChannel(this.baseDataUtil.getDictName(vo.getEntryChannel(), null));
            vo.setBandLevel(this.baseDataUtil.getDictName(vo.getBandLevel(), null));
            vo.setFirstTryUser(this.baseDataUtil.userSelectValues(vo.getFirstTryUser()));
            vo.setSecondTryUser(this.baseDataUtil.userSelectValues(vo.getSecondTryUser()));
            vo.setFlowStateName(EmployeeStatusEnum.getNameByCode(vo.getFlowStateEnable()));
            vo.setEntryCompany(this.baseDataUtil.comSelectValues(vo.getEntryCompany()));
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerEntryCompanyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsManagerEntryCompanyCrForm hrmsManagerEntryCompanyCrForm = (HrmsManagerEntryCompanyCrForm)((Object)JsonUtil.getJsonToBean(crData, HrmsManagerEntryCompanyCrForm.class));
        String flowEngineId = "503896216543916357";
        if (StringUtils.isNotEmpty((String)hrmsManagerEntryCompanyCrForm.getFlowId())) {
            flowEngineId = hrmsManagerEntryCompanyCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsManagerEntryCompanyEntity entity = (HrmsManagerEntryCompanyEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerEntryCompanyCrForm), HrmsManagerEntryCompanyEntity.class);
        entity.setId(mainId);
        this.hrmsManagerEntryCompanyService.save(entity);
        if (!ObjectUtil.isEmpty(hrmsManagerEntryCompanyCrForm.getEducateList())) {
            List<HrmsEmployeArchiveEducationCrForm> educateList = hrmsManagerEntryCompanyCrForm.getEducateList();
            educateList.stream().forEach(v -> {
                v.setArchiveId(mainId);
                v.setId(RandomUtil.uuId());
                v.setFile(v.getFileList().toString());
            });
            List jsonToList = JsonUtil.getJsonToList(educateList, HrmsEmployeArchiveEducationEntity.class);
            this.hrmsEmployeArchiveEducationService.saveOrUpdateBatch(jsonToList);
        }
        FlowUtil.saveOrSubmit((String)hrmsManagerEntryCompanyCrForm.getTaskId(), (String)flowEngineId, (String)hrmsManagerEntryCompanyCrForm.getTemplateId(), (String)mainId, (Object)((Object)hrmsManagerEntryCompanyCrForm), (Integer)hrmsManagerEntryCompanyCrForm.getStatus(), (String)hrmsManagerEntryCompanyCrForm.getName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(HrmsManagerEntryCompanyPaginationExportModel hrmsManagerEntryCompanyPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)hrmsManagerEntryCompanyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        HrmsManagerEntryCompanyPagination hrmsManagerEntryCompanyPagination = (HrmsManagerEntryCompanyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerEntryCompanyPaginationExportModel), HrmsManagerEntryCompanyPagination.class));
        List<HrmsManagerEntryCompanyEntity> list = this.hrmsManagerEntryCompanyService.getTypeList(hrmsManagerEntryCompanyPagination, hrmsManagerEntryCompanyPaginationExportModel.getDataType());
        for (HrmsManagerEntryCompanyEntity entity : list) {
            entity.setGender(this.baseDataUtil.getDictName(entity.getGender(), null));
            entity.setOrganizeId(this.baseDataUtil.comSelectValues(entity.getOrganizeId()));
            entity.setPositionId(this.baseDataUtil.posSelectValues(entity.getPositionId()));
            entity.setEmployeeType(this.baseDataUtil.getDictName(entity.getEmployeeType(), null));
            entity.setApproveLeader(this.baseDataUtil.userSelectValues(entity.getApproveLeader()));
            entity.setRecruitQuarter(this.baseDataUtil.getDictName(entity.getRecruitQuarter(), null));
            entity.setEntryType(this.baseDataUtil.getDictName(entity.getEntryType(), null));
            entity.setEntryChannel(this.baseDataUtil.getDictName(entity.getEntryChannel(), null));
            entity.setBandLevel(this.baseDataUtil.getDictName(entity.getBandLevel(), null));
            entity.setFirstTryUser(this.baseDataUtil.userSelectValues(entity.getFirstTryUser()));
            entity.setSecondTryUser(this.baseDataUtil.userSelectValues(entity.getSecondTryUser()));
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsManagerEntryCompanyListVO.class);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)hrmsManagerEntryCompanyPaginationExportModel.getSelectKey()) ? hrmsManagerEntryCompanyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block94: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u59d3\u540d", (Object)"name"));
                        continue block94;
                    }
                    case "gender": {
                        entitys.add(new ExcelExportEntity("\u6027\u522b", (Object)"gender"));
                        continue block94;
                    }
                    case "entryDate": {
                        entitys.add(new ExcelExportEntity("\u5165\u804c\u65e5\u671f", (Object)"entryDate"));
                        continue block94;
                    }
                    case "organizeId": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"organizeId"));
                        continue block94;
                    }
                    case "positionId": {
                        entitys.add(new ExcelExportEntity("\u5c97\u4f4d", (Object)"positionId"));
                        continue block94;
                    }
                    case "employeeType": {
                        entitys.add(new ExcelExportEntity("\u5458\u5de5\u7c7b\u578b", (Object)"employeeType"));
                        continue block94;
                    }
                    case "approveLeader": {
                        entitys.add(new ExcelExportEntity("\u5165\u804c\u5ba1\u6279\u9886\u5bfc", (Object)"approveLeader"));
                        continue block94;
                    }
                    case "entryCompany": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u8ba2\u516c\u53f8", (Object)"entryCompany"));
                        continue block94;
                    }
                    case "recruitYear": {
                        entitys.add(new ExcelExportEntity("\u62db\u8058\u7533\u8bf7\u5e74\u4efd", (Object)"recruitYear"));
                        continue block94;
                    }
                    case "recruitQuarter": {
                        entitys.add(new ExcelExportEntity("\u62db\u8058\u7533\u8bf7\u5b63\u5ea6", (Object)"recruitQuarter"));
                        continue block94;
                    }
                    case "organizeNumber": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8\u73b0\u6709\u4eba\u6570", (Object)"organizeNumber"));
                        continue block94;
                    }
                    case "organizeMadeNumber": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8\u5b9a\u7f16\u4eba\u6570", (Object)"organizeMadeNumber"));
                        continue block94;
                    }
                    case "entryType": {
                        entitys.add(new ExcelExportEntity("\u5f55\u7528\u6027\u8d28", (Object)"entryType"));
                        continue block94;
                    }
                    case "entryChannel": {
                        entitys.add(new ExcelExportEntity("\u5f55\u7528\u6e20\u9053", (Object)"entryChannel"));
                        continue block94;
                    }
                    case "planEntryDate": {
                        entitys.add(new ExcelExportEntity("\u62df\u5165\u804c\u65e5\u671f", (Object)"planEntryDate"));
                        continue block94;
                    }
                    case "probationPeriod": {
                        entitys.add(new ExcelExportEntity("\u8bd5\u7528\u671f\u9650", (Object)"probationPeriod"));
                        continue block94;
                    }
                    case "band": {
                        entitys.add(new ExcelExportEntity("\u7b49\u7ea7", (Object)"band"));
                        continue block94;
                    }
                    case "trueEntryDate": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u5165\u804c\u65e5\u671f", (Object)"trueEntryDate"));
                        continue block94;
                    }
                    case "firstTryUser": {
                        entitys.add(new ExcelExportEntity("\u521d\u8bd5\u4eba\u5458", (Object)"firstTryUser"));
                        continue block94;
                    }
                    case "secondTryUser": {
                        entitys.add(new ExcelExportEntity("\u590d\u8bd5\u4eba\u5458", (Object)"secondTryUser"));
                        continue block94;
                    }
                    case "firstTryDate": {
                        entitys.add(new ExcelExportEntity("\u521d\u8bd5\u65f6\u95f4", (Object)"firstTryDate"));
                        continue block94;
                    }
                    case "secondTryDate": {
                        entitys.add(new ExcelExportEntity("\u590d\u8bd5\u65f6\u95f4", (Object)"secondTryDate"));
                        continue block94;
                    }
                    case "firstTryDescription": {
                        entitys.add(new ExcelExportEntity("\u521d\u8bd5\u5907\u6ce8", (Object)"firstTryDescription"));
                        continue block94;
                    }
                    case "secondTryDescription": {
                        entitys.add(new ExcelExportEntity("\u590d\u8bd5\u5907\u6ce8", (Object)"secondTryDescription"));
                        continue block94;
                    }
                    case "trialMoney": {
                        entitys.add(new ExcelExportEntity("\u8bd5\u7528\u85aa\u8d44", (Object)"trialMoney"));
                        continue block94;
                    }
                    case "formalMoney": {
                        entitys.add(new ExcelExportEntity("\u6b63\u5f0f\u85aa\u8d44", (Object)"formalMoney"));
                        continue block94;
                    }
                    case "school": {
                        entitys.add(new ExcelExportEntity("\u6bd5\u4e1a\u5b66\u6821", (Object)"school"));
                        continue block94;
                    }
                    case "education": {
                        entitys.add(new ExcelExportEntity("\u5b66\u5386", (Object)"education"));
                        continue block94;
                    }
                    case "major": {
                        entitys.add(new ExcelExportEntity("\u4e13\u4e1a", (Object)"major"));
                        continue block94;
                    }
                    case "graduationTime": {
                        entitys.add(new ExcelExportEntity("\u6bd5\u4e1a\u65f6\u95f4", (Object)"graduationTime"));
                        continue block94;
                    }
                    case "fieldDate": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u4e60\u622a\u6b62\u65e5", (Object)"fieldDate"));
                        continue block94;
                    }
                    case "trialDate": {
                        entitys.add(new ExcelExportEntity("\u8bd5\u7528\u622a\u6b62\u65e5", (Object)"trialDate"));
                        continue block94;
                    }
                    case "oldCompany": {
                        entitys.add(new ExcelExportEntity("\u539f\u5355\u4f4d", (Object)"oldCompany"));
                        continue block94;
                    }
                    case "address": {
                        entitys.add(new ExcelExportEntity("\u6237\u53e3\u6240\u5728\u5730", (Object)"address"));
                        continue block94;
                    }
                    case "pEmail": {
                        entitys.add(new ExcelExportEntity("\u79c1\u4eba\u90ae\u7bb1", (Object)"pEmail"));
                        continue block94;
                    }
                    case "tPhone": {
                        entitys.add(new ExcelExportEntity("\u7535\u8bdd", (Object)"tPhone"));
                        continue block94;
                    }
                    case "mPhone": {
                        entitys.add(new ExcelExportEntity("\u624b\u673a", (Object)"mPhone"));
                        continue block94;
                    }
                    case "cEmail": {
                        entitys.add(new ExcelExportEntity("\u516c\u53f8\u90ae\u7bb1", (Object)"cEmail"));
                        continue block94;
                    }
                    case "personCode": {
                        entitys.add(new ExcelExportEntity("\u5de5\u53f7", (Object)"personCode"));
                        continue block94;
                    }
                    case "oaAccount": {
                        entitys.add(new ExcelExportEntity("oa\u8d26\u53f7", (Object)"oaAccount"));
                        continue block94;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block94;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsManagerEntryCompanyCrForm> info(@PathVariable(value="id") String id) {
        HrmsManagerEntryCompanyEntity entity = this.hrmsManagerEntryCompanyService.getInfo(id);
        HrmsManagerEntryCompanyCrForm vo = (HrmsManagerEntryCompanyCrForm)((Object)JsonUtil.getJsonToBean((Object)entity, HrmsManagerEntryCompanyCrForm.class));
        List<HrmsEmployeArchiveEducationEntity> listByEducate = this.hrmsEmployeArchiveEducationService.getListByArchive(id);
        List listByEducateVO = JsonUtil.getJsonToList(listByEducate, HrmsEmployeArchiveEducationCrForm.class);
        ArrayList<HrmsManagerEntryCompanyCrForm> archiveEducationCrForms = new ArrayList<HrmsManagerEntryCompanyCrForm>();
        archiveEducationCrForms.add(vo);
        this.hrmsEmployeArchiveEducationService.getNameByCodeEdu(listByEducateVO);
        this.hrmsEmployeArchiveEducationService.getNameByCode(archiveEducationCrForms);
        vo.setEducateList(listByEducateVO);
        vo.setTrialMoneyUnitName(this.baseDataUtil.getDictName(vo.getTrialMoneyUnit(), "moneyUnitOptions"));
        vo.setFormalMoneyUnitName(this.baseDataUtil.getDictName(vo.getFormalMoneyUnit(), "moneyUnitOptions"));
        if (StringUtils.isNotEmpty((String)vo.getOrganizeId())) {
            vo.setOrganizeTree(this.organizeService.getInfo(vo.getOrganizeId()).getOrganizeIdTree());
        }
        return ActionResult.success((Object)((Object)vo));
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsManagerEntryCompanyCrForm hrmsManagerEntryCompanyCrForm = (HrmsManagerEntryCompanyCrForm)((Object)JsonUtil.getJsonToBean(upData, HrmsManagerEntryCompanyCrForm.class));
        String flowEngineId = "503896216543916357";
        if (StringUtils.isNotEmpty((String)hrmsManagerEntryCompanyCrForm.getFlowId())) {
            flowEngineId = hrmsManagerEntryCompanyCrForm.getFlowId();
        }
        UserInfo userInfo = this.userProvider.get();
        HrmsManagerEntryCompanyEntity entity = this.hrmsManagerEntryCompanyService.getInfo(id);
        if (entity != null) {
            HrmsManagerEntryCompanyEntity subentity = (HrmsManagerEntryCompanyEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerEntryCompanyCrForm), HrmsManagerEntryCompanyEntity.class);
            this.hrmsManagerEntryCompanyService.update(id, subentity);
            if (!ObjectUtil.isEmpty(hrmsManagerEntryCompanyCrForm.getEducateList())) {
                List<HrmsEmployeArchiveEducationCrForm> educateList = hrmsManagerEntryCompanyCrForm.getEducateList();
                educateList.stream().forEach(v -> {
                    v.setArchiveId(id);
                    if (ObjectUtil.isEmpty((Object)v.getId())) {
                        v.setId(RandomUtil.uuId());
                        v.setFile(v.getFileList().toString());
                    }
                });
                List jsonToList = JsonUtil.getJsonToList(educateList, HrmsEmployeArchiveEducationEntity.class);
                this.hrmsEmployeArchiveEducationService.saveOrUpdateBatch(jsonToList);
            }
            FlowUtil.saveOrSubmit((String)hrmsManagerEntryCompanyCrForm.getTaskId(), (String)flowEngineId, (String)hrmsManagerEntryCompanyCrForm.getTemplateId(), (String)id, (Object)((Object)hrmsManagerEntryCompanyCrForm), (Integer)hrmsManagerEntryCompanyCrForm.getStatus(), (String)hrmsManagerEntryCompanyCrForm.getName());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/confirmEntry"})
    @DSTransactional
    public ActionResult confirmEntry(@RequestBody @Valid HrmsManagerEntryCompanyCrForm companyCrForm) throws DataException {
        this.hrmsManagerEntryCompanyService.confirmEntry(companyCrForm);
        return ActionResult.success((String)"\u5165\u804c\u6210\u529f");
    }

    @GetMapping(value={"/cancelEntry/{id}"})
    @DSTransactional
    public ActionResult cancelEntry(@PathVariable(value="id") String id) throws DataException {
        this.hrmsManagerEntryCompanyService.cancelEntry(id);
        return ActionResult.success((String)"\u53d6\u6d88\u5165\u804c\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsManagerEntryCompanyEntity entity = this.hrmsManagerEntryCompanyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.hrmsManagerEntryCompanyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

