/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsManagerSalaryLevelEntity;
import com.bringspring.hrms.model.hrmsmanagersalarylevelchange.HrmsManagerSalaryLevelChangeInfoVO;
import com.bringspring.hrms.model.hrmsmanagersalarylevelchange.HrmsManagerSalaryLevelChangeListVO;
import com.bringspring.hrms.model.hrmsmanagersalarylevelchange.HrmsManagerSalaryLevelChangePagination;
import com.bringspring.hrms.model.hrmsmanagersalarylevelchange.HrmsManagerSalaryLevelChangeUpForm;
import com.bringspring.hrms.model.hrmsmanagersalarylevelchange.HrmsManagerSalaryLevelCrForm;
import com.bringspring.hrms.service.HrmsManagerSalaryLevelChangeService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"hr\u8c03\u85aa\u8c03\u7ea7"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaHrSalaryLevelChange"})
public class HrmsManagerSalaryLevelController {
    private static final Logger log = LoggerFactory.getLogger(HrmsManagerSalaryLevelController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private HrmsManagerSalaryLevelChangeService oahrsalarylevechangeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsManagerSalaryLevelChangePagination oahrsalarylevechangePagination) throws IOException {
        List<HrmsManagerSalaryLevelEntity> list = this.oahrsalarylevechangeService.getList(oahrsalarylevechangePagination);
        for (HrmsManagerSalaryLevelEntity hrmsManagerSalaryLevelEntity : list) {
            hrmsManagerSalaryLevelEntity.setApplyUserId(this.baseDataUtil.userSelectValues(hrmsManagerSalaryLevelEntity.getApplyUserId()));
            hrmsManagerSalaryLevelEntity.setChangeDeptId(this.baseDataUtil.comSelectValues(hrmsManagerSalaryLevelEntity.getChangeDeptId()));
            hrmsManagerSalaryLevelEntity.setChangeJobId(this.baseDataUtil.posSelectValues(hrmsManagerSalaryLevelEntity.getChangeJobId()));
            hrmsManagerSalaryLevelEntity.setChangeBandLevel(this.baseDataUtil.getDictName(hrmsManagerSalaryLevelEntity.getChangeBandLevel(), "band"));
            hrmsManagerSalaryLevelEntity.setApplyUserLeader(this.baseDataUtil.userSelectValues(hrmsManagerSalaryLevelEntity.getApplyUserLeader()));
            hrmsManagerSalaryLevelEntity.setApplyDeptId(this.baseDataUtil.comSelectValues(hrmsManagerSalaryLevelEntity.getApplyDeptId()));
            hrmsManagerSalaryLevelEntity.setApplyJobId(this.baseDataUtil.posSelectValues(hrmsManagerSalaryLevelEntity.getApplyJobId()));
            hrmsManagerSalaryLevelEntity.setApplyBandLevel(this.baseDataUtil.getDictName(hrmsManagerSalaryLevelEntity.getApplyBandLevel(), "band"));
            hrmsManagerSalaryLevelEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(hrmsManagerSalaryLevelEntity.getCreatorUserId()));
            hrmsManagerSalaryLevelEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(hrmsManagerSalaryLevelEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsManagerSalaryLevelChangeListVO.class);
        for (HrmsManagerSalaryLevelChangeListVO hrmsManagerSalaryLevelChangeListVO : listVO) {
        }
        for (HrmsManagerSalaryLevelChangeListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oahrsalarylevechangePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsManagerSalaryLevelCrForm oahrsalarylevechangeCrForm = (HrmsManagerSalaryLevelCrForm)((Object)JsonUtil.getJsonToBean(crData, HrmsManagerSalaryLevelCrForm.class));
        String flowEngineId = "502886196565781189";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oahrsalarylevechangeCrForm.setCreatorTime(DateUtil.getNow());
        oahrsalarylevechangeCrForm.setCreatorUserId(userInfo.getUserId());
        oahrsalarylevechangeCrForm.setSubLeaderName(this.baseDataUtil.userSelectValues(oahrsalarylevechangeCrForm.getSubLeader()));
        if (StrUtil.isNotEmpty((CharSequence)oahrsalarylevechangeCrForm.getChangeDeptId())) {
            List deptIds = JsonUtil.getJsonToList((String)oahrsalarylevechangeCrForm.getChangeDeptId(), String.class);
            oahrsalarylevechangeCrForm.setChangeDeptIdName(this.baseDataUtil.comSelectValue((String)deptIds.get(deptIds.size() - 1), "all"));
        }
        HrmsManagerSalaryLevelEntity entity = (HrmsManagerSalaryLevelEntity)JsonUtil.getJsonToBean((Object)((Object)oahrsalarylevechangeCrForm), HrmsManagerSalaryLevelEntity.class);
        entity.setId(mainId);
        this.oahrsalarylevechangeService.save(entity);
        UserEntity changeUser = this.userService.getInfo(entity.getApplyUserId());
        String title = "";
        if (changeUser != null) {
            title = changeUser.getRealName();
        }
        FlowUtil.saveOrSubmit((String)oahrsalarylevechangeCrForm.getTaskId(), (String)flowEngineId, (String)oahrsalarylevechangeCrForm.getTemplateId(), (String)mainId, (Object)((Object)oahrsalarylevechangeCrForm), (Integer)oahrsalarylevechangeCrForm.getStatus());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsManagerSalaryLevelChangeInfoVO> info(@PathVariable(value="id") String id) {
        HrmsManagerSalaryLevelEntity entity = this.oahrsalarylevechangeService.getInfo(id);
        HrmsManagerSalaryLevelChangeInfoVO vo = (HrmsManagerSalaryLevelChangeInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsManagerSalaryLevelChangeInfoVO.class);
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setChangeDeptIdName(this.baseDataUtil.comSelectValues(entity.getChangeDeptId()));
        vo.setApplyDeptIdName(this.baseDataUtil.comSelectValues(entity.getApplyDeptId()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setApplyUserLeaderName(this.baseDataUtil.userSelectValues(vo.getApplyUserLeader()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsManagerSalaryLevelChangeUpForm oahrsalarylevechangeUpForm = (HrmsManagerSalaryLevelChangeUpForm)((Object)JsonUtil.getJsonToBean(upData, HrmsManagerSalaryLevelChangeUpForm.class));
        String flowEngineId = "502886196565781189";
        UserInfo userInfo = this.userProvider.get();
        HrmsManagerSalaryLevelEntity entity = this.oahrsalarylevechangeService.getInfo(id);
        if (entity != null) {
            oahrsalarylevechangeUpForm.setSubLeaderName(this.baseDataUtil.userSelectValues(oahrsalarylevechangeUpForm.getSubLeader()));
            if (StrUtil.isNotEmpty((CharSequence)oahrsalarylevechangeUpForm.getChangeDeptId())) {
                List deptIds = JsonUtil.getJsonToList((String)oahrsalarylevechangeUpForm.getChangeDeptId(), String.class);
                oahrsalarylevechangeUpForm.setChangeDeptIdName(this.baseDataUtil.comSelectValue((String)deptIds.get(deptIds.size() - 1), "all"));
            }
            HrmsManagerSalaryLevelEntity subentity = (HrmsManagerSalaryLevelEntity)JsonUtil.getJsonToBean((Object)((Object)oahrsalarylevechangeUpForm), HrmsManagerSalaryLevelEntity.class);
            subentity.setCreatorTime(entity.getCreatorTime());
            subentity.setCreatorUserId(entity.getCreatorUserId());
            this.oahrsalarylevechangeService.update(id, subentity);
            UserEntity changeUser = this.userService.getInfo(entity.getApplyUserId());
            String title = "";
            if (changeUser != null) {
                title = changeUser.getRealName();
            }
            FlowUtil.saveOrSubmit((String)oahrsalarylevechangeUpForm.getTaskId(), (String)flowEngineId, (String)oahrsalarylevechangeUpForm.getTemplateId(), (String)id, (Object)((Object)oahrsalarylevechangeUpForm), (Integer)oahrsalarylevechangeUpForm.getStatus());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsManagerSalaryLevelEntity entity = this.oahrsalarylevechangeService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oahrsalarylevechangeService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

