/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsManagerSignApplicationEntity;
import com.bringspring.hrms.model.hrmsmanagersignapplication.HrmsManagerSignApplicationCrForm;
import com.bringspring.hrms.model.hrmsmanagersignapplication.HrmsManagerSignApplicationInfoVO;
import com.bringspring.hrms.model.hrmsmanagersignapplication.HrmsManagerSignApplicationListVO;
import com.bringspring.hrms.model.hrmsmanagersignapplication.HrmsManagerSignApplicationPagination;
import com.bringspring.hrms.model.hrmsmanagersignapplication.HrmsManagerSignApplicationUpForm;
import com.bringspring.hrms.service.HrmsManagerSignApplicationService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4eba\u529b\u4e13\u9879\u7533\u8bf7"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaHrSignApplication"})
public class HrmsManagerSignApplicationController {
    private static final Logger log = LoggerFactory.getLogger(HrmsManagerSignApplicationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsManagerSignApplicationService oahrsignapplicationService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsManagerSignApplicationPagination oahrsignapplicationPagination) throws IOException {
        List<HrmsManagerSignApplicationEntity> list = this.oahrsignapplicationService.getList(oahrsignapplicationPagination);
        for (HrmsManagerSignApplicationEntity hrmsManagerSignApplicationEntity : list) {
            hrmsManagerSignApplicationEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(hrmsManagerSignApplicationEntity.getCreatorUserId()));
            hrmsManagerSignApplicationEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(hrmsManagerSignApplicationEntity.getLastModifyUserId()));
            hrmsManagerSignApplicationEntity.setCreatorDept(this.baseDataUtil.comSelectValue(hrmsManagerSignApplicationEntity.getCreatorDept(), "last"));
            hrmsManagerSignApplicationEntity.setOaType(this.baseDataUtil.getDictName(hrmsManagerSignApplicationEntity.getOaType(), "OaHrSignApplication"));
            hrmsManagerSignApplicationEntity.setIsCeo(this.baseDataUtil.switchSelectValue(hrmsManagerSignApplicationEntity.getIsCeo(), "\u5f00", "\u5173"));
            hrmsManagerSignApplicationEntity.setOaUploads(this.baseDataUtil.getFileNameInJson(hrmsManagerSignApplicationEntity.getOaUploads()));
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsManagerSignApplicationListVO.class);
        for (HrmsManagerSignApplicationListVO hrmsManagerSignApplicationListVO : listVO) {
        }
        for (HrmsManagerSignApplicationListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oahrsignapplicationPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsManagerSignApplicationCrForm oahrsignapplicationCrForm = (HrmsManagerSignApplicationCrForm)((Object)JsonUtil.getJsonToBean(crData, HrmsManagerSignApplicationCrForm.class));
        String flowEngineId = "502877926362983109";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oahrsignapplicationCrForm.setCreatorUserId(userInfo.getUserId());
        oahrsignapplicationCrForm.setCreatorTime(DateUtil.getNow());
        oahrsignapplicationCrForm.setCreatorDept(StringUtils.isEmpty((String)userInfo.getDepartmentId()) ? userInfo.getOrganizeId() : userInfo.getDepartmentId());
        oahrsignapplicationCrForm.setFormId(this.baseDataUtil.getBillNumber("OaHrSignApplication", Boolean.valueOf(false)));
        oahrsignapplicationCrForm.setCreatorUserName(userInfo.getUserName());
        if (StringUtils.isNotEmpty((String)oahrsignapplicationCrForm.getCreatorDept())) {
            oahrsignapplicationCrForm.setCreatorDeptName(this.organizeService.getFullNameByOrgIdTree(oahrsignapplicationCrForm.getCreatorDept(), "/"));
        }
        oahrsignapplicationCrForm.setBelongCompanyName(StringUtils.isEmpty((String)oahrsignapplicationCrForm.getBelongCompany()) ? "" : this.baseDataUtil.getDictName(oahrsignapplicationCrForm.getBelongCompany(), "SubsidiaryCompanies"));
        HrmsManagerSignApplicationEntity entity = (HrmsManagerSignApplicationEntity)JsonUtil.getJsonToBean((Object)((Object)oahrsignapplicationCrForm), HrmsManagerSignApplicationEntity.class);
        entity.setId(mainId);
        entity.setEntryCompany(userInfo.getOrganizeId());
        this.oahrsignapplicationService.save(entity);
        FlowUtil.saveOrSubmit((String)oahrsignapplicationCrForm.getTaskId(), (String)flowEngineId, (String)oahrsignapplicationCrForm.getTemplateId(), (String)mainId, (Object)((Object)oahrsignapplicationCrForm), (Integer)oahrsignapplicationCrForm.getStatus(), (String)oahrsignapplicationCrForm.getApplicationTitle());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsManagerSignApplicationInfoVO> info(@PathVariable(value="id") String id) {
        HrmsManagerSignApplicationEntity entity = this.oahrsignapplicationService.getInfo(id);
        HrmsManagerSignApplicationInfoVO vo = (HrmsManagerSignApplicationInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsManagerSignApplicationInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        vo.setCreatorDept(this.baseDataUtil.comSelectValue(vo.getCreatorDept(), "last"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsManagerSignApplicationUpForm oahrsignapplicationUpForm = (HrmsManagerSignApplicationUpForm)((Object)JsonUtil.getJsonToBean(upData, HrmsManagerSignApplicationUpForm.class));
        String flowEngineId = "502877926362983109";
        UserInfo userInfo = this.userProvider.get();
        HrmsManagerSignApplicationEntity entity = this.oahrsignapplicationService.getInfo(id);
        if (entity != null) {
            oahrsignapplicationUpForm.setLastModifyUserId(userInfo.getUserId());
            oahrsignapplicationUpForm.setLastModifyTime(DateUtil.getNow());
            oahrsignapplicationUpForm.setCreatorDept(entity.getCreatorDept());
            HrmsManagerSignApplicationEntity subentity = (HrmsManagerSignApplicationEntity)JsonUtil.getJsonToBean((Object)((Object)oahrsignapplicationUpForm), HrmsManagerSignApplicationEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            subentity.setCreatorUserName(userInfo.getUserName());
            if (StringUtils.isNotEmpty((String)subentity.getCreatorDept())) {
                subentity.setCreatorDeptName(this.organizeService.getFullNameByOrgIdTree(subentity.getCreatorDept(), "/"));
            }
            subentity.setBelongCompanyName(StringUtils.isEmpty((String)subentity.getBelongCompany()) ? "" : this.baseDataUtil.getDictName(subentity.getBelongCompany(), "SubsidiaryCompanies"));
            this.oahrsignapplicationService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oahrsignapplicationUpForm.getTaskId(), (String)flowEngineId, (String)oahrsignapplicationUpForm.getTemplateId(), (String)id, (Object)((Object)oahrsignapplicationUpForm), (Integer)oahrsignapplicationUpForm.getStatus(), (String)oahrsignapplicationUpForm.getApplicationTitle());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsManagerSignApplicationEntity entity = this.oahrsignapplicationService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oahrsignapplicationService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

