/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsManagerTransferEntity;
import com.bringspring.hrms.model.hrmsmanagertransfer.HrmsManagerTransferCrForm;
import com.bringspring.hrms.model.hrmsmanagertransfer.HrmsManagerTransferInfoVO;
import com.bringspring.hrms.model.hrmsmanagertransfer.HrmsManagerTransferListVO;
import com.bringspring.hrms.model.hrmsmanagertransfer.HrmsManagerTransferPagination;
import com.bringspring.hrms.model.hrmsmanagertransfer.HrmsManagerTransferUpForm;
import com.bringspring.hrms.service.HrmsManagerTransferService;
import com.bringspring.hrms.util.TransferEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8f6c\u5c97\u7533\u8bf7"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaTransfer"})
public class HrmsManagerTransferController {
    private static final Logger log = LoggerFactory.getLogger(HrmsManagerTransferController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsManagerTransferService hrmsManagerTransferService;
    @Autowired
    private UserService userService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsManagerTransferPagination hrmsManagerTransferPagination) throws IOException {
        List<HrmsManagerTransferEntity> list = this.hrmsManagerTransferService.getList(hrmsManagerTransferPagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsManagerTransferListVO.class);
        for (HrmsManagerTransferListVO vo : listVO) {
            vo.setIsZwy(this.baseDataUtil.getDictName(vo.getIsZwy(), "whether"));
            vo.setApplyDept(this.baseDataUtil.comSelectValues(vo.getApplyDept()));
            vo.setTransferDept(this.baseDataUtil.comSelectValues(vo.getTransferDept()));
            vo.setOldStation(this.baseDataUtil.posSelectValues(vo.getOldStation()));
            vo.setNewStation(this.baseDataUtil.posSelectValues(vo.getNewStation()));
            vo.setOldBand(this.baseDataUtil.getDictName(vo.getOldBand(), "band"));
            vo.setNewBand(this.baseDataUtil.getDictName(vo.getNewBand(), "band"));
            vo.setOldLeader(this.baseDataUtil.userSelectValues(vo.getOldLeader()));
            vo.setNewLeader(this.baseDataUtil.userSelectValues(vo.getNewLeader()));
            vo.setCreatorUserId(this.baseDataUtil.userSelectValues(vo.getCreatorUserId()));
            vo.setFlowStateName(TransferEnum.getNameByCode(vo.getFlowStateEnable()));
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerTransferPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsManagerTransferCrForm hrmsManagerTransferCrForm = (HrmsManagerTransferCrForm)((Object)JsonUtil.getJsonToBean(crData, HrmsManagerTransferCrForm.class));
        String flowEngineId = "509390524621504133";
        if (StringUtils.isNotEmpty((String)hrmsManagerTransferCrForm.getFlowId())) {
            flowEngineId = hrmsManagerTransferCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        hrmsManagerTransferCrForm.setCode(this.baseDataUtil.getBillNumber("transfer", Boolean.valueOf(false)));
        hrmsManagerTransferCrForm.setChangeTypeName(this.baseDataUtil.getDictName(hrmsManagerTransferCrForm.getChangeType(), "changeTypeOptions"));
        HrmsManagerTransferEntity entity = (HrmsManagerTransferEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerTransferCrForm), HrmsManagerTransferEntity.class);
        entity.setId(mainId);
        entity.setEntryCompany(this.userService.getUserCompany(hrmsManagerTransferCrForm.getCreatorUserId()));
        this.hrmsManagerTransferService.save(entity);
        String transferName = this.baseDataUtil.userSelectValueNoAccount(hrmsManagerTransferCrForm.getCreatorUserId());
        FlowUtil.saveOrSubmit((String)hrmsManagerTransferCrForm.getTaskId(), (String)flowEngineId, (String)hrmsManagerTransferCrForm.getTemplateId(), (String)mainId, (Object)((Object)hrmsManagerTransferCrForm), (Integer)hrmsManagerTransferCrForm.getStatus(), (String)transferName);
        return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsManagerTransferInfoVO> info(@PathVariable(value="id") String id) {
        HrmsManagerTransferEntity entity = this.hrmsManagerTransferService.getInfo(id);
        HrmsManagerTransferInfoVO vo = (HrmsManagerTransferInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsManagerTransferInfoVO.class);
        vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setApplyDeptName(this.baseDataUtil.comSelectValues(vo.getApplyDept()));
        vo.setOldStationName(this.baseDataUtil.posSelectValues(vo.getOldStation()));
        vo.setOldBandName(this.baseDataUtil.getDictName(vo.getOldBand(), "band"));
        vo.setOldLeaderName(this.baseDataUtil.userSelectValues(vo.getOldLeader()));
        vo.setNewLeaderName(this.baseDataUtil.userSelectValues(vo.getNewLeader()));
        vo.setNewStationName(this.baseDataUtil.posSelectValues(vo.getNewStation()));
        vo.setTransferDeptName(this.baseDataUtil.comSelectValues(vo.getTransferDept()));
        vo.setNewBandName(this.baseDataUtil.getDictName(vo.getNewBand(), "band"));
        vo.setGanderName(this.baseDataUtil.getDictName(vo.getGander(), "sex"));
        vo.setEntryCompanyName(this.baseDataUtil.getDictName(vo.getEntryCompany(), "companyName"));
        vo.setTransferCompanyName(this.baseDataUtil.getDictName(vo.getTransferCompany(), "companyName"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/transfer/{id}"})
    @DSTransactional
    public ActionResult transfer(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException {
        HrmsManagerTransferInfoVO info = (HrmsManagerTransferInfoVO)JsonUtil.getJsonToBean(upData, HrmsManagerTransferInfoVO.class);
        this.hrmsManagerTransferService.transfer(id, info);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsManagerTransferUpForm hrmsManagerTransferUpForm = (HrmsManagerTransferUpForm)((Object)JsonUtil.getJsonToBean(upData, HrmsManagerTransferUpForm.class));
        String flowEngineId = "509390524621504133";
        if (StringUtils.isNotEmpty((String)hrmsManagerTransferUpForm.getFlowId())) {
            flowEngineId = hrmsManagerTransferUpForm.getFlowId();
        }
        UserInfo userInfo = this.userProvider.get();
        hrmsManagerTransferUpForm.setChangeTypeName(this.baseDataUtil.getDictName(hrmsManagerTransferUpForm.getChangeType(), "changeTypeOptions"));
        HrmsManagerTransferEntity entity = this.hrmsManagerTransferService.getInfo(id);
        if (entity != null) {
            HrmsManagerTransferEntity subentity = (HrmsManagerTransferEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerTransferUpForm), HrmsManagerTransferEntity.class);
            this.hrmsManagerTransferService.update(id, subentity);
            String transferName = this.baseDataUtil.userSelectValueNoAccount(hrmsManagerTransferUpForm.getCreatorUserId());
            FlowUtil.saveOrSubmit((String)hrmsManagerTransferUpForm.getTaskId(), (String)flowEngineId, (String)hrmsManagerTransferUpForm.getTemplateId(), (String)id, (Object)((Object)hrmsManagerTransferUpForm), (Integer)hrmsManagerTransferUpForm.getStatus(), (String)transferName);
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsManagerTransferEntity entity = this.hrmsManagerTransferService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.hrmsManagerTransferService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

