/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsPerformanceCheckinEntity;
import com.bringspring.hrms.model.hrmsattendancecheckindata.HrmsPerformanceCheckinReport;
import com.bringspring.hrms.model.hrmsperformanceapcbtxjsal.HrmsPerformanceApCbTxjSalPagination;
import com.bringspring.hrms.model.hrmsperformancecheckin.HrmsPerformanceCheckinCrForm;
import com.bringspring.hrms.model.hrmsperformancecheckin.HrmsPerformanceCheckinInfoVO;
import com.bringspring.hrms.model.hrmsperformancecheckin.HrmsPerformanceCheckinListVO;
import com.bringspring.hrms.model.hrmsperformancecheckin.HrmsPerformanceCheckinPagination;
import com.bringspring.hrms.model.hrmsperformancecheckin.HrmsPerformanceCheckinPaginationExportModel;
import com.bringspring.hrms.model.hrmsperformancecheckin.HrmsPerformanceCheckinUpForm;
import com.bringspring.hrms.service.HrmsPerformanceApCbTxjSalService;
import com.bringspring.hrms.service.HrmsPerformanceCheckinService;
import com.bringspring.hrms.service.HrmsPerformanceHolidayBalancePService;
import com.bringspring.hrms.service.HrmsPerformanceHolidayBalanceService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e2a\u4eba\u8003\u52e4"}, value="hrms")
@RequestMapping(value={"/api/hrms/HrmsPerformanceCheckin"})
public class HrmsPerformanceCheckinController {
    private static final Logger log = LoggerFactory.getLogger(HrmsPerformanceCheckinController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private HrmsPerformanceCheckinService hrmsPerformanceCheckinService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private HrmsPerformanceApCbTxjSalService hrmsPerformanceApCbTxjSalService;
    @Autowired
    private HrmsPerformanceHolidayBalancePService hrmsPerformanceHolidayBalancePService;
    @Autowired
    private HrmsPerformanceHolidayBalanceService hrmsPerformanceHolidayBalanceService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsPerformanceCheckinPagination hrmsPerformanceCheckinPagination) throws IOException {
        if (!ObjectUtil.isEmpty((Object)hrmsPerformanceCheckinPagination.getUserid())) {
            List infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("1", "2", hrmsPerformanceCheckinPagination.getUserid());
            if (!ObjectUtil.isEmpty((Object)infoBySysObjIds)) {
                String[] split = ((SynThirdInfoEntity)infoBySysObjIds.get(0)).getThirdObjectId().split("/");
                hrmsPerformanceCheckinPagination.setUserid(split.length > 1 ? split[1] : split[0]);
            } else {
                return ActionResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u5fae\u4fe1\u5bf9\u5e94\u8d26\u53f7");
            }
        }
        List<HrmsPerformanceCheckinEntity> list = this.hrmsPerformanceCheckinService.getList(hrmsPerformanceCheckinPagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceCheckinListVO.class);
        for (HrmsPerformanceCheckinListVO hrmsPerformanceCheckinVO : listVO) {
            String currentDayType;
            if (!StrUtil.isBlank((CharSequence)hrmsPerformanceCheckinVO.getResultType())) {
                hrmsPerformanceCheckinVO.setResultType(hrmsPerformanceCheckinVO.getResultType().equals("artificial") ? "\u4eba\u5de5" : "\u7a0b\u5e8f");
            } else {
                hrmsPerformanceCheckinVO.setResultType("\u7a0b\u5e8f");
            }
            if (StrUtil.isBlank((CharSequence)(currentDayType = this.baseDataUtil.getDictName(hrmsPerformanceCheckinVO.getCurrentDayResult(), "currentDayType")))) continue;
            hrmsPerformanceCheckinVO.setCurrentDayResult(currentDayType);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceCheckinPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListReport"})
    public ActionResult getListReport(@RequestBody HrmsPerformanceApCbTxjSalPagination hrmsPerformanceApCbTxjSalPagination) throws IOException {
        String[] split;
        List infoBySysObjIds;
        if (!ObjectUtil.isEmpty((Object)hrmsPerformanceApCbTxjSalPagination.getApplyUserId()) && !ObjectUtil.isEmpty((Object)(infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("1", "2", hrmsPerformanceApCbTxjSalPagination.getApplyUserId())))) {
            split = ((SynThirdInfoEntity)infoBySysObjIds.get(0)).getThirdObjectId().split("/");
            hrmsPerformanceApCbTxjSalPagination.setApplyUserId(split.length > 1 ? split[1] : split[0]);
        }
        if (!ObjectUtil.isEmpty((Object)hrmsPerformanceApCbTxjSalPagination.getUserid()) && !ObjectUtil.isEmpty((Object)(infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("1", "2", hrmsPerformanceApCbTxjSalPagination.getUserid())))) {
            split = ((SynThirdInfoEntity)infoBySysObjIds.get(0)).getThirdObjectId().split("/");
            hrmsPerformanceApCbTxjSalPagination.setUserid(split.length > 1 ? split[1] : split[0]);
        }
        List<HrmsPerformanceCheckinReport> list = this.hrmsPerformanceCheckinService.getListReport(hrmsPerformanceApCbTxjSalPagination);
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceApCbTxjSalPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(HrmsPerformanceCheckinPaginationExportModel hrmsPerformanceCheckinPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)hrmsPerformanceCheckinPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        DownloadVO vo = this.hrmsPerformanceCheckinService.exportData(hrmsPerformanceCheckinPaginationExportModel);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/ExportDailyAttendance"})
    public ActionResult ExportDailyAttendance(HrmsPerformanceCheckinPagination hrmsPerformanceCheckinPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)hrmsPerformanceCheckinPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        if (!ObjectUtil.isEmpty((Object)hrmsPerformanceCheckinPaginationExportModel.getUserid())) {
            List infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("1", "2", hrmsPerformanceCheckinPaginationExportModel.getUserid());
            if (!ObjectUtil.isEmpty((Object)infoBySysObjIds)) {
                String[] split = ((SynThirdInfoEntity)infoBySysObjIds.get(0)).getThirdObjectId().split("/");
                hrmsPerformanceCheckinPaginationExportModel.setUserid(split.length > 1 ? split[1] : split[0]);
            } else {
                return ActionResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u5fae\u4fe1\u5bf9\u5e94\u8d26\u53f7");
            }
        }
        DownloadVO vo = this.hrmsPerformanceCheckinService.exportDailyAttendance(hrmsPerformanceCheckinPaginationExportModel);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/allTest"})
    public ActionResult allTest(@RequestBody HrmsPerformanceCheckinPagination hrmsPerformanceCheckinPagination) throws IOException {
        List<Date> cdateList = hrmsPerformanceCheckinPagination.getCdateList();
        this.hrmsPerformanceCheckinService.autoAddMonthData(cdateList.get(0), cdateList.get(1));
        PageListVO vo = new PageListVO();
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceCheckinPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/allTest2"})
    public ActionResult allTest2(@RequestBody HrmsPerformanceCheckinPagination hrmsPerformanceCheckinPagination) throws IOException {
        List<Date> cdateList = hrmsPerformanceCheckinPagination.getCdateList();
        this.hrmsPerformanceHolidayBalancePService.handleCancelHoliday(cdateList.get(0));
        PageListVO vo = new PageListVO();
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceCheckinPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/previewAllTest"})
    public ActionResult previewAllTest(@RequestBody HrmsPerformanceCheckinPagination hrmsPerformanceCheckinPagination) throws IOException {
        Date date1 = DateUtil.dateAddMonths((Date)DateUtil.getNowDate(), (int)-3);
        Date date2 = DateUtil.getNowDate();
        List<Date> cdateList = hrmsPerformanceCheckinPagination.getCdateList();
        this.hrmsPerformanceCheckinService.updateAttendanceUserCompanyId();
        this.hrmsPerformanceCheckinService.autoAddMonthData(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceCheckinService.handleCheckinDK(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceCheckinService.handleCheckinBK(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceCheckinService.handleCheckinQJ(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceCheckinService.handleCheckinCC(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceCheckinService.handleCheckinWC(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceApCbTxjSalService.insertTxjSal(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceHolidayBalancePService.testAddBalance(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceCheckinService.checkAttendance(cdateList.get(0), cdateList.get(1));
        PageListVO vo = new PageListVO();
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceCheckinPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/correctAttendanceData"})
    public ActionResult correctAttendanceData(@RequestBody HrmsPerformanceCheckinPagination hrmsPerformanceCheckinPagination) throws IOException {
        Date date1 = DateUtil.dateAddMonths((Date)DateUtil.getNowDate(), (int)-3);
        Date date2 = DateUtil.getNowDate();
        List<Date> cdateList = hrmsPerformanceCheckinPagination.getCdateList();
        this.hrmsPerformanceCheckinService.updateAttendanceUserCompanyId();
        this.hrmsPerformanceCheckinService.autoAddMonthData(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceCheckinService.handleCheckinDK(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceCheckinService.handleCheckinBK(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceCheckinService.handleCheckinQJ(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceCheckinService.handleCheckinCC(cdateList.get(0), cdateList.get(1));
        this.hrmsPerformanceCheckinService.handleCheckinWC(cdateList.get(0), cdateList.get(1));
        PageListVO vo = new PageListVO();
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceCheckinPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/CLMJ"})
    public ActionResult CLMJ(@RequestBody HrmsPerformanceCheckinPagination hrmsPerformanceCheckinPagination) throws IOException {
        Date date = DateUtil.dateAddMonths((Date)DateUtil.getNowDate(), (int)-1);
        this.hrmsPerformanceApCbTxjSalService.pullTxjDate(date, DateUtil.getNowDate());
        PageListVO vo = new PageListVO();
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceCheckinPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/updateAttendanceCheckinByQJ"})
    public ActionResult updateAttendanceCheckinByQJ(@RequestBody HrmsPerformanceCheckinPagination hrmsPerformanceCheckinPagination) throws IOException {
        Date date = DateUtil.dateAddDays((Date)DateUtil.getNowDate(), (int)-24);
        Date date2 = DateUtil.dateAddDays((Date)DateUtil.getNowDate(), (int)-19);
        this.hrmsPerformanceCheckinService.handleEmployeeAttendance(date, date2);
        PageListVO vo = new PageListVO();
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceCheckinPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid HrmsPerformanceCheckinCrForm hrmsPerformanceCheckinCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceCheckinEntity entity = (HrmsPerformanceCheckinEntity)JsonUtil.getJsonToBean((Object)hrmsPerformanceCheckinCrForm, HrmsPerformanceCheckinEntity.class);
        this.hrmsPerformanceCheckinService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsPerformanceCheckinInfoVO> info(@PathVariable(value="id") String id) {
        HrmsPerformanceCheckinEntity entity = this.hrmsPerformanceCheckinService.getInfo(id);
        HrmsPerformanceCheckinInfoVO vo = (HrmsPerformanceCheckinInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceCheckinInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<HrmsPerformanceCheckinInfoVO> detailInfo(@PathVariable(value="id") String id) {
        HrmsPerformanceCheckinEntity entity = this.hrmsPerformanceCheckinService.getInfo(id);
        HrmsPerformanceCheckinInfoVO vo = (HrmsPerformanceCheckinInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceCheckinInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid HrmsPerformanceCheckinUpForm hrmsPerformanceCheckinUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceCheckinEntity entity = this.hrmsPerformanceCheckinService.getInfo(id);
        if (entity != null) {
            HrmsPerformanceCheckinEntity subentity = (HrmsPerformanceCheckinEntity)JsonUtil.getJsonToBean((Object)hrmsPerformanceCheckinUpForm, HrmsPerformanceCheckinEntity.class);
            if (subentity.getCurrentDayResult().contains("normal")) {
                subentity.setZt(null);
                subentity.setCd(null);
                subentity.setKgCnt(null);
                subentity.setCtype("\u6b63\u5e38");
            }
            this.hrmsPerformanceCheckinService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsPerformanceCheckinEntity entity = this.hrmsPerformanceCheckinService.getInfo(id);
        if (entity != null) {
            this.hrmsPerformanceCheckinService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

