/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.model.rkcontractproduct.ContractProductImportVO;
import com.bringspring.hrms.entity.HrmsAttendanceUserEntity;
import com.bringspring.hrms.entity.HrmsPerformanceHolidayBalancePEntity;
import com.bringspring.hrms.mapper.HrmsAttendanceGetapprovaldetailQjMapper;
import com.bringspring.hrms.model.hrmsperformancecheckin.HrmsPerformanceCheckinPagination;
import com.bringspring.hrms.model.hrmsperformanceholidaybalancep.HrmsHolidayBalancePImportReturnVO;
import com.bringspring.hrms.model.hrmsperformanceholidaybalancep.HrmsPerformanceHolidayBalancePCrForm;
import com.bringspring.hrms.model.hrmsperformanceholidaybalancep.HrmsPerformanceHolidayBalancePImportVO;
import com.bringspring.hrms.model.hrmsperformanceholidaybalancep.HrmsPerformanceHolidayBalancePInfoVO;
import com.bringspring.hrms.model.hrmsperformanceholidaybalancep.HrmsPerformanceHolidayBalancePListVO;
import com.bringspring.hrms.model.hrmsperformanceholidaybalancep.HrmsPerformanceHolidayBalancePPagination;
import com.bringspring.hrms.model.hrmsperformanceholidaybalancep.HrmsPerformanceHolidayBalancePUpForm;
import com.bringspring.hrms.service.HrmsAttendanceCalendarService;
import com.bringspring.hrms.service.HrmsAttendanceGetapprovaldetailQjService;
import com.bringspring.hrms.service.HrmsAttendanceUserService;
import com.bringspring.hrms.service.HrmsPerformanceCheckinService;
import com.bringspring.hrms.service.HrmsPerformanceHolidayBalancePService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5f53\u524d\u8003\u52e4\u5468\u671f\u5047\u671f"}, value="hrms")
@RequestMapping(value={"/api/hrms/HrmsPerformanceHolidayBalanceP"})
public class HrmsPerformanceHolidayBalancePController {
    private static final Logger log = LoggerFactory.getLogger(HrmsPerformanceHolidayBalancePController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsPerformanceHolidayBalancePService hrmsPerformanceHolidayBalancePService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private HrmsPerformanceCheckinService hrmsPerformanceCheckinService;
    @Autowired
    private HrmsAttendanceGetapprovaldetailQjService hrmsAttendanceGetapprovaldetailQjService;
    @Autowired
    private HrmsAttendanceGetapprovaldetailQjMapper hrmsAttendanceGetapprovaldetailQjMapper;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private HrmsAttendanceCalendarService hrmsAttendanceCalendarService;
    @Autowired
    private HrmsAttendanceUserService hrmsAttendanceUserService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsPerformanceHolidayBalancePPagination hrmsPerformanceHolidayBalancePPagination) throws IOException {
        List infoBySysObjIds;
        if (!ObjectUtil.isEmpty((Object)hrmsPerformanceHolidayBalancePPagination.getUserid()) && !ObjectUtil.isEmpty((Object)(infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("1", "2", hrmsPerformanceHolidayBalancePPagination.getUserid())))) {
            String[] split = ((SynThirdInfoEntity)infoBySysObjIds.get(0)).getThirdObjectId().split("/");
            hrmsPerformanceHolidayBalancePPagination.setUserid(split.length > 1 ? split[1] : split[0]);
        }
        List<HrmsPerformanceHolidayBalancePEntity> list = this.hrmsPerformanceHolidayBalancePService.getList(hrmsPerformanceHolidayBalancePPagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceHolidayBalancePListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceHolidayBalancePPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/testAddBalance"})
    public ActionResult testAddBalance(@RequestBody HrmsPerformanceHolidayBalancePPagination hrmsPerformanceHolidayBalancePPagination) throws IOException {
        Date date = DateUtil.dateAddDays((Date)DateUtil.getNowDate(), (int)-1);
        this.hrmsPerformanceHolidayBalancePService.testAddBalance(date, DateUtil.getNowDate());
        return ActionResult.success();
    }

    @PostMapping(value={"/updateHoliday"})
    public ActionResult updateHoliday(@RequestBody HrmsPerformanceHolidayBalancePPagination hrmsPerformanceHolidayBalancePPagination) throws IOException {
        this.hrmsPerformanceHolidayBalancePService.synchronousCurrentHoliday();
        return ActionResult.success();
    }

    @PostMapping(value={"/updateHistoryHolidayMJ"})
    public ActionResult updateHistoryHolidayMJ(@RequestBody HrmsPerformanceHolidayBalancePPagination hrmsPerformanceHolidayBalancePPagination) throws IOException {
        this.hrmsPerformanceHolidayBalancePService.addAndUpdateHolidayMJ();
        return ActionResult.success();
    }

    @PostMapping(value={"/updateHistoryHolidayRK"})
    public ActionResult updateHistoryHolidayRK(@RequestBody HrmsPerformanceHolidayBalancePPagination hrmsPerformanceHolidayBalancePPagination) throws IOException {
        this.hrmsPerformanceHolidayBalancePService.addAndUpdateHolidayRK();
        return ActionResult.success();
    }

    @PostMapping(value={"/updateHolidayMJ"})
    public ActionResult updateHolidayMJ(@RequestBody HrmsPerformanceCheckinPagination hrmsPerformanceCheckinPagination) throws IOException {
        this.hrmsPerformanceHolidayBalancePService.testAddBalance(DateUtil.dateAddMonths((Date)DateUtil.getNowDate(), (int)-1), DateUtil.getNowDate());
        return ActionResult.success();
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid HrmsPerformanceHolidayBalancePCrForm hrmsPerformanceHolidayBalancePCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceHolidayBalancePEntity entity = (HrmsPerformanceHolidayBalancePEntity)JsonUtil.getJsonToBean((Object)hrmsPerformanceHolidayBalancePCrForm, HrmsPerformanceHolidayBalancePEntity.class);
        this.hrmsPerformanceHolidayBalancePService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsPerformanceHolidayBalancePInfoVO> info(@PathVariable(value="id") String id) {
        HrmsPerformanceHolidayBalancePEntity entity = this.hrmsPerformanceHolidayBalancePService.getInfo(id);
        HrmsPerformanceHolidayBalancePInfoVO vo = (HrmsPerformanceHolidayBalancePInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceHolidayBalancePInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<HrmsPerformanceHolidayBalancePInfoVO> detailInfo(@PathVariable(value="id") String id) {
        HrmsPerformanceHolidayBalancePEntity entity = this.hrmsPerformanceHolidayBalancePService.getInfo(id);
        HrmsPerformanceHolidayBalancePInfoVO vo = (HrmsPerformanceHolidayBalancePInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceHolidayBalancePInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid HrmsPerformanceHolidayBalancePUpForm hrmsPerformanceHolidayBalancePUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceHolidayBalancePEntity entity = this.hrmsPerformanceHolidayBalancePService.getInfo(id);
        if (entity != null) {
            HrmsPerformanceHolidayBalancePEntity subentity = (HrmsPerformanceHolidayBalancePEntity)JsonUtil.getJsonToBean((Object)hrmsPerformanceHolidayBalancePUpForm, HrmsPerformanceHolidayBalancePEntity.class);
            this.hrmsPerformanceHolidayBalancePService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsPerformanceHolidayBalancePEntity entity = this.hrmsPerformanceHolidayBalancePService.getInfo(id);
        if (entity != null) {
            this.hrmsPerformanceHolidayBalancePService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<HrmsHolidayBalancePImportReturnVO> ImportData(@RequestBody HrmsPerformanceHolidayBalancePImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), HrmsPerformanceHolidayBalancePImportVO.class);
        HrmsHolidayBalancePImportReturnVO result = this.hrmsPerformanceHolidayBalancePService.importData(dataList);
        return ActionResult.success((Object)((Object)result));
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportDataAdd"})
    public ActionResult<HrmsHolidayBalancePImportReturnVO> importDataAdd(@RequestBody HrmsPerformanceHolidayBalancePImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), HrmsPerformanceHolidayBalancePImportVO.class);
        HrmsHolidayBalancePImportReturnVO result = this.hrmsPerformanceHolidayBalancePService.importDataAdd(dataList);
        return ActionResult.success((Object)((Object)result));
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u5047\u671f\u4f59\u989d\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u5047\u671f\u4f59\u989d\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List contractList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, HrmsPerformanceHolidayBalancePImportVO.class);
        List list = JsonUtil.getJsonToList((Object)contractList, Object.class);
        Map<String, Object> map = this.hrmsPerformanceHolidayBalancePService.importPreview(list, new ContractProductImportVO());
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9519\u8bef\u62a5\u544a")
    @PostMapping(value={"/ExportExceptionData"})
    public ActionResult<DownloadVO> exportExceptionData(@RequestBody ContractProductImportVO data) {
        List dataList = JsonUtil.getJsonToList((Object)data.getList(), Object.class);
        DownloadVO vo = this.hrmsPerformanceHolidayBalancePService.exportExceptionData(dataList, new HrmsPerformanceHolidayBalancePImportVO());
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownloadSH"})
    public ActionResult<DownloadVO> TemplateDownloadSH() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u89c6\u7ff0\u8c03\u4f11\u5047.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u5047\u671f\u4f59\u989d\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportDataSH"})
    public ActionResult<HrmsHolidayBalancePImportReturnVO> ImportDataSH(@RequestBody HrmsPerformanceHolidayBalancePImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), HrmsPerformanceHolidayBalancePImportVO.class);
        HrmsHolidayBalancePImportReturnVO result = this.hrmsPerformanceHolidayBalancePService.importDataSH(dataList);
        return ActionResult.success((Object)((Object)result));
    }

    @PostMapping(value={"/generateCalendarData"})
    public ActionResult generateCalendarData(@RequestBody HashMap map) {
        Integer year = (Integer)map.get("year");
        this.hrmsAttendanceCalendarService.generateCalendarData(year);
        return ActionResult.success();
    }

    @PostMapping(value={"/testupdateHoliday"})
    public void testupdateHoliday(@RequestBody Map<String, String> paramMap) {
        List list = this.hrmsPerformanceHolidayBalancePService.list();
        List userEntities = this.hrmsAttendanceUserService.list();
        List userEntitiesRK = userEntities.stream().filter(i -> StrUtil.equals((CharSequence)i.getCompanyId(), (CharSequence)"2") || StrUtil.equals((CharSequence)i.getCompanyId(), (CharSequence)"14") || StrUtil.equals((CharSequence)i.getCompanyId(), (CharSequence)"9")).map(HrmsAttendanceUserEntity::getUserid).collect(Collectors.toList());
        List<HrmsPerformanceHolidayBalancePEntity> hrmsPerformanceHolidayBalancePEntities = list.stream().filter(i -> userEntitiesRK.contains(i.getUserid())).collect(Collectors.toList());
        this.hrmsPerformanceHolidayBalancePService.synchronousHolidayToQiWei(hrmsPerformanceHolidayBalancePEntities);
    }
}

