/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsPerformanceStaffQuarterEntity;
import com.bringspring.hrms.entity.HrmsPerformanceTotalPointEntity;
import com.bringspring.hrms.model.hrmsperformancestaffquarter.HrmsPerformanceStaffQuarterListVO;
import com.bringspring.hrms.model.hrmsperformancestaffquarter.HrmsPerformanceStaffQuarterPagination;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointCrForm;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointInfoVO;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointListVO;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointPagination;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointUpForm;
import com.bringspring.hrms.service.HrmsPerformanceStaffQuarterPrimaryService;
import com.bringspring.hrms.service.HrmsPerformanceStaffQuarterService;
import com.bringspring.hrms.service.HrmsPerformanceTotalPointService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5458\u5de5\u7ee9\u6548\u8003\u6838\u8868"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaHrStaffQuarterPerformance"})
public class HrmsPerformanceStaffQuarterController {
    private static final Logger log = LoggerFactory.getLogger(HrmsPerformanceStaffQuarterController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsPerformanceStaffQuarterPrimaryService hrmsPerformanceStaffQuarterPrimaryService;
    @Autowired
    private HrmsPerformanceTotalPointService hrmsPerformanceTotalPointService;
    @Autowired
    private HrmsPerformanceStaffQuarterService hrmsPerformanceStaffQuarterService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsPerformanceTotalPointPagination hrmsPerformanceTotalPointPagination) throws IOException {
        List<HrmsPerformanceTotalPointEntity> list = this.hrmsPerformanceStaffQuarterPrimaryService.getList(hrmsPerformanceTotalPointPagination);
        for (HrmsPerformanceTotalPointEntity hrmsPerformanceTotalPointEntity : list) {
            hrmsPerformanceTotalPointEntity.setType(this.baseDataUtil.getDictName(hrmsPerformanceTotalPointEntity.getType(), "applyType"));
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceTotalPointListVO.class);
        for (HrmsPerformanceTotalPointListVO vo : listVO) {
            vo.setApplyDepartmentName(this.baseDataUtil.comSelectValues(vo.getApplyDepartment()));
            vo.setApplyPersonName(this.baseDataUtil.userSelectValue(vo.getApplyPerson()));
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
            } else {
                vo.setFlowState(null);
            }
            vo.setApplyId(this.baseDataUtil.userSelectValue(vo.getApplyId()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getStaffList"})
    public ActionResult staffList(@RequestBody HrmsPerformanceStaffQuarterPagination hrmsPerformanceStaffQuarterPagination) throws IOException {
        List<HrmsPerformanceStaffQuarterEntity> list = this.hrmsPerformanceStaffQuarterService.getList(hrmsPerformanceStaffQuarterPagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceStaffQuarterListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceStaffQuarterPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsPerformanceTotalPointCrForm hrmsPerformanceTotalPointCrForm = (HrmsPerformanceTotalPointCrForm)((Object)JsonUtil.getJsonToBean(crData, HrmsPerformanceTotalPointCrForm.class));
        String flowEngineId = "511909477692465093";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceTotalPointEntity entity = (HrmsPerformanceTotalPointEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointCrForm), HrmsPerformanceTotalPointEntity.class);
        entity.setId(mainId);
        entity.setDocumentationMark(0);
        Boolean repeat = this.hrmsPerformanceTotalPointService.judgeSubmitPerformanceRepeat(hrmsPerformanceTotalPointCrForm);
        if (repeat.booleanValue()) {
            return ActionResult.success((String)"duplication");
        }
        this.hrmsPerformanceStaffQuarterPrimaryService.save(entity);
        List oaHrStaffQuarterPerformanceList = JsonUtil.getJsonToList(hrmsPerformanceTotalPointCrForm.getOaHrStaffQuarterPerformanceEntities(), HrmsPerformanceStaffQuarterEntity.class);
        for (HrmsPerformanceStaffQuarterEntity entitys : oaHrStaffQuarterPerformanceList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setPrimaryId(entity.getId());
            this.hrmsPerformanceStaffQuarterService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)hrmsPerformanceTotalPointCrForm.getTaskId(), (String)flowEngineId, (String)hrmsPerformanceTotalPointCrForm.getTemplateId(), (String)mainId, (Object)((Object)hrmsPerformanceTotalPointCrForm), (Integer)hrmsPerformanceTotalPointCrForm.getStatus());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsPerformanceTotalPointInfoVO> info(@PathVariable(value="id") String id) {
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceStaffQuarterPrimaryService.getInfo(id);
        HrmsPerformanceTotalPointInfoVO vo = (HrmsPerformanceTotalPointInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceTotalPointInfoVO.class);
        List<HrmsPerformanceStaffQuarterEntity> oaHrStaffQuarterPerformanceList = this.hrmsPerformanceStaffQuarterPrimaryService.getOaHrStaffQuarterPerformanceList(id);
        vo.setOaHrStaffQuarterPerformanceEntities(JsonUtil.getJsonToList(oaHrStaffQuarterPerformanceList, HrmsPerformanceStaffQuarterEntity.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsPerformanceTotalPointUpForm hrmsPerformanceTotalPointUpForm = (HrmsPerformanceTotalPointUpForm)((Object)JsonUtil.getJsonToBean(upData, HrmsPerformanceTotalPointUpForm.class));
        String flowEngineId = "511909477692465093";
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceStaffQuarterPrimaryService.getInfo(id);
        if (entity != null) {
            HrmsPerformanceTotalPointEntity subentity = (HrmsPerformanceTotalPointEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointUpForm), HrmsPerformanceTotalPointEntity.class);
            this.hrmsPerformanceStaffQuarterPrimaryService.update(id, subentity);
            QueryWrapper Oa_hr_staff_quarter_performancequeryWrapper = new QueryWrapper();
            Oa_hr_staff_quarter_performancequeryWrapper.lambda().eq(HrmsPerformanceStaffQuarterEntity::getPrimaryId, (Object)entity.getId());
            this.hrmsPerformanceStaffQuarterService.remove((Wrapper)Oa_hr_staff_quarter_performancequeryWrapper);
            List oaHrStaffQuarterPerformanceList = JsonUtil.getJsonToList(hrmsPerformanceTotalPointUpForm.getOaHrStaffQuarterPerformanceEntities(), HrmsPerformanceStaffQuarterEntity.class);
            for (HrmsPerformanceStaffQuarterEntity entitys : oaHrStaffQuarterPerformanceList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setPrimaryId(entity.getId());
                this.hrmsPerformanceStaffQuarterService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)hrmsPerformanceTotalPointUpForm.getTaskId(), (String)flowEngineId, (String)hrmsPerformanceTotalPointUpForm.getTemplateId(), (String)id, (Object)((Object)hrmsPerformanceTotalPointUpForm), (Integer)hrmsPerformanceTotalPointUpForm.getStatus());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceStaffQuarterPrimaryService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.hrmsPerformanceStaffQuarterPrimaryService.delete(entity);
            QueryWrapper queryWrapperOa_hr_staff_quarter_performance = new QueryWrapper();
            queryWrapperOa_hr_staff_quarter_performance.lambda().eq(HrmsPerformanceStaffQuarterEntity::getPrimaryId, (Object)entity.getId());
            this.hrmsPerformanceStaffQuarterService.remove((Wrapper)queryWrapperOa_hr_staff_quarter_performance);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

