/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsPerformanceStaffQuarterEvaluateEntity;
import com.bringspring.hrms.entity.HrmsPerformanceTotalPointEntity;
import com.bringspring.hrms.model.hrmsperformancestaffquarterevaluate.HrmsPerformanceStaffQuarterEvaluateInfoVO;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointCrForm;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointInfoVO;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointListVO;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointPagination;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointUpForm;
import com.bringspring.hrms.service.HrmsPerformanceStaffQuarterEvaluateService;
import com.bringspring.hrms.service.HrmsPerformanceStaffQuarterPrimaryEvaluateService;
import com.bringspring.hrms.service.HrmsPerformanceTotalPointService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5458\u5de5\u7ee9\u6548\u660e\u7ec6\u8868"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaHrStaffQuarterPerformanceEvaluate"})
public class HrmsPerformanceStaffQuarterEvaluateController {
    private static final Logger log = LoggerFactory.getLogger(HrmsPerformanceStaffQuarterEvaluateController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsPerformanceStaffQuarterPrimaryEvaluateService hrmsPerformanceStaffQuarterPrimaryEvaluateService;
    @Autowired
    private HrmsPerformanceTotalPointService hrmsPerformanceTotalPointService;
    @Autowired
    private HrmsPerformanceStaffQuarterEvaluateService hrmsPerformanceStaffQuarterEvaluateService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsPerformanceTotalPointPagination hrmsPerformanceTotalPointPagination) throws IOException {
        List<HrmsPerformanceTotalPointEntity> list = this.hrmsPerformanceStaffQuarterPrimaryEvaluateService.getList(hrmsPerformanceTotalPointPagination);
        for (HrmsPerformanceTotalPointEntity hrmsPerformanceTotalPointEntity : list) {
            hrmsPerformanceTotalPointEntity.setType(this.baseDataUtil.getDictName(hrmsPerformanceTotalPointEntity.getType(), "applyType"));
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceTotalPointListVO.class);
        for (HrmsPerformanceTotalPointListVO vo : listVO) {
            vo.setApplyDepartmentName(this.baseDataUtil.comSelectValues(vo.getApplyDepartment()));
            vo.setApplyPersonName(this.baseDataUtil.userSelectValue(vo.getApplyPerson()));
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsPerformanceTotalPointCrForm hrmsPerformanceTotalPointCrForm = (HrmsPerformanceTotalPointCrForm)((Object)JsonUtil.getJsonToBean(crData, HrmsPerformanceTotalPointCrForm.class));
        String flowEngineId = "511955041893212549";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceTotalPointEntity entity = (HrmsPerformanceTotalPointEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointCrForm), HrmsPerformanceTotalPointEntity.class);
        entity.setId(mainId);
        entity.setDocumentationMark(0);
        Boolean repeat = this.hrmsPerformanceTotalPointService.judgeSubmitPerformanceRepeat(hrmsPerformanceTotalPointCrForm);
        if (repeat.booleanValue()) {
            return ActionResult.success((String)"duplication");
        }
        this.hrmsPerformanceStaffQuarterPrimaryEvaluateService.save(entity);
        List oaHrStaffQuarterPerformanceEvaluateList = JsonUtil.getJsonToList(hrmsPerformanceTotalPointCrForm.getHrmsPerformanceStaffQuarterEvaluateInfoVOList(), HrmsPerformanceStaffQuarterEvaluateEntity.class);
        for (HrmsPerformanceStaffQuarterEvaluateEntity entitys : oaHrStaffQuarterPerformanceEvaluateList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setPrimaryId(entity.getId());
            this.hrmsPerformanceStaffQuarterEvaluateService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)hrmsPerformanceTotalPointCrForm.getTaskId(), (String)flowEngineId, (String)hrmsPerformanceTotalPointCrForm.getTemplateId(), (String)mainId, (Object)((Object)hrmsPerformanceTotalPointCrForm), (Integer)hrmsPerformanceTotalPointCrForm.getStatus());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsPerformanceTotalPointInfoVO> info(@PathVariable(value="id") String id) {
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceStaffQuarterPrimaryEvaluateService.getInfo(id);
        HrmsPerformanceTotalPointInfoVO vo = (HrmsPerformanceTotalPointInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceTotalPointInfoVO.class);
        List<HrmsPerformanceStaffQuarterEvaluateEntity> oaHrStaffQuarterPerformanceEvaluateList = this.hrmsPerformanceStaffQuarterPrimaryEvaluateService.getOaHrStaffQuarterPerformanceEvaluateList(id);
        for (HrmsPerformanceStaffQuarterEvaluateEntity hrmsPerformanceStaffQuarterEvaluateEntity : oaHrStaffQuarterPerformanceEvaluateList) {
        }
        vo.setHrmsPerformanceStaffQuarterEvaluateInfoVOList(JsonUtil.getJsonToList(oaHrStaffQuarterPerformanceEvaluateList, HrmsPerformanceStaffQuarterEvaluateInfoVO.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsPerformanceTotalPointUpForm hrmsPerformanceTotalPointUpForm = (HrmsPerformanceTotalPointUpForm)((Object)JsonUtil.getJsonToBean(upData, HrmsPerformanceTotalPointUpForm.class));
        String flowEngineId = "511955041893212549";
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceStaffQuarterPrimaryEvaluateService.getInfo(id);
        if (entity != null) {
            HrmsPerformanceTotalPointEntity subentity = (HrmsPerformanceTotalPointEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointUpForm), HrmsPerformanceTotalPointEntity.class);
            this.hrmsPerformanceStaffQuarterPrimaryEvaluateService.update(id, subentity);
            QueryWrapper Oa_hr_staff_quarter_performance_evaluatequeryWrapper = new QueryWrapper();
            Oa_hr_staff_quarter_performance_evaluatequeryWrapper.lambda().eq(HrmsPerformanceStaffQuarterEvaluateEntity::getPrimaryId, (Object)entity.getId());
            this.hrmsPerformanceStaffQuarterEvaluateService.remove((Wrapper)Oa_hr_staff_quarter_performance_evaluatequeryWrapper);
            List oaHrStaffQuarterPerformanceEvaluateList = JsonUtil.getJsonToList(hrmsPerformanceTotalPointUpForm.getHrmsPerformanceStaffQuarterEvaluateInfoVOList(), HrmsPerformanceStaffQuarterEvaluateEntity.class);
            for (HrmsPerformanceStaffQuarterEvaluateEntity entitys : oaHrStaffQuarterPerformanceEvaluateList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setPrimaryId(entity.getId());
                this.hrmsPerformanceStaffQuarterEvaluateService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)hrmsPerformanceTotalPointUpForm.getTaskId(), (String)flowEngineId, (String)hrmsPerformanceTotalPointUpForm.getTemplateId(), (String)id, (Object)((Object)hrmsPerformanceTotalPointUpForm), (Integer)hrmsPerformanceTotalPointUpForm.getStatus());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceStaffQuarterPrimaryEvaluateService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.hrmsPerformanceStaffQuarterPrimaryEvaluateService.delete(entity);
            QueryWrapper queryWrapperOa_hr_staff_quarter_performance_evaluate = new QueryWrapper();
            queryWrapperOa_hr_staff_quarter_performance_evaluate.lambda().eq(HrmsPerformanceStaffQuarterEvaluateEntity::getPrimaryId, (Object)entity.getId());
            this.hrmsPerformanceStaffQuarterEvaluateService.remove((Wrapper)queryWrapperOa_hr_staff_quarter_performance_evaluate);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

