/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.hrms.entity.HrmsPerformanceDepAnnualEntity;
import com.bringspring.hrms.entity.HrmsPerformanceTotalPointEntity;
import com.bringspring.hrms.model.hrmsperformancedepannual.HrmsPerformanceDepAnnualInfoVO;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointCrForm;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointInfoVO;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointListVO;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointPagination;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointPaginationExportModel;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointPaginationVO;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointUpForm;
import com.bringspring.hrms.service.HrmsPerformanceDepAnnualService;
import com.bringspring.hrms.service.HrmsPerformanceTotalPointService;
import com.bringspring.hrms.util.OaConstants;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e3b\u5b50\u8868\u5e74\u5ea6\u7ee9\u6548"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaHrPerformanceTotalPoint"})
public class HrmsPerformanceTotalPointController {
    private static final Logger log = LoggerFactory.getLogger(HrmsPerformanceTotalPointController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsPerformanceTotalPointService hrmsPerformanceTotalPointService;
    @Autowired
    private HrmsPerformanceDepAnnualService hrmsPerformanceDepAnnualService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsPerformanceTotalPointPagination hrmsPerformanceTotalPointPagination) throws IOException {
        HrmsPerformanceTotalPointListVO vo2;
        List<HrmsPerformanceTotalPointEntity> list = this.hrmsPerformanceTotalPointService.getList(hrmsPerformanceTotalPointPagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceTotalPointListVO.class);
        for (HrmsPerformanceTotalPointListVO oaHrPerformanceTotalPointVO : listVO) {
            if (oaHrPerformanceTotalPointVO.getType().equals("depAnnualTarget")) {
                oaHrPerformanceTotalPointVO.setPerformanceQuarter("-");
            }
            oaHrPerformanceTotalPointVO.setApplyPersonName(this.baseDataUtil.userSelectValue(oaHrPerformanceTotalPointVO.getApplyPerson()));
            oaHrPerformanceTotalPointVO.setApplyDepartmentName(this.baseDataUtil.comSelectValues(oaHrPerformanceTotalPointVO.getApplyDepartment()));
            oaHrPerformanceTotalPointVO.setType(this.baseDataUtil.getDictName(oaHrPerformanceTotalPointVO.getType(), "applyType"));
        }
        for (HrmsPerformanceTotalPointListVO vo2 : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo2.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo2.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo2.setFlowState(null);
        }
        HrmsPerformanceTotalPointPaginationVO hrmsPerformanceTotalPointPaginationVO = this.hrmsPerformanceTotalPointService.getAllTypeDataNumber(hrmsPerformanceTotalPointPagination);
        vo2 = new PageListVO();
        vo2.setList(listVO);
        HrmsPerformanceTotalPointPaginationVO page = (HrmsPerformanceTotalPointPaginationVO)((Object)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointPagination), HrmsPerformanceTotalPointPaginationVO.class));
        hrmsPerformanceTotalPointPaginationVO.setCurrentPage(page.getCurrentPage());
        hrmsPerformanceTotalPointPaginationVO.setPageSize(page.getPageSize());
        hrmsPerformanceTotalPointPaginationVO.setTotal(page.getTotal());
        vo2.setPagination(hrmsPerformanceTotalPointPaginationVO);
        return ActionResult.success((Object)vo2);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsPerformanceTotalPointCrForm hrmsPerformanceTotalPointCrForm = (HrmsPerformanceTotalPointCrForm)((Object)JsonUtil.getJsonToBean(crData, HrmsPerformanceTotalPointCrForm.class));
        String flowEngineId = "510340260866281221";
        if (!hrmsPerformanceTotalPointCrForm.getType().equals("depAnnualTarget")) {
            flowEngineId = "510442421067437509";
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceTotalPointEntity entity = (HrmsPerformanceTotalPointEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointCrForm), HrmsPerformanceTotalPointEntity.class);
        List oaAnnualPerformanceFormEntities = JsonUtil.getJsonToList(hrmsPerformanceTotalPointCrForm.getOahrperformancetotalpointList(), HrmsPerformanceDepAnnualEntity.class);
        entity.setId(mainId);
        entity.setDocumentationMark(0);
        entity.setChildrenNumbers(oaAnnualPerformanceFormEntities.size());
        Boolean repeat = this.hrmsPerformanceTotalPointService.judgeSubmitPerformanceRepeat(hrmsPerformanceTotalPointCrForm);
        if (repeat.booleanValue()) {
            return ActionResult.success((String)"duplication");
        }
        this.hrmsPerformanceTotalPointService.save(entity);
        hrmsPerformanceTotalPointCrForm.setApplyDepartment(this.baseDataUtil.comSelectValues(entity.getApplyDepartment()));
        for (HrmsPerformanceDepAnnualEntity entitys : oaAnnualPerformanceFormEntities) {
            entitys.setId(RandomUtil.uuId());
            entitys.setPrimaryId(entity.getId());
            this.hrmsPerformanceDepAnnualService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)hrmsPerformanceTotalPointCrForm.getTaskId(), (String)flowEngineId, (String)hrmsPerformanceTotalPointCrForm.getTemplateId(), (String)mainId, (Object)((Object)hrmsPerformanceTotalPointCrForm), (Integer)hrmsPerformanceTotalPointCrForm.getStatus());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(HrmsPerformanceTotalPointPaginationExportModel hrmsPerformanceTotalPointPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)hrmsPerformanceTotalPointPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        HrmsPerformanceTotalPointPagination hrmsPerformanceTotalPointPagination = (HrmsPerformanceTotalPointPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointPaginationExportModel), HrmsPerformanceTotalPointPagination.class));
        List<HrmsPerformanceTotalPointEntity> list = this.hrmsPerformanceTotalPointService.getTypeList(hrmsPerformanceTotalPointPagination, hrmsPerformanceTotalPointPaginationExportModel.getDataType());
        for (HrmsPerformanceTotalPointEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceTotalPointListVO.class);
        for (HrmsPerformanceTotalPointListVO hrmsPerformanceTotalPointListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)hrmsPerformanceTotalPointPaginationExportModel.getSelectKey()) ? hrmsPerformanceTotalPointPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block16: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "performanceYear": {
                        entitys.add(new ExcelExportEntity("\u5e74\u4efd", (Object)"performanceYear"));
                        continue block16;
                    }
                    case "performanceQuarter": {
                        entitys.add(new ExcelExportEntity("\u5b63\u5ea6", (Object)"performanceQuarter"));
                        continue block16;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @DSTransactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        List<String> allIdList = Arrays.asList(idList);
        ArrayList<String> columnIdList = new ArrayList<String>(20);
        int i = 0;
        for (String allId : allIdList) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)allId, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity == null) {
                columnIdList.add(allId);
                continue;
            }
            if (!taskEntity.getStatus().equals(0)) continue;
            try {
                FlowUtil.deleteByProcessId((String)allId);
                columnIdList.add(allId);
                ++i;
            }
            catch (WorkFlowException e) {
                e.printStackTrace();
            }
        }
        this.hrmsPerformanceTotalPointService.removeByIds(columnIdList);
        if (i == 0 && columnIdList.size() == 0) {
            return ActionResult.fail((String)"\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/placeOnFile/{ids}"})
    @DSTransactional
    public ActionResult placeOnFile(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        List<String> allIdList = Arrays.asList(idList);
        ArrayList<HrmsPerformanceTotalPointEntity> oaHrPerformanceTotalPointEntities = new ArrayList<HrmsPerformanceTotalPointEntity>();
        for (String allId : allIdList) {
            HrmsPerformanceTotalPointEntity info = this.hrmsPerformanceTotalPointService.getInfo(allId);
            info.setDocumentationMark(1);
            oaHrPerformanceTotalPointEntities.add(info);
        }
        this.hrmsPerformanceTotalPointService.updateBatchById(oaHrPerformanceTotalPointEntities);
        return ActionResult.success((String)"\u5f52\u6863\u6210\u529f!");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsPerformanceTotalPointInfoVO> info(@PathVariable(value="id") String id) {
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceTotalPointService.getInfo(id);
        HrmsPerformanceTotalPointInfoVO vo = (HrmsPerformanceTotalPointInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceTotalPointInfoVO.class);
        vo.setApplyPersonName(this.baseDataUtil.userSelectValue(vo.getApplyPerson()));
        vo.setApplyDepartmentName(this.baseDataUtil.comSelectValues(vo.getApplyDepartment()));
        List<HrmsPerformanceDepAnnualEntity> oaHrDepAnnualPerformanceList = this.hrmsPerformanceTotalPointService.getAnnualPerformanceList(id);
        vo.setOaHrPerformanceTotalPointList(JsonUtil.getJsonToList(oaHrDepAnnualPerformanceList, HrmsPerformanceDepAnnualInfoVO.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsPerformanceTotalPointUpForm hrmsPerformanceTotalPointUpForm = (HrmsPerformanceTotalPointUpForm)((Object)JsonUtil.getJsonToBean(upData, HrmsPerformanceTotalPointUpForm.class));
        String flowEngineId = "510340260866281221";
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceTotalPointService.getInfo(id);
        if (entity != null) {
            HrmsPerformanceTotalPointEntity subentity = (HrmsPerformanceTotalPointEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointUpForm), HrmsPerformanceTotalPointEntity.class);
            this.hrmsPerformanceTotalPointService.update(id, subentity);
            QueryWrapper oaHrDepAnnualPerformancequeryWrapper = new QueryWrapper();
            oaHrDepAnnualPerformancequeryWrapper.lambda().eq(HrmsPerformanceDepAnnualEntity::getPrimaryId, (Object)entity.getId());
            this.hrmsPerformanceDepAnnualService.remove((Wrapper)oaHrDepAnnualPerformancequeryWrapper);
            List oaHrDepAnnualPerformanceList = JsonUtil.getJsonToList(hrmsPerformanceTotalPointUpForm.getOahrperformancetotalpointList(), HrmsPerformanceDepAnnualEntity.class);
            for (HrmsPerformanceDepAnnualEntity entitys : oaHrDepAnnualPerformanceList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setPrimaryId(entity.getId());
                this.hrmsPerformanceDepAnnualService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)hrmsPerformanceTotalPointUpForm.getTaskId(), (String)flowEngineId, (String)hrmsPerformanceTotalPointUpForm.getTemplateId(), (String)id, (Object)((Object)hrmsPerformanceTotalPointUpForm), (Integer)hrmsPerformanceTotalPointUpForm.getStatus());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceTotalPointService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.hrmsPerformanceTotalPointService.delete(entity);
            QueryWrapper queryWrapperoaHrDepAnnualPerformance = new QueryWrapper();
            queryWrapperoaHrDepAnnualPerformance.lambda().eq(HrmsPerformanceDepAnnualEntity::getPrimaryId, (Object)entity.getId());
            this.hrmsPerformanceDepAnnualService.remove((Wrapper)queryWrapperoaHrDepAnnualPerformance);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getDepQuarterListevaluate"})
    public ActionResult DepQuarterList(@RequestBody HrmsPerformanceTotalPointPagination hrmsPerformanceTotalPointPagination) throws IOException {
        List<HrmsPerformanceTotalPointEntity> list = this.hrmsPerformanceTotalPointService.getList(hrmsPerformanceTotalPointPagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceTotalPointListVO.class);
        for (HrmsPerformanceTotalPointListVO oaHrPerformanceTotalPointVO : listVO) {
            if (OaConstants.DEP_FORM_TYPE.contains(oaHrPerformanceTotalPointVO.getType())) {
                oaHrPerformanceTotalPointVO.setApplyId(this.baseDataUtil.comSelectValues(oaHrPerformanceTotalPointVO.getApplyId()));
            } else {
                oaHrPerformanceTotalPointVO.setApplyId(this.baseDataUtil.userSelectValues(oaHrPerformanceTotalPointVO.getApplyId()));
            }
            oaHrPerformanceTotalPointVO.setType(this.baseDataUtil.getDictName(oaHrPerformanceTotalPointVO.getType(), "510104426388901317"));
        }
        for (HrmsPerformanceTotalPointListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }
}

