/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.hrms.entity.HrmsTeachPlanDetailEntity;
import com.bringspring.hrms.entity.HrmsTeachPlanEntity;
import com.bringspring.hrms.model.hrmsteachplan.HrmsTeachPlanCrForm;
import com.bringspring.hrms.model.hrmsteachplan.HrmsTeachPlanDetailExportModel;
import com.bringspring.hrms.model.hrmsteachplan.HrmsTeachPlanDetailModel;
import com.bringspring.hrms.model.hrmsteachplan.HrmsTeachPlanInfoVO;
import com.bringspring.hrms.model.hrmsteachplan.HrmsTeachPlanListVO;
import com.bringspring.hrms.model.hrmsteachplan.HrmsTeachPlanPagination;
import com.bringspring.hrms.model.hrmsteachplan.HrmsTeachPlanPaginationExportModel;
import com.bringspring.hrms.model.hrmsteachplan.HrmsTeachPlanUpForm;
import com.bringspring.hrms.service.HrmsManagerEntryCompanyService;
import com.bringspring.hrms.service.HrmsTeachPlanDetailService;
import com.bringspring.hrms.service.HrmsTeachPlanService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5e26\u6559\u8ba1\u5212"}, value="oa")
@RequestMapping(value={"/api/oa/HrmsTeachPlan"})
public class HrmsTeachPlanController {
    private static final Logger log = LoggerFactory.getLogger(HrmsTeachPlanController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsTeachPlanService hrmsTeachPlanService;
    @Autowired
    private HrmsTeachPlanDetailService hrms_teachPlanDetailService;
    @Autowired
    private HrmsManagerEntryCompanyService hrmsManagerEntryCompanyService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsTeachPlanPagination hrmsTeachPlanPagination) throws IOException {
        List<HrmsTeachPlanEntity> list = this.hrmsTeachPlanService.getList(hrmsTeachPlanPagination);
        for (HrmsTeachPlanEntity iterator : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsTeachPlanListVO.class);
        for (HrmsTeachPlanListVO hrmsTeachPlanVO : listVO) {
            hrmsTeachPlanVO.setCreatorUserId(this.baseDataUtil.userSelectValue(hrmsTeachPlanVO.getCreatorUserId()));
            hrmsTeachPlanVO.setTeacher(this.baseDataUtil.userSelectValues(hrmsTeachPlanVO.getTeacher()));
            hrmsTeachPlanVO.setStudentName(this.baseDataUtil.userSelectValues(hrmsTeachPlanVO.getStudent()));
            hrmsTeachPlanVO.setPlanPhase(this.baseDataUtil.getDictName(hrmsTeachPlanVO.getPlanPhase(), "615508715990186181"));
        }
        for (HrmsTeachPlanListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsTeachPlanPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getListByUser/{id}"})
    public ActionResult getListByUser(@PathVariable(value="id") String id) throws IOException {
        List<HrmsTeachPlanDetailEntity> detailList = this.hrms_teachPlanDetailService.getListByUser(id);
        ArrayList<HrmsTeachPlanDetailModel> listVO = new ArrayList<HrmsTeachPlanDetailModel>();
        for (HrmsTeachPlanDetailEntity vo : detailList) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getParentId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity == null || !flowTaskEntity.getStatus().toString().equals("2")) continue;
            HrmsTeachPlanDetailModel o = (HrmsTeachPlanDetailModel)JsonUtil.getJsonToBean((Object)vo, HrmsTeachPlanDetailModel.class);
            o.setPlanPhase(this.baseDataUtil.getDictName(o.getPlanPhase(), "615508715990186181"));
            listVO.add(o);
        }
        return ActionResult.success(listVO);
    }

    @PostMapping(value={"/listGroupByUser"})
    public ActionResult listGroupByUser(@RequestBody HrmsTeachPlanPagination hrmsTeachPlanPagination) throws IOException {
        List<HrmsTeachPlanEntity> list = this.hrmsTeachPlanService.listGroupByUser(hrmsTeachPlanPagination);
        List<HrmsTeachPlanDetailEntity> detailList = this.hrms_teachPlanDetailService.getList(hrmsTeachPlanPagination);
        List voList = JsonUtil.getJsonToList(list, HrmsTeachPlanInfoVO.class);
        for (HrmsTeachPlanInfoVO vo : voList) {
            vo.setHrmsTeachPlanList(JsonUtil.getJsonToList(detailList.stream().filter(a -> a.getStudent().equals(vo.getStudent())).collect(Collectors.toList()), HrmsTeachPlanDetailModel.class));
            vo.setPlanPhase(vo.getHrmsTeachPlanList().stream().map(HrmsTeachPlanDetailModel::getPlanPhase).distinct().collect(Collectors.joining(",")));
            vo.setPlanPhase(this.baseDataUtil.getDictName(vo.getPlanPhase(), "615508715990186181"));
            vo.setTeacher(this.baseDataUtil.userSelectValues(vo.getHrmsTeachPlanList().stream().map(HrmsTeachPlanDetailModel::getTeacher).distinct().collect(Collectors.joining(","))));
            vo.setStudentName(this.baseDataUtil.userSelectValue(vo.getStudent()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(voList);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsTeachPlanPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsTeachPlanCrForm hrmsTeachPlanCrForm = (HrmsTeachPlanCrForm)JsonUtil.getJsonToBean(crData, HrmsTeachPlanCrForm.class);
        String visualId = "615507900114172101";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        hrmsTeachPlanCrForm.setCreatorUserId(userInfo.getUserId());
        hrmsTeachPlanCrForm.setCreatorTime(DateUtil.getNow());
        HrmsTeachPlanEntity entity = (HrmsTeachPlanEntity)JsonUtil.getJsonToBean((Object)hrmsTeachPlanCrForm, HrmsTeachPlanEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.hrmsTeachPlanService.save(entity);
        List Hrms_teach_plan_detailList = JsonUtil.getJsonToList(hrmsTeachPlanCrForm.getHrmsTeachPlanListOne(), HrmsTeachPlanDetailEntity.class);
        for (Object entitys : Hrms_teach_plan_detailList) {
            ((HrmsTeachPlanDetailEntity)entitys).setId(RandomUtil.uuId());
            ((HrmsTeachPlanDetailEntity)entitys).setParentId(entity.getId());
            ((HrmsTeachPlanDetailEntity)entitys).setStudent(entity.getStudent());
            ((HrmsTeachPlanDetailEntity)entitys).setTeacher(entity.getTeacher());
            ((HrmsTeachPlanDetailEntity)entitys).setPlanPhase("615508865731033285");
            this.hrms_teachPlanDetailService.save(entitys);
        }
        List Hrms_teach_plan_detailList_two = JsonUtil.getJsonToList(hrmsTeachPlanCrForm.getHrmsTeachPlanListTwo(), HrmsTeachPlanDetailEntity.class);
        for (Object entitys : Hrms_teach_plan_detailList_two) {
            ((HrmsTeachPlanDetailEntity)entitys).setId(RandomUtil.uuId());
            ((HrmsTeachPlanDetailEntity)entitys).setParentId(entity.getId());
            ((HrmsTeachPlanDetailEntity)entitys).setStudent(entity.getStudent());
            ((HrmsTeachPlanDetailEntity)entitys).setTeacher(entity.getTeacher());
            ((HrmsTeachPlanDetailEntity)entitys).setPlanPhase("615508922668710085");
            this.hrms_teachPlanDetailService.save(entitys);
        }
        List Hrms_teach_plan_detailList_three = JsonUtil.getJsonToList(hrmsTeachPlanCrForm.getHrmsTeachPlanListThree(), HrmsTeachPlanDetailEntity.class);
        for (Object entitys : Hrms_teach_plan_detailList_three) {
            ((HrmsTeachPlanDetailEntity)entitys).setId(RandomUtil.uuId());
            ((HrmsTeachPlanDetailEntity)entitys).setParentId(entity.getId());
            ((HrmsTeachPlanDetailEntity)entitys).setStudent(entity.getStudent());
            ((HrmsTeachPlanDetailEntity)entitys).setTeacher(entity.getTeacher());
            ((HrmsTeachPlanDetailEntity)entitys).setPlanPhase("615508956512549061");
            this.hrms_teachPlanDetailService.save(entitys);
        }
        List Hrms_teach_plan_detailList_five = JsonUtil.getJsonToList(hrmsTeachPlanCrForm.getHrmsTeachPlanListFive(), HrmsTeachPlanDetailEntity.class);
        for (HrmsTeachPlanDetailEntity entitys : Hrms_teach_plan_detailList_five) {
            entitys.setId(RandomUtil.uuId());
            entitys.setParentId(entity.getId());
            entitys.setStudent(entity.getStudent());
            entitys.setTeacher(entity.getTeacher());
            entitys.setPlanPhase("615508995267918021");
            this.hrms_teachPlanDetailService.save(entitys);
        }
        String title = this.baseDataUtil.userSelectValue(hrmsTeachPlanCrForm.getStudent());
        FlowUtil.saveOrSubmit((String)hrmsTeachPlanCrForm.getTaskId(), (String)visualId, (String)hrmsTeachPlanCrForm.getTemplateId(), (String)mainId, (Object)hrmsTeachPlanCrForm, (Integer)hrmsTeachPlanCrForm.getStatus(), (String)title);
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(HrmsTeachPlanPaginationExportModel hrmsTeachPlanPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)hrmsTeachPlanPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        HrmsTeachPlanPagination hrmsTeachPlanPagination = (HrmsTeachPlanPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)hrmsTeachPlanPaginationExportModel), HrmsTeachPlanPagination.class));
        List<HrmsTeachPlanDetailEntity> list = this.hrms_teachPlanDetailService.getTypeList(hrmsTeachPlanPagination, hrmsTeachPlanPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, HrmsTeachPlanDetailExportModel.class);
        for (HrmsTeachPlanDetailExportModel entity : listVO) {
            HrmsTeachPlanEntity mainData = this.hrmsTeachPlanService.getInfo(entity.getParentId());
            entity.setCreatorTime(DateUtil.format((Date)mainData.getCreatorTime(), (String)"yyyy-MM-dd"));
            entity.setTeacher(this.baseDataUtil.userSelectValues(entity.getTeacher()));
            entity.setStudent(this.baseDataUtil.userSelectValues(entity.getStudent()));
            entity.setPlanPhase(this.baseDataUtil.getDictName(entity.getPlanPhase(), "615508715990186181"));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)hrmsTeachPlanPaginationExportModel.getSelectKey()) ? hrmsTeachPlanPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/ExportInfo/{id}"})
    public ActionResult ExportInfo(@PathVariable(value="id") String id) throws IOException {
        HrmsTeachPlanDetailEntity vo2;
        List<HrmsTeachPlanDetailEntity> detailList = this.hrms_teachPlanDetailService.getListByUser(id);
        ArrayList<HrmsTeachPlanDetailModel> listVO = new ArrayList<HrmsTeachPlanDetailModel>();
        for (HrmsTeachPlanDetailEntity vo2 : detailList) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo2.getParentId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity == null || !flowTaskEntity.getStatus().toString().equals("2")) continue;
            HrmsTeachPlanDetailModel o = (HrmsTeachPlanDetailModel)JsonUtil.getJsonToBean((Object)vo2, HrmsTeachPlanDetailModel.class);
            o.setPlanPhase(this.baseDataUtil.getDictName(o.getPlanPhase(), "615508715990186181"));
            listVO.add(o);
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        vo2 = this.creatModelExcelData(this.configValueUtil.getTemporaryFilePath(), mapList, this.baseDataUtil.userSelectValue(id));
        return ActionResult.success((Object)vo2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block24: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block24;
                    }
                    case "teacher": {
                        entitys.add(new ExcelExportEntity("\u5e26\u6559\u4eba", (Object)"teacher"));
                        continue block24;
                    }
                    case "student": {
                        entitys.add(new ExcelExportEntity("\u5458\u5de5", (Object)"student"));
                        continue block24;
                    }
                    case "planPhase": {
                        entitys.add(new ExcelExportEntity("\u8003\u6838\u8ba1\u5212\u9636\u6bb5", (Object)"planPhase"));
                        continue block24;
                    }
                    case "phaseAim": {
                        entitys.add(new ExcelExportEntity("\u9636\u6bb5\u76ee\u6807", (Object)"phaseAim"));
                        continue block24;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5e26\u6559\u5de5\u4f5c\u8ba1\u5212\u53ca\u5b89\u6392\u7ec6\u8282", (Object)"description"));
                        continue block24;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcelData(String path, List<Map<String, Object>> list, String title) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        entitys.add(new ExcelExportEntity("\u8003\u6838\u8ba1\u5212\u9636\u6bb5", (Object)"planPhase"));
        entitys.add(new ExcelExportEntity("\u9636\u6bb5\u76ee\u6807", (Object)"phaseAim"));
        entitys.add(new ExcelExportEntity("\u5e26\u6559\u5de5\u4f5c\u8ba1\u5212\u53ca\u5b89\u6392\u7ec6\u8282", (Object)"description"));
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
                    dataList.addAll(list);
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                    Sheet sheet = workbook.getSheet("\u8868\u5355\u4fe1\u606f");
                    int startNum = 0;
                    int startAimNum = 0;
                    for (int i = 0; i < dataList.size(); ++i) {
                        if (i <= 0) continue;
                        if (!ObjectUtil.equals(((Map)dataList.get(i - 1)).get("planPhase"), ((Map)dataList.get(i)).get("planPhase"))) {
                            startNum = i;
                            startAimNum = i;
                            continue;
                        }
                        if (i < dataList.size() - 1) {
                            if (!ObjectUtil.equals(((Map)dataList.get(i + 1)).get("planPhase"), ((Map)dataList.get(i)).get("planPhase"))) {
                                sheet.addMergedRegion(new CellRangeAddress(startNum + 1, i + 1, 0, 0));
                            }
                            if (!ObjectUtil.equals(((Map)dataList.get(i - 1)).get("phaseAim"), ((Map)dataList.get(i)).get("phaseAim"))) {
                                startAimNum = i;
                                continue;
                            }
                            if (ObjectUtil.equals(((Map)dataList.get(i + 1)).get("phaseAim"), ((Map)dataList.get(i)).get("phaseAim"))) continue;
                            sheet.addMergedRegion(new CellRangeAddress(startAimNum + 1, i + 1, 1, 1));
                            continue;
                        }
                        if (startNum != i) {
                            sheet.addMergedRegion(new CellRangeAddress(startNum + 1, i + 1, 0, 0));
                        }
                        if (startAimNum == i) continue;
                        sheet.addMergedRegion(new CellRangeAddress(startAimNum + 1, i + 1, 1, 1));
                    }
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(title + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsTeachPlanInfoVO> info(@PathVariable(value="id") String id) {
        HrmsTeachPlanEntity entity = this.hrmsTeachPlanService.getInfo(id);
        HrmsTeachPlanInfoVO vo = (HrmsTeachPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsTeachPlanInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        List<HrmsTeachPlanDetailEntity> Hrms_teach_plan_detailList = this.hrmsTeachPlanService.GetHrmsTeachPlanDetailList(id);
        for (HrmsTeachPlanDetailEntity detail : Hrms_teach_plan_detailList) {
            detail.setPlanPhaseName(this.baseDataUtil.getDictName(detail.getPlanPhase(), "HrmsTeachPlanPhase"));
        }
        vo.setHrmsTeachPlanList(JsonUtil.getJsonToList(Hrms_teach_plan_detailList, HrmsTeachPlanDetailModel.class));
        vo.setHrmsTeachPlanListOne(vo.getHrmsTeachPlanList().stream().filter(a -> "615508865731033285".equals(a.getPlanPhase())).collect(Collectors.toList()));
        vo.setHrmsTeachPlanListTwo(vo.getHrmsTeachPlanList().stream().filter(a -> "615508922668710085".equals(a.getPlanPhase())).collect(Collectors.toList()));
        vo.setHrmsTeachPlanListThree(vo.getHrmsTeachPlanList().stream().filter(a -> "615508956512549061".equals(a.getPlanPhase())).collect(Collectors.toList()));
        vo.setHrmsTeachPlanListFive(vo.getHrmsTeachPlanList().stream().filter(a -> "615508995267918021".equals(a.getPlanPhase())).collect(Collectors.toList()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsTeachPlanUpForm hrmsTeachPlanUpForm = (HrmsTeachPlanUpForm)JsonUtil.getJsonToBean(upData, HrmsTeachPlanUpForm.class);
        String visualId = "615507900114172101";
        UserInfo userInfo = this.userProvider.get();
        HrmsTeachPlanEntity entity = this.hrmsTeachPlanService.getInfo(id);
        if (entity != null) {
            HrmsTeachPlanEntity subentity = (HrmsTeachPlanEntity)JsonUtil.getJsonToBean((Object)hrmsTeachPlanUpForm, HrmsTeachPlanEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.hrmsTeachPlanService.update(id, subentity);
            QueryWrapper Hrms_teach_plan_detailqueryWrapper = new QueryWrapper();
            Hrms_teach_plan_detailqueryWrapper.lambda().eq(HrmsTeachPlanDetailEntity::getParentId, (Object)entity.getId());
            this.hrms_teachPlanDetailService.remove((Wrapper)Hrms_teach_plan_detailqueryWrapper);
            List Hrms_teach_plan_detailList = JsonUtil.getJsonToList(hrmsTeachPlanUpForm.getHrmsTeachPlanListOne(), HrmsTeachPlanDetailEntity.class);
            for (Object entitys : Hrms_teach_plan_detailList) {
                ((HrmsTeachPlanDetailEntity)entitys).setId(RandomUtil.uuId());
                ((HrmsTeachPlanDetailEntity)entitys).setParentId(entity.getId());
                ((HrmsTeachPlanDetailEntity)entitys).setStudent(entity.getStudent());
                ((HrmsTeachPlanDetailEntity)entitys).setTeacher(entity.getTeacher());
                ((HrmsTeachPlanDetailEntity)entitys).setPlanPhase("615508865731033285");
                this.hrms_teachPlanDetailService.save(entitys);
            }
            List Hrms_teach_plan_detailList_two = JsonUtil.getJsonToList(hrmsTeachPlanUpForm.getHrmsTeachPlanListTwo(), HrmsTeachPlanDetailEntity.class);
            for (Object entitys : Hrms_teach_plan_detailList_two) {
                ((HrmsTeachPlanDetailEntity)entitys).setId(RandomUtil.uuId());
                ((HrmsTeachPlanDetailEntity)entitys).setParentId(entity.getId());
                ((HrmsTeachPlanDetailEntity)entitys).setStudent(entity.getStudent());
                ((HrmsTeachPlanDetailEntity)entitys).setTeacher(entity.getTeacher());
                ((HrmsTeachPlanDetailEntity)entitys).setPlanPhase("615508922668710085");
                this.hrms_teachPlanDetailService.save(entitys);
            }
            List Hrms_teach_plan_detailList_three = JsonUtil.getJsonToList(hrmsTeachPlanUpForm.getHrmsTeachPlanListThree(), HrmsTeachPlanDetailEntity.class);
            for (Object entitys : Hrms_teach_plan_detailList_three) {
                ((HrmsTeachPlanDetailEntity)entitys).setId(RandomUtil.uuId());
                ((HrmsTeachPlanDetailEntity)entitys).setParentId(entity.getId());
                ((HrmsTeachPlanDetailEntity)entitys).setStudent(entity.getStudent());
                ((HrmsTeachPlanDetailEntity)entitys).setTeacher(entity.getTeacher());
                ((HrmsTeachPlanDetailEntity)entitys).setPlanPhase("615508956512549061");
                this.hrms_teachPlanDetailService.save(entitys);
            }
            List Hrms_teach_plan_detailList_five = JsonUtil.getJsonToList(hrmsTeachPlanUpForm.getHrmsTeachPlanListFive(), HrmsTeachPlanDetailEntity.class);
            for (HrmsTeachPlanDetailEntity entitys : Hrms_teach_plan_detailList_five) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(entity.getId());
                entitys.setStudent(entity.getStudent());
                entitys.setTeacher(entity.getTeacher());
                entitys.setPlanPhase("615508995267918021");
                this.hrms_teachPlanDetailService.save(entitys);
            }
            String title = this.baseDataUtil.userSelectValue(hrmsTeachPlanUpForm.getStudent());
            FlowUtil.saveOrSubmit((String)hrmsTeachPlanUpForm.getTaskId(), (String)visualId, (String)hrmsTeachPlanUpForm.getTemplateId(), (String)id, (Object)hrmsTeachPlanUpForm, (Integer)hrmsTeachPlanUpForm.getStatus(), (String)title);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsTeachPlanEntity entity = this.hrmsTeachPlanService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.hrmsTeachPlanService.delete(entity);
            QueryWrapper queryWrapperHrms_teach_plan_detail = new QueryWrapper();
            queryWrapperHrms_teach_plan_detail.lambda().eq(HrmsTeachPlanDetailEntity::getParentId, (Object)entity.getId());
            this.hrms_teachPlanDetailService.remove((Wrapper)queryWrapperHrms_teach_plan_detail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

