/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.attendance.utils.SendRequest;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsAttendanceCalendarEntity;
import com.bringspring.hrms.mapper.HrmsAttendanceCalendarMapper;
import com.bringspring.hrms.model.hrmsattendancecalendar.HrmsAttendanceCalendarPagination;
import com.bringspring.hrms.service.HrmsAttendanceCalendarService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HrmsAttendanceCalendarServiceImpl
extends ServiceImpl<HrmsAttendanceCalendarMapper, HrmsAttendanceCalendarEntity>
implements HrmsAttendanceCalendarService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<HrmsAttendanceCalendarEntity> getList(HrmsAttendanceCalendarPagination hrmsAttendanceCalendarPagination) {
        Object hrmsAttendanceCalendarObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int hrmsAttendanceCalendarNum = 0;
        QueryWrapper hrmsAttendanceCalendarQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            hrmsAttendanceCalendarObj = this.authorizeService.getCondition(new AuthorizeConditionModel(hrmsAttendanceCalendarQueryWrapper, hrmsAttendanceCalendarPagination.getMenuId(), "hrmsAttendanceCalendar"));
            if (ObjectUtil.isEmpty((Object)hrmsAttendanceCalendarObj)) {
                return new ArrayList<HrmsAttendanceCalendarEntity>();
            }
            hrmsAttendanceCalendarQueryWrapper = (QueryWrapper)hrmsAttendanceCalendarObj;
            ++hrmsAttendanceCalendarNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            hrmsAttendanceCalendarObj = this.authorizeService.getCondition(new AuthorizeConditionModel(hrmsAttendanceCalendarQueryWrapper, hrmsAttendanceCalendarPagination.getMenuId(), "hrmsAttendanceCalendar"));
            if (ObjectUtil.isEmpty((Object)hrmsAttendanceCalendarObj)) {
                return new ArrayList<HrmsAttendanceCalendarEntity>();
            }
            hrmsAttendanceCalendarQueryWrapper = (QueryWrapper)hrmsAttendanceCalendarObj;
            ++hrmsAttendanceCalendarNum;
        }
        if (StringUtil.isNotEmpty((String)hrmsAttendanceCalendarPagination.getWdate())) {
            ++hrmsAttendanceCalendarNum;
            hrmsAttendanceCalendarQueryWrapper.lambda().like(HrmsAttendanceCalendarEntity::getWdate, (Object)hrmsAttendanceCalendarPagination.getWdate());
        }
        if (ObjectUtil.isNotEmpty(hrmsAttendanceCalendarPagination.getWdateList())) {
            ++hrmsAttendanceCalendarNum;
            hrmsAttendanceCalendarQueryWrapper.lambda().between(HrmsAttendanceCalendarEntity::getWdate, (Object)hrmsAttendanceCalendarPagination.getWdateList().get(0), (Object)hrmsAttendanceCalendarPagination.getWdateList().get(1));
        }
        if (StringUtil.isNotEmpty((String)hrmsAttendanceCalendarPagination.getWorktime())) {
            ++hrmsAttendanceCalendarNum;
            hrmsAttendanceCalendarQueryWrapper.lambda().like(HrmsAttendanceCalendarEntity::getWorktime, (Object)hrmsAttendanceCalendarPagination.getWorktime());
        }
        if (StringUtil.isNotEmpty((String)hrmsAttendanceCalendarPagination.getWeekstart())) {
            ++hrmsAttendanceCalendarNum;
            hrmsAttendanceCalendarQueryWrapper.lambda().like(HrmsAttendanceCalendarEntity::getWeekstart, (Object)hrmsAttendanceCalendarPagination.getWeekstart());
        }
        if (StringUtil.isNotEmpty((String)hrmsAttendanceCalendarPagination.getTriplesalary())) {
            ++hrmsAttendanceCalendarNum;
            hrmsAttendanceCalendarQueryWrapper.lambda().like(HrmsAttendanceCalendarEntity::getTriplesalary, (Object)hrmsAttendanceCalendarPagination.getTriplesalary());
        }
        if (AllIdList.size() > 0) {
            // empty if block
        }
        if (!StringUtil.isEmpty((String)hrmsAttendanceCalendarPagination.getSidx())) {
            try {
                String sidx = hrmsAttendanceCalendarPagination.getSidx();
                HrmsAttendanceCalendarEntity hrmsAttendanceCalendarEntity = new HrmsAttendanceCalendarEntity();
                Field declaredField = hrmsAttendanceCalendarEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                hrmsAttendanceCalendarQueryWrapper = "asc".equals(hrmsAttendanceCalendarPagination.getSort().toLowerCase()) ? (QueryWrapper)hrmsAttendanceCalendarQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)hrmsAttendanceCalendarQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(hrmsAttendanceCalendarPagination.getCurrentPage(), hrmsAttendanceCalendarPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)hrmsAttendanceCalendarQueryWrapper);
            return hrmsAttendanceCalendarPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return hrmsAttendanceCalendarPagination.setData(list, list.size());
    }

    @Override
    public List<HrmsAttendanceCalendarEntity> getTypeList(HrmsAttendanceCalendarPagination hrmsAttendanceCalendarPagination, String dataType) {
        Object hrmsAttendanceCalendarObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int hrmsAttendanceCalendarNum = 0;
        QueryWrapper hrmsAttendanceCalendarQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            hrmsAttendanceCalendarObj = this.authorizeService.getCondition(new AuthorizeConditionModel(hrmsAttendanceCalendarQueryWrapper, hrmsAttendanceCalendarPagination.getMenuId(), "hrmsAttendanceCalendar"));
            if (ObjectUtil.isEmpty((Object)hrmsAttendanceCalendarObj)) {
                return new ArrayList<HrmsAttendanceCalendarEntity>();
            }
            hrmsAttendanceCalendarQueryWrapper = (QueryWrapper)hrmsAttendanceCalendarObj;
            ++hrmsAttendanceCalendarNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            hrmsAttendanceCalendarObj = this.authorizeService.getCondition(new AuthorizeConditionModel(hrmsAttendanceCalendarQueryWrapper, hrmsAttendanceCalendarPagination.getMenuId(), "hrmsAttendanceCalendar"));
            if (ObjectUtil.isEmpty((Object)hrmsAttendanceCalendarObj)) {
                return new ArrayList<HrmsAttendanceCalendarEntity>();
            }
            hrmsAttendanceCalendarQueryWrapper = (QueryWrapper)hrmsAttendanceCalendarObj;
            ++hrmsAttendanceCalendarNum;
        }
        if (StringUtil.isNotEmpty((String)hrmsAttendanceCalendarPagination.getWdate())) {
            ++hrmsAttendanceCalendarNum;
            hrmsAttendanceCalendarQueryWrapper.lambda().like(HrmsAttendanceCalendarEntity::getWdate, (Object)hrmsAttendanceCalendarPagination.getWdate());
        }
        if (StringUtil.isNotEmpty((String)hrmsAttendanceCalendarPagination.getWorktime())) {
            ++hrmsAttendanceCalendarNum;
            hrmsAttendanceCalendarQueryWrapper.lambda().like(HrmsAttendanceCalendarEntity::getWorktime, (Object)hrmsAttendanceCalendarPagination.getWorktime());
        }
        if (StringUtil.isNotEmpty((String)hrmsAttendanceCalendarPagination.getWeekstart())) {
            ++hrmsAttendanceCalendarNum;
            hrmsAttendanceCalendarQueryWrapper.lambda().like(HrmsAttendanceCalendarEntity::getWeekstart, (Object)hrmsAttendanceCalendarPagination.getWeekstart());
        }
        if (StringUtil.isNotEmpty((String)hrmsAttendanceCalendarPagination.getTriplesalary())) {
            ++hrmsAttendanceCalendarNum;
            hrmsAttendanceCalendarQueryWrapper.lambda().like(HrmsAttendanceCalendarEntity::getTriplesalary, (Object)hrmsAttendanceCalendarPagination.getTriplesalary());
        }
        if (AllIdList.size() > 0) {
            // empty if block
        }
        if (!StringUtil.isEmpty((String)hrmsAttendanceCalendarPagination.getSidx())) {
            try {
                String sidx = hrmsAttendanceCalendarPagination.getSidx();
                HrmsAttendanceCalendarEntity hrmsAttendanceCalendarEntity = new HrmsAttendanceCalendarEntity();
                Field declaredField = hrmsAttendanceCalendarEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                hrmsAttendanceCalendarQueryWrapper = "asc".equals(hrmsAttendanceCalendarPagination.getSort().toLowerCase()) ? (QueryWrapper)hrmsAttendanceCalendarQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)hrmsAttendanceCalendarQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(hrmsAttendanceCalendarPagination.getCurrentPage(), hrmsAttendanceCalendarPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)hrmsAttendanceCalendarQueryWrapper);
                return hrmsAttendanceCalendarPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return hrmsAttendanceCalendarPagination.setData(list, list.size());
        }
        return this.list((Wrapper)hrmsAttendanceCalendarQueryWrapper);
    }

    @Override
    public HrmsAttendanceCalendarEntity getInfo(String wdate) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(HrmsAttendanceCalendarEntity::getWdate, (Object)wdate);
        return (HrmsAttendanceCalendarEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(HrmsAttendanceCalendarEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, HrmsAttendanceCalendarEntity entity) {
        return this.updateById(entity);
    }

    @Override
    public List<HrmsAttendanceCalendarEntity> getListByWdate(Date wdateStart, Date wdateEnd) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().ge(HrmsAttendanceCalendarEntity::getWdate, (Object)wdateStart);
        queryWrapper.lambda().le(HrmsAttendanceCalendarEntity::getWdate, (Object)wdateEnd);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<HrmsAttendanceCalendarEntity> getBeforeWorkDate(Date startDate, Integer num, boolean isExcludeNotWork) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().le(HrmsAttendanceCalendarEntity::getWdate, (Object)startDate);
        if (isExcludeNotWork) {
            queryWrapper.lambda().gt(HrmsAttendanceCalendarEntity::getWorktime, (Object)0);
        }
        queryWrapper.lambda().orderByDesc(HrmsAttendanceCalendarEntity::getWdate);
        queryWrapper.last("limit " + num);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public HrmsAttendanceCalendarEntity getOneByWdate(String wdate) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(HrmsAttendanceCalendarEntity::getWdate, (Object)wdate);
        return (HrmsAttendanceCalendarEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void generateCalendarData(Integer year) {
        ArrayList<String> list = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        ArrayList<HrmsAttendanceCalendarEntity> calendarEntities = new ArrayList<HrmsAttendanceCalendarEntity>();
        for (int j = 1; j <= 12; ++j) {
            calendar.set(year, j, 1);
            calendar.add(5, -1);
            int maxDay = calendar.getActualMaximum(5);
            for (int i = 1; i <= maxDay; ++i) {
                list.add(calendar.get(1) + "-" + j + "-" + i);
                Calendar calendar2 = Calendar.getInstance();
                calendar2.set(year, j - 1, i);
                HrmsAttendanceCalendarEntity calendarEntity = new HrmsAttendanceCalendarEntity();
                calendarEntity.setWdate(calendar2.getTime());
                int week = calendar2.get(7);
                if (week == 1 || week == 7) {
                    calendarEntity.setWorktime(0);
                } else {
                    calendarEntity.setWorktime(8);
                }
                calendarEntities.add(calendarEntity);
            }
        }
        JSONObject jsonObject = SendRequest.sendGet("http://timor.tech/api/holiday/year/2025/");
        JSONObject holiday = jsonObject.getJSONObject("holiday");
        Set keySet = holiday.keySet();
        for (String key : keySet) {
            JSONObject object = holiday.getJSONObject(key);
            Boolean flag = (Boolean)object.get((Object)"holiday");
            Integer wage = (Integer)object.get((Object)"wage");
            for (HrmsAttendanceCalendarEntity calendarEntity : calendarEntities) {
                if (!StrUtil.equals((CharSequence)DateUtil.daFormat((Date)calendarEntity.getWdate()), (CharSequence)(year + "-" + key))) continue;
                calendarEntity.setWorktime(flag != false ? 0 : 8);
                calendarEntity.setTriplesalary(flag != false && wage == 3 ? Integer.valueOf(1) : null);
            }
        }
        this.saveBatch(calendarEntities);
        System.out.println(jsonObject);
    }

    @Override
    public void delete(HrmsAttendanceCalendarEntity entity) {
        if (entity != null) {
            // empty if block
        }
    }
}

