/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.util.DateUtil;
import com.bringspring.crm.config.AppPageConfig;
import com.bringspring.crm.constant.MessageTypeConst;
import com.bringspring.hrms.entity.HrmsEmployeArchiveEntity;
import com.bringspring.hrms.service.HrmsEmployeArchiveService;
import com.bringspring.hrms.service.HrmsPerformanceApCbTxjSalService;
import com.bringspring.hrms.service.HrmsPerformanceCheckinService;
import com.bringspring.hrms.service.HrmsPerformanceHolidayBalancePService;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HrmsTaskUtil {
    Logger logger = LoggerFactory.getLogger(HrmsTaskUtil.class);
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private AppPageConfig appPageConfig;
    @Autowired
    private HrmsEmployeArchiveService hrmsEmployeArchiveService;
    @Autowired
    private HrmsPerformanceCheckinService hrmsPerformanceCheckinService;
    @Autowired
    private UserService userService;
    @Autowired
    private HrmsPerformanceApCbTxjSalService hrmsPerformanceApCbTxjSalService;
    @Autowired
    private HrmsPerformanceHolidayBalancePService hrmsPerformanceHolidayBalancePService;

    @JsbosTask(fullName="\u63d0\u9192\u8f6c\u6b63\u524d30\u5929\u5b9a\u65f6\u63d0\u9192", description="archiveTrialDateTask", cron="")
    public void hrTrialDateMessage() {
        Date date = DateUtil.dateAddDays((Date)DateUtil.getNowDate(), (int)30);
        String s = DateUtil.daFormat((Date)date);
        List<HrmsEmployeArchiveEntity> archiveByDate = this.hrmsEmployeArchiveService.getArchiveByDate(s);
        String collectName = archiveByDate.stream().map(v -> v.getName()).collect(Collectors.joining(","));
        if (ObjectUtil.isEmpty(archiveByDate)) {
            this.logger.info("\u6ca1\u6709\u5f85\u8f6c\u6b63\u524d30\u5929\u7684\u4eba\u5458\u4fe1\u606f");
        } else {
            this.pushToSaler("\u6709\u5458\u5de530\u5929\u540e\u8f6c\u6b63", "\u4ee5\u4e0b\u4eba\u5458\u8f6c\u6b63\u8fd8\u6709\u4e09\u5341\u5929(" + collectName + ")");
        }
    }

    private void pushToSaler(String title, String content) {
        List toUserIds = CollectionUtil.list((boolean)false);
        StringBuffer msg = new StringBuffer();
        SentMessageForm sentMessageForm = this.getMessageForm(MessageTypeConst.OPPORTUNITY_PUSH_SALER, "hrTrialDateMessage");
        if (ObjectUtil.isEmpty((Object)sentMessageForm)) {
            return;
        }
        List listByRoleId = this.userService.getListByRoleId("519482291097966021");
        List collectUserHr = listByRoleId.stream().map(v -> v.getId()).collect(Collectors.toList());
        toUserIds.add("410819140824078213");
        toUserIds.addAll(collectUserHr);
        sentMessageForm.setToUserIds(toUserIds);
        sentMessageForm.setTitle("\u6709\u5458\u5de530\u5929\u540e\u8f6c\u6b63");
        sentMessageForm.setContent(content);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", "\u6709\u5458\u5de530\u5929\u540e\u8f6c\u6b63");
        map.put("content", content);
        String messageTime = DateUtil.dateFormat((Date)new Date());
        map.put("MessageTime", messageTime);
        map.put("PcUrl", "https://gl.bringspring.com/jsbos-web/#/hrms/hrmsemployeeoverview?applicationId=all");
        map.put("content", content);
        sentMessageForm.setParameterMap(map);
        sentMessageForm.setBodyText(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
        this.logger.info("\u63a8\u9001\u4eba\u4e8b\u8bd5\u7528\u7ed3\u675f\u63d0\u9192:{}", (Object)msg.toString());
    }

    private SentMessageForm getMessageForm(Integer type, String templateCode) {
        QueryWrapper templateEntityQueryWrapper = new QueryWrapper();
        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)templateCode);
        MessageTemplateEntity one = (MessageTemplateEntity)this.messageTemplateService.getOne((Wrapper)templateEntityQueryWrapper);
        if (ObjectUtil.isEmpty((Object)one)) {
            this.logger.info("\u672a\u914d\u7f6e\u6d88\u606f\u6a21\u677f,code:{}", (Object)templateCode);
            return null;
        }
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(type);
        sentMessageForm.setTemplateId(one.getId());
        return sentMessageForm;
    }

    @JsbosTask(fullName="\u62c9\u53d6\u57fa\u7840\u6570\u636e", description="pullBaseDate", cron="0 0 3 * * ?")
    public void hrmsAttendanceBaseData() {
        Date date = DateUtil.dateAddDays((Date)DateUtil.getNowDate(), (int)-1);
        this.hrmsPerformanceCheckinService.updateAttendanceUserCompanyId();
        this.hrmsPerformanceCheckinService.autoAddMonthData(date, DateUtil.getNowDate());
        this.hrmsPerformanceCheckinService.updateAttendanceCheckin(date, DateUtil.getNowDate());
        this.hrmsPerformanceCheckinService.updateAttendanceCheckinByBK(date, DateUtil.getNowDate());
        this.hrmsPerformanceCheckinService.updateAttendanceCheckinByQJ(date, DateUtil.getNowDate());
        this.hrmsPerformanceCheckinService.updateAttendanceCheckinByCC(date, DateUtil.getNowDate());
        this.hrmsPerformanceCheckinService.updateAttendanceCheckinByWC(date, DateUtil.getNowDate());
        this.hrmsPerformanceApCbTxjSalService.insertTxjSal(date, DateUtil.getNowDate());
        this.hrmsPerformanceHolidayBalancePService.testAddBalance(date, DateUtil.getNowDate());
    }
}

