/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.annotation;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.util.DateUtil;
import com.bringspring.contract.utils.Constants;
import com.bringspring.oa.model.oarecordborrow.OaRecorBorrowTask;
import com.bringspring.oa.model.oarecordborrow.OaRecordPastVo;
import com.bringspring.oa.service.OaRecordBorrowService;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.workitem.service.CrmWorkitemService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileTask {
    Logger logger = LoggerFactory.getLogger(FileTask.class);
    @Autowired
    private OaRecordBorrowService oaRecordBorrowService;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private CrmWorkitemService crmWorkitemService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;

    @JsbosTask(fullName="\u5b9a\u65f6\u63d0\u9192\u6863\u6848\u5f52\u8fd8", description="\u5b9a\u65f6\u63d0\u9192\u6863\u6848\u5f52\u8fd8", cron="0 0 9 * * ?")
    public void getFileReturn() throws BaseException {
        List<OaRecorBorrowTask> fileReturnTask = this.oaRecordBorrowService.getFileReturnTask();
        this.logger.info("\u5b9a\u65f6\u63d0\u9192\u6863\u6848\u5f52\u8fd8:{}" + fileReturnTask.size(), (Object)"\u5b9a\u65f6\u63d0\u9192\u6863\u6848\u5f52\u8fd8\uff0c,\u5f53\u524d\u65f6\u95f4:{}", (Object)LocalDateTime.now());
        if (CollectionUtil.isNotEmpty(fileReturnTask)) {
            fileReturnTask.forEach(oaRecorBorrowTask -> {
                try {
                    this.fileReturnTaskAttachmentMessage((OaRecorBorrowTask)oaRecorBorrowTask);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public void fileReturnTaskAttachmentMessage(OaRecorBorrowTask entity) throws Exception {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String formattedDateTime = entity.getBorrowDate().format(formatter);
        String url = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
        List toUserIds = CollectionUtil.list((boolean)false);
        toUserIds.add(entity.getCreatorUserId());
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode("\u6863\u6848\u7ba1\u7406");
        taskMsg.setSendCode(Constants.fileBorrowDateMessage);
        String messageTime = DateUtil.dateFormat((Date)new Date());
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (entity.getResidueNumber() != null) {
            parameterMap.put("title", "\u6863\u6848\u5f52\u8fd8\u901a\u77e5");
            parameterMap.put("content", "\u6863\u6848\u7f16\u7801\u53ca\u540d\u79f0\uff1a" + entity.getRecordName() + "\n\u6863\u6848\u5b50\u9879\u540d\u79f0\uff1a" + entity.getSubitemName() + ",\u6863\u6848\u5b50\u9879\u7f16\u7801\uff1a" + entity.getFileCode() + "\n\u6863\u6848\u5f52\u8fd8\u5269\u4f59" + entity.getResidueNumber() + "\u5929\u903e\u671f\n\u5f52\u8fd8\u65e5\u671f\uff1a" + formattedDateTime);
        } else {
            parameterMap.put("title", "\u6863\u6848\u903e\u671f\u901a\u77e5");
            parameterMap.put("content", "\u6863\u6848\u7f16\u7801\u53ca\u540d\u79f0\uff1a" + entity.getRecordName() + "\u6863\u6848\u5b50\u9879\u540d\u79f0\uff1a" + entity.getSubitemName() + ",\u6863\u6848\u5b50\u9879\u7f16\u7801\uff1a" + entity.getFileCode() + "\n\u903e\u671f\uff1a" + entity.getOverdue() + "\u5929\n\u5f52\u8fd8\u65e5\u671f\uff1a" + formattedDateTime);
        }
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setLinkUrl("");
        linkMsgKeys.setKeys(parameterMap);
        taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
        CustomKeysLink customKeysLink = new CustomKeysLink();
        customKeysLink.setTermType(TermTypeEnum.TERM_PC.getCode());
        customKeysLink.setTermTypeDesc("\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4");
        customKeysLink.setPcUrl("/#/oa/oaRecordLend?applicationId=all");
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setToUserIds(String.join((CharSequence)",", toUserIds));
        this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        this.logger.info("\u5b9a\u65f6\u63d0\u9192\u6863\u6848\u5f52\u8fd8:{}", new Object[]{entity.getFileName(), "\u5b9a\u65f6\u63d0\u9192\u6863\u6848\u5f52\u8fd8\uff0c,\u5f53\u524d\u65f6\u95f4:{}", LocalDateTime.now()});
    }

    public void getPressTask(String userId, String fileName) throws Exception {
        String url = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
        List toUserIds = CollectionUtil.list((boolean)false);
        toUserIds.add(userId);
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode("\u6863\u6848\u7ba1\u7406");
        taskMsg.setSendCode(Constants.filePressHandle);
        String messageTime = DateUtil.dateFormat((Date)new Date());
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("title", "\u6863\u6848\u5f52\u8fd8\u50ac\u529e");
        parameterMap.put("content", "\u6863\u6848\u540d\u79f0:" + fileName + "\n\u521b\u5efa\u65f6\u95f4:" + messageTime);
        parameterMap.put("MessageTime", messageTime);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setLinkUrl("");
        linkMsgKeys.setKeys(parameterMap);
        taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
        CustomKeysLink customKeysLink = new CustomKeysLink();
        customKeysLink.setTermType(TermTypeEnum.TERM_PC.getCode());
        customKeysLink.setTermTypeDesc("\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4");
        customKeysLink.setPcUrl("/#/oa/oaRecordLend?applicationId=all");
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setToUserIds(String.join((CharSequence)",", toUserIds));
        this.logger.info("\u738b\u742a\u70b9\u51fb\u50ac\u529e---\u7ed9\u7528\u6237\u53d1\u6d88\u606f:{}", (Object)linkMsgKeys.toString());
        this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
    }

    public void getUserReturn(String userName, String fileName) throws Exception {
        String url = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
        List toUserIds = CollectionUtil.list((boolean)false);
        toUserIds.add("410819120196491141");
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode("\u6863\u6848\u7ba1\u7406");
        taskMsg.setSendCode(Constants.userReturnRemind);
        String messageTime = DateUtil.dateFormat((Date)new Date());
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("title", userName + "\u6863\u6848\u5f52\u8fd8");
        parameterMap.put("content", "\u6863\u6848\u540d\u79f0:" + fileName + "\n\u521b\u5efa\u65f6\u95f4:" + messageTime);
        parameterMap.put("MessageTime", messageTime);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setLinkUrl("");
        linkMsgKeys.setKeys(parameterMap);
        taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
        CustomKeysLink customKeysLink = new CustomKeysLink();
        customKeysLink.setTermType(TermTypeEnum.TERM_PC.getCode());
        customKeysLink.setTermTypeDesc("\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4");
        customKeysLink.setPcUrl("/#/oa/oaRecordLend?applicationId=all");
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setToUserIds(String.join((CharSequence)",", toUserIds));
        this.logger.info("\u7528\u6237\u70b9\u51fb\u5f52\u8fd8\uff0c\u7ed9\u738b\u742a\u53d1\u6d88\u606f\u63d0\u793a:{}", (Object)linkMsgKeys.toString());
        this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
    }

    public void getOaRecordPastVo(List<OaRecordPastVo> oaRecordPastVo) throws Exception {
        String url = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
        List toUserIds = CollectionUtil.list((boolean)false);
        toUserIds.add(oaRecordPastVo.get(0).getCreatorUserId());
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode("\u6863\u6848\u7ba1\u7406");
        taskMsg.setSendCode(Constants.fileElectronic);
        String messageTime = DateUtil.dateFormat((Date)new Date());
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("title", "\u6863\u6848\u7535\u5b50\u9644\u4ef6");
        parameterMap.put("content", "\u7535\u5b50\u9644\u4ef6\u67e5\u770b\u6216\u4e0b\u8f7d\u6709\u6548\u671f\u4e3a3\u5929\n\u521b\u5efa\u65f6\u95f4:" + messageTime);
        parameterMap.put("MessageTime", messageTime);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setLinkUrl("");
        linkMsgKeys.setKeys(parameterMap);
        taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
        CustomKeysLink customKeysLink = new CustomKeysLink();
        customKeysLink.setTermType(TermTypeEnum.TERM_PC.getCode());
        customKeysLink.setTermTypeDesc("\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4");
        customKeysLink.setPcUrl("/#/oa/oaRecordBorrow/accessoryDetail");
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setToUserIds(String.join((CharSequence)",", toUserIds));
        this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
    }

    public void getEntrant(String name, String title) throws Exception {
        String url = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
        List toUserIds = CollectionUtil.list((boolean)false);
        toUserIds.add("410819120196491141");
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode("\u6863\u6848\u7ba1\u7406");
        taskMsg.setSendCode(Constants.userReturnRemind);
        String messageTime = DateUtil.dateFormat((Date)new Date());
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("title", name + "\u4eba\u5458" + title);
        parameterMap.put("content", "\u4eba\u5458\u59d3\u540d:" + name + "\n\u521b\u5efa\u65f6\u95f4:" + messageTime);
        parameterMap.put("MessageTime", messageTime);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setLinkUrl("");
        linkMsgKeys.setKeys(parameterMap);
        taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
        CustomKeysLink customKeysLink = new CustomKeysLink();
        customKeysLink.setTermType(TermTypeEnum.TERM_PC.getCode());
        customKeysLink.setTermTypeDesc("\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4");
        customKeysLink.setPcUrl("/#/oa/oaRecord?applicationId=all");
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setToUserIds(String.join((CharSequence)",", toUserIds));
        this.logger.info("\u7528\u6237\u70b9\u51fb\u5f52\u8fd8\uff0c\u7ed9\u738b\u742a\u53d1\u6d88\u606f\u63d0\u793a:{}", (Object)linkMsgKeys.toString());
        this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        this.logger.info("\u4eba\u5458\u5165\u804c\u63d0\u9192:{}");
    }

    private SentMessageForm getMessageForm(Integer type, String templateCode) {
        QueryWrapper templateEntityQueryWrapper = new QueryWrapper();
        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)templateCode);
        MessageTemplateEntity one = (MessageTemplateEntity)this.messageTemplateService.getOne((Wrapper)templateEntityQueryWrapper);
        if (ObjectUtil.isEmpty((Object)one)) {
            this.logger.info("\u672a\u914d\u7f6e\u6d88\u606f\u6a21\u677f,code:{}", (Object)templateCode);
            return null;
        }
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(type);
        sentMessageForm.setTemplateId(one.getId());
        return sentMessageForm;
    }
}

