/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.entity.MjOaAssetsListEntity;
import com.bringspring.oa.model.mjoaassetslist.MjOaAssetsListCrForm;
import com.bringspring.oa.model.mjoaassetslist.MjOaAssetsListInfoVO;
import com.bringspring.oa.model.mjoaassetslist.MjOaAssetsListListVO;
import com.bringspring.oa.model.mjoaassetslist.MjOaAssetsListPagination;
import com.bringspring.oa.model.mjoaassetslist.MjOaAssetsListPaginationExportModel;
import com.bringspring.oa.model.mjoaassetslist.MjOaAssetsListUpForm;
import com.bringspring.oa.service.MjOaAssetsListService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56fa\u5b9a\u8d44\u4ea7\u6863\u6848"}, value="oa")
@RequestMapping(value={"/api/oa/MjOaAssetsList"})
public class MjOaAssetsListController {
    private static final Logger log = LoggerFactory.getLogger(MjOaAssetsListController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private MjOaAssetsListService mjOaAssetsListService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody MjOaAssetsListPagination mjOaAssetsListPagination) throws IOException {
        List<MjOaAssetsListEntity> list = this.mjOaAssetsListService.getList(mjOaAssetsListPagination);
        for (MjOaAssetsListEntity mjOaAssetsListEntity : list) {
            mjOaAssetsListEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(mjOaAssetsListEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, MjOaAssetsListListVO.class);
        for (MjOaAssetsListListVO mjOaAssetsListListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mjOaAssetsListPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid MjOaAssetsListCrForm mjOaAssetsListCrForm) throws DataException {
        this.mjOaAssetsListService.create(mjOaAssetsListCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(MjOaAssetsListPaginationExportModel mjOaAssetsListPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)mjOaAssetsListPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        MjOaAssetsListPagination mjOaAssetsListPagination = (MjOaAssetsListPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)mjOaAssetsListPaginationExportModel), MjOaAssetsListPagination.class));
        List<MjOaAssetsListEntity> list = this.mjOaAssetsListService.getTypeList(mjOaAssetsListPagination, mjOaAssetsListPaginationExportModel.getDataType());
        for (MjOaAssetsListEntity mjOaAssetsListEntity : list) {
            mjOaAssetsListEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(mjOaAssetsListEntity.getCreatorUserId()));
            mjOaAssetsListEntity.setEnabledMark(StrUtil.isEmpty((CharSequence)mjOaAssetsListEntity.getEnabledMark()) ? "\u65e0\u6548" : this.baseDataUtil.switchSelectValue(mjOaAssetsListEntity.getEnabledMark(), "\u6709\u6548", "\u65e0\u6548"));
        }
        List listVO = JsonUtil.getJsonToList(list, MjOaAssetsListListVO.class);
        for (MjOaAssetsListListVO mjOaAssetsListListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)mjOaAssetsListPaginationExportModel.getSelectKey()) ? mjOaAssetsListPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block28: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block28;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block28;
                    }
                    case "assetsName": {
                        entitys.add(new ExcelExportEntity("\u540d\u79f0", (Object)"assetsName"));
                        continue block28;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u89c4\u683c", (Object)"description"));
                        continue block28;
                    }
                    case "assetsCount": {
                        entitys.add(new ExcelExportEntity("\u5e93\u5b58\u6570\u91cf", (Object)"assetsCount"));
                        continue block28;
                    }
                    case "assetsPrice": {
                        entitys.add(new ExcelExportEntity("\u5355\u4ef7", (Object)"assetsPrice"));
                        continue block28;
                    }
                    case "sortCode": {
                        entitys.add(new ExcelExportEntity("\u6392\u5e8f\u7801", (Object)"sortCode"));
                        continue block28;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u5fd7", (Object)"enabledMark"));
                        continue block28;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<MjOaAssetsListInfoVO> info(@PathVariable(value="id") String id) {
        MjOaAssetsListEntity entity = this.mjOaAssetsListService.getInfo(id);
        MjOaAssetsListInfoVO vo = (MjOaAssetsListInfoVO)JsonUtil.getJsonToBean((Object)entity, MjOaAssetsListInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<MjOaAssetsListInfoVO> detailInfo(@PathVariable(value="id") String id) {
        MjOaAssetsListEntity entity = this.mjOaAssetsListService.getInfo(id);
        MjOaAssetsListInfoVO vo = (MjOaAssetsListInfoVO)JsonUtil.getJsonToBean((Object)entity, MjOaAssetsListInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid MjOaAssetsListUpForm mjOaAssetsListUpForm) throws DataException {
        this.mjOaAssetsListService.update(id, mjOaAssetsListUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        MjOaAssetsListEntity entity = this.mjOaAssetsListService.getInfo(id);
        if (entity != null) {
            this.mjOaAssetsListService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

