/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkContractVerifyEntity;
import com.bringspring.contract.entity.RkProcureChangeRelationEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractVerifyService;
import com.bringspring.contract.service.RkProcureChangeRelationService;
import com.bringspring.contract.service.RkProcureChangeService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.oa.entity.OaContractReviewDetailEntity;
import com.bringspring.oa.entity.OaContractReviewEntity;
import com.bringspring.oa.entity.OaContractUpdateApplyEntity;
import com.bringspring.oa.entity.OaContractVoidedApplyEntity;
import com.bringspring.oa.entity.OaRecordSubitemEntity;
import com.bringspring.oa.entity.OacdsealapplicationEntity;
import com.bringspring.oa.entity.RkContractInternalTransactionEntity;
import com.bringspring.oa.model.oacontractreview.OaContractReviewCrForm;
import com.bringspring.oa.model.oacontractreview.OaContractReviewDetailModel;
import com.bringspring.oa.model.oacontractreview.OaContractReviewInfoVO;
import com.bringspring.oa.model.oacontractreview.OaContractReviewListVO;
import com.bringspring.oa.model.oacontractreview.OaContractReviewPagination;
import com.bringspring.oa.model.oacontractreview.OaContractReviewPaginationExportModel;
import com.bringspring.oa.model.oacontractreview.OaContractReviewUpForm;
import com.bringspring.oa.service.OaCdSealApplicationService;
import com.bringspring.oa.service.OaContractReviewDetailService;
import com.bringspring.oa.service.OaContractReviewService;
import com.bringspring.oa.service.OaContractUpdateAppyService;
import com.bringspring.oa.service.OaContractVoidedApplyService;
import com.bringspring.oa.service.OaRecordSubitemService;
import com.bringspring.oa.service.RkContractInternalTransactionService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u590d\u6838\u7533\u8bf7"}, value="oa")
@RequestMapping(value={"/api/oa/OaContractReview"})
public class OaContractReviewController {
    private static final Logger log = LoggerFactory.getLogger(OaContractReviewController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaContractReviewService oaContractReviewService;
    @Autowired
    private OaContractReviewDetailService oaContractReviewDetailService;
    @Autowired
    private RkContractVerifyService rkContractVerifyService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private OaCdSealApplicationService oaCdSealApplicationService;
    @Autowired
    private OaRecordSubitemService oaRecordSubitemService;
    @Autowired
    private OaContractUpdateAppyService oaContractUpdateAppyService;
    @Autowired
    private OaContractVoidedApplyService oaContractVoidedApplyService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkProcureChangeRelationService rkProcureChangeRelationService;
    @Autowired
    private RkProcureChangeService rkProcureChangeService;
    @Autowired
    private RkContractInternalTransactionService rkContractInternalTransactionService;
    @Autowired
    private RkProcureManageService rkProcureManageService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaContractReviewPagination oaContractReviewPagination) throws IOException {
        List<OaContractReviewEntity> list = this.oaContractReviewService.getList(oaContractReviewPagination);
        for (OaContractReviewEntity iterator : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OaContractReviewListVO.class);
        for (OaContractReviewListVO oaContractReviewListVO : listVO) {
        }
        for (OaContractReviewListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaContractReviewPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaContractReviewCrForm oaContractReviewCrForm = (OaContractReviewCrForm)((Object)JsonUtil.getJsonToBean(crData, OaContractReviewCrForm.class));
        String visualId = "598168228060992325";
        if (StringUtils.isNotEmpty((String)oaContractReviewCrForm.getFlowId())) {
            visualId = oaContractReviewCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OaContractReviewEntity entity = (OaContractReviewEntity)JsonUtil.getJsonToBean((Object)((Object)oaContractReviewCrForm), OaContractReviewEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.oaContractReviewService.save(entity);
        List OaContractReviewDetailList = JsonUtil.getJsonToList(oaContractReviewCrForm.getOaContractReviewDetailList(), OaContractReviewDetailEntity.class);
        for (OaContractReviewDetailEntity entitys : OaContractReviewDetailList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setParentId(entity.getId());
            if (ObjectUtil.isEmpty((Object)entitys.getSignDate())) {
                entitys.setSignDate(DateUtil.getNowDate());
            }
            if (ObjectUtil.isEmpty((Object)entitys.getBackDate())) {
                entitys.setBackDate(DateUtil.getNowDate());
            }
            if (ObjectUtil.isEmpty((Object)entitys.getReviewTime())) {
                entitys.setReviewTime(DateUtil.getNowDate());
            }
            this.oaContractReviewDetailService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)oaContractReviewCrForm.getTaskId(), (String)visualId, (String)oaContractReviewCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaContractReviewCrForm), (Integer)oaContractReviewCrForm.getStatus(), (String)"");
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaContractReviewPaginationExportModel oaContractReviewPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaContractReviewPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaContractReviewPagination oaContractReviewPagination = (OaContractReviewPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaContractReviewPaginationExportModel), OaContractReviewPagination.class));
        List<OaContractReviewEntity> list = this.oaContractReviewService.getTypeList(oaContractReviewPagination, oaContractReviewPaginationExportModel.getDataType());
        for (OaContractReviewEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OaContractReviewListVO.class);
        for (OaContractReviewListVO oaContractReviewListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaContractReviewPaginationExportModel.getSelectKey()) ? oaContractReviewPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block16: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block16;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block16;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaContractReviewInfoVO> info(@PathVariable(value="id") String id) {
        OaContractReviewEntity entity = this.oaContractReviewService.getInfo(id);
        OaContractReviewInfoVO vo = (OaContractReviewInfoVO)((Object)JsonUtil.getJsonToBean((Object)entity, OaContractReviewInfoVO.class));
        vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        UserInfo userInfo = this.userProvider.get();
        String backBtn = "0";
        if (userInfo.getRoleIds().contains("519880251291997637")) {
            backBtn = "1";
        }
        List<OaContractReviewDetailEntity> OaContractReviewDetailList = this.oaContractReviewService.getOaContractReviewDetailList(id);
        List oaContractReviewDetailModelList = JsonUtil.getJsonToList(OaContractReviewDetailList, OaContractReviewDetailModel.class);
        for (OaContractReviewDetailModel o : oaContractReviewDetailModelList) {
            o.setBusinessTypeName(this.baseDataUtil.getDictName(o.getBusinessType(), "dataSources"));
            OaRecordSubitemEntity oaRecordSubitem = this.oaRecordSubitemService.getInfo(o.getSubItemId());
            if (ObjectUtil.isNotEmpty((Object)oaRecordSubitem)) {
                o.setSubItemStates(this.baseDataUtil.getDictName(oaRecordSubitem.getSubitemStates(), "subitem"));
            } else {
                o.setSubItemStates("\u5f85\u5f52\u6863");
            }
            o.setBackBtn(backBtn);
        }
        vo.setOaContractReviewDetailList(oaContractReviewDetailModelList);
        return ActionResult.success((Object)((Object)vo));
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaContractReviewUpForm oaContractReviewUpForm = (OaContractReviewUpForm)((Object)JsonUtil.getJsonToBean(upData, OaContractReviewUpForm.class));
        String visualId = "598168228060992325";
        if (StringUtils.isNotEmpty((String)oaContractReviewUpForm.getFlowId())) {
            visualId = oaContractReviewUpForm.getFlowId();
        }
        UserInfo userInfo = this.userProvider.get();
        OaContractReviewEntity entity = this.oaContractReviewService.getInfo(id);
        if (entity != null) {
            OaContractReviewEntity subentity = (OaContractReviewEntity)JsonUtil.getJsonToBean((Object)((Object)oaContractReviewUpForm), OaContractReviewEntity.class);
            this.oaContractReviewService.update(id, subentity);
            QueryWrapper OaContractReviewDetailqueryWrapper = new QueryWrapper();
            OaContractReviewDetailqueryWrapper.lambda().eq(OaContractReviewDetailEntity::getParentId, (Object)entity.getId());
            this.oaContractReviewDetailService.remove((Wrapper)OaContractReviewDetailqueryWrapper);
            List OaContractReviewDetailList = JsonUtil.getJsonToList(oaContractReviewUpForm.getOaContractReviewDetailList(), OaContractReviewDetailEntity.class);
            for (OaContractReviewDetailEntity entitys : OaContractReviewDetailList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(entity.getId());
                if (ObjectUtil.isEmpty((Object)entitys.getSignDate())) {
                    entitys.setSignDate(DateUtil.getNowDate());
                }
                if (ObjectUtil.isEmpty((Object)entitys.getBackDate())) {
                    entitys.setBackDate(DateUtil.getNowDate());
                }
                if (ObjectUtil.isEmpty((Object)entitys.getReviewTime())) {
                    entitys.setReviewTime(DateUtil.getNowDate());
                }
                this.oaContractReviewDetailService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)oaContractReviewUpForm.getTaskId(), (String)visualId, (String)oaContractReviewUpForm.getTemplateId(), (String)id, (Object)((Object)oaContractReviewUpForm), (Integer)oaContractReviewUpForm.getStatus(), (String)"");
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaContractReviewEntity entity = this.oaContractReviewService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaContractReviewService.delete(entity);
            QueryWrapper queryWrapperOaContractReviewDetail = new QueryWrapper();
            queryWrapperOaContractReviewDetail.lambda().eq(OaContractReviewDetailEntity::getParentId, (Object)entity.getId());
            this.oaContractReviewDetailService.remove((Wrapper)queryWrapperOaContractReviewDetail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/findContract"})
    public ActionResult findContract(@RequestBody OaContractReviewPagination oaContractReviewPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaRecordSubitemEntity::getSubitemStates, (Object)"normal");
        queryWrapper.lambda().ne(OaRecordSubitemEntity::getBusinessType, (Object)"entry");
        if (StringUtils.isNotEmpty((String)oaContractReviewPagination.getBusinessType())) {
            queryWrapper.lambda().eq(OaRecordSubitemEntity::getBusinessType, (Object)oaContractReviewPagination.getBusinessType());
        }
        queryWrapper.lambda().orderByDesc(OaRecordSubitemEntity::getCreatorTime);
        List subitemList = this.oaRecordSubitemService.list((Wrapper)queryWrapper);
        List<Object> resList = new ArrayList();
        for (OaRecordSubitemEntity oaRecordSubitem : subitemList) {
            OaContractReviewDetailModel oaContractReviewDetailModel = new OaContractReviewDetailModel();
            oaContractReviewDetailModel.setReviewTime(DateUtil.format((Date)oaRecordSubitem.getCreatorTime(), (String)"YYYY-MM-dd"));
            oaContractReviewDetailModel.setBusinessId(oaRecordSubitem.getBusinessId());
            oaContractReviewDetailModel.setBusinessType(oaRecordSubitem.getBusinessType());
            oaContractReviewDetailModel.setSubItemId(oaRecordSubitem.getId());
            String businessTypeName = this.baseDataUtil.getDictName(oaRecordSubitem.getBusinessType(), "dataSources");
            oaContractReviewDetailModel.setBusinessTypeName(businessTypeName);
            if (StringUtils.isNotEmpty((String)oaRecordSubitem.getBusinessType())) {
                Object entity;
                if (oaRecordSubitem.getBusinessType().equals("market")) {
                    RkContractEntity rkContractEntity;
                    String procureCode = oaRecordSubitem.getProcureCode();
                    if (StrUtil.isNotEmpty((CharSequence)procureCode)) {
                        procureCode = procureCode.split("-")[0];
                    }
                    oaContractReviewDetailModel.setBusinessCode(procureCode);
                    RkContractVerifyEntity rkContractVerifyEntity = this.rkContractVerifyService.getInfo(oaRecordSubitem.getBusinessId());
                    if (rkContractVerifyEntity != null) {
                        oaContractReviewDetailModel.setBusinessCode(rkContractVerifyEntity.getContractCode());
                        oaContractReviewDetailModel.setBusinessName(rkContractVerifyEntity.getContractName());
                        oaContractReviewDetailModel.setBusinessMount(ObjectUtil.isEmpty((Object)rkContractVerifyEntity.getContractAmount()) ? "" : rkContractVerifyEntity.getContractAmount().toString());
                        oaContractReviewDetailModel.setBusinessCompanyId(rkContractVerifyEntity.getCompanyId());
                    }
                    if ((rkContractEntity = this.rkContractService.getInfoByCode(procureCode, this.userProvider.get().getOrganizeId())) != null) {
                        oaContractReviewDetailModel.setSignDate(rkContractEntity.getSignDate());
                    }
                } else if (oaRecordSubitem.getBusinessType().equals("purchase")) {
                    oaContractReviewDetailModel.setBusinessCode(oaRecordSubitem.getProcureCode());
                    RkProcureManageEntity rkProcureManageEntity = this.rkProcureManageService.getInfo(oaRecordSubitem.getBusinessId());
                    if (rkProcureManageEntity != null) {
                        oaContractReviewDetailModel.setBusinessName(rkProcureManageEntity.getSupplierName() + "-" + rkProcureManageEntity.getProcureName());
                        oaContractReviewDetailModel.setBusinessMount(ObjectUtil.isEmpty((Object)rkProcureManageEntity.getProcureAmount()) ? "" : rkProcureManageEntity.getProcureAmount().toString());
                        oaContractReviewDetailModel.setBusinessCompanyId(rkProcureManageEntity.getCompanyId());
                    } else {
                        RkContractProcureEntity rkContractProcureEntity = this.rkContractProcureService.getInfo(oaRecordSubitem.getBusinessId());
                        if (rkContractProcureEntity != null) {
                            oaContractReviewDetailModel.setBusinessName(rkContractProcureEntity.getSupplierName() + "-" + rkContractProcureEntity.getProcureName());
                            oaContractReviewDetailModel.setBusinessMount(ObjectUtil.isEmpty((Object)rkContractProcureEntity.getProcureAmount()) ? "" : rkContractProcureEntity.getProcureAmount().toString());
                            oaContractReviewDetailModel.setBusinessCompanyId(rkContractProcureEntity.getCompanyId());
                        }
                    }
                } else if (oaRecordSubitem.getBusinessType().equals("seal")) {
                    OacdsealapplicationEntity oacdsealapplication = this.oaCdSealApplicationService.getInfo(oaRecordSubitem.getBusinessId());
                    if (oacdsealapplication != null) {
                        if (StringUtils.isNotEmpty((String)oacdsealapplication.getProjectId())) {
                            RkContractEntity c = this.rkContractService.getInfo(oacdsealapplication.getProjectId());
                            if (ObjectUtil.isNotEmpty((Object)c)) {
                                oaContractReviewDetailModel.setBusinessCode(c.getContractCode());
                                oaContractReviewDetailModel.setBusinessName(oacdsealapplication.getApplyTitle() + ";\u9879\u76ee\u540d\u79f0\uff1a" + c.getContractName());
                                oaContractReviewDetailModel.setBusinessMount(c.getContractAmount().toString());
                            }
                        } else {
                            oaContractReviewDetailModel.setBusinessName(oacdsealapplication.getApplyTitle());
                            oaContractReviewDetailModel.setBusinessMount("0");
                        }
                        oaContractReviewDetailModel.setBusinessCompanyId(oacdsealapplication.getCompanyId());
                    }
                } else if (oaRecordSubitem.getBusinessType().equals("alterMarket")) {
                    OaContractUpdateApplyEntity u = this.oaContractUpdateAppyService.getInfo(oaRecordSubitem.getBusinessId());
                    if (u != null) {
                        oaContractReviewDetailModel.setBusinessCode(u.getContractCode());
                        oaContractReviewDetailModel.setBusinessName(u.getContractName());
                        oaContractReviewDetailModel.setBusinessMount(ObjectUtil.isEmpty((Object)u.getContractAmount()) ? "" : u.getContractAmount().toString());
                        oaContractReviewDetailModel.setBusinessCompanyId(u.getCompanyId());
                    }
                } else if ("marketCancelled".equals(oaRecordSubitem.getBusinessType())) {
                    OaContractVoidedApplyEntity o = this.oaContractVoidedApplyService.getInfo(oaRecordSubitem.getBusinessId());
                    if (o != null) {
                        RkContractEntity contract = this.rkContractService.getInfo(o.getContractId());
                        oaContractReviewDetailModel.setBusinessCode(contract.getContractCode());
                        oaContractReviewDetailModel.setBusinessName(contract.getContractName());
                        oaContractReviewDetailModel.setBusinessMount(ObjectUtil.isEmpty((Object)contract.getContractAmount()) ? "" : contract.getContractAmount().toString());
                        oaContractReviewDetailModel.setBusinessCompanyId(contract.getCompanyId());
                    }
                } else if ("purchaseChange".equals(oaRecordSubitem.getBusinessType())) {
                    RkProcureChangeRelationEntity rkProcureChangeRelationEntity = this.rkProcureChangeRelationService.getByProcureId(oaRecordSubitem.getBusinessId());
                    if (rkProcureChangeRelationEntity != null) {
                        RkProcureManageEntity rkProcureManageEntity = this.rkProcureManageService.getInfo(rkProcureChangeRelationEntity.getProcureId());
                        if (rkProcureManageEntity != null) {
                            oaContractReviewDetailModel.setBusinessCode(rkProcureManageEntity.getProcureCode());
                            oaContractReviewDetailModel.setBusinessName(rkProcureManageEntity.getProcureName());
                            oaContractReviewDetailModel.setBusinessMount(ObjectUtil.isEmpty((Object)rkProcureManageEntity.getProcureAmount()) ? "" : rkProcureManageEntity.getProcureAmount().toString());
                            oaContractReviewDetailModel.setBusinessCompanyId(rkProcureManageEntity.getCompanyId());
                        } else {
                            RkContractProcureEntity contract = this.rkContractProcureService.getInfo(rkProcureChangeRelationEntity.getProcureId());
                            oaContractReviewDetailModel.setBusinessCode(contract.getProcureCode());
                            oaContractReviewDetailModel.setBusinessName(contract.getProcureName());
                            oaContractReviewDetailModel.setBusinessMount(ObjectUtil.isEmpty((Object)contract.getProcureAmount()) ? "" : contract.getProcureAmount().toString());
                            oaContractReviewDetailModel.setBusinessCompanyId(contract.getCompanyId());
                        }
                    }
                } else if ("currentPast".equals(oaRecordSubitem.getBusinessType()) && (entity = this.rkContractInternalTransactionService.getInfo(oaRecordSubitem.getBusinessId())) != null) {
                    oaContractReviewDetailModel.setBusinessCode(((RkContractInternalTransactionEntity)entity).getContractCode());
                    oaContractReviewDetailModel.setBusinessName(((RkContractInternalTransactionEntity)entity).getContractName());
                    oaContractReviewDetailModel.setBusinessMount(ObjectUtil.isEmpty((Object)((RkContractInternalTransactionEntity)entity).getContractMount()) ? "" : ((RkContractInternalTransactionEntity)entity).getContractMount().toString());
                    oaContractReviewDetailModel.setBusinessCompanyId("2");
                }
            }
            resList.add(oaContractReviewDetailModel);
        }
        if (StrUtil.isNotEmpty((CharSequence)oaContractReviewPagination.getContractCode())) {
            resList = resList.stream().filter(a -> StrUtil.contains((CharSequence)a.getBusinessCode(), (CharSequence)oaContractReviewPagination.getContractCode())).collect(Collectors.toList());
        }
        if (StrUtil.isNotEmpty((CharSequence)oaContractReviewPagination.getContractName())) {
            resList = resList.stream().filter(a -> StrUtil.contains((CharSequence)a.getBusinessName(), (CharSequence)oaContractReviewPagination.getContractName())).collect(Collectors.toList());
        }
        OaContractReviewPagination pagination = new OaContractReviewPagination();
        ArrayList<String> enList = new ArrayList<String>();
        enList.add("2");
        enList.add("1");
        pagination.setEnableMark(enList);
        List<OaContractReviewDetailEntity> haveList = this.oaContractReviewDetailService.getList(pagination);
        ArrayList resNotHaveList = new ArrayList();
        for (OaContractReviewDetailModel vo : resList) {
            haveList = haveList.stream().filter(a -> StrUtil.isNotEmpty((CharSequence)a.getBusinessId())).collect(Collectors.toList());
            List matchList = (haveList = haveList.stream().filter(a -> StrUtil.isNotEmpty((CharSequence)a.getBusinessType())).collect(Collectors.toList())).stream().filter(a -> a.getBusinessType().equals(vo.getBusinessType()) && a.getBusinessId().equals(vo.getBusinessId())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(matchList)) {
                vo.setIsSubmit("1");
                continue;
            }
            vo.setIsSubmit("0");
        }
        if (CollectionUtil.isNotEmpty(resList)) {
            resList = resList.stream().filter(a -> this.userProvider.get().getOrganizeId().equals(a.getBusinessCompanyId())).collect(Collectors.toList());
            if (StrUtil.isNotEmpty((CharSequence)oaContractReviewPagination.getIsSubmit())) {
                resList = resList.stream().filter(a -> a.getIsSubmit().equals(oaContractReviewPagination.getIsSubmit())).collect(Collectors.toList());
            }
        }
        PageListVO vo = new PageListVO();
        vo.setList(resList);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaContractReviewPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }
}

