/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.entity.OaEntertainApplicationDetailEntity;
import com.bringspring.oa.entity.OaEntertainApplicationEntity;
import com.bringspring.oa.model.oaentertainapplication.OaEntertainApplicationCrForm;
import com.bringspring.oa.model.oaentertainapplication.OaEntertainApplicationInfoVO;
import com.bringspring.oa.model.oaentertainapplication.OaEntertainApplicationListVO;
import com.bringspring.oa.model.oaentertainapplication.OaEntertainApplicationPagination;
import com.bringspring.oa.model.oaentertainapplication.OaEntertainApplicationPaginationExportModel;
import com.bringspring.oa.model.oaentertainapplication.OaEntertainApplicationUpForm;
import com.bringspring.oa.service.OaEntertainApplicationDetailService;
import com.bringspring.oa.service.OaEntertainApplicationService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62db\u5f85\u7533\u8bf7\u8868"}, value="oa")
@RequestMapping(value={"/api/oa/OaEntertainApplication"})
public class OaEntertainApplicationController {
    private static final Logger log = LoggerFactory.getLogger(OaEntertainApplicationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaEntertainApplicationService oaEntertainApplicationService;
    @Autowired
    private OaEntertainApplicationDetailService oaEntertainApplicationDetailService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaEntertainApplicationPagination oaEntertainApplicationPagination) throws IOException {
        List<OaEntertainApplicationEntity> list = this.oaEntertainApplicationService.getList(oaEntertainApplicationPagination);
        for (OaEntertainApplicationEntity iterator : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OaEntertainApplicationListVO.class);
        for (OaEntertainApplicationListVO oaEntertainApplicationListVO : listVO) {
        }
        for (OaEntertainApplicationListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaEntertainApplicationPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaEntertainApplicationCrForm oaEntertainApplicationCrForm = (OaEntertainApplicationCrForm)((Object)JsonUtil.getJsonToBean(crData, OaEntertainApplicationCrForm.class));
        String visualId = "577413243463589189";
        if (StringUtils.isNotEmpty((String)oaEntertainApplicationCrForm.getFlowId())) {
            visualId = oaEntertainApplicationCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        if (StrUtil.isNotEmpty((CharSequence)oaEntertainApplicationCrForm.getBusinessId())) {
            oaEntertainApplicationCrForm.setSalerId(oaEntertainApplicationCrForm.getBusinessId());
        } else {
            oaEntertainApplicationCrForm.setSalerId(oaEntertainApplicationCrForm.getCreatorUserId());
        }
        if (StrUtil.isNotEmpty((CharSequence)oaEntertainApplicationCrForm.getBusinessAreaId())) {
            List businessList = (List)JsonUtil.getJsonToBean((String)oaEntertainApplicationCrForm.getBusinessAreaId(), List.class);
            ArrayList<String> nameList = new ArrayList<String>();
            for (String temp : businessList) {
                String tempName = this.baseDataUtil.provinceData(temp);
                nameList.add(tempName);
            }
            oaEntertainApplicationCrForm.setBusinessArea(nameList.stream().collect(Collectors.joining("/")));
        }
        oaEntertainApplicationCrForm.setBusinessName(this.baseDataUtil.userSelectValue(oaEntertainApplicationCrForm.getBusinessId()));
        oaEntertainApplicationCrForm.setBusinessCenter(this.baseDataUtil.getDictName(oaEntertainApplicationCrForm.getBusinessCenterId(), "businessCenterOptions"));
        oaEntertainApplicationCrForm.setEngineeringArea(this.baseDataUtil.getDictName(oaEntertainApplicationCrForm.getEngineeringAreaId(), "businessAreaOptions"));
        List<OaEntertainApplicationDetailEntity> detailList = oaEntertainApplicationCrForm.getOaEntertainApplicationDetailList();
        if (CollectionUtil.isNotEmpty(detailList)) {
            for (OaEntertainApplicationDetailEntity entitys : detailList) {
                entitys.setParentId(mainId);
                entitys.setId(RandomUtil.uuId());
                this.oaEntertainApplicationDetailService.save(entitys);
            }
        }
        if (StrUtil.isEmpty((CharSequence)oaEntertainApplicationCrForm.getCreatorUserId())) {
            oaEntertainApplicationCrForm.setCreatorUserId(userInfo.getUserId());
        }
        if (StrUtil.isEmpty((CharSequence)oaEntertainApplicationCrForm.getCreatorTime())) {
            oaEntertainApplicationCrForm.setCreatorTime(DateUtil.getNow());
        }
        if (StrUtil.isEmpty((CharSequence)oaEntertainApplicationCrForm.getCreatorDeptId())) {
            oaEntertainApplicationCrForm.setCreatorDeptId((String)JsonUtil.getJsonToBean((Object)userInfo.getOrganizeId().split(","), String.class));
        }
        OaEntertainApplicationEntity entity = (OaEntertainApplicationEntity)JsonUtil.getJsonToBean((Object)((Object)oaEntertainApplicationCrForm), OaEntertainApplicationEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setFlowUserId(userInfo.getUserId());
        entity.setCreatorUser(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
        entity.setCreatorDept(this.baseDataUtil.comSelectValues(entity.getCreatorDeptId()));
        entity.setEntertainTypeName(this.baseDataUtil.getDictName(entity.getEntertainType(), "entertainType"));
        entity.setAccompanyingPersonName(this.baseDataUtil.userSelectValues(entity.getAccompanyingPerson()));
        this.oaEntertainApplicationService.save(entity);
        oaEntertainApplicationCrForm.setCreatorDept(entity.getCreatorDept());
        oaEntertainApplicationCrForm.setIsLeader(this.oaEntertainApplicationService.isLeader(oaEntertainApplicationCrForm.getCreatorUserId()));
        FlowUtil.saveOrSubmit((String)oaEntertainApplicationCrForm.getTaskId(), (String)visualId, (String)oaEntertainApplicationCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaEntertainApplicationCrForm), (Integer)oaEntertainApplicationCrForm.getStatus(), (String)oaEntertainApplicationCrForm.getApplyTitle());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaEntertainApplicationPaginationExportModel oaEntertainApplicationPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaEntertainApplicationPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaEntertainApplicationPagination oaEntertainApplicationPagination = (OaEntertainApplicationPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaEntertainApplicationPaginationExportModel), OaEntertainApplicationPagination.class));
        List<OaEntertainApplicationEntity> list = this.oaEntertainApplicationService.getTypeList(oaEntertainApplicationPagination, oaEntertainApplicationPaginationExportModel.getDataType());
        for (OaEntertainApplicationEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OaEntertainApplicationListVO.class);
        for (OaEntertainApplicationListVO oaEntertainApplicationListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaEntertainApplicationPaginationExportModel.getSelectKey()) ? oaEntertainApplicationPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block32: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u65e5\u671f", (Object)"creatorTime"));
                        continue block32;
                    }
                    case "creatorUser": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"creatorUser"));
                        continue block32;
                    }
                    case "creatorDept": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u90e8\u95e8", (Object)"creatorDept"));
                        continue block32;
                    }
                    case "entertainDate": {
                        entitys.add(new ExcelExportEntity("\u62db\u5f85\u65e5\u671f", (Object)"entertainDate"));
                        continue block32;
                    }
                    case "entertainAmount": {
                        entitys.add(new ExcelExportEntity("\u62db\u5f85\u9884\u7b97", (Object)"entertainAmount"));
                        continue block32;
                    }
                    case "entertainEntity": {
                        entitys.add(new ExcelExportEntity("\u62db\u5f85\u5bf9\u8c61", (Object)"entertainEntity"));
                        continue block32;
                    }
                    case "accompanyingPersonName": {
                        entitys.add(new ExcelExportEntity("\u966a\u540c\u4eba\u5458\u540d\u79f0", (Object)"accompanyingPersonName"));
                        continue block32;
                    }
                    case "entertainTypeName": {
                        entitys.add(new ExcelExportEntity("\u62db\u5f85\u7c7b\u578b\u540d\u79f0", (Object)"entertainTypeName"));
                        continue block32;
                    }
                    case "entertainAddress": {
                        entitys.add(new ExcelExportEntity("\u62db\u5f85\u5730\u70b9", (Object)"entertainAddress"));
                        continue block32;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4e8b\u7531", (Object)"description"));
                        continue block32;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaEntertainApplicationInfoVO> info(@PathVariable(value="id") String id) {
        OaEntertainApplicationEntity entity = this.oaEntertainApplicationService.getInfo(id);
        OaEntertainApplicationInfoVO vo = (OaEntertainApplicationInfoVO)JsonUtil.getJsonToBean((Object)entity, OaEntertainApplicationInfoVO.class);
        List<OaEntertainApplicationDetailEntity> detailList = this.oaEntertainApplicationDetailService.getDetailListById(id);
        vo.setOaEntertainApplicationDetailList(detailList);
        vo.setIsLeader(this.oaEntertainApplicationService.isLeader(entity.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaEntertainApplicationUpForm oaEntertainApplicationUpForm = (OaEntertainApplicationUpForm)((Object)JsonUtil.getJsonToBean(upData, OaEntertainApplicationUpForm.class));
        String visualId = "577413243463589189";
        if (StringUtils.isNotEmpty((String)oaEntertainApplicationUpForm.getFlowId())) {
            visualId = oaEntertainApplicationUpForm.getFlowId();
        }
        UserInfo userInfo = this.userProvider.get();
        OaEntertainApplicationEntity entity = this.oaEntertainApplicationService.getInfo(id);
        if (entity != null) {
            if (StrUtil.isNotEmpty((CharSequence)entity.getBusinessAreaId())) {
                List businessList = (List)JsonUtil.getJsonToBean((String)entity.getBusinessAreaId(), List.class);
                ArrayList<String> nameList = new ArrayList<String>();
                for (String temp : businessList) {
                    String tempName = this.baseDataUtil.provinceData(temp);
                    nameList.add(tempName);
                }
                oaEntertainApplicationUpForm.setBusinessArea(nameList.stream().collect(Collectors.joining("/")));
            }
            if (StrUtil.isNotEmpty((CharSequence)oaEntertainApplicationUpForm.getBusinessId())) {
                oaEntertainApplicationUpForm.setSalerId(oaEntertainApplicationUpForm.getBusinessId());
            } else {
                oaEntertainApplicationUpForm.setSalerId(oaEntertainApplicationUpForm.getCreatorUserId());
            }
            oaEntertainApplicationUpForm.setBusinessName(this.baseDataUtil.userSelectValue(oaEntertainApplicationUpForm.getBusinessId()));
            oaEntertainApplicationUpForm.setBusinessCenter(this.baseDataUtil.getDictName(oaEntertainApplicationUpForm.getBusinessCenterId(), "businessCenterOptions"));
            oaEntertainApplicationUpForm.setEngineeringArea(this.baseDataUtil.getDictName(oaEntertainApplicationUpForm.getEngineeringAreaId(), "businessAreaOptions"));
            this.oaEntertainApplicationDetailService.deleteDetailByParentId(id);
            List<OaEntertainApplicationDetailEntity> detailList = oaEntertainApplicationUpForm.getOaEntertainApplicationDetailList();
            if (CollectionUtil.isNotEmpty(detailList)) {
                for (OaEntertainApplicationDetailEntity entitys : detailList) {
                    entitys.setParentId(id);
                    entitys.setId(RandomUtil.uuId());
                    this.oaEntertainApplicationDetailService.save(entitys);
                }
            }
            OaEntertainApplicationEntity subentity = (OaEntertainApplicationEntity)JsonUtil.getJsonToBean((Object)((Object)oaEntertainApplicationUpForm), OaEntertainApplicationEntity.class);
            subentity.setCreatorUser(this.baseDataUtil.userSelectValue(subentity.getCreatorUserId()));
            subentity.setCreatorDept(this.baseDataUtil.comSelectValues(subentity.getCreatorDeptId()));
            subentity.setEntertainTypeName(this.baseDataUtil.getDictName(subentity.getEntertainType(), "entertainType"));
            subentity.setAccompanyingPersonName(this.baseDataUtil.userSelectValues(subentity.getAccompanyingPerson()));
            this.oaEntertainApplicationService.update(id, subentity);
            oaEntertainApplicationUpForm.setCreatorDept(subentity.getCreatorDept());
            oaEntertainApplicationUpForm.setIsLeader(subentity.getCreatorUserId());
            FlowUtil.saveOrSubmit((String)oaEntertainApplicationUpForm.getTaskId(), (String)visualId, (String)oaEntertainApplicationUpForm.getTemplateId(), (String)id, (Object)((Object)oaEntertainApplicationUpForm), (Integer)oaEntertainApplicationUpForm.getStatus(), (String)oaEntertainApplicationUpForm.getApplyTitle());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaEntertainApplicationEntity entity = this.oaEntertainApplicationService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaEntertainApplicationService.delete(entity);
            this.oaEntertainApplicationDetailService.deleteDetailByParentId(id);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

