/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.entity.OaFmsSealEntity;
import com.bringspring.oa.model.oafmsseal.OaFmsSealCrForm;
import com.bringspring.oa.model.oafmsseal.OaFmsSealInfoVO;
import com.bringspring.oa.model.oafmsseal.OaFmsSealListVO;
import com.bringspring.oa.model.oafmsseal.OaFmsSealPagination;
import com.bringspring.oa.model.oafmsseal.OaFmsSealUpForm;
import com.bringspring.oa.service.OaFmsSealService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d22\u52a1\u516c\u7ae0\u8bc1\u4ef6\u7533\u8bf7\u8868"}, value="oa")
@RequestMapping(value={"/api/oa/OaFmsSeal"})
public class OaFmsSealController {
    private static final Logger log = LoggerFactory.getLogger(OaFmsSealController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaFmsSealService oaFmsSealService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaFmsSealPagination oaFmsSealPagination) throws IOException {
        List<OaFmsSealEntity> list = this.oaFmsSealService.getList(oaFmsSealPagination);
        for (OaFmsSealEntity oaFmsSealEntity : list) {
            oaFmsSealEntity.setCompany(this.baseDataUtil.getDictName(oaFmsSealEntity.getCompany(), "499248793733047493"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaFmsSealListVO.class);
        for (OaFmsSealListVO oaFmsSealVO : listVO) {
            oaFmsSealVO.setBorrow(this.baseDataUtil.getDictName(oaFmsSealVO.getBorrow(), "535107783545072005"));
        }
        for (OaFmsSealListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaFmsSealPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaFmsSealCrForm oaFmsSealCrForm = (OaFmsSealCrForm)((Object)JsonUtil.getJsonToBean(crData, OaFmsSealCrForm.class));
        String flowEngineId = "547070078777034949";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaFmsSealCrForm.setBelongDeptName(this.baseDataUtil.getDictName(oaFmsSealCrForm.getBelongDept(), "ShSealFileTypeOptions"));
        oaFmsSealCrForm.setFileType(this.baseDataUtil.getDictName(oaFmsSealCrForm.getFileTypeId(), "ShOaFmsbelongDeptOptions"));
        OaFmsSealEntity entity = (OaFmsSealEntity)JsonUtil.getJsonToBean((Object)((Object)oaFmsSealCrForm), OaFmsSealEntity.class);
        entity.setId(mainId);
        entity.setDate(DateUtil.getNowDate());
        entity.setApplicationId(userInfo.getUserId());
        entity.setApplicantName(userInfo.getRealName());
        entity.setApplicantDept(userInfo.getDepartmentId());
        this.oaFmsSealService.save(entity);
        FlowUtil.saveOrSubmit((String)oaFmsSealCrForm.getTaskId(), (String)flowEngineId, (String)oaFmsSealCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaFmsSealCrForm), (Integer)oaFmsSealCrForm.getStatus(), (String)oaFmsSealCrForm.getApplicationTopic());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaFmsSealInfoVO> info(@PathVariable(value="id") String id) {
        OaFmsSealEntity entity = this.oaFmsSealService.getInfo(id);
        OaFmsSealInfoVO vo = (OaFmsSealInfoVO)JsonUtil.getJsonToBean((Object)entity, OaFmsSealInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaFmsSealUpForm oaFmsSealUpForm = (OaFmsSealUpForm)((Object)JsonUtil.getJsonToBean(upData, OaFmsSealUpForm.class));
        String flowEngineId = "547070078777034949";
        UserInfo userInfo = this.userProvider.get();
        OaFmsSealEntity entity = this.oaFmsSealService.getInfo(id);
        if (entity != null) {
            oaFmsSealUpForm.setBelongDeptName(this.baseDataUtil.getDictName(oaFmsSealUpForm.getBelongDept(), "ShSealFileTypeOptions"));
            oaFmsSealUpForm.setFileType(this.baseDataUtil.getDictName(oaFmsSealUpForm.getFileTypeId(), "ShOaFmsbelongDeptOptions"));
            OaFmsSealEntity subentity = (OaFmsSealEntity)JsonUtil.getJsonToBean((Object)((Object)oaFmsSealUpForm), OaFmsSealEntity.class);
            this.oaFmsSealService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oaFmsSealUpForm.getTaskId(), (String)flowEngineId, (String)oaFmsSealUpForm.getTemplateId(), (String)id, (Object)((Object)oaFmsSealUpForm), (Integer)oaFmsSealUpForm.getStatus(), (String)oaFmsSealUpForm.getApplicationTopic());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaFmsSealEntity entity = this.oaFmsSealService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaFmsSealService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

