/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.entity.OaFmsSignApplyDetailEntity;
import com.bringspring.oa.entity.OaFmsSignApplyEntity;
import com.bringspring.oa.entity.OaGlBudgetChangeEntity;
import com.bringspring.oa.model.oafmssignapply.OaFmsApplyDetailModel;
import com.bringspring.oa.model.oafmssignapply.OaFmsSignApplyCrForm;
import com.bringspring.oa.model.oafmssignapply.OaFmsSignApplyInfoVO;
import com.bringspring.oa.model.oafmssignapply.OaFmsSignApplyListVO;
import com.bringspring.oa.model.oafmssignapply.OaFmsSignApplyPagination;
import com.bringspring.oa.model.oafmssignapply.OaFmsSignApplyUpForm;
import com.bringspring.oa.model.oafmssignapply.OaGlBudgetChangeModel;
import com.bringspring.oa.service.OaFmsSignApplyDetailService;
import com.bringspring.oa.service.OaFmsSignApplyService;
import com.bringspring.oa.service.OaGlBudgetChangeService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"OaFmsSignApply"}, value="oa")
@RequestMapping(value={"/api/oa/OaFmsSignApply"})
public class OaFmsSignApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaFmsSignApplyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaFmsSignApplyService oaFmsSignApplyService;
    @Autowired
    private OaGlBudgetChangeService oaGlBudgetChangeService;
    @Autowired
    private OaFmsSignApplyDetailService oaFmsSignApplyDetailService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaFmsSignApplyPagination oaFmsSignApplyPagination) throws IOException {
        List<OaFmsSignApplyEntity> list = this.oaFmsSignApplyService.getList(oaFmsSignApplyPagination);
        for (OaFmsSignApplyEntity oaFmsSignApplyEntity : list) {
            oaFmsSignApplyEntity.setBelongCompany(this.baseDataUtil.getDictName(oaFmsSignApplyEntity.getBelongCompany(), "499248793733047493"));
            oaFmsSignApplyEntity.setApplyUpload(this.baseDataUtil.getFileNameInJson(oaFmsSignApplyEntity.getApplyUpload()));
            oaFmsSignApplyEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaFmsSignApplyEntity.getCreatorUserId()));
            oaFmsSignApplyEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(oaFmsSignApplyEntity.getLastModifyUserId()));
            oaFmsSignApplyEntity.setCreatorDepartId(this.baseDataUtil.comSelectValue(oaFmsSignApplyEntity.getCreatorDepartId(), "last"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaFmsSignApplyListVO.class);
        for (OaFmsSignApplyListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaFmsSignApplyPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaFmsSignApplyCrForm oaFmsSignApplyCrForm = (OaFmsSignApplyCrForm)((Object)JsonUtil.getJsonToBean(crData, OaFmsSignApplyCrForm.class));
        String flowEngineId = "515428200294122949";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaFmsSignApplyCrForm.setCreatorUserId(userInfo.getUserId());
        oaFmsSignApplyCrForm.setCreatorTime(DateUtil.getNow());
        oaFmsSignApplyCrForm.setCreatorDepartId(StringUtils.isEmpty((String)userInfo.getDepartmentId()) ? userInfo.getOrganizeId() : userInfo.getDepartmentId());
        OaFmsSignApplyEntity entity = (OaFmsSignApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaFmsSignApplyCrForm), OaFmsSignApplyEntity.class);
        entity.setId(mainId);
        List Oa_gl_budget_changeList = JsonUtil.getJsonToList(oaFmsSignApplyCrForm.getOafmssignapplyList(), OaGlBudgetChangeEntity.class);
        for (OaGlBudgetChangeEntity entitys : Oa_gl_budget_changeList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setParentId(entity.getId());
            if (StrUtil.equals((CharSequence)entitys.getChangeType(), (CharSequence)"add")) {
                entity.setIsNewBudget("add");
            }
            this.oaGlBudgetChangeService.save(entitys);
        }
        this.oaFmsSignApplyService.save(entity);
        List oaFmsSignApplyDetailEntityList = JsonUtil.getJsonToList(oaFmsSignApplyCrForm.getOaFmsApplyDetailList(), OaFmsSignApplyDetailEntity.class);
        for (OaFmsSignApplyDetailEntity entitys : oaFmsSignApplyDetailEntityList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setParentId(entity.getId());
            entitys.setCreatorTime(new Date());
            entitys.setCreatorUserId(userInfo.getUserId());
            this.oaFmsSignApplyDetailService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)oaFmsSignApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaFmsSignApplyCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaFmsSignApplyCrForm), (Integer)oaFmsSignApplyCrForm.getStatus(), (String)oaFmsSignApplyCrForm.getApplyTitle());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaFmsSignApplyInfoVO> info(@PathVariable(value="id") String id) {
        OaFmsSignApplyEntity entity = this.oaFmsSignApplyService.getInfo(id);
        OaFmsSignApplyInfoVO vo = (OaFmsSignApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaFmsSignApplyInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        vo.setCreatorDepartId(this.baseDataUtil.comSelectValue(vo.getCreatorDepartId(), "last"));
        List<OaGlBudgetChangeEntity> Oa_gl_budget_changeList = this.oaFmsSignApplyService.GetOa_gl_budget_changeList(id);
        for (OaGlBudgetChangeEntity oaGlBudgetChangeEntity : Oa_gl_budget_changeList) {
        }
        vo.setOafmssignapplyList(JsonUtil.getJsonToList(Oa_gl_budget_changeList, OaGlBudgetChangeModel.class));
        List<OaFmsSignApplyDetailEntity> OaFmsSignApplyDetailList = this.oaFmsSignApplyService.getOaFmsSignApplyDetailList(id);
        vo.setOaFmsApplyDetailList(JsonUtil.getJsonToList(OaFmsSignApplyDetailList, OaFmsApplyDetailModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaFmsSignApplyUpForm oaFmsSignApplyUpForm = (OaFmsSignApplyUpForm)((Object)JsonUtil.getJsonToBean(upData, OaFmsSignApplyUpForm.class));
        String flowEngineId = "515428200294122949";
        UserInfo userInfo = this.userProvider.get();
        OaFmsSignApplyEntity entity = this.oaFmsSignApplyService.getInfo(id);
        if (entity != null) {
            oaFmsSignApplyUpForm.setLastModifyUserId(userInfo.getUserId());
            oaFmsSignApplyUpForm.setLastModifyTime(DateUtil.getNow());
            oaFmsSignApplyUpForm.setCreatorDepartId(entity.getCreatorDepartId());
            OaFmsSignApplyEntity subentity = (OaFmsSignApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaFmsSignApplyUpForm), OaFmsSignApplyEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            subentity.setIsNewBudget("");
            QueryWrapper Oa_gl_budget_changequeryWrapper = new QueryWrapper();
            Oa_gl_budget_changequeryWrapper.lambda().eq(OaGlBudgetChangeEntity::getParentId, (Object)entity.getId());
            this.oaGlBudgetChangeService.remove((Wrapper)Oa_gl_budget_changequeryWrapper);
            List Oa_gl_budget_changeList = JsonUtil.getJsonToList(oaFmsSignApplyUpForm.getOafmssignapplyList(), OaGlBudgetChangeEntity.class);
            for (OaGlBudgetChangeEntity entitys : Oa_gl_budget_changeList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(entity.getId());
                if (StrUtil.equals((CharSequence)entitys.getChangeType(), (CharSequence)"add")) {
                    entity.setIsNewBudget("add");
                }
                this.oaGlBudgetChangeService.save(entitys);
            }
            this.oaFmsSignApplyService.update(id, subentity);
            QueryWrapper oaFmsSignApplyDetailEntityQueryWrapper = new QueryWrapper();
            oaFmsSignApplyDetailEntityQueryWrapper.lambda().eq(OaFmsSignApplyDetailEntity::getParentId, (Object)entity.getId());
            this.oaFmsSignApplyDetailService.remove((Wrapper)oaFmsSignApplyDetailEntityQueryWrapper);
            List oaFmsSignApplyDetailEntityList = JsonUtil.getJsonToList(oaFmsSignApplyUpForm.getOaFmsApplyDetailList(), OaFmsSignApplyDetailEntity.class);
            for (OaFmsSignApplyDetailEntity entitys : oaFmsSignApplyDetailEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(entity.getId());
                entitys.setCreatorTime(new Date());
                entitys.setCreatorUserId(userInfo.getUserId());
                this.oaFmsSignApplyDetailService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)oaFmsSignApplyUpForm.getTaskId(), (String)flowEngineId, (String)oaFmsSignApplyUpForm.getTemplateId(), (String)id, (Object)((Object)oaFmsSignApplyUpForm), (Integer)oaFmsSignApplyUpForm.getStatus(), (String)oaFmsSignApplyUpForm.getApplyTitle());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaFmsSignApplyEntity entity = this.oaFmsSignApplyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaFmsSignApplyService.delete(entity);
            QueryWrapper queryWrapperOa_gl_budget_change = new QueryWrapper();
            queryWrapperOa_gl_budget_change.lambda().eq(OaGlBudgetChangeEntity::getParentId, (Object)entity.getId());
            this.oaGlBudgetChangeService.remove((Wrapper)queryWrapperOa_gl_budget_change);
            QueryWrapper oaFmsSignApplyDetailEntityQueryWrapper = new QueryWrapper();
            oaFmsSignApplyDetailEntityQueryWrapper.lambda().eq(OaFmsSignApplyDetailEntity::getParentId, (Object)entity.getId());
            this.oaFmsSignApplyDetailService.remove((Wrapper)oaFmsSignApplyDetailEntityQueryWrapper);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

