/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaFrameworkAgreementApplyEntity;
import com.bringspring.oa.model.oaframeworkagreementapply.OaFrameworkAgreementApplyCrForm;
import com.bringspring.oa.model.oaframeworkagreementapply.OaFrameworkAgreementApplyInfoVO;
import com.bringspring.oa.model.oaframeworkagreementapply.OaFrameworkAgreementApplyListVO;
import com.bringspring.oa.model.oaframeworkagreementapply.OaFrameworkAgreementApplyPagination;
import com.bringspring.oa.model.oaframeworkagreementapply.OaFrameworkAgreementApplyPaginationExportModel;
import com.bringspring.oa.model.oaframeworkagreementapply.OaFrameworkAgreementApplyUpForm;
import com.bringspring.oa.service.OaFrameworkAgreementApplyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6846\u67b6\u534f\u8bae\u7533\u8bf7"}, value="oa")
@RequestMapping(value={"/api/oa/OaFrameworkAgreementApply"})
public class OaFrameworkAgreementApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaFrameworkAgreementApplyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaFrameworkAgreementApplyService oaFrameworkAgreementApplyService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaFrameworkAgreementApplyPagination oaFrameworkAgreementApplyPagination) throws IOException {
        List<OaFrameworkAgreementApplyEntity> list = this.oaFrameworkAgreementApplyService.getList(oaFrameworkAgreementApplyPagination);
        List listVO = JsonUtil.getJsonToList(list, OaFrameworkAgreementApplyListVO.class);
        for (OaFrameworkAgreementApplyListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaFrameworkAgreementApplyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaFrameworkAgreementApplyCrForm oaFrameworkAgreementApplyCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "619090122758967301";
        if (StrUtil.isNotBlank((CharSequence)oaFrameworkAgreementApplyCrForm.getFlowId())) {
            flowEngineId = oaFrameworkAgreementApplyCrForm.getFlowId();
        }
        this.oaFrameworkAgreementApplyService.insertInfo(oaFrameworkAgreementApplyCrForm);
        FlowUtil.saveOrSubmit((String)oaFrameworkAgreementApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaFrameworkAgreementApplyCrForm.getTemplateId(), (String)oaFrameworkAgreementApplyCrForm.getId(), (Object)((Object)oaFrameworkAgreementApplyCrForm), (Integer)oaFrameworkAgreementApplyCrForm.getStatus(), (String)oaFrameworkAgreementApplyCrForm.getContractName());
        if (oaFrameworkAgreementApplyCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaFrameworkAgreementApplyUpForm oaFrameworkAgreementApplyUpForm) throws DataException {
        String flowEngineId = "619090122758967301";
        OaFrameworkAgreementApplyEntity entity = this.oaFrameworkAgreementApplyService.getInfo(id);
        if (entity != null) {
            this.oaFrameworkAgreementApplyService.editInfo(oaFrameworkAgreementApplyUpForm);
            try {
                FlowUtil.saveOrSubmit((String)oaFrameworkAgreementApplyUpForm.getTaskId(), (String)flowEngineId, (String)oaFrameworkAgreementApplyUpForm.getTemplateId(), (String)id, (Object)((Object)oaFrameworkAgreementApplyUpForm), (Integer)oaFrameworkAgreementApplyUpForm.getStatus(), (String)oaFrameworkAgreementApplyUpForm.getContractName());
            }
            catch (WorkFlowException e) {
                throw new RuntimeException(e);
            }
            if (oaFrameworkAgreementApplyUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaFrameworkAgreementApplyPaginationExportModel oaFrameworkAgreementApplyPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaFrameworkAgreementApplyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaFrameworkAgreementApplyPagination oaFrameworkAgreementApplyPagination = (OaFrameworkAgreementApplyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaFrameworkAgreementApplyPaginationExportModel), OaFrameworkAgreementApplyPagination.class));
        List<OaFrameworkAgreementApplyEntity> list = this.oaFrameworkAgreementApplyService.getTypeList(oaFrameworkAgreementApplyPagination, oaFrameworkAgreementApplyPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OaFrameworkAgreementApplyListVO.class);
        for (OaFrameworkAgreementApplyListVO oaFrameworkAgreementApplyListVO : listVO) {
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaFrameworkAgreementApplyPaginationExportModel.getSelectKey()) ? oaFrameworkAgreementApplyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block38: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "incomeType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeType"));
                        continue block38;
                    }
                    case "contractType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractType"));
                        continue block38;
                    }
                    case "industryType": {
                        entitys.add(new ExcelExportEntity("\u884c\u4e1a\u7c7b\u578b", (Object)"industryType"));
                        continue block38;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5bf9\u8c61", (Object)"agentName"));
                        continue block38;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block38;
                    }
                    case "customerAddress": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237\u5730\u5740", (Object)"customerAddress"));
                        continue block38;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block38;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block38;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u603b\u91d1\u989d", (Object)"contractAmount"));
                        continue block38;
                    }
                    case "isStampType": {
                        entitys.add(new ExcelExportEntity("\u76d6\u7ae0\u7c7b\u578b", (Object)"isStampType"));
                        continue block38;
                    }
                    case "startContractTime": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u6267\u884c\u5468\u671f", (Object)"startContractTime"));
                        continue block38;
                    }
                    case "salesId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u4eba\u5458", (Object)"salesId"));
                        continue block38;
                    }
                    case "salesDepartment": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u90e8\u95e8", (Object)"salesDepartment"));
                        continue block38;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaFrameworkAgreementApplyInfoVO> info(@PathVariable(value="id") String id) {
        OaFrameworkAgreementApplyInfoVO vo = this.oaFrameworkAgreementApplyService.queryInfo(id);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaFrameworkAgreementApplyInfoVO> detail(@PathVariable(value="id") String id) {
        OaFrameworkAgreementApplyInfoVO vo = this.oaFrameworkAgreementApplyService.detailInfo(id);
        return ActionResult.success((Object)vo);
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaFrameworkAgreementApplyEntity entity = this.oaFrameworkAgreementApplyService.getInfo(id);
        if (entity != null) {
            this.oaFrameworkAgreementApplyService.removeInfo(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

