/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.entity.OaHotelBookEntity;
import com.bringspring.oa.entity.OaHotelReservationApplicationEntity;
import com.bringspring.oa.entity.OaHotelReservationPersonEntity;
import com.bringspring.oa.model.oahotelreservationapplication.OaHotelReservationApplicationCrForm;
import com.bringspring.oa.model.oahotelreservationapplication.OaHotelReservationApplicationImportVO;
import com.bringspring.oa.model.oahotelreservationapplication.OaHotelReservationApplicationInfoVO;
import com.bringspring.oa.model.oahotelreservationapplication.OaHotelReservationApplicationListVO;
import com.bringspring.oa.model.oahotelreservationapplication.OaHotelReservationApplicationPagination;
import com.bringspring.oa.model.oahotelreservationapplication.OaHotelReservationApplicationPaginationExportModel;
import com.bringspring.oa.model.oahotelreservationapplication.OaHotelReservationApplicationUpForm;
import com.bringspring.oa.model.oahotelreservationapplication.OaHotelReservationPersonModel;
import com.bringspring.oa.service.OaHotelBookService;
import com.bringspring.oa.service.OaHotelReservationApplicationService;
import com.bringspring.oa.service.OaHotelReservationPersonService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u9152\u5e97\u9884\u8ba2\u7533\u8bf7"}, value="oa")
@RequestMapping(value={"/api/oa/OaHotelReservationApplication"})
public class OaHotelReservationApplicationController {
    private static final Logger log = LoggerFactory.getLogger(OaHotelReservationApplicationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaHotelReservationApplicationService oaHotelReservationApplicationService;
    @Autowired
    private OaHotelReservationPersonService oaHotelReservationPersonService;
    @Autowired
    private OaHotelBookService oaHotelBookService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaHotelReservationApplicationPagination oaHotelReservationApplicationPagination) throws IOException {
        List<OaHotelReservationApplicationEntity> list = this.oaHotelReservationApplicationService.getList(oaHotelReservationApplicationPagination);
        List listVO = JsonUtil.getJsonToList(list, OaHotelReservationApplicationListVO.class);
        for (OaHotelReservationApplicationListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaHotelReservationApplicationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaHotelBookEntity book;
        OaHotelReservationApplicationCrForm oaHotelReservationApplicationCrForm = (OaHotelReservationApplicationCrForm)((Object)JsonUtil.getJsonToBean(crData, OaHotelReservationApplicationCrForm.class));
        String visualId = "575282066204186181";
        if (StringUtils.isNotEmpty((String)oaHotelReservationApplicationCrForm.getFlowId())) {
            visualId = oaHotelReservationApplicationCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OaHotelReservationApplicationEntity entity = (OaHotelReservationApplicationEntity)JsonUtil.getJsonToBean((Object)((Object)oaHotelReservationApplicationCrForm), OaHotelReservationApplicationEntity.class);
        entity.setId(mainId);
        if (StringUtils.isNotEmpty((String)entity.getHotelNameEncode()) && (book = (OaHotelBookEntity)this.oaHotelBookService.getById((Serializable)((Object)entity.getHotelNameEncode()))) != null) {
            entity.setHotelName(book.getHotelName());
        }
        entity.setCreatorUserName(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
        entity.setCreatorDeptName(this.baseDataUtil.comSelectValues(entity.getCreatorDeptId()));
        this.oaHotelReservationApplicationService.save(entity);
        List Oa_hotel_reservation_personList = JsonUtil.getJsonToList(oaHotelReservationApplicationCrForm.getOaHotelReservationPersonList(), OaHotelReservationPersonEntity.class);
        for (OaHotelReservationPersonEntity entitys : Oa_hotel_reservation_personList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setParentId(entity.getId());
            this.oaHotelReservationPersonService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)oaHotelReservationApplicationCrForm.getTaskId(), (String)visualId, (String)oaHotelReservationApplicationCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaHotelReservationApplicationCrForm), (Integer)oaHotelReservationApplicationCrForm.getStatus(), (String)oaHotelReservationApplicationCrForm.getHotelName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u9152\u5e97\u9884\u8ba2\u4eba\u5458\u540d\u5355\u6a21\u677f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u9152\u5e97\u9884\u8ba2\u4eba\u5458\u540d\u5355\u6a21\u677f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaHotelReservationApplicationPaginationExportModel oaHotelReservationApplicationPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaHotelReservationApplicationPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaHotelReservationApplicationPagination oaHotelReservationApplicationPagination = (OaHotelReservationApplicationPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaHotelReservationApplicationPaginationExportModel), OaHotelReservationApplicationPagination.class));
        List<OaHotelReservationApplicationEntity> list = this.oaHotelReservationApplicationService.getTypeList(oaHotelReservationApplicationPagination, oaHotelReservationApplicationPaginationExportModel.getDataType());
        List<OaHotelReservationPersonEntity> personList = this.oaHotelReservationPersonService.getList();
        List listVO = JsonUtil.getJsonToList(list, OaHotelReservationApplicationListVO.class);
        for (OaHotelReservationApplicationListVO vo : listVO) {
            List tempPerson = personList.stream().filter(a -> a.getParentId().equals(vo.getId())).collect(Collectors.toList());
            List personMatchList = JsonUtil.getJsonToList(tempPerson, OaHotelReservationPersonModel.class);
            if (!CollectionUtil.isNotEmpty((Collection)personMatchList)) continue;
            vo.setVisitName(personMatchList.stream().map(OaHotelReservationPersonModel::getPersonName).collect(Collectors.joining("\n")));
            vo.setVisitCardNumber(personMatchList.stream().map(OaHotelReservationPersonModel::getPersonCard).collect(Collectors.joining("\n")));
            personMatchList.forEach(a -> {
                String checkIn = DateUtil.daFormat((Date)a.getCheckInDate());
                String checkOut = DateUtil.daFormat((Date)a.getCheckOutDate());
                a.setPersonCheckDate(checkIn + "\u81f3" + checkOut);
            });
            vo.setCheckInDate(personMatchList.stream().map(OaHotelReservationPersonModel::getPersonCheckDate).collect(Collectors.joining("\n")));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaHotelReservationApplicationPaginationExportModel.getSelectKey()) ? oaHotelReservationApplicationPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block34: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65e5\u671f", (Object)"creatorTime"));
                        continue block34;
                    }
                    case "creatorUserName": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"creatorUserName"));
                        continue block34;
                    }
                    case "creatorDeptName": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u90e8\u95e8", (Object)"creatorDeptName"));
                        continue block34;
                    }
                    case "hotelName": {
                        entitys.add(new ExcelExportEntity("\u9884\u5b9a\u9152\u5e97", (Object)"hotelName"));
                        continue block34;
                    }
                    case "hotelRoomPrice": {
                        entitys.add(new ExcelExportEntity("\u623f\u578b\u4ef7\u683c", (Object)"hotelRoomPrice"));
                        continue block34;
                    }
                    case "visitCount": {
                        entitys.add(new ExcelExportEntity("\u8bbf\u5ba2\u4eba\u6570", (Object)"visitCount"));
                        continue block34;
                    }
                    case "roomCount": {
                        entitys.add(new ExcelExportEntity("\u95f4\u6570", (Object)"roomCount"));
                        continue block34;
                    }
                    case "checkInDate": {
                        entitys.add(new ExcelExportEntity("\u5165\u4f4f\u65f6\u95f4", (Object)"checkInDate"));
                        continue block34;
                    }
                    case "visitName": {
                        entitys.add(new ExcelExportEntity("\u8bbf\u5ba2\u59d3\u540d", (Object)"visitName"));
                        continue block34;
                    }
                    case "visitCardNumber": {
                        entitys.add(new ExcelExportEntity("\u8eab\u4efd\u8bc1\u53f7\u7801", (Object)"visitCardNumber"));
                        continue block34;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block34;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaHotelReservationApplicationInfoVO> info(@PathVariable(value="id") String id) {
        OaHotelReservationApplicationEntity entity = this.oaHotelReservationApplicationService.getInfo(id);
        OaHotelReservationApplicationInfoVO vo = (OaHotelReservationApplicationInfoVO)JsonUtil.getJsonToBean((Object)entity, OaHotelReservationApplicationInfoVO.class);
        List<OaHotelReservationPersonEntity> Oa_hotel_reservation_personList = this.oaHotelReservationApplicationService.GetOa_hotel_reservation_personList(id);
        for (OaHotelReservationPersonEntity oaHotelReservationPersonEntity : Oa_hotel_reservation_personList) {
        }
        vo.setOaHotelReservationPersonList(JsonUtil.getJsonToList(Oa_hotel_reservation_personList, OaHotelReservationPersonModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaHotelReservationApplicationUpForm oaHotelReservationApplicationUpForm = (OaHotelReservationApplicationUpForm)((Object)JsonUtil.getJsonToBean(upData, OaHotelReservationApplicationUpForm.class));
        String visualId = "575282066204186181";
        if (StringUtils.isNotEmpty((String)oaHotelReservationApplicationUpForm.getFlowId())) {
            visualId = oaHotelReservationApplicationUpForm.getFlowId();
        }
        UserInfo userInfo = this.userProvider.get();
        OaHotelReservationApplicationEntity entity = this.oaHotelReservationApplicationService.getInfo(id);
        if (entity != null) {
            OaHotelBookEntity book;
            OaHotelReservationApplicationEntity subentity = (OaHotelReservationApplicationEntity)JsonUtil.getJsonToBean((Object)((Object)oaHotelReservationApplicationUpForm), OaHotelReservationApplicationEntity.class);
            subentity.setLastModifyTime(new Date());
            subentity.setLastModifyUserId(userInfo.getUserId());
            if (StringUtils.isNotEmpty((String)subentity.getHotelNameEncode()) && (book = (OaHotelBookEntity)this.oaHotelBookService.getById((Serializable)((Object)subentity.getHotelNameEncode()))) != null) {
                subentity.setHotelName(book.getHotelName());
            }
            subentity.setCreatorUserName(this.baseDataUtil.userSelectValue(subentity.getCreatorUserId()));
            subentity.setCreatorDeptName(this.baseDataUtil.comSelectValues(subentity.getCreatorDeptId()));
            this.oaHotelReservationApplicationService.update(id, subentity);
            QueryWrapper Oa_hotel_reservation_personqueryWrapper = new QueryWrapper();
            Oa_hotel_reservation_personqueryWrapper.lambda().eq(OaHotelReservationPersonEntity::getParentId, (Object)entity.getId());
            this.oaHotelReservationPersonService.remove((Wrapper)Oa_hotel_reservation_personqueryWrapper);
            List Oa_hotel_reservation_personList = JsonUtil.getJsonToList(oaHotelReservationApplicationUpForm.getOaHotelReservationPersonList(), OaHotelReservationPersonEntity.class);
            for (OaHotelReservationPersonEntity entitys : Oa_hotel_reservation_personList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(entity.getId());
                this.oaHotelReservationPersonService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)oaHotelReservationApplicationUpForm.getTaskId(), (String)visualId, (String)oaHotelReservationApplicationUpForm.getTemplateId(), (String)id, (Object)((Object)oaHotelReservationApplicationUpForm), (Integer)oaHotelReservationApplicationUpForm.getStatus(), (String)oaHotelReservationApplicationUpForm.getHotelName());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaHotelReservationApplicationEntity entity = this.oaHotelReservationApplicationService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaHotelReservationApplicationService.delete(entity);
            QueryWrapper queryWrapperOa_hotel_reservation_person = new QueryWrapper();
            queryWrapperOa_hotel_reservation_person.lambda().eq(OaHotelReservationPersonEntity::getParentId, (Object)entity.getId());
            this.oaHotelReservationPersonService.remove((Wrapper)queryWrapperOa_hotel_reservation_person);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List fileImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, OaHotelReservationApplicationImportVO.class);
        if (CollectionUtil.isEmpty((Collection)fileImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileImportList.size() > 100) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e100\u6761");
        }
        Map<String, Object> map = this.oaHotelReservationPersonService.importPreview(fileImportList);
        return ActionResult.success(map);
    }

    @GetMapping(value={"/hotelList"})
    public ActionResult hotelList() throws IOException {
        List<OaHotelBookEntity> listVo = this.oaHotelBookService.getList();
        return ActionResult.success(listVo);
    }
}

