/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.entity.OaManageBudgetEntity;
import com.bringspring.oa.model.oamanagebudget.OaManageBudgetCrForm;
import com.bringspring.oa.model.oamanagebudget.OaManageBudgetInfoVO;
import com.bringspring.oa.model.oamanagebudget.OaManageBudgetListVO;
import com.bringspring.oa.model.oamanagebudget.OaManageBudgetPagination;
import com.bringspring.oa.model.oamanagebudget.OaManageBudgetUpForm;
import com.bringspring.oa.service.OaManageBudgetService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ba1\u7406\u7c7b\u9884\u7b97\u7ba1\u7406"}, value="oa")
@RequestMapping(value={"/api/oa/OaManageBudget"})
public class OaManageBudgetController {
    private static final Logger log = LoggerFactory.getLogger(OaManageBudgetController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaManageBudgetService oamanagebudgetService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaManageBudgetPagination oamanagebudgetPagination) throws IOException {
        List<OaManageBudgetEntity> list = this.oamanagebudgetService.getList(oamanagebudgetPagination);
        for (OaManageBudgetEntity oaManageBudgetEntity : list) {
            oaManageBudgetEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaManageBudgetEntity.getCreatorUserId()));
            oaManageBudgetEntity.setDeptId(this.baseDataUtil.comSelectValues(oaManageBudgetEntity.getDeptId()));
            oaManageBudgetEntity.setManagerUserId(this.baseDataUtil.userSelectValues(oaManageBudgetEntity.getManagerUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaManageBudgetListVO.class);
        for (OaManageBudgetListVO oaManageBudgetListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oamanagebudgetPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getBudgetList"})
    public ActionResult getBudgetList(@RequestBody OaManageBudgetPagination oamanagebudgetPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        oamanagebudgetPagination.setDeptIdOne(userInfo.getOrganizeId());
        List<OaManageBudgetEntity> list = this.oamanagebudgetService.getBudgetList(oamanagebudgetPagination);
        for (OaManageBudgetEntity oaManageBudgetEntity : list) {
            oaManageBudgetEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaManageBudgetEntity.getCreatorUserId()));
            oaManageBudgetEntity.setDeptId(this.baseDataUtil.comSelectValues(oaManageBudgetEntity.getDeptId()));
            oaManageBudgetEntity.setManagerUserId(this.baseDataUtil.userSelectValues(oaManageBudgetEntity.getManagerUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaManageBudgetListVO.class);
        for (OaManageBudgetListVO oaManageBudgetListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oamanagebudgetPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaManageBudgetCrForm oamanagebudgetCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oamanagebudgetCrForm.setCreatorUserId(userInfo.getUserId());
        oamanagebudgetCrForm.setCreatorTime(DateUtil.getNow());
        OaManageBudgetEntity entity = (OaManageBudgetEntity)JsonUtil.getJsonToBean((Object)oamanagebudgetCrForm, OaManageBudgetEntity.class);
        entity.setId(mainId);
        this.oamanagebudgetService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaManageBudgetInfoVO> info(@PathVariable(value="id") String id) {
        OaManageBudgetEntity entity = this.oamanagebudgetService.getInfo(id);
        OaManageBudgetInfoVO vo = (OaManageBudgetInfoVO)JsonUtil.getJsonToBean((Object)entity, OaManageBudgetInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaManageBudgetInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OaManageBudgetEntity entity = this.oamanagebudgetService.getInfo(id);
        OaManageBudgetInfoVO vo = (OaManageBudgetInfoVO)JsonUtil.getJsonToBean((Object)entity, OaManageBudgetInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setDeptId(this.baseDataUtil.comSelectValues(vo.getDeptId()));
        vo.setManagerUserId(this.baseDataUtil.userSelectValues(vo.getManagerUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaManageBudgetUpForm oamanagebudgetUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OaManageBudgetEntity entity = this.oamanagebudgetService.getInfo(id);
        if (entity != null) {
            OaManageBudgetEntity subentity = (OaManageBudgetEntity)JsonUtil.getJsonToBean((Object)oamanagebudgetUpForm, OaManageBudgetEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.oamanagebudgetService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaManageBudgetEntity entity = this.oamanagebudgetService.getInfo(id);
        if (entity != null) {
            this.oamanagebudgetService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

