/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.entity.OaOfficeSummationEntity;
import com.bringspring.oa.entity.OaOfficeSupplyReimbursementEntity;
import com.bringspring.oa.model.oaofficesupplyreimbursement.OaOfficeSupplyReimbursementCrForm;
import com.bringspring.oa.model.oaofficesupplyreimbursement.OaOfficeSupplyReimbursementInfoVO;
import com.bringspring.oa.model.oaofficesupplyreimbursement.OaOfficeSupplyReimbursementListVO;
import com.bringspring.oa.model.oaofficesupplyreimbursement.OaOfficeSupplyReimbursementPagination;
import com.bringspring.oa.model.oaofficesupplyreimbursement.OaOfficeSupplyReimbursementUpForm;
import com.bringspring.oa.service.OaOfficeSummationService;
import com.bringspring.oa.service.OaOfficeSupplyReimbursementService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u529e\u516c\u7528\u54c1\u91c7\u8d2d\u8d39\u62a5\u9500"}, value="oa")
@RequestMapping(value={"/api/oa/OaOfficeSupplyReimbursement"})
public class OaOfficeSupplyReimbursementController {
    private static final Logger log = LoggerFactory.getLogger(OaOfficeSupplyReimbursementController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaOfficeSupplyReimbursementService oaOfficeSupplyReimbursementService;
    @Autowired
    private OaOfficeSummationService oaOfficeSummationService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaOfficeSupplyReimbursementPagination oaOfficeSupplyReimbursementPagination) throws IOException {
        List<OaOfficeSupplyReimbursementEntity> list = this.oaOfficeSupplyReimbursementService.getList(oaOfficeSupplyReimbursementPagination);
        for (OaOfficeSupplyReimbursementEntity oaOfficeSupplyReimbursementEntity : list) {
            oaOfficeSupplyReimbursementEntity.setApplicantName(this.baseDataUtil.userSelectValue(oaOfficeSupplyReimbursementEntity.getApplicantName()));
            oaOfficeSupplyReimbursementEntity.setApplicationDept(this.baseDataUtil.comSelectValue(oaOfficeSupplyReimbursementEntity.getApplicationDept(), "last"));
            oaOfficeSupplyReimbursementEntity.setApplyUploads(this.baseDataUtil.getFileNameInJson(oaOfficeSupplyReimbursementEntity.getApplyUploads()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaOfficeSupplyReimbursementListVO.class);
        for (OaOfficeSupplyReimbursementListVO oaOfficeSupplyReimbursementListVO : listVO) {
        }
        for (OaOfficeSupplyReimbursementListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaOfficeSupplyReimbursementPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaOfficeSummationEntity oaOfficeSummationEntity;
        OaOfficeSupplyReimbursementCrForm oaOfficeSupplyReimbursementCrForm = (OaOfficeSupplyReimbursementCrForm)((Object)JsonUtil.getJsonToBean(crData, OaOfficeSupplyReimbursementCrForm.class));
        String flowEngineId = "515150187040081221";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaOfficeSupplyReimbursementCrForm.setApplicantName(userInfo.getUserId());
        oaOfficeSupplyReimbursementCrForm.setApplicationDate(DateUtil.getNow());
        oaOfficeSupplyReimbursementCrForm.setApplicationDept(StringUtils.isEmpty((String)userInfo.getDepartmentId()) ? userInfo.getOrganizeId() : userInfo.getDepartmentId());
        oaOfficeSupplyReimbursementCrForm.setApplicationId(this.baseDataUtil.getBillNumber("OfficeSupplyReimbursement", Boolean.valueOf(false)));
        OaOfficeSupplyReimbursementEntity entity = (OaOfficeSupplyReimbursementEntity)JsonUtil.getJsonToBean((Object)((Object)oaOfficeSupplyReimbursementCrForm), OaOfficeSupplyReimbursementEntity.class);
        entity.setId(mainId);
        this.oaOfficeSupplyReimbursementService.save(entity);
        String title = "";
        if (entity.getSumApplyId() != null && (oaOfficeSummationEntity = this.oaOfficeSummationService.getInfo(entity.getSumApplyId())) != null) {
            title = oaOfficeSummationEntity.getApplyYear() + "\u5e74" + oaOfficeSummationEntity.getApplyQuarter() + "\u5b63\u5ea6";
        }
        FlowUtil.saveOrSubmit((String)oaOfficeSupplyReimbursementCrForm.getTaskId(), (String)flowEngineId, (String)oaOfficeSupplyReimbursementCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaOfficeSupplyReimbursementCrForm), (Integer)oaOfficeSupplyReimbursementCrForm.getStatus(), (String)title);
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaOfficeSupplyReimbursementInfoVO> info(@PathVariable(value="id") String id) {
        OaOfficeSupplyReimbursementEntity entity = this.oaOfficeSupplyReimbursementService.getInfo(id);
        OaOfficeSupplyReimbursementInfoVO vo = (OaOfficeSupplyReimbursementInfoVO)JsonUtil.getJsonToBean((Object)entity, OaOfficeSupplyReimbursementInfoVO.class);
        vo.setApplicantName(this.baseDataUtil.userSelectValue(vo.getApplicantName()));
        if (vo.getApplicationDate() != null) {
            vo.setApplicationDate(vo.getApplicationDate());
        }
        vo.setApplicationDept(this.baseDataUtil.comSelectValue(vo.getApplicationDept(), "last"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaOfficeSupplyReimbursementUpForm oaOfficeSupplyReimbursementUpForm = (OaOfficeSupplyReimbursementUpForm)((Object)JsonUtil.getJsonToBean(upData, OaOfficeSupplyReimbursementUpForm.class));
        String flowEngineId = "515150187040081221";
        UserInfo userInfo = this.userProvider.get();
        OaOfficeSupplyReimbursementEntity entity = this.oaOfficeSupplyReimbursementService.getInfo(id);
        if (entity != null) {
            OaOfficeSummationEntity oaOfficeSummationEntity;
            oaOfficeSupplyReimbursementUpForm.setApplicationDept(entity.getApplicationDept());
            OaOfficeSupplyReimbursementEntity subentity = (OaOfficeSupplyReimbursementEntity)JsonUtil.getJsonToBean((Object)((Object)oaOfficeSupplyReimbursementUpForm), OaOfficeSupplyReimbursementEntity.class);
            subentity.setApplicantName(entity.getApplicantName());
            subentity.setApplicationDate(entity.getApplicationDate());
            this.oaOfficeSupplyReimbursementService.update(id, subentity);
            String title = "";
            if (subentity.getSumApplyId() != null && (oaOfficeSummationEntity = this.oaOfficeSummationService.getInfo(subentity.getSumApplyId())) != null) {
                title = oaOfficeSummationEntity.getApplyYear() + "\u5e74" + oaOfficeSummationEntity.getApplyQuarter() + "\u5b63\u5ea6";
            }
            FlowUtil.saveOrSubmit((String)oaOfficeSupplyReimbursementUpForm.getTaskId(), (String)flowEngineId, (String)oaOfficeSupplyReimbursementUpForm.getTemplateId(), (String)id, (Object)((Object)oaOfficeSupplyReimbursementUpForm), (Integer)oaOfficeSupplyReimbursementUpForm.getStatus(), (String)title);
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaOfficeSupplyReimbursementEntity entity = this.oaOfficeSupplyReimbursementService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaOfficeSupplyReimbursementService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

