/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectAcceptanceConfirmedReceiptEntity;
import com.bringspring.oa.model.oaProjectAcceptanceConfirmedReceipt.OaProjectAcceptanceConfirmedReceiptCrForm;
import com.bringspring.oa.model.oaProjectAcceptanceConfirmedReceipt.OaProjectAcceptanceConfirmedReceiptInfoVO;
import com.bringspring.oa.model.oaProjectAcceptanceConfirmedReceipt.OaProjectAcceptanceConfirmedReceiptListVO;
import com.bringspring.oa.model.oaProjectAcceptanceConfirmedReceipt.OaProjectAcceptanceConfirmedReceiptPagination;
import com.bringspring.oa.model.oaProjectAcceptanceConfirmedReceipt.OaProjectAcceptanceConfirmedReceiptPaginationExportModel;
import com.bringspring.oa.model.oaProjectAcceptanceConfirmedReceipt.OaProjectAcceptanceConfirmedReceiptUpForm;
import com.bringspring.oa.model.oaattachment.OaAttachmentCrForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectAcceptanceConfirmedReceiptService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u9a8c\u6536\u786e\u6536\u7533\u8bf7"}, value="oa")
@RequestMapping(value={"/api/oa/OaProjectAcceptanceConfirmedReceipt"})
public class OaProjectAcceptanceConfirmedReceiptController {
    private static final Logger log = LoggerFactory.getLogger(OaProjectAcceptanceConfirmedReceiptController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaProjectAcceptanceConfirmedReceiptService oaProjectAcceptanceConfirmedReceiptService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private CrmCustomerService crmCustomerService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaProjectAcceptanceConfirmedReceiptPagination oaProjectAcceptanceConfirmedReceiptPagination) throws IOException {
        List<OaProjectAcceptanceConfirmedReceiptEntity> list = this.oaProjectAcceptanceConfirmedReceiptService.getList(oaProjectAcceptanceConfirmedReceiptPagination);
        for (OaProjectAcceptanceConfirmedReceiptEntity oaProjectAcceptanceConfirmedReceiptEntity : list) {
            oaProjectAcceptanceConfirmedReceiptEntity.setSalerId(this.baseDataUtil.userSelectValues(oaProjectAcceptanceConfirmedReceiptEntity.getSalerId()));
            oaProjectAcceptanceConfirmedReceiptEntity.setSalerAssistant(this.baseDataUtil.userSelectValues(oaProjectAcceptanceConfirmedReceiptEntity.getSalerAssistant()));
            oaProjectAcceptanceConfirmedReceiptEntity.setProjectHeader(this.baseDataUtil.userSelectValues(oaProjectAcceptanceConfirmedReceiptEntity.getProjectHeader()));
            oaProjectAcceptanceConfirmedReceiptEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaProjectAcceptanceConfirmedReceiptEntity.getCreatorUserId()));
            oaProjectAcceptanceConfirmedReceiptEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(oaProjectAcceptanceConfirmedReceiptEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaProjectAcceptanceConfirmedReceiptListVO.class);
        for (OaProjectAcceptanceConfirmedReceiptListVO oaProjectAcceptanceConfirmedReceiptListVO : listVO) {
        }
        for (OaProjectAcceptanceConfirmedReceiptListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaProjectAcceptanceConfirmedReceiptPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        RkContractProjectEntity project;
        OaProjectAcceptanceConfirmedReceiptCrForm oaProjectAcceptanceConfirmedReceiptCrForm = (OaProjectAcceptanceConfirmedReceiptCrForm)JsonUtil.getJsonToBean(crData, OaProjectAcceptanceConfirmedReceiptCrForm.class);
        String visualId = "700718735798835909";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaProjectAcceptanceConfirmedReceiptCrForm.setCreatorUserId(userInfo.getUserId());
        oaProjectAcceptanceConfirmedReceiptCrForm.setCreatorTime(DateUtil.getNow());
        if (StringUtils.isNotEmpty((String)oaProjectAcceptanceConfirmedReceiptCrForm.getProjectId()) && ObjectUtil.isNotEmpty((Object)(project = this.rkContractProjectService.getInfo(oaProjectAcceptanceConfirmedReceiptCrForm.getProjectId())))) {
            oaProjectAcceptanceConfirmedReceiptCrForm.setProjectCode(project.getProjectCode());
            oaProjectAcceptanceConfirmedReceiptCrForm.setProjectName(project.getProjectName());
            oaProjectAcceptanceConfirmedReceiptCrForm.setProjectHeader(project.getProjectHeader());
            oaProjectAcceptanceConfirmedReceiptCrForm.setContractId(project.getContractId());
            RkContractEntity rkContract = this.rkContractService.getInfo(project.getContractId());
            if (ObjectUtil.isNotEmpty((Object)rkContract)) {
                oaProjectAcceptanceConfirmedReceiptCrForm.setContractCode(rkContract.getContractCode());
                oaProjectAcceptanceConfirmedReceiptCrForm.setContractName(rkContract.getContractName());
                oaProjectAcceptanceConfirmedReceiptCrForm.setCustomerId(rkContract.getCustomerId());
                oaProjectAcceptanceConfirmedReceiptCrForm.setSalerId(rkContract.getSalerId());
                if (ObjectUtil.isNotEmpty((Object)rkContract.getReturnAmount())) {
                    oaProjectAcceptanceConfirmedReceiptCrForm.setReturnAmount(rkContract.getReturnAmount().toString());
                    if (ObjectUtil.isNotEmpty((Object)rkContract.getContractAmount())) {
                        oaProjectAcceptanceConfirmedReceiptCrForm.setReturnRadio(rkContract.getReturnAmount().multiply(new BigDecimal(100)).divide(rkContract.getContractAmount(), 2, 4).toString());
                    } else {
                        oaProjectAcceptanceConfirmedReceiptCrForm.setReturnRadio("0");
                    }
                } else {
                    oaProjectAcceptanceConfirmedReceiptCrForm.setReturnRadio("0");
                }
            }
        }
        OaProjectAcceptanceConfirmedReceiptEntity entity = (OaProjectAcceptanceConfirmedReceiptEntity)JsonUtil.getJsonToBean((Object)oaProjectAcceptanceConfirmedReceiptCrForm, OaProjectAcceptanceConfirmedReceiptEntity.class);
        entity.setId(mainId);
        this.oaProjectAcceptanceConfirmedReceiptService.save(entity);
        if (ObjectUtil.isNotEmpty(oaProjectAcceptanceConfirmedReceiptCrForm.getAttachmentList())) {
            List<OaAttachmentCrForm> attachmentList = oaProjectAcceptanceConfirmedReceiptCrForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType("confirm");
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(attachmentEntityList);
        }
        List<OaAttachmentCrForm> factoryAttachmentList = oaProjectAcceptanceConfirmedReceiptCrForm.getFactoryAttachmentList();
        factoryAttachmentList.stream().forEach(attach -> {
            attach.setContractId(mainId);
            attach.setFileType("factory");
        });
        List factoryLicenseEntityList = JsonUtil.getJsonToList(factoryAttachmentList, OaAttachmentEntity.class);
        this.oaAttachmentService.saveBatch(factoryLicenseEntityList);
        List<OaAttachmentCrForm> financialAttachmentList = oaProjectAcceptanceConfirmedReceiptCrForm.getFinancialAttachmentList();
        financialAttachmentList.stream().forEach(attach -> {
            attach.setContractId(mainId);
            attach.setFileType("financial");
        });
        List financialLicenseEntityList = JsonUtil.getJsonToList(financialAttachmentList, OaAttachmentEntity.class);
        this.oaAttachmentService.saveBatch(financialLicenseEntityList);
        List<OaAttachmentCrForm> assistantAttachmentList = oaProjectAcceptanceConfirmedReceiptCrForm.getAssistantAttachmentList();
        assistantAttachmentList.stream().forEach(attach -> {
            attach.setContractId(mainId);
            attach.setFileType("assistant");
        });
        List assistantEntityList = JsonUtil.getJsonToList(assistantAttachmentList, OaAttachmentEntity.class);
        this.oaAttachmentService.saveBatch(assistantEntityList);
        FlowUtil.saveOrSubmit((String)oaProjectAcceptanceConfirmedReceiptCrForm.getTaskId(), (String)oaProjectAcceptanceConfirmedReceiptCrForm.getFlowId(), (String)oaProjectAcceptanceConfirmedReceiptCrForm.getTemplateId(), (String)mainId, (Object)oaProjectAcceptanceConfirmedReceiptCrForm, (Integer)oaProjectAcceptanceConfirmedReceiptCrForm.getStatus(), (String)"");
        if (FlowTaskStatusEnum.Handle.getCode().equals(oaProjectAcceptanceConfirmedReceiptCrForm.getStatus())) {
            return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
        }
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaProjectAcceptanceConfirmedReceiptPaginationExportModel oaProjectAcceptanceConfirmedReceiptPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaProjectAcceptanceConfirmedReceiptPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaProjectAcceptanceConfirmedReceiptPagination oaProjectAcceptanceConfirmedReceiptPagination = (OaProjectAcceptanceConfirmedReceiptPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaProjectAcceptanceConfirmedReceiptPaginationExportModel), OaProjectAcceptanceConfirmedReceiptPagination.class));
        List<OaProjectAcceptanceConfirmedReceiptEntity> list = this.oaProjectAcceptanceConfirmedReceiptService.getTypeList(oaProjectAcceptanceConfirmedReceiptPagination, oaProjectAcceptanceConfirmedReceiptPaginationExportModel.getDataType());
        for (OaProjectAcceptanceConfirmedReceiptEntity oaProjectAcceptanceConfirmedReceiptEntity : list) {
            oaProjectAcceptanceConfirmedReceiptEntity.setSalerId(this.baseDataUtil.userSelectValues(oaProjectAcceptanceConfirmedReceiptEntity.getSalerId()));
            oaProjectAcceptanceConfirmedReceiptEntity.setSalerAssistant(this.baseDataUtil.userSelectValues(oaProjectAcceptanceConfirmedReceiptEntity.getSalerAssistant()));
            oaProjectAcceptanceConfirmedReceiptEntity.setProjectHeader(this.baseDataUtil.userSelectValues(oaProjectAcceptanceConfirmedReceiptEntity.getProjectHeader()));
            oaProjectAcceptanceConfirmedReceiptEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaProjectAcceptanceConfirmedReceiptEntity.getCreatorUserId()));
            oaProjectAcceptanceConfirmedReceiptEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(oaProjectAcceptanceConfirmedReceiptEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaProjectAcceptanceConfirmedReceiptListVO.class);
        for (OaProjectAcceptanceConfirmedReceiptListVO oaProjectAcceptanceConfirmedReceiptListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaProjectAcceptanceConfirmedReceiptPaginationExportModel.getSelectKey()) ? oaProjectAcceptanceConfirmedReceiptPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block50: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "projectId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76eeid", (Object)"projectId"));
                        continue block50;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block50;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block50;
                    }
                    case "contractId": {
                        entitys.add(new ExcelExportEntity("\u5408\u540cid", (Object)"contractId"));
                        continue block50;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block50;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block50;
                    }
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237id", (Object)"customerId"));
                        continue block50;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237", (Object)"customerName"));
                        continue block50;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d", (Object)"contractAmount"));
                        continue block50;
                    }
                    case "salerId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e", (Object)"salerId"));
                        continue block50;
                    }
                    case "salerAssistant": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u52a9\u7406", (Object)"salerAssistant"));
                        continue block50;
                    }
                    case "projectHeader": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"projectHeader"));
                        continue block50;
                    }
                    case "returnAmount": {
                        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u91d1\u989d", (Object)"returnAmount"));
                        continue block50;
                    }
                    case "contractType": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7c7b\u578b", (Object)"contractType"));
                        continue block50;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u8bf4\u660e", (Object)"description"));
                        continue block50;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"creatorUserId"));
                        continue block50;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65e5\u671f", (Object)"creatorTime"));
                        continue block50;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block50;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block50;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaProjectAcceptanceConfirmedReceiptInfoVO> info(@PathVariable(value="id") String id) {
        CrmCustomerEntity crmCustomer;
        OaProjectAcceptanceConfirmedReceiptEntity entity = this.oaProjectAcceptanceConfirmedReceiptService.getInfo(id);
        OaProjectAcceptanceConfirmedReceiptInfoVO vo = (OaProjectAcceptanceConfirmedReceiptInfoVO)JsonUtil.getJsonToBean((Object)entity, OaProjectAcceptanceConfirmedReceiptInfoVO.class);
        if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerId()) && ObjectUtil.isNotEmpty((Object)(crmCustomer = this.crmCustomerService.getInfo(vo.getCustomerId())))) {
            vo.setCustomerName(crmCustomer.getName());
        }
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        List<OaAttachmentEntity> attachmentList = this.oaAttachmentService.getListByContractIdAndFileType(id, "confirm");
        List<OaAttachmentEntity> factoryAttachmentList = this.oaAttachmentService.getListByContractIdAndFileType(id, "factory");
        List<OaAttachmentEntity> financialAttachmentList = this.oaAttachmentService.getListByContractIdAndFileType(id, "financial");
        List<OaAttachmentEntity> assistantAttachmentList = this.oaAttachmentService.getListByContractIdAndFileType(id, "assistant");
        vo.setAttachmentList(JsonUtil.getJsonToList(attachmentList, OaAttachmentCrForm.class));
        vo.setFinancialAttachmentList(JsonUtil.getJsonToList(financialAttachmentList, OaAttachmentCrForm.class));
        vo.setFactoryAttachmentList(JsonUtil.getJsonToList(factoryAttachmentList, OaAttachmentCrForm.class));
        vo.setAssistantAttachmentList(JsonUtil.getJsonToList(assistantAttachmentList, OaAttachmentCrForm.class));
        if (ObjectUtil.isNotEmpty((Object)vo.getReturnAmount())) {
            if (ObjectUtil.isNotEmpty((Object)vo.getContractAmount())) {
                BigDecimal returnAmount = new BigDecimal(vo.getReturnAmount());
                BigDecimal contractAmount = new BigDecimal(vo.getContractAmount());
                vo.setReturnRadio(returnAmount.multiply(new BigDecimal(100)).divide(contractAmount, 2, 4).toString());
            } else {
                vo.setReturnRadio("0");
            }
        } else {
            vo.setReturnRadio("0");
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaProjectAcceptanceConfirmedReceiptUpForm oaProjectAcceptanceConfirmedReceiptUpForm = (OaProjectAcceptanceConfirmedReceiptUpForm)JsonUtil.getJsonToBean(upData, OaProjectAcceptanceConfirmedReceiptUpForm.class);
        String visualId = "700718735798835909";
        UserInfo userInfo = this.userProvider.get();
        OaProjectAcceptanceConfirmedReceiptEntity entity = this.oaProjectAcceptanceConfirmedReceiptService.getInfo(id);
        if (entity != null) {
            RkContractProjectEntity project;
            oaProjectAcceptanceConfirmedReceiptUpForm.setLastModifyUserId(userInfo.getUserId());
            oaProjectAcceptanceConfirmedReceiptUpForm.setLastModifyTime(DateUtil.getNow());
            if (StringUtils.isNotEmpty((String)oaProjectAcceptanceConfirmedReceiptUpForm.getProjectId()) && ObjectUtil.isNotEmpty((Object)(project = this.rkContractProjectService.getInfo(oaProjectAcceptanceConfirmedReceiptUpForm.getProjectId())))) {
                oaProjectAcceptanceConfirmedReceiptUpForm.setProjectCode(project.getProjectCode());
                oaProjectAcceptanceConfirmedReceiptUpForm.setProjectName(project.getProjectName());
                oaProjectAcceptanceConfirmedReceiptUpForm.setProjectHeader(project.getProjectHeader());
                oaProjectAcceptanceConfirmedReceiptUpForm.setContractId(project.getContractId());
                RkContractEntity rkContract = this.rkContractService.getInfo(project.getContractId());
                if (ObjectUtil.isNotEmpty((Object)rkContract)) {
                    oaProjectAcceptanceConfirmedReceiptUpForm.setContractCode(rkContract.getContractCode());
                    oaProjectAcceptanceConfirmedReceiptUpForm.setContractName(rkContract.getContractName());
                    oaProjectAcceptanceConfirmedReceiptUpForm.setCustomerId(rkContract.getCustomerId());
                    oaProjectAcceptanceConfirmedReceiptUpForm.setSalerId(rkContract.getSalerId());
                    if (ObjectUtil.isNotEmpty((Object)rkContract.getReturnAmount())) {
                        oaProjectAcceptanceConfirmedReceiptUpForm.setReturnAmount(rkContract.getReturnAmount().toString());
                        if (ObjectUtil.isNotEmpty((Object)rkContract.getContractAmount())) {
                            oaProjectAcceptanceConfirmedReceiptUpForm.setReturnRadio(rkContract.getReturnAmount().multiply(new BigDecimal(100)).divide(rkContract.getContractAmount(), 2, 4).toString());
                        } else {
                            oaProjectAcceptanceConfirmedReceiptUpForm.setReturnRadio("0");
                        }
                    } else {
                        oaProjectAcceptanceConfirmedReceiptUpForm.setReturnRadio("0");
                    }
                }
            }
            OaProjectAcceptanceConfirmedReceiptEntity subentity = (OaProjectAcceptanceConfirmedReceiptEntity)JsonUtil.getJsonToBean((Object)oaProjectAcceptanceConfirmedReceiptUpForm, OaProjectAcceptanceConfirmedReceiptEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.oaProjectAcceptanceConfirmedReceiptService.update(id, subentity);
            this.oaAttachmentService.deleteByContractId(id);
            List<OaAttachmentCrForm> attachmentList = oaProjectAcceptanceConfirmedReceiptUpForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(id);
                attach.setFileType("confirm");
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(attachmentEntityList);
            List<OaAttachmentCrForm> factoryAttachmentList = oaProjectAcceptanceConfirmedReceiptUpForm.getFactoryAttachmentList();
            factoryAttachmentList.stream().forEach(attach -> {
                attach.setContractId(id);
                attach.setFileType("factory");
            });
            List factoryLicenseEntityList = JsonUtil.getJsonToList(factoryAttachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(factoryLicenseEntityList);
            List<OaAttachmentCrForm> financialAttachmentList = oaProjectAcceptanceConfirmedReceiptUpForm.getFinancialAttachmentList();
            financialAttachmentList.stream().forEach(attach -> {
                attach.setContractId(id);
                attach.setFileType("financial");
            });
            List financialLicenseEntityList = JsonUtil.getJsonToList(financialAttachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(financialLicenseEntityList);
            List<OaAttachmentCrForm> assistantAttachmentList = oaProjectAcceptanceConfirmedReceiptUpForm.getAssistantAttachmentList();
            assistantAttachmentList.stream().forEach(attach -> {
                attach.setContractId(id);
                attach.setFileType("assistant");
            });
            List assistantEntityList = JsonUtil.getJsonToList(assistantAttachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(assistantEntityList);
            FlowUtil.saveOrSubmit((String)oaProjectAcceptanceConfirmedReceiptUpForm.getTaskId(), (String)oaProjectAcceptanceConfirmedReceiptUpForm.getFlowId(), (String)oaProjectAcceptanceConfirmedReceiptUpForm.getTemplateId(), (String)id, (Object)oaProjectAcceptanceConfirmedReceiptUpForm, (Integer)oaProjectAcceptanceConfirmedReceiptUpForm.getStatus(), (String)"");
            if (FlowTaskStatusEnum.Handle.getCode().equals(oaProjectAcceptanceConfirmedReceiptUpForm.getStatus())) {
                return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaProjectAcceptanceConfirmedReceiptEntity entity = this.oaProjectAcceptanceConfirmedReceiptService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaProjectAcceptanceConfirmedReceiptService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

