/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.crm.entity.CrmClueInfoEntity;
import com.bringspring.crm.entity.CrmCompetitorEntity;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmCustomerOpportunityEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductPriceEntity;
import com.bringspring.crm.service.CrmClueInfoService;
import com.bringspring.crm.service.CrmCompetitorService;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductPriceService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectReportingApplyEntity;
import com.bringspring.oa.model.reporting.OaProjectReportingApplyCrForm;
import com.bringspring.oa.model.reporting.OaProjectReportingApplyInfoVO;
import com.bringspring.oa.model.reporting.OaProjectReportingApplyListVO;
import com.bringspring.oa.model.reporting.OaProjectReportingApplyPagination;
import com.bringspring.oa.model.reporting.OaProjectReportingApplyPaginationExportModel;
import com.bringspring.oa.model.reporting.OaProjectReportingApplyUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectReportingApplyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.entity.RkProjectReportingStageTrendsEntity;
import com.bringspring.visit.model.RkMrketLogRelevanceListInfo;
import com.bringspring.visit.model.rkMarketLog.RkMrketLogRelevanceListVO;
import com.bringspring.visit.model.rkMarketLog.VisitFollowUpForm;
import com.bringspring.visit.model.rkprojectreportingstagetrends.RkProjectReportingStageTrendsPagination;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.service.RkProjectReportingStageTrendsService;
import com.bringspring.visit.utils.ProjectReportingEnum;
import com.bringspring.visit.utils.SalesRoleUtils;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u62a5\u5907\u7533\u8bf7"}, value="visit")
@RequestMapping(value={"/api/oa/RkProjectReporting"})
public class OaProjectReportingApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaProjectReportingApplyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaProjectReportingApplyService oaProjectReportingApplyService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private SalesRoleUtils salesRoleUtils;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private RkProjectReportingStageTrendsService rkProjectReportingStageTrendsService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductPriceService crmProductPriceService;
    @Autowired
    private CrmCompetitorService crmCompetitorService;
    @Autowired
    private CrmClueInfoService crmClueInfoService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaProjectReportingApplyPagination oaProjectReportingApplyPagination) throws IOException {
        List list;
        UserInfo userInfo = this.userProvider.get();
        HashMap iCanWho = this.salesRoleUtils.getICanWho(this.userProvider.get());
        List userIdList = CollectionUtil.list((boolean)false);
        boolean isAll = (Boolean)iCanWho.get("isAll");
        if (!isAll) {
            userIdList.add(userInfo.getUserId());
            list = (List)iCanWho.get("idList");
            List authAddress = (List)iCanWho.get("authAddress");
            userIdList.addAll(list);
            oaProjectReportingApplyPagination.setAuthAddress(authAddress);
            oaProjectReportingApplyPagination.setCanSeeUserIdList(userIdList);
        }
        list = this.oaProjectReportingApplyService.getList(oaProjectReportingApplyPagination);
        for (Object entity : list) {
            ((OaProjectReportingApplyEntity)entity).setAddress(this.baseDataUtil.provinceData(((OaProjectReportingApplyEntity)entity).getAddress()));
            ((OaProjectReportingApplyEntity)entity).setGarde(this.baseDataUtil.getDictName(((OaProjectReportingApplyEntity)entity).getGarde(), "CustomerGrade"));
            OrganizeEntity info = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)((OaProjectReportingApplyEntity)entity).getCompanyId()));
            OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), OrganizeCrModel.class);
            ((OaProjectReportingApplyEntity)entity).setCompanyId(jsonToBean.getShortName());
        }
        List listVO = JsonUtil.getJsonToList((Object)list, OaProjectReportingApplyListVO.class);
        for (OaProjectReportingApplyListVO rkProjectReportingVO : listVO) {
            List<String> productCompanyList;
            List organizeEntityList;
            rkProjectReportingVO.setCreatorUser(rkProjectReportingVO.getCreatorUserId());
            rkProjectReportingVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkProjectReportingVO.getCreatorUserId()));
            rkProjectReportingVO.setEnabledMarkCode(rkProjectReportingVO.getEnabledMark());
            rkProjectReportingVO.setEnabledMark(this.baseDataUtil.getDictName(rkProjectReportingVO.getEnabledMark(), "projectReportingEnabledMark"));
            rkProjectReportingVO.setSaleStageName(this.baseDataUtil.getDictName(rkProjectReportingVO.getSaleStage(), "ReportingSaleStage"));
            rkProjectReportingVO.setProjectStageName(this.baseDataUtil.getDictName(rkProjectReportingVO.getProjectStage(), "ReportingProjectStage"));
            rkProjectReportingVO.setSalesType(StringUtils.isBlank((CharSequence)rkProjectReportingVO.getSalesType()) ? "" : (StrUtil.equals((CharSequence)rkProjectReportingVO.getSalesType(), (CharSequence)"directSales") ? "\u76f4\u9500" : "\u5206\u9500"));
            rkProjectReportingVO.setIsSecondarySales(StringUtils.isBlank((CharSequence)rkProjectReportingVO.getIsSecondarySales()) ? "" : (StrUtil.equals((CharSequence)rkProjectReportingVO.getIsSecondarySales(), (CharSequence)"1") ? "\u662f" : "\u5426"));
            rkProjectReportingVO.setIsNeedInternalApplication(StringUtils.isBlank((CharSequence)rkProjectReportingVO.getIsNeedInternalApplication()) ? "" : (StrUtil.equals((CharSequence)rkProjectReportingVO.getIsNeedInternalApplication(), (CharSequence)"1") ? "\u9700\u8981" : "\u4e0d\u9700\u8981"));
            HashSet<String> productCompanySet = new HashSet<String>();
            if (StrUtil.isNotBlank((CharSequence)rkProjectReportingVO.getProductCompany()) && CollectionUtil.isNotEmpty((Collection)(organizeEntityList = this.organizeService.listByIds(productCompanyList = Arrays.asList(rkProjectReportingVO.getProductCompany().split(",")))))) {
                for (OrganizeEntity byId : organizeEntityList) {
                    OrganizeCrModel crModel = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
                    productCompanySet.add(crModel.getShortName());
                }
            }
            if (CollectionUtil.isNotEmpty(productCompanySet)) {
                rkProjectReportingVO.setProductCompany(StrUtil.join((CharSequence)",", productCompanySet));
            }
            this.oaProjectReportingApplyService.appendBrokerInfo(rkProjectReportingVO);
            if (StrUtil.isNotBlank((CharSequence)rkProjectReportingVO.getCompetitorId())) {
                CrmCompetitorEntity byId = (CrmCompetitorEntity)this.crmCompetitorService.getById((Serializable)((Object)rkProjectReportingVO.getCompetitorId()));
                rkProjectReportingVO.setCompetitorId(ObjectUtil.isNull((Object)byId) ? "" : byId.getCompetitorName());
            } else {
                rkProjectReportingVO.setCompetitorId("");
            }
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkProjectReportingVO.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                rkProjectReportingVO.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            rkProjectReportingVO.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaProjectReportingApplyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaProjectReportingApplyCrForm oaProjectReportingApplyCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "503829668818848773";
        if (StrUtil.isNotBlank((CharSequence)oaProjectReportingApplyCrForm.getFlowId())) {
            flowEngineId = oaProjectReportingApplyCrForm.getFlowId();
        }
        UserInfo userInfo = this.userProvider.get();
        if (this.oaProjectReportingApplyService.isPrimary(oaProjectReportingApplyCrForm)) {
            return ActionResult.fail((String)"\u65b0\u589e\u5931\u8d25\uff0c\u5546\u673a\u7f16\u7801\u91cd\u590d");
        }
        if (FlowTaskStatusEnum.Handle.getCode() == oaProjectReportingApplyCrForm.getStatus()) {
            oaProjectReportingApplyCrForm.setEnabledMark(ProjectReportingEnum.AUDIT_NODE.getType());
        } else {
            oaProjectReportingApplyCrForm.setEnabledMark(ProjectReportingEnum.DRAFT_NODE.getType());
        }
        if (StrUtil.isNotEmpty((CharSequence)oaProjectReportingApplyCrForm.getProductId())) {
            List productList = this.crmProductService.getInfoByListId(oaProjectReportingApplyCrForm.getProductId());
            oaProjectReportingApplyCrForm.setProductName(productList.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        }
        this.oaProjectReportingApplyService.saveProjectReporting(oaProjectReportingApplyCrForm);
        oaProjectReportingApplyCrForm.setIsBelowFloorPrice(oaProjectReportingApplyCrForm.getIsBelowFloorPrice());
        CrmCustomerEntity customer = this.crmCustomerService.getInfo(oaProjectReportingApplyCrForm.getCustomerId());
        if (ObjectUtil.isNotEmpty((Object)customer)) {
            oaProjectReportingApplyCrForm.setCustomerType(customer.getClassificationCode());
        }
        FlowUtil.saveOrSubmit((String)oaProjectReportingApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaProjectReportingApplyCrForm.getTemplateId(), (String)oaProjectReportingApplyCrForm.getMainId(), (Object)((Object)oaProjectReportingApplyCrForm), (Integer)oaProjectReportingApplyCrForm.getStatus(), (String)oaProjectReportingApplyCrForm.getReportingProject());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/Export"})
    public ActionResult Export(@RequestBody OaProjectReportingApplyPaginationExportModel oaProjectReportingApplyPaginationExportModel) throws IOException {
        if (StrUtil.isEmpty((CharSequence)oaProjectReportingApplyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaProjectReportingApplyPagination oaProjectReportingApplyPagination = (OaProjectReportingApplyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaProjectReportingApplyPaginationExportModel), OaProjectReportingApplyPagination.class));
        List<OaProjectReportingApplyEntity> list = this.oaProjectReportingApplyService.getTypeList(oaProjectReportingApplyPagination, oaProjectReportingApplyPaginationExportModel.getDataType());
        for (OaProjectReportingApplyEntity oaProjectReportingApplyEntity : list) {
            oaProjectReportingApplyEntity.setEnabledMark(this.baseDataUtil.getDictName(oaProjectReportingApplyEntity.getEnabledMark(), "projectReportingEnabledMark"));
            oaProjectReportingApplyEntity.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(oaProjectReportingApplyEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaProjectReportingApplyListVO.class);
        for (OaProjectReportingApplyListVO rkProjectReportingVO : listVO) {
            List<String> list2;
            List categoryEntityList;
            List<String> productCompanyList;
            List organizeEntityList;
            HashSet<String> productCompanySet = new HashSet<String>();
            if (StrUtil.isNotBlank((CharSequence)rkProjectReportingVO.getProductCompany()) && CollectionUtil.isNotEmpty((Collection)(organizeEntityList = this.organizeService.listByIds(productCompanyList = Arrays.asList(rkProjectReportingVO.getProductCompany().split(",")))))) {
                for (OrganizeEntity byId : organizeEntityList) {
                    OrganizeCrModel crModel = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
                    productCompanySet.add(crModel.getShortName());
                }
            }
            if (CollectionUtil.isNotEmpty(productCompanySet)) {
                rkProjectReportingVO.setProductCompany(StrUtil.join((CharSequence)",", productCompanySet));
            }
            rkProjectReportingVO.setGarde(this.baseDataUtil.getDictName(rkProjectReportingVO.getGarde(), "CustomerGrade"));
            rkProjectReportingVO.setSaleStageName(this.baseDataUtil.getDictName(rkProjectReportingVO.getSaleStage(), "ReportingSaleStage"));
            rkProjectReportingVO.setProjectStageName(this.baseDataUtil.getDictName(rkProjectReportingVO.getProjectStage(), "ReportingProjectStage"));
            rkProjectReportingVO.setReportingType(StrUtil.equals((CharSequence)rkProjectReportingVO.getReportingType(), (CharSequence)"1") ? "\u957f\u671f\u62a5\u5907" : "\u51c6\u5ba2\u6237\u62a5\u5907");
            rkProjectReportingVO.setSalesType(StringUtils.isBlank((CharSequence)rkProjectReportingVO.getSalesType()) ? "" : (StrUtil.equals((CharSequence)rkProjectReportingVO.getSalesType(), (CharSequence)"directSales") ? "\u76f4\u9500" : "\u5206\u9500"));
            rkProjectReportingVO.setIsSecondarySales(StringUtils.isBlank((CharSequence)rkProjectReportingVO.getIsSecondarySales()) ? "" : (StrUtil.equals((CharSequence)rkProjectReportingVO.getIsSecondarySales(), (CharSequence)"1") ? "\u662f" : "\u5426"));
            rkProjectReportingVO.setIsNeedInternalApplication(StringUtils.isBlank((CharSequence)rkProjectReportingVO.getIsNeedInternalApplication()) ? "" : (StrUtil.equals((CharSequence)rkProjectReportingVO.getIsNeedInternalApplication(), (CharSequence)"1") ? "\u9700\u8981" : "\u4e0d\u9700\u8981"));
            this.oaProjectReportingApplyService.appendBrokerInfo(rkProjectReportingVO);
            if (StrUtil.isNotBlank((CharSequence)rkProjectReportingVO.getCompetitorId())) {
                CrmCompetitorEntity byId = (CrmCompetitorEntity)this.crmCompetitorService.getById((Serializable)((Object)rkProjectReportingVO.getCompetitorId()));
                rkProjectReportingVO.setCompetitorId(ObjectUtil.isNull((Object)byId) ? "" : byId.getCompetitorName());
            } else {
                rkProjectReportingVO.setCompetitorId("");
            }
            if (oaProjectReportingApplyPaginationExportModel.getSelectKey().contains("productType") && StrUtil.isNotBlank((CharSequence)rkProjectReportingVO.getProductType()) && CollectionUtil.isNotEmpty((Collection)(categoryEntityList = this.crmProductCategoryService.listByIds(list2 = Arrays.asList(rkProjectReportingVO.getProductType().split(",")))))) {
                String join = categoryEntityList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
                rkProjectReportingVO.setProductType(join);
            }
            rkProjectReportingVO.setAddress(oaProjectReportingApplyPaginationExportModel.getSelectKey().contains("address") ? this.baseDataUtil.provinceData(rkProjectReportingVO.getAddress()) : "");
            RkProjectReportingStageTrendsPagination trendsPagination = new RkProjectReportingStageTrendsPagination();
            trendsPagination.setReportingId(rkProjectReportingVO.getId());
            List listByReporting = this.rkProjectReportingStageTrendsService.getListByReporting(trendsPagination);
            rkProjectReportingVO.setReportingList(listByReporting);
            if ("2".equals(rkProjectReportingVO.getOpportunityType())) {
                rkProjectReportingVO.setOpportunityTypeName("\u76f4\u7b7e\u5546\u673a");
                continue;
            }
            if (!"1".equals(rkProjectReportingVO.getOpportunityType())) continue;
            rkProjectReportingVO.setOpportunityTypeName("\u6e20\u9053\u5546\u673a");
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd"));
        HashSet set = CollectionUtil.set((boolean)false, (Object[])new String[0]);
        HashMap keyMap = MapUtil.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)list2)) {
            list2.stream().forEach(m -> {
                List ll;
                Object o = m.get("reportingList");
                if (ObjectUtil.isNotNull(m.get("expectedSigningDate"))) {
                    DateTime expectedSigningDate = cn.hutool.core.date.DateUtil.date((long)Long.valueOf(m.get("expectedSigningDate").toString()));
                    String s = cn.hutool.core.date.DateUtil.formatDate((Date)expectedSigningDate);
                    m.put("expectedSigningDate", s);
                }
                if (ObjectUtil.isNotNull(o) && CollectionUtil.isNotEmpty((Collection)(ll = JsonUtil.getJsonToList(o, RkProjectReportingStageTrendsEntity.class)))) {
                    ll.stream().forEach(trend -> {
                        String key = "follow" + cn.hutool.core.date.DateUtil.formatDate((Date)trend.getFollowTime());
                        m.put(key, StrUtil.isNotBlank((CharSequence)trend.getFollowMethod()) ? this.baseDataUtil.getDictName(trend.getFollowMethod(), "followMethod") + "-" + trend.getDescription() : trend.getDescription());
                        set.add(key);
                        keyMap.put(key, "\u9879\u76ee\u8fdb\u5ea6(" + cn.hutool.core.date.DateUtil.formatDate((Date)trend.getFollowTime()) + ")");
                    });
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)list2)) {
            list2.stream().forEach(m -> {
                for (Object key : keyMap.keySet()) {
                    Set strings = m.keySet();
                    if (strings.contains(key)) continue;
                    m.put(key.toString(), "");
                }
            });
        }
        List collect = set.stream().collect(Collectors.toList());
        Collections.sort(collect, Collections.reverseOrder());
        oaProjectReportingApplyPaginationExportModel.setSelectKey(oaProjectReportingApplyPaginationExportModel.getSelectKey() + "," + CollectionUtil.join(collect, (CharSequence)","));
        String[] keys = StrUtil.isNotBlank((CharSequence)oaProjectReportingApplyPaginationExportModel.getSelectKey()) ? oaProjectReportingApplyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo, keyMap);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo, HashMap keyMap) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            block202: for (String key : keys) {
                if (ObjectUtil.isNotNull((Object)keyMap) && ObjectUtil.isNotNull(keyMap.get(key)) && StrUtil.isNotBlank((CharSequence)keyMap.get(key).toString())) {
                    entitys.add(new ExcelExportEntity(keyMap.get(key).toString(), (Object)key));
                    continue;
                }
                switch (key) {
                    case "reportingType": {
                        entitys.add(new ExcelExportEntity("\u62a5\u5907\u7c7b\u578b", (Object)"reportingType"));
                        continue block202;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237", (Object)"customerName"));
                        continue block202;
                    }
                    case "saleStageName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u9636\u6bb5", (Object)"saleStageName"));
                        continue block202;
                    }
                    case "projectStageName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u9636\u6bb5", (Object)"projectStageName"));
                        continue block202;
                    }
                    case "reportingProject": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a\u540d\u79f0", (Object)"reportingProject"));
                        continue block202;
                    }
                    case "garde": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u7b49\u7ea7", (Object)"garde"));
                        continue block202;
                    }
                    case "address": {
                        entitys.add(new ExcelExportEntity("\u5730\u5740", (Object)"address"));
                        continue block202;
                    }
                    case "addressDetail": {
                        entitys.add(new ExcelExportEntity("\u8be6\u7ec6\u5730\u5740", (Object)"addressDetail"));
                        continue block202;
                    }
                    case "contactName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u8054\u7cfb\u4eba", (Object)"contactName"));
                        continue block202;
                    }
                    case "contactPost": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u804c\u52a1", (Object)"contactPost"));
                        continue block202;
                    }
                    case "contactPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"contactPhone"));
                        continue block202;
                    }
                    case "projectScale": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u89c4\u6a21", (Object)"projectScale"));
                        continue block202;
                    }
                    case "hisManufacturer": {
                        entitys.add(new ExcelExportEntity("HIS\u5382\u5bb6", (Object)"hisManufacturer"));
                        continue block202;
                    }
                    case "projectScore": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u5f97\u5206", (Object)"projectScore"));
                        continue block202;
                    }
                    case "integratorName": {
                        entitys.add(new ExcelExportEntity("\u96c6\u6210\u5546\u540d\u79f0", (Object)"integratorName"));
                        continue block202;
                    }
                    case "integratorProjectManager": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"integratorProjectManager"));
                        continue block202;
                    }
                    case "integratorContactPhone": {
                        entitys.add(new ExcelExportEntity("\u96c6\u6210\u5546\u8054\u7cfb\u65b9\u5f0f", (Object)"integratorContactPhone"));
                        continue block202;
                    }
                    case "customerContactName": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u59d3\u540d", (Object)"customerContactName"));
                        continue block202;
                    }
                    case "customerEepartment": {
                        entitys.add(new ExcelExportEntity("\u79d1\u5ba4", (Object)"customerEepartment"));
                        continue block202;
                    }
                    case "customerPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"customerPhone"));
                        continue block202;
                    }
                    case "productClearness": {
                        entitys.add(new ExcelExportEntity("\u5df2\u660e\u786e\u9700\u6c42", (Object)"productClearness"));
                        continue block202;
                    }
                    case "productType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5206\u7c7b", (Object)"productType"));
                        continue block202;
                    }
                    case "productCompany": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u7ea6\u516c\u53f8", (Object)"productCompany"));
                        continue block202;
                    }
                    case "isSolution": {
                        entitys.add(new ExcelExportEntity("\u5df2\u63d0\u4f9b\u65b9\u6848", (Object)"isSolution"));
                        continue block202;
                    }
                    case "solutionType": {
                        entitys.add(new ExcelExportEntity("\u65b9\u6848\u7c7b\u578b", (Object)"solutionType"));
                        continue block202;
                    }
                    case "isQuotation": {
                        entitys.add(new ExcelExportEntity("\u5df2\u63d0\u4f9b\u6b63\u5f0f\u62a5\u4ef7\u5355", (Object)"isQuotation"));
                        continue block202;
                    }
                    case "productScore": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u9700\u6c42\u5f97\u5206", (Object)"productScore"));
                        continue block202;
                    }
                    case "competitiveName": {
                        entitys.add(new ExcelExportEntity("\u7ade\u54c1", (Object)"competitiveName"));
                        continue block202;
                    }
                    case "internalLines": {
                        entitys.add(new ExcelExportEntity("\u5185\u7ebf\u8bbe\u7acb", (Object)"internalLines"));
                        continue block202;
                    }
                    case "competitiveScore": {
                        entitys.add(new ExcelExportEntity("\u7ade\u53bf/\u5185\u7ebf\u5f97\u5206", (Object)"competitiveScore"));
                        continue block202;
                    }
                    case "isDemonstration": {
                        entitys.add(new ExcelExportEntity("\u8fdb\u884c\u4ea7\u54c1\u6f14\u793a", (Object)"isDemonstration"));
                        continue block202;
                    }
                    case "demonstrationDesc": {
                        entitys.add(new ExcelExportEntity("\u6f14\u793a\u8bf4\u660e", (Object)"demonstrationDesc"));
                        continue block202;
                    }
                    case "isVisitingExamples": {
                        entitys.add(new ExcelExportEntity("\u5df2\u53c2\u89c2\u793a\u4f8b", (Object)"isVisitingExamples"));
                        continue block202;
                    }
                    case "visitingDesc": {
                        entitys.add(new ExcelExportEntity("\u53c2\u89c2\u8bf4\u660e", (Object)"visitingDesc"));
                        continue block202;
                    }
                    case "isDemonstrate": {
                        entitys.add(new ExcelExportEntity("\u9662\u5185\u8bba\u8bc1\u4f1a", (Object)"isDemonstrate"));
                        continue block202;
                    }
                    case "demonstrateDesc": {
                        entitys.add(new ExcelExportEntity("\u8bba\u8bc1\u8bf4\u660e", (Object)"demonstrateDesc"));
                        continue block202;
                    }
                    case "demonstrateScore": {
                        entitys.add(new ExcelExportEntity("\u8bba\u8bc1\u5f97\u5206", (Object)"demonstrateScore"));
                        continue block202;
                    }
                    case "isBiddingTime": {
                        entitys.add(new ExcelExportEntity("\u660e\u786e\u62db\u6807\u65f6\u95f4", (Object)"isBiddingTime"));
                        continue block202;
                    }
                    case "biddingDesc": {
                        entitys.add(new ExcelExportEntity("\u62db\u6295\u6807\u8bf4\u660e", (Object)"biddingDesc"));
                        continue block202;
                    }
                    case "isProjectApproval": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u7acb\u9879\u901a\u8fc7", (Object)"isProjectApproval"));
                        continue block202;
                    }
                    case "projectApprovalDesc": {
                        entitys.add(new ExcelExportEntity("\u7acb\u9879\u8bf4\u660e", (Object)"projectApprovalDesc"));
                        continue block202;
                    }
                    case "isClearBudget": {
                        entitys.add(new ExcelExportEntity("\u660e\u786e\u9884\u7b97", (Object)"isClearBudget"));
                        continue block202;
                    }
                    case "budgetDesc": {
                        entitys.add(new ExcelExportEntity("\u660e\u786e\u9884\u7b97\u8bf4\u660e", (Object)"budgetDesc"));
                        continue block202;
                    }
                    case "projectApprovalScore": {
                        entitys.add(new ExcelExportEntity("\u7acb\u9879\u5f97\u5206", (Object)"projectApprovalScore"));
                        continue block202;
                    }
                    case "isBrandRecommendation": {
                        entitys.add(new ExcelExportEntity("\u54c1\u724c\u63a8\u8350", (Object)"isBrandRecommendation"));
                        continue block202;
                    }
                    case "brandRecommendationDesc": {
                        entitys.add(new ExcelExportEntity("\u63a8\u8350\u8bf4\u660e", (Object)"brandRecommendationDesc"));
                        continue block202;
                    }
                    case "isTenderRequirements": {
                        entitys.add(new ExcelExportEntity("\u62db\u6807\u8981\u6c42\u64b0\u5199", (Object)"isTenderRequirements"));
                        continue block202;
                    }
                    case "tenderRequirementsDesc": {
                        entitys.add(new ExcelExportEntity("\u6280\u672f\u8981\u6c42\u64b0\u5199\u8bf4\u660e", (Object)"tenderRequirementsDesc"));
                        continue block202;
                    }
                    case "isScoringMethod": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u5206\u529e\u6cd5\u64b0\u5199 ", (Object)"isScoringMethod"));
                        continue block202;
                    }
                    case "scoringMethodDesc": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u5206\u529e\u6cd5\u64b0\u5199\u8bf4\u660e", (Object)"scoringMethodDesc"));
                        continue block202;
                    }
                    case "biddingScore": {
                        entitys.add(new ExcelExportEntity("\u62db\u6807\u8bbe\u8ba1\u5f97\u5206", (Object)"biddingScore"));
                        continue block202;
                    }
                    case "cooperativeCompaniesName": {
                        entitys.add(new ExcelExportEntity("\u5408\u4f5c\u516c\u53f8", (Object)"cooperativeCompaniesName"));
                        continue block202;
                    }
                    case "companyProjectManager": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"companyProjectManager"));
                        continue block202;
                    }
                    case "companyContactPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"companyContactPhone"));
                        continue block202;
                    }
                    case "cooperativeCompaniesScore": {
                        entitys.add(new ExcelExportEntity("\u5408\u4f5c\u516c\u53f8\u5f97\u5206", (Object)"cooperativeCompaniesScore"));
                        continue block202;
                    }
                    case "competentDepartmentManager": {
                        entitys.add(new ExcelExportEntity("\u4e3b\u7ba1\u90e8\u95e8\u8d1f\u8d23\u4eba", (Object)"competentDepartmentManager"));
                        continue block202;
                    }
                    case "competentDepartmentPost": {
                        entitys.add(new ExcelExportEntity("\u804c\u4f4d", (Object)"competentDepartmentPost"));
                        continue block202;
                    }
                    case "competentDepartmentPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"competentDepartmentPhone"));
                        continue block202;
                    }
                    case "competentDepartmentScore": {
                        entitys.add(new ExcelExportEntity("\u4e3b\u7ba1\u90e8\u95e8\u5f97\u5206", (Object)"competentDepartmentScore"));
                        continue block202;
                    }
                    case "useDepartmentManager": {
                        entitys.add(new ExcelExportEntity("\u4f7f\u7528\u90e8\u95e8\u8d1f\u8d23\u4eba", (Object)"useDepartmentManager"));
                        continue block202;
                    }
                    case "useDepartmentPost": {
                        entitys.add(new ExcelExportEntity("\u804c\u4f4d", (Object)"useDepartmentPost"));
                        continue block202;
                    }
                    case "useDepartmentPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"useDepartmentPhone"));
                        continue block202;
                    }
                    case "useDepartmentScore": {
                        entitys.add(new ExcelExportEntity("\u4f7f\u7528\u90e8\u95e8\u5f97\u5206", (Object)"useDepartmentScore"));
                        continue block202;
                    }
                    case "instituteLeader": {
                        entitys.add(new ExcelExportEntity("\u9662\u9886\u5bfc", (Object)"instituteLeader"));
                        continue block202;
                    }
                    case "instituteLeaderPost": {
                        entitys.add(new ExcelExportEntity("\u804c\u4f4d", (Object)"instituteLeaderPost"));
                        continue block202;
                    }
                    case "instituteLeaderPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"instituteLeaderPhone"));
                        continue block202;
                    }
                    case "instituteLeaderScore": {
                        entitys.add(new ExcelExportEntity("\u9662\u9886\u5bfc\u5f97\u5206", (Object)"instituteLeaderScore"));
                        continue block202;
                    }
                    case "isProductPromotion": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u5ba2\u6237\u4ea7\u54c1\u5ba3\u8bb2", (Object)"isProductPromotion"));
                        continue block202;
                    }
                    case "productPromotionDesc": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5ba3\u8bb2\u8bf4\u660e", (Object)"productPromotionDesc"));
                        continue block202;
                    }
                    case "productPromotionScore": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5ba3\u8bb2\u5f97\u5206", (Object)"productPromotionScore"));
                        continue block202;
                    }
                    case "isTargetedSolutions": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u63d0\u4f9b\u9488\u5bf9\u6027\u65b9\u6848 ", (Object)"isTargetedSolutions"));
                        continue block202;
                    }
                    case "targetedSolutionsDesc": {
                        entitys.add(new ExcelExportEntity("\u65b9\u6848\u8bf4\u660e", (Object)"targetedSolutionsDesc"));
                        continue block202;
                    }
                    case "targetedSolutionsScore": {
                        entitys.add(new ExcelExportEntity("\u65b9\u6848\u5f97\u5206", (Object)"targetedSolutionsScore"));
                        continue block202;
                    }
                    case "isLongQuotation": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u62a5\u4ef7", (Object)"isLongQuotation"));
                        continue block202;
                    }
                    case "quotationDesc": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4ef7\u8bf4\u660e", (Object)"quotationDesc"));
                        continue block202;
                    }
                    case "quotationScore": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4ef7\u5f97\u5206", (Object)"quotationScore"));
                        continue block202;
                    }
                    case "totalScore": {
                        entitys.add(new ExcelExportEntity("\u603b\u5206", (Object)"totalScore"));
                        continue block202;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block202;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u62a5\u5907\u4eba", (Object)"creatorUserId"));
                        continue block202;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u62a5\u5907\u65f6\u95f4", (Object)"creatorTime"));
                        continue block202;
                    }
                    case "expectedSigningDate": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u7b7e\u5355\u65e5\u671f", (Object)"expectedSigningDate"));
                        continue block202;
                    }
                    case "estimatedSigningAmount": {
                        ExcelExportEntity estimatedSigningAmount = new ExcelExportEntity("\u9884\u8ba1\u9500\u552e\u91d1\u989d(\u5143)", (Object)"estimatedSigningAmount");
                        estimatedSigningAmount.setType(10);
                        entitys.add(estimatedSigningAmount);
                        continue block202;
                    }
                    case "estimatedGrossProfit": {
                        ExcelExportEntity estimatedSigningAmount = new ExcelExportEntity("\u672a\u7a0e\u9884\u4f30\u6bdb\u5229\u6da6(\u5143)", (Object)"estimatedGrossProfit");
                        estimatedSigningAmount.setType(10);
                        entitys.add(estimatedSigningAmount);
                        continue block202;
                    }
                    case "expectedBidOpenMonth": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u5f00\u6807\u6708\u4efd", (Object)"expectedBidOpenMonth"));
                        continue block202;
                    }
                    case "salesType": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u65b9\u5f0f", (Object)"salesType"));
                        continue block202;
                    }
                    case "opportunityTypeName": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a\u7c7b\u578b", (Object)"opportunityTypeName"));
                        continue block202;
                    }
                    case "brokerId": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546", (Object)"brokerName"));
                        continue block202;
                    }
                    case "brokerContactName": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546\u8054\u7cfb\u4eba", (Object)"brokerContactName"));
                        continue block202;
                    }
                    case "brokerPhone": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546\u8054\u7cfb\u65b9\u5f0f", (Object)"brokerPhone"));
                        continue block202;
                    }
                    case "competitorId": {
                        entitys.add(new ExcelExportEntity("\u7ade\u4e89\u5bf9\u624b", (Object)"competitorId"));
                        continue block202;
                    }
                    case "winRate": {
                        entitys.add(new ExcelExportEntity("\u8d62\u5355\u7387", (Object)"winRate"));
                        continue block202;
                    }
                    case "hospitalBudget": {
                        ExcelExportEntity estimatedSigningAmount = new ExcelExportEntity("\u533b\u9662\u9884\u7b97(\u5143)", (Object)"hospitalBudget");
                        estimatedSigningAmount.setType(10);
                        entitys.add(estimatedSigningAmount);
                        continue block202;
                    }
                    case "isSecondarySales": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4e8c\u6b21\u9500\u552e", (Object)"isSecondarySales"));
                        continue block202;
                    }
                    case "isNeedInternalApplication": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u9700\u8981\u6295\u6807\u7533\u8bf7", (Object)"isNeedInternalApplication"));
                        continue block202;
                    }
                    case "bidDescription": {
                        entitys.add(new ExcelExportEntity("\u65e0\u9700\u6295\u6807\u60c5\u51b5\u8bf4\u660e", (Object)"bidDescription"));
                        continue block202;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u62a5\u5907\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaProjectReportingApplyInfoVO> info(@PathVariable(value="id") String id) {
        QueryWrapper queryWrapper;
        List<String> idList;
        RkAgentEntity agentEntity;
        CrmCustomerOpportunityEntity byId;
        List list;
        List ll;
        OaProjectReportingApplyEntity entity = this.oaProjectReportingApplyService.getInfo(id);
        OaProjectReportingApplyInfoVO vo = (OaProjectReportingApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaProjectReportingApplyInfoVO.class);
        vo.setCreatorUser(vo.getCreatorUserId());
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        if (StringUtils.isNotEmpty((String)vo.getProductType()) && CollectionUtil.isNotEmpty((Collection)(ll = this.crmProductCategoryService.listByIds((Collection)(list = CollectionUtil.list((boolean)false, Arrays.asList(vo.getProductType().split(",")))))))) {
            String collect = ll.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
            vo.setProductTypeName(collect);
        }
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
        if (StringUtils.isNotEmpty((String)vo.getOppId()) && !StringUtils.isNull((Object)(byId = (CrmCustomerOpportunityEntity)this.crmCustomerOpportunityService.getById((Serializable)((Object)vo.getOppId()))))) {
            vo.setOppDesc(byId.getDescription());
        }
        vo.setAttachmentList(oaAttachmentEntityList);
        if (StringUtils.isNotEmpty((String)vo.getChannelId()) && ObjectUtil.isNotEmpty((Object)(agentEntity = this.rkAgentService.getInfo(vo.getChannelId())))) {
            vo.setChannelName(agentEntity.getName());
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getAssociationProduct())) {
            if (vo.getAssociationProduct().contains(",")) {
                StringBuffer stringBuffer = new StringBuffer();
                List<String> asList = Arrays.asList(vo.getAssociationProduct().split(","));
                for (String s : asList) {
                    CrmProductEntity productEntity;
                    CrmProductPriceEntity priceEntity = this.crmProductPriceService.getInfo(s);
                    if (!ObjectUtil.isNotEmpty((Object)priceEntity) || !ObjectUtil.isNotEmpty((Object)(productEntity = this.crmProductService.getInfo(priceEntity.getProductId())))) continue;
                    stringBuffer.append(productEntity.getProductName() + ",");
                }
                String productStr = stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(",")).toString();
                vo.setAssociationProductName(productStr);
            } else {
                CrmProductEntity productEntity;
                CrmProductPriceEntity priceEntity = this.crmProductPriceService.getInfo(vo.getAssociationProduct());
                if (ObjectUtil.isNotEmpty((Object)priceEntity) && ObjectUtil.isNotEmpty((Object)(productEntity = this.crmProductService.getInfo(priceEntity.getProductId())))) {
                    vo.setAssociationProductName(productEntity.getProductName());
                }
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getCompetitorId())) {
            idList = Arrays.asList(vo.getCompetitorId().split(","));
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmCompetitorEntity::getId, idList);
            List competitorList = this.crmCompetitorService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)competitorList)) {
                String competitorName = competitorList.stream().map(CrmCompetitorEntity::getCompetitorName).collect(Collectors.joining(","));
                vo.setCompetitorName(competitorName);
            }
        }
        if (StringUtils.isNotEmpty((String)vo.getBrokerId()) && null != (agentEntity = this.rkAgentService.getInfo(vo.getBrokerId()))) {
            vo.setBrokerName(agentEntity.getName());
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getClueId()) && ObjectUtil.isNotEmpty((Object)(byId = (CrmClueInfoEntity)this.crmClueInfoService.getById((Serializable)((Object)vo.getClueId()))))) {
            vo.setClueName(byId.getName());
        }
        vo.setHasOtherCategory(false);
        if (StringUtils.isNotEmpty((String)vo.getOtherProduct())) {
            vo.setHasOtherCategory(true);
        } else if (StringUtils.isNotEmpty((String)vo.getProductType())) {
            idList = Arrays.asList(vo.getProductType().split(","));
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmProductCategoryEntity::getId, idList);
            queryWrapper.lambda().eq(CrmProductCategoryEntity::getName, (Object)"\u5176\u4ed6");
            if (null != this.crmProductCategoryService.getOne((Wrapper)queryWrapper)) {
                vo.setHasOtherCategory(true);
            }
        }
        CrmCustomerEntity customer = this.crmCustomerService.getInfo(vo.getCustomerId());
        if (ObjectUtil.isNotEmpty((Object)customer)) {
            vo.setCustomerType(customer.getClassificationCode());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaProjectReportingApplyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkAgentEntity agentEntity;
        CrmCustomerOpportunityEntity byId;
        List list;
        List ll;
        OaProjectReportingApplyEntity entity = this.oaProjectReportingApplyService.getInfo(id);
        OaProjectReportingApplyInfoVO vo = (OaProjectReportingApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaProjectReportingApplyInfoVO.class);
        vo.setGarde(this.baseDataUtil.getDictName(vo.getGarde(), "CustomerGrade"));
        if (StringUtils.isNotEmpty((String)vo.getProductType()) && CollectionUtil.isNotEmpty((Collection)(ll = this.crmProductCategoryService.listByIds((Collection)(list = CollectionUtil.list((boolean)false, Arrays.asList(vo.getProductType().split(",")))))))) {
            String collect = ll.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
            vo.setProductType(collect);
        }
        if (StringUtils.isNotEmpty((String)vo.getOppId()) && !StringUtils.isNull((Object)(byId = (CrmCustomerOpportunityEntity)this.crmCustomerOpportunityService.getById((Serializable)((Object)vo.getOppId()))))) {
            vo.setOppDesc(byId.getDescription());
        }
        vo.setAddress(this.baseDataUtil.provinceData(vo.getAddress()));
        vo.setEnabledMark(this.baseDataUtil.getDictName(vo.getEnabledMark(), "projectReportingEnabledMark"));
        vo.setCreatorUser(vo.getCreatorUserId());
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
        vo.setAttachmentList(oaAttachmentEntityList);
        if (StrUtil.isNotEmpty((CharSequence)vo.getCompetitorId())) {
            List<String> idList = Arrays.asList(vo.getCompetitorId().split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmCompetitorEntity::getId, idList);
            List competitorList = this.crmCompetitorService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)competitorList)) {
                String competitorName = competitorList.stream().map(CrmCompetitorEntity::getCompetitorName).collect(Collectors.joining(","));
                vo.setCompetitorName(competitorName);
            }
        }
        if (StringUtils.isNotEmpty((String)vo.getBrokerId()) && null != (agentEntity = this.rkAgentService.getInfo(vo.getBrokerId()))) {
            vo.setBrokerName(agentEntity.getName());
        }
        vo.setBidOpenDateStatusName(this.baseDataUtil.getDictName(vo.getBidOpenDateStatus(), "bidOpenDateStatus"));
        vo.setSalesType(this.baseDataUtil.getDictName(vo.getSalesType(), "salesType"));
        vo.setHasOtherCategory(false);
        if (StringUtils.isNotEmpty((String)vo.getOtherProduct())) {
            vo.setHasOtherCategory(true);
        }
        vo.setReportingSaleTypeName(this.baseDataUtil.getDictName(vo.getReportingSaleType(), "reportingSalesType"));
        CrmCustomerEntity customer = this.crmCustomerService.getInfo(vo.getCustomerId());
        if (ObjectUtil.isNotEmpty((Object)customer)) {
            vo.setCustomerType(customer.getClassificationCode());
        }
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/countMy"})
    public ActionResult countMy(@RequestBody OaProjectReportingApplyPagination oaProjectReportingApplyPagination) {
        long l = this.oaProjectReportingApplyService.countMy(oaProjectReportingApplyPagination);
        HashMap map = MapUtil.newHashMap();
        map.put("myApply", l);
        return ActionResult.success((Object)map);
    }

    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaProjectReportingApplyUpForm rkProjectReportingUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "503829668818848773";
        if (StrUtil.isNotBlank((CharSequence)rkProjectReportingUpForm.getFlowId())) {
            flowEngineId = rkProjectReportingUpForm.getFlowId();
        }
        UserInfo userInfo = this.userProvider.get();
        OaProjectReportingApplyEntity entity = this.oaProjectReportingApplyService.getInfo(id);
        if (entity != null) {
            rkProjectReportingUpForm.setId(id);
            if (FlowTaskStatusEnum.Handle.getCode().equals(rkProjectReportingUpForm.getStatus())) {
                rkProjectReportingUpForm.setEnabledMark(ProjectReportingEnum.RECONSIDER_NODE.getType());
            }
            if (StrUtil.isNotEmpty((CharSequence)rkProjectReportingUpForm.getProductId())) {
                List productList = this.crmProductService.getInfoByListId(rkProjectReportingUpForm.getProductId());
                rkProjectReportingUpForm.setProductName(productList.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
            }
            this.oaProjectReportingApplyService.updateProjectReporting(rkProjectReportingUpForm);
            OaProjectReportingApplyEntity subentity = this.oaProjectReportingApplyService.getInfo(id);
            subentity.setEnabledMark(entity.getEnabledMark());
            rkProjectReportingUpForm.setIsBelowFloorPrice(rkProjectReportingUpForm.getIsBelowFloorPrice());
            CrmCustomerEntity customer = this.crmCustomerService.getInfo(rkProjectReportingUpForm.getCustomerId());
            if (ObjectUtil.isNotEmpty((Object)customer)) {
                rkProjectReportingUpForm.setCustomerType(customer.getClassificationCode());
            }
            FlowUtil.saveOrSubmit((String)rkProjectReportingUpForm.getTaskId(), (String)flowEngineId, (String)rkProjectReportingUpForm.getTemplateId(), (String)id, (Object)((Object)rkProjectReportingUpForm), (Integer)rkProjectReportingUpForm.getStatus(), (String)rkProjectReportingUpForm.getReportingProject());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaProjectReportingApplyEntity entity = this.oaProjectReportingApplyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaProjectReportingApplyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/projectReportingLog"})
    public ActionResult<RkMrketLogRelevanceListInfo> projectReportingLog(@RequestBody @Valid VisitFollowUpForm visitFollowUpForm) {
        RkMrketLogRelevanceListInfo info = new RkMrketLogRelevanceListInfo();
        List<OaProjectReportingApplyEntity> addUserIdDate = this.oaProjectReportingApplyService.getAddUserIdDate(visitFollowUpForm);
        ArrayList<RkMrketLogRelevanceListVO> visitList = new ArrayList<RkMrketLogRelevanceListVO>();
        if (CollectionUtil.isNotEmpty(addUserIdDate)) {
            for (OaProjectReportingApplyEntity byId : addUserIdDate) {
                RkMrketLogRelevanceListVO build = RkMrketLogRelevanceListVO.builder().mainTypeName(this.baseDataUtil.getDictName("business", "dailyType")).mainType("business").nextType("addBusiness").nextTypeName(this.baseDataUtil.getDictName("addBusiness", "dailyType")).customerId(byId.getCustomerId()).customerName(byId.getCustomerName()).business(byId.getReportingProject()).creatorTime(byId.getCreatorTime()).build();
                visitList.add(build);
            }
        }
        if (CollectionUtil.isNotEmpty(visitList)) {
            info.setAddBusinessCount(Long.valueOf(visitList.stream().filter(s -> s.getNextType().equals("addBusiness")).count()));
        }
        info.setTrendsList(visitList);
        return ActionResult.success((Object)info);
    }

    @PostMapping(value={"/isRepeat"})
    public ActionResult isRepeat(@RequestBody OaProjectReportingApplyUpForm updateForm) {
        UserInfo userInfo = this.userProvider.get();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isRepeat", "0");
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)updateForm.getCustomerId())) {
            queryWrapper.lambda().eq(OaProjectReportingApplyEntity::getCustomerId, (Object)updateForm.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)updateForm.getProductType())) {
            queryWrapper.lambda().eq(OaProjectReportingApplyEntity::getProductType, (Object)updateForm.getProductType());
        }
        if (StringUtils.isNotEmpty((String)updateForm.getId())) {
            queryWrapper.lambda().ne(OaProjectReportingApplyEntity::getId, (Object)updateForm.getId());
        }
        queryWrapper.lambda().eq(OaProjectReportingApplyEntity::getCompanyId, (Object)userInfo.getOrganizeId());
        if (this.oaProjectReportingApplyService.count((Wrapper)queryWrapper) > 0L) {
            map.put("isRepeat", "1");
            return ActionResult.success(map);
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)updateForm.getCustomerId())) {
            wrapper.lambda().eq(RkProjectReportingEntity::getCustomerId, (Object)updateForm.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)updateForm.getProductType())) {
            wrapper.lambda().eq(RkProjectReportingEntity::getProductType, (Object)updateForm.getProductType());
        }
        if (StringUtils.isNotEmpty((String)updateForm.getId())) {
            wrapper.lambda().ne(RkProjectReportingEntity::getId, (Object)updateForm.getId());
        }
        wrapper.lambda().ne(RkProjectReportingEntity::getWinOrLose, (Object)0);
        wrapper.lambda().eq(RkProjectReportingEntity::getCompanyId, (Object)userInfo.getOrganizeId());
        if (this.rkProjectReportingService.count((Wrapper)wrapper) > 0L) {
            map.put("isRepeat", "1");
            return ActionResult.success(map);
        }
        return ActionResult.success(map);
    }
}

