/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.OaProjectPlanApplyEntity;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectStopRecordEntity;
import com.bringspring.contract.entity.RkPurchaseApplyEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.model.rkprojectstartproduct.RkProjectStartProductRelationModel;
import com.bringspring.contract.service.OaProjectPlanApplyService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectStopRecordService;
import com.bringspring.contract.service.RkPurchaseApplyService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionListVO;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmProductVersionService;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectAcceptApplyEntity;
import com.bringspring.oa.entity.OaProjectAuthorizationEntity;
import com.bringspring.oa.entity.OaProjectChangeHeaderApplyEntity;
import com.bringspring.oa.entity.OaProjectPlanChangeApplyEntity;
import com.bringspring.oa.entity.OaProjectQuestionApplyEntity;
import com.bringspring.oa.entity.OaProjectStartApplyEntity;
import com.bringspring.oa.entity.OaProjectStartProductRelationEntity;
import com.bringspring.oa.entity.OaProjectStartThirdEntity;
import com.bringspring.oa.entity.OaProjectTransferAftersaleApplyEntity;
import com.bringspring.oa.model.oaprojectstartthird.OaProjectStartThirdModel;
import com.bringspring.oa.model.projectstart.OaProjectStartCrForm;
import com.bringspring.oa.model.projectstart.OaProjectStartInfoVO;
import com.bringspring.oa.model.projectstart.OaProjectStartUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectAcceptApplyService;
import com.bringspring.oa.service.OaProjectAcceptanceConfirmedReceiptService;
import com.bringspring.oa.service.OaProjectAuthorizationService;
import com.bringspring.oa.service.OaProjectChangeHeaderApplyService;
import com.bringspring.oa.service.OaProjectPlanChangeApplyService;
import com.bringspring.oa.service.OaProjectQuestionApplyService;
import com.bringspring.oa.service.OaProjectStartApplyService;
import com.bringspring.oa.service.OaProjectStartProductRelationService;
import com.bringspring.oa.service.OaProjectStartThirdService;
import com.bringspring.oa.service.OaProjectTransferAftersaleApplyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u5f00\u5de5\u7533\u8bf7"}, value="contract")
@RequestMapping(value={"/api/oa/contract/RkProjectStart"})
public class OaProjectStartApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaProjectStartApplyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaProjectStartApplyService oaProjectStartApplyService;
    @Autowired
    private OaProjectPlanApplyService oaProjectApplyService;
    @Autowired
    private OaProjectStartProductRelationService oaProjectStartProductRelationService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CrmProductVersionService crmProductVersionService;
    @Autowired
    private OaProjectAcceptApplyService oaProjectAcceptApplyService;
    @Autowired
    private OaProjectTransferAftersaleApplyService oaProjectTransferAftersaleApplyService;
    @Autowired
    private OaProjectChangeHeaderApplyService oaProjectChangeHeaderApplyService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private OaProjectQuestionApplyService oaProjectQuestionApplyService;
    @Autowired
    private OaProjectAuthorizationService oaProjectAuthorizationService;
    @Autowired
    private OaProjectPlanChangeApplyService oaProjectPlanChangeApplyService;
    @Autowired
    private RkProjectStopRecordService rkProjectStopRecordService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private OaProjectStartThirdService oaProjectStartThirdService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private RkPurchaseApplyService rkPurchaseApplyService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private OaProjectAcceptanceConfirmedReceiptService oaProjectAcceptanceConfirmedReceiptService;

    @RepeatSubmit
    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OaProjectStartCrForm rkProjectStartCrForm) throws DataException, WorkFlowException {
        UserInfo userInfo = this.userProvider.get();
        if (StrUtil.isBlank((CharSequence)rkProjectStartCrForm.getProjectId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5f00\u5de5\u7684\u9879\u76ee");
        }
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkProjectStartCrForm.getProjectId()));
        if (ObjectUtil.isNull((Object)byId)) {
            return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        if (byId.getIsAcceptance() == 1) {
            return ActionResult.fail((String)"\u9879\u76ee\u5df2\u9a8c\u6536\uff0c\u4e0d\u80fd\u518d\u7533\u8bf7\u5f00\u5de5");
        }
        if (!ObjectUtil.isNull((Object)byId.getState()) && !StrUtil.equals((CharSequence)byId.getState(), (CharSequence)ProjectStateEnum.notStartApply_state.getState())) {
            return ActionResult.fail((String)"\u9879\u76ee\u5df2\u7533\u8bf7\u8fc7\u5f00\u5de5,\u4e0d\u80fd\u518d\u6b21\u7533\u8bf7");
        }
        String flowEngineId = "509621384276619909";
        if (StrUtil.isNotBlank((CharSequence)rkProjectStartCrForm.getFlowId())) {
            flowEngineId = rkProjectStartCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        rkProjectStartCrForm.setMainId(mainId);
        RkContractEntity rkContractEntity = this.rkContractService.getInfo(byId.getContractId());
        if (rkContractEntity != null) {
            rkProjectStartCrForm.setContractLevel(rkContractEntity.getContractLevel());
        }
        rkProjectStartCrForm.setCreatorCompanyId(userInfo.getOrganizeId());
        if (StrUtil.isNotEmpty((CharSequence)byId.getSalerCompanyId())) {
            rkProjectStartCrForm.setSalerCompanyId(byId.getSalerCompanyId());
        }
        this.oaProjectStartApplyService.startApply(rkProjectStartCrForm);
        FlowUtil.saveOrSubmit((String)rkProjectStartCrForm.getTaskId(), (String)flowEngineId, (String)rkProjectStartCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkProjectStartCrForm), (Integer)rkProjectStartCrForm.getStatus(), (String)byId.getProjectName());
        if (rkProjectStartCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaProjectStartInfoVO> info(@PathVariable(value="id") String id) {
        OaProjectStartApplyEntity entity = this.oaProjectStartApplyService.getInfo(id);
        OaProjectStartInfoVO vo = (OaProjectStartInfoVO)JsonUtil.getJsonToBean((Object)entity, OaProjectStartInfoVO.class);
        if (!StrUtil.isBlank((CharSequence)vo.getCustomerId())) {
            vo.setCustomerName(this.crmCustomerService.getInfo(vo.getCustomerId()).getName());
        }
        if (StringUtils.isNotEmpty((String)vo.getProjectId())) {
            vo.setProjectName(this.rkContractProjectService.getInfo(vo.getProjectId()).getProjectName());
        }
        if (StringUtils.isNotEmpty((String)vo.getContractId())) {
            SaleNoContractEntity contract;
            if (vo.getContractId().equals(vo.getNoContractId())) {
                contract = this.saleNoContractService.getInfo(vo.getNoContractId());
                if (null != contract) {
                    vo.setContractName(contract.getContractName());
                    vo.setIsAgent(0);
                    vo.setAgentId(contract.getCustomerId());
                    vo.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(contract.getId()));
                    vo.setContractCode(contract.getContractCode());
                    vo.setContractAmount(contract.getExpectedContractAmount());
                    vo.setSalerId(contract.getCreatorUserId());
                    vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
                }
            } else {
                contract = this.rkContractService.getInfo(vo.getContractId());
                if (null != contract) {
                    vo.setContractName(contract.getContractName());
                    vo.setIsAgent(contract.getIsAgent());
                    if (ObjectUtil.equals((Object)contract.getIsAgent(), (Object)1)) {
                        RkAgentEntity agent;
                        vo.setAgentId(contract.getAgentId());
                        if (StringUtils.isNotEmpty((String)contract.getAgentId()) && null != (agent = this.agentService.getInfo(contract.getAgentId()))) {
                            vo.setAgentName(agent.getName());
                        }
                    } else {
                        vo.setAgentId(contract.getCustomerIds());
                        vo.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(contract.getId()));
                    }
                    vo.setContractCode(contract.getContractCode());
                    vo.setContractAmount(contract.getContractAmount());
                    vo.setSalerId(contract.getSalerId());
                    vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
                }
            }
        }
        List<OaProjectStartProductRelationEntity> Rk_project_start_product_relationList = this.oaProjectStartApplyService.getRkProjectStartProductRelationList(id);
        for (OaProjectStartProductRelationEntity rk_project_start_product_relationEntity : Rk_project_start_product_relationList) {
            List listByProductId = this.crmProductVersionService.getListByProductId(rk_project_start_product_relationEntity.getProductId());
            List versionListVOS = JsonUtil.getJsonToList((Object)listByProductId, CrmProductVersionListVO.class);
            rk_project_start_product_relationEntity.setVersionList(versionListVOS);
        }
        vo.setRkProjectStartProductRelationModels(JsonUtil.getJsonToList(Rk_project_start_product_relationList, RkProjectStartProductRelationModel.class));
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
        vo.setAttachmentList(oaAttachmentEntityList);
        List<OaProjectStartThirdEntity> thirdEntityList = this.oaProjectStartThirdService.queryListByProjectStartId(id);
        vo.setThirdList(JsonUtil.getJsonToList(thirdEntityList, OaProjectStartThirdModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaProjectStartUpForm rkProjectStartUpForm) throws DataException, WorkFlowException {
        OaProjectStartApplyEntity entity;
        UserInfo userInfo = this.userProvider.get();
        if (StrUtil.isBlank((CharSequence)rkProjectStartUpForm.getProjectId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5f00\u5de5\u7684\u9879\u76ee");
        }
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkProjectStartUpForm.getProjectId()));
        if (ObjectUtil.isNull((Object)byId)) {
            return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        if (byId.getIsAcceptance() == 1) {
            return ActionResult.fail((String)"\u9879\u76ee\u5df2\u9a8c\u6536\uff0c\u4e0d\u80fd\u518d\u7533\u8bf7\u5f00\u5de5");
        }
        if (!ObjectUtil.isNull((Object)byId.getState()) && !StrUtil.equals((CharSequence)byId.getState(), (CharSequence)ProjectStateEnum.notStartApply_state.getState())) {
            return ActionResult.fail((String)"\u9879\u76ee\u5df2\u7533\u8bf7\u8fc7\u5f00\u5de5,\u4e0d\u80fd\u518d\u6b21\u7533\u8bf7");
        }
        String state = "";
        state = FlowTaskStatusEnum.Handle.getCode().equals(rkProjectStartUpForm.getStatus()) ? ProjectStateEnum.startAudit_state.getState() : ProjectStateEnum.notStartApply_state.getState();
        byId.setState(state);
        if (FlowTaskStatusEnum.Handle.getCode() == rkProjectStartUpForm.getStatus()) {
            byId.setStartApplyDate(new Date());
        }
        this.rkContractProjectService.updateById((Object)byId);
        String flowEngineId = "509621384276619909";
        if (StrUtil.isNotBlank((CharSequence)rkProjectStartUpForm.getFlowId())) {
            flowEngineId = rkProjectStartUpForm.getFlowId();
        }
        if ((entity = this.oaProjectStartApplyService.getInfo(id)) != null) {
            RkContractEntity rkContractEntity;
            rkProjectStartUpForm.setCreatorCompanyId(userInfo.getOrganizeId());
            if (StrUtil.isNotEmpty((CharSequence)byId.getSalerCompanyId())) {
                rkProjectStartUpForm.setSalerCompanyId(byId.getSalerCompanyId());
            }
            if ((rkContractEntity = this.rkContractService.getInfo(byId.getContractId())) != null) {
                rkProjectStartUpForm.setContractLevel(rkContractEntity.getContractLevel());
            }
            OaProjectStartApplyEntity subentity = (OaProjectStartApplyEntity)JsonUtil.getJsonToBean((Object)((Object)rkProjectStartUpForm), OaProjectStartApplyEntity.class);
            this.oaProjectStartApplyService.update(id, subentity);
            QueryWrapper Rk_project_start_product_relationqueryWrapper = new QueryWrapper();
            Rk_project_start_product_relationqueryWrapper.lambda().eq(OaProjectStartProductRelationEntity::getProjectStartId, (Object)entity.getId());
            this.oaProjectStartProductRelationService.remove((Wrapper)Rk_project_start_product_relationqueryWrapper);
            List Rk_project_start_product_relationList = JsonUtil.getJsonToList(rkProjectStartUpForm.getRkProjectStartProductRelationModels(), OaProjectStartProductRelationEntity.class);
            for (Object entitys : Rk_project_start_product_relationList) {
                ((OaProjectStartProductRelationEntity)entitys).setId(RandomUtil.uuId());
                ((OaProjectStartProductRelationEntity)entitys).setProjectStartId(entity.getId());
                this.oaProjectStartProductRelationService.save(entitys);
            }
            this.oaAttachmentService.deleteByObjId(entity.getId());
            List oaAttachmentEntityList = JsonUtil.getJsonToList(rkProjectStartUpForm.getAttachmentList(), OaAttachmentEntity.class);
            for (OaAttachmentEntity entitys : oaAttachmentEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setObjId(entity.getId());
                entitys.setFileType("project_" + ProjectStateEnum.startAudit_state.getState());
                this.oaAttachmentService.save(entitys);
            }
            this.oaProjectStartThirdService.deleteByProjectStartId(entity.getId());
            List<OaProjectStartThirdEntity> thirdList = rkProjectStartUpForm.getThirdList();
            if (CollectionUtil.isNotEmpty(thirdList)) {
                for (OaProjectStartThirdEntity third : thirdList) {
                    if (StringUtils.isEmpty((String)third.getId())) {
                        third.setId(RandomUtil.uuId());
                    }
                    third.setProjectStartId(entity.getId());
                    third.setCompanyId(byId.getCompanyId());
                }
                this.oaProjectStartThirdService.saveBatch(thirdList);
            }
            FlowUtil.saveOrSubmit((String)rkProjectStartUpForm.getTaskId(), (String)flowEngineId, (String)rkProjectStartUpForm.getTemplateId(), (String)id, (Object)((Object)rkProjectStartUpForm), (Integer)rkProjectStartUpForm.getStatus(), (String)byId.getProjectName());
            if (rkProjectStartUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaProjectStartApplyEntity entity = this.oaProjectStartApplyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaProjectStartApplyService.delete(entity);
            QueryWrapper queryWrapperRk_project_start_product_relation = new QueryWrapper();
            queryWrapperRk_project_start_product_relation.lambda().eq(OaProjectStartProductRelationEntity::getProjectStartId, (Object)entity.getId());
            this.oaProjectStartProductRelationService.remove((Wrapper)queryWrapperRk_project_start_product_relation);
            this.oaProjectStartThirdService.deleteByProjectStartId(entity.getId());
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"getByProjectId/{projectId}"})
    public ActionResult getByProjectId(@PathVariable(value="projectId") String projectId) {
        List byProjectIdPlan = this.oaProjectApplyService.getByProjectId(projectId);
        List<OaProjectStartApplyEntity> byProjectId = this.oaProjectStartApplyService.getByProjectId(projectId);
        List<OaProjectAcceptApplyEntity> byProjectId1 = this.oaProjectAcceptApplyService.getByProjectId(projectId);
        List<OaProjectChangeHeaderApplyEntity> byProjectId2 = this.oaProjectChangeHeaderApplyService.getByProjectId(projectId);
        List<OaProjectTransferAftersaleApplyEntity> byProjectId3 = this.oaProjectTransferAftersaleApplyService.getByProjectId(projectId);
        List<OaProjectQuestionApplyEntity> byProjectId4 = this.oaProjectQuestionApplyService.getByProjectId(projectId);
        List<OaProjectAuthorizationEntity> byProjectId5 = this.oaProjectAuthorizationService.getByProjectId(projectId);
        List<OaProjectPlanChangeApplyEntity> byProjectId6 = this.oaProjectPlanChangeApplyService.getByProjectId(projectId);
        List purchaseId = this.rkPurchaseApplyService.getByProjectId(projectId);
        List procureId = this.rkContractProcureService.getByProjectId(projectId);
        List<String> oaShihanConfirmFormIds = this.oaProjectAcceptanceConfirmedReceiptService.getByProjectId(projectId);
        List byProjectId7 = this.rkProjectStopRecordService.getByProjectId(projectId);
        List list = CollectionUtil.list((boolean)false);
        if (CollectionUtil.isNotEmpty(byProjectId)) {
            list.addAll(byProjectId.stream().map(OaProjectStartApplyEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty(byProjectId1)) {
            list.addAll(byProjectId1.stream().map(OaProjectAcceptApplyEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty(byProjectId2)) {
            list.addAll(byProjectId2.stream().map(OaProjectChangeHeaderApplyEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty(byProjectId3)) {
            list.addAll(byProjectId3.stream().map(OaProjectTransferAftersaleApplyEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty(byProjectId4)) {
            list.addAll(byProjectId4.stream().map(OaProjectQuestionApplyEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty(byProjectId5)) {
            list.addAll(byProjectId5.stream().map(OaProjectAuthorizationEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty(byProjectId6)) {
            list.addAll(byProjectId6.stream().map(OaProjectPlanChangeApplyEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)byProjectId7)) {
            list.addAll(byProjectId7.stream().map(RkProjectStopRecordEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)purchaseId)) {
            list.addAll(purchaseId.stream().map(RkPurchaseApplyEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)procureId)) {
            list.addAll(procureId.stream().map(RkContractProcureEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)byProjectIdPlan)) {
            list.addAll(byProjectIdPlan.stream().map(OaProjectPlanApplyEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty(oaShihanConfirmFormIds)) {
            list.addAll(oaShihanConfirmFormIds);
        }
        return ActionResult.success((Object)list);
    }

    @GetMapping(value={"countByProjectId/{projectId}"})
    public ActionResult countByProjectId(@PathVariable(value="projectId") String projectId) {
        long startApplyCount = this.oaProjectStartApplyService.countByProjectId(projectId);
        long acceptAppplyCount = this.oaProjectAcceptApplyService.countByProjectId(projectId);
        long changeHeaderApplyCount = this.oaProjectChangeHeaderApplyService.countByProjectId(projectId);
        long transferAftersaleApplyCount = this.oaProjectTransferAftersaleApplyService.countByProjectId(projectId);
        long questionApplyCount = this.oaProjectQuestionApplyService.countByProjectId(projectId);
        long authorizationCount = this.oaProjectAuthorizationService.countByProjectId(projectId);
        long palnCount = this.oaProjectPlanChangeApplyService.countByProjectId(projectId);
        long stopCount = this.rkProjectStopRecordService.countByProjectId(projectId);
        long applyCount = this.oaProjectApplyService.countByProjectId(projectId);
        long purchaseCount = this.rkPurchaseApplyService.countByProjectId(projectId);
        long procureCount = this.rkContractProcureService.countByProjectId(projectId);
        long shihanConfirFormCount = this.oaProjectAcceptanceConfirmedReceiptService.countByProjectId(projectId);
        String add = MathUtils.add((String)String.valueOf(startApplyCount), (String)String.valueOf(acceptAppplyCount));
        String add1 = MathUtils.add((String)add, (String)String.valueOf(changeHeaderApplyCount));
        String add2 = MathUtils.add((String)add1, (String)String.valueOf(transferAftersaleApplyCount));
        String add3 = MathUtils.add((String)add2, (String)String.valueOf(questionApplyCount));
        String add4 = MathUtils.add((String)add3, (String)String.valueOf(authorizationCount));
        String add5 = MathUtils.add((String)add4, (String)String.valueOf(palnCount));
        String add6 = MathUtils.add((String)add5, (String)String.valueOf(stopCount));
        String add7 = MathUtils.add((String)add6, (String)String.valueOf(applyCount));
        String add8 = MathUtils.add((String)add7, (String)String.valueOf(purchaseCount));
        String add9 = MathUtils.add((String)add8, (String)String.valueOf(procureCount));
        String add10 = MathUtils.add((String)add9, (String)String.valueOf(shihanConfirFormCount));
        HashMap map = MapUtil.newHashMap();
        map.put("flowCount", add10);
        return ActionResult.success((Object)map);
    }
}

