/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectTransferAftersaleApplyEntity;
import com.bringspring.oa.model.oaprojecttransferaftersaleapply.OaProjectTransferAftersaleApplyCrForm;
import com.bringspring.oa.model.oaprojecttransferaftersaleapply.OaProjectTransferAftersaleApplyInfoVO;
import com.bringspring.oa.model.oaprojecttransferaftersaleapply.OaProjectTransferAftersaleApplyUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectTransferAftersaleApplyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u79fb\u4ea4\u552e\u540e\u7533\u8bf7"}, value="oa")
@RequestMapping(value={"/api/oa/OaProjectTransferAftersaleApply"})
public class OaProjectTransferAftersaleApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaProjectTransferAftersaleApplyController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaProjectTransferAftersaleApplyService oaProjectTransferAftersaleApplyService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private OaAttachmentService oaAttachmentService;

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OaProjectTransferAftersaleApplyCrForm oaProjectTransferAftersaleApplyCrForm) throws DataException, WorkFlowException {
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)oaProjectTransferAftersaleApplyCrForm.getProjectId()));
        String flowEngineId = "535114518326419461";
        if (StrUtil.isNotBlank((CharSequence)oaProjectTransferAftersaleApplyCrForm.getFlowId())) {
            flowEngineId = oaProjectTransferAftersaleApplyCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        oaProjectTransferAftersaleApplyCrForm.setMainId(mainId);
        oaProjectTransferAftersaleApplyCrForm.setProjectHeader(byId.getProjectHeader());
        this.oaProjectTransferAftersaleApplyService.createTransferAfterApply(oaProjectTransferAftersaleApplyCrForm);
        FlowUtil.saveOrSubmit((String)oaProjectTransferAftersaleApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaProjectTransferAftersaleApplyCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaProjectTransferAftersaleApplyCrForm), (Integer)oaProjectTransferAftersaleApplyCrForm.getStatus(), (String)byId.getProjectName());
        if (oaProjectTransferAftersaleApplyCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaProjectTransferAftersaleApplyInfoVO> info(@PathVariable(value="id") String id) {
        RkContractProjectEntity byId;
        OaProjectTransferAftersaleApplyEntity entity = this.oaProjectTransferAftersaleApplyService.getInfo(id);
        OaProjectTransferAftersaleApplyInfoVO vo = (OaProjectTransferAftersaleApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaProjectTransferAftersaleApplyInfoVO.class);
        if (StrUtil.isNotEmpty((CharSequence)vo.getProjectId()) && ObjectUtil.isNotNull((Object)(byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)vo.getProjectId()))))) {
            vo.setProjectName(byId.getProjectName());
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getProduct())) {
            vo.setProductName(this.crmProductService.getInfoByListId(vo.getProduct()).stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        }
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
        vo.setAttachmentList(oaAttachmentEntityList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaProjectTransferAftersaleApplyUpForm oaProjectTransferAftersaleApplyUpForm) throws DataException, WorkFlowException {
        OaProjectTransferAftersaleApplyEntity entity;
        String flowEngineId = "535114518326419461";
        if (StrUtil.isNotBlank((CharSequence)flowEngineId)) {
            flowEngineId = oaProjectTransferAftersaleApplyUpForm.getFlowId();
        }
        if ((entity = this.oaProjectTransferAftersaleApplyService.getInfo(id)) != null) {
            RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)oaProjectTransferAftersaleApplyUpForm.getProjectId()));
            oaProjectTransferAftersaleApplyUpForm.setProjectHeader(byId.getProjectHeader());
            OaProjectTransferAftersaleApplyEntity subentity = (OaProjectTransferAftersaleApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaProjectTransferAftersaleApplyUpForm), OaProjectTransferAftersaleApplyEntity.class);
            subentity.setDepartmentTree(CollectionUtil.join(oaProjectTransferAftersaleApplyUpForm.getDepartmentTree(), (CharSequence)","));
            this.oaProjectTransferAftersaleApplyService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oaProjectTransferAftersaleApplyUpForm.getTaskId(), (String)flowEngineId, (String)oaProjectTransferAftersaleApplyUpForm.getTemplateId(), (String)id, (Object)((Object)oaProjectTransferAftersaleApplyUpForm), (Integer)oaProjectTransferAftersaleApplyUpForm.getStatus(), (String)byId.getProjectName());
            if (oaProjectTransferAftersaleApplyUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaProjectTransferAftersaleApplyEntity entity = this.oaProjectTransferAftersaleApplyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaProjectTransferAftersaleApplyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

