/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.utils.Constants;
import com.bringspring.oa.entity.OaPropetyAllotEntity;
import com.bringspring.oa.model.oapropetyallot.OaPropetyAllotCrForm;
import com.bringspring.oa.model.oapropetyallot.OaPropetyAllotInfoVO;
import com.bringspring.oa.model.oapropetyallot.OaPropetyAllotListVO;
import com.bringspring.oa.model.oapropetyallot.OaPropetyAllotPagination;
import com.bringspring.oa.model.oapropetyallot.OaPropetyAllotPaginationExportModel;
import com.bringspring.oa.model.oapropetyallot.OaPropetyAllotUpForm;
import com.bringspring.oa.service.OaPropetyAllotService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d44\u4ea7\u9886\u7528\u8c03\u62e8\u5355"}, value="oa")
@RequestMapping(value={"/api/oa/OaPropetyAllot"})
public class OaPropetyAllotController {
    private static final Logger log = LoggerFactory.getLogger(OaPropetyAllotController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaPropetyAllotService oaPropetyAllotService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaPropetyAllotPagination oaPropetyAllotPagination) throws IOException {
        List<OaPropetyAllotEntity> list = this.oaPropetyAllotService.getList(oaPropetyAllotPagination);
        for (OaPropetyAllotEntity oaPropetyAllotEntity : list) {
            oaPropetyAllotEntity.setPropetyId(this.baseDataUtil.userSelectValue(oaPropetyAllotEntity.getPropetyId()));
            oaPropetyAllotEntity.setNowDepartment(this.baseDataUtil.comSelectValues(oaPropetyAllotEntity.getNowDepartment()));
            oaPropetyAllotEntity.setPropetyDepartment(this.baseDataUtil.comSelectValue(oaPropetyAllotEntity.getPropetyDepartment(), "last"));
            oaPropetyAllotEntity.setBandLevel(this.baseDataUtil.getDictName(oaPropetyAllotEntity.getBandLevel(), "504630758800063429"));
            oaPropetyAllotEntity.setJobAttribute(this.baseDataUtil.getDictName(oaPropetyAllotEntity.getJobAttribute(), "502881474148575941"));
            oaPropetyAllotEntity.setCallOutDept(this.baseDataUtil.comSelectValues(oaPropetyAllotEntity.getCallOutDept()));
            oaPropetyAllotEntity.setOldUser(this.baseDataUtil.userSelectValues(oaPropetyAllotEntity.getOldUser()));
            oaPropetyAllotEntity.setApplyType(this.baseDataUtil.getDictName(oaPropetyAllotEntity.getApplyType(), "540156199987861125"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaPropetyAllotListVO.class);
        for (OaPropetyAllotListVO oaPropetyAllotListVO : listVO) {
        }
        for (OaPropetyAllotListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaPropetyAllotPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        String[] split;
        OaPropetyAllotCrForm oaPropetyAllotCrForm = (OaPropetyAllotCrForm)((Object)JsonUtil.getJsonToBean(crData, OaPropetyAllotCrForm.class));
        String flowEngineId = "504211896380126981";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaPropetyAllotCrForm.setPropetyId(userInfo.getUserId());
        oaPropetyAllotCrForm.setPropetyDate(DateUtil.getNow());
        oaPropetyAllotCrForm.setPropetyDepartment(StringUtils.isEmpty((String)userInfo.getDepartmentId()) ? userInfo.getOrganizeId() : userInfo.getDepartmentId());
        OaPropetyAllotEntity entity = (OaPropetyAllotEntity)JsonUtil.getJsonToBean((Object)((Object)oaPropetyAllotCrForm), OaPropetyAllotEntity.class);
        entity.setPropetyDepartmentName(this.baseDataUtil.comSelectValue(entity.getPropetyDepartment(), "1"));
        entity.setCallOutDeptName(this.baseDataUtil.comSelectValue(entity.getCallOutDept(), "1"));
        entity.setCallOutDeptLeaderName(this.baseDataUtil.userSelectValues(entity.getCallOutDeptLeader()));
        entity.setOldUserName(this.baseDataUtil.userSelectValue(entity.getOldUser()));
        entity.setPropetyDepartmentTree(this.organizeService.getInfo(entity.getPropetyDepartment()).getOrganizeIdTree());
        if (StringUtils.isNotEmpty((String)entity.getPropetyDepartmentTree()) && (split = entity.getPropetyDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
            entity.setPropetyDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getPropetyDepartmentTree()));
            entity.setPropetyDepartmentOne(split[0]);
            entity.setPropetyDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getPropetyDepartmentOne()));
            entity.setPropetyDepartment(split[split.length - 1]);
            entity.setPropetyDepartmentName(this.baseDataUtil.comSelectValues(entity.getPropetyDepartment()));
        }
        entity.setEnableMark(this.baseDataUtil.getDictName(entity.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
        entity.setId(mainId);
        this.oaPropetyAllotService.save(entity);
        String title = this.baseDataUtil.getDictName(entity.getApplyType(), "540156199987861125");
        FlowUtil.saveOrSubmit((String)oaPropetyAllotCrForm.getTaskId(), (String)flowEngineId, (String)oaPropetyAllotCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaPropetyAllotCrForm), (Integer)oaPropetyAllotCrForm.getStatus(), (String)oaPropetyAllotCrForm.getPropetyName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaPropetyAllotPaginationExportModel oaPropetyAllotPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaPropetyAllotPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaPropetyAllotPagination oaPropetyAllotPagination = (OaPropetyAllotPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaPropetyAllotPaginationExportModel), OaPropetyAllotPagination.class));
        List<OaPropetyAllotEntity> list = this.oaPropetyAllotService.getTypeList(oaPropetyAllotPagination, oaPropetyAllotPaginationExportModel.getDataType());
        for (OaPropetyAllotEntity oaPropetyAllotEntity : list) {
            oaPropetyAllotEntity.setPropetyId(this.baseDataUtil.userSelectValue(oaPropetyAllotEntity.getPropetyId()));
            oaPropetyAllotEntity.setNowDepartment(this.baseDataUtil.comSelectValues(oaPropetyAllotEntity.getNowDepartment()));
            oaPropetyAllotEntity.setPropetyDepartment(this.baseDataUtil.comSelectValue(oaPropetyAllotEntity.getPropetyDepartment(), "last"));
            oaPropetyAllotEntity.setBandLevel(this.baseDataUtil.getDictName(oaPropetyAllotEntity.getBandLevel(), "504630758800063429"));
            oaPropetyAllotEntity.setJobAttribute(this.baseDataUtil.getDictName(oaPropetyAllotEntity.getJobAttribute(), "502881474148575941"));
            oaPropetyAllotEntity.setCallOutDept(this.baseDataUtil.comSelectValues(oaPropetyAllotEntity.getCallOutDept()));
            oaPropetyAllotEntity.setOldUser(this.baseDataUtil.userSelectValues(oaPropetyAllotEntity.getOldUser()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaPropetyAllotListVO.class);
        for (OaPropetyAllotListVO oaPropetyAllotListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaPropetyAllotPaginationExportModel.getSelectKey()) ? oaPropetyAllotPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block48: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "applyType": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u5206\u7c7b", (Object)"applyType"));
                        continue block48;
                    }
                    case "propetyId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"propetyId"));
                        continue block48;
                    }
                    case "propetyDate": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65e5\u671f", (Object)"propetyDate"));
                        continue block48;
                    }
                    case "propetyDepartment": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u90e8\u95e8", (Object)"propetyDepartment"));
                        continue block48;
                    }
                    case "bandLevel": {
                        entitys.add(new ExcelExportEntity("BAND\u7b49\u7ea7", (Object)"bandLevel"));
                        continue block48;
                    }
                    case "jobAttribute": {
                        entitys.add(new ExcelExportEntity("\u5c97\u4f4d\u6027\u8d28", (Object)"jobAttribute"));
                        continue block48;
                    }
                    case "applyBase": {
                        entitys.add(new ExcelExportEntity("\u7535\u8111\u4f7f\u7528\u5730\u70b9", (Object)"applyBase"));
                        continue block48;
                    }
                    case "applyTelephone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"applyTelephone"));
                        continue block48;
                    }
                    case "number": {
                        entitys.add(new ExcelExportEntity("\u6570\u91cf", (Object)"number"));
                        continue block48;
                    }
                    case "specificConfiguration": {
                        entitys.add(new ExcelExportEntity("\u5177\u4f53\u914d\u7f6e", (Object)"specificConfiguration"));
                        continue block48;
                    }
                    case "isSpecialAllot": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4e3a\u7279\u6b8a\u8d44\u4ea7\u8c03\u62e8", (Object)"isSpecialAllot"));
                        continue block48;
                    }
                    case "callOutDept": {
                        entitys.add(new ExcelExportEntity("\u8c03\u51fa\u90e8\u95e8", (Object)"callOutDept"));
                        continue block48;
                    }
                    case "oldUser": {
                        entitys.add(new ExcelExportEntity("\u539f\u4f7f\u7528\u4eba", (Object)"oldUser"));
                        continue block48;
                    }
                    case "allotDescription": {
                        entitys.add(new ExcelExportEntity("\u8c03\u62e8\u8d44\u4ea7\u63cf\u8ff0", (Object)"allotDescription"));
                        continue block48;
                    }
                    case "allotReason": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u7406\u7531", (Object)"allotReason"));
                        continue block48;
                    }
                    case "propetyCode": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u7f16\u7801", (Object)"propetyCode"));
                        continue block48;
                    }
                    case "propetyName": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u540d\u79f0", (Object)"propetyName"));
                        continue block48;
                    }
                    case "propetyStatus": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u72b6\u6001", (Object)"propetyStatus"));
                        continue block48;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaPropetyAllotInfoVO> info(@PathVariable(value="id") String id) {
        OaPropetyAllotEntity entity = this.oaPropetyAllotService.getInfo(id);
        OaPropetyAllotInfoVO vo = (OaPropetyAllotInfoVO)JsonUtil.getJsonToBean((Object)entity, OaPropetyAllotInfoVO.class);
        vo.setPropetyId(this.baseDataUtil.userSelectValue(vo.getPropetyId()));
        if (vo.getPropetyDate() != null) {
            vo.setPropetyDate(vo.getPropetyDate());
        }
        vo.setPropetyDepartment(this.baseDataUtil.comSelectValue(vo.getPropetyDepartment(), "last"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaPropetyAllotUpForm oaPropetyAllotUpForm = (OaPropetyAllotUpForm)((Object)JsonUtil.getJsonToBean(upData, OaPropetyAllotUpForm.class));
        String flowEngineId = "504211896380126981";
        UserInfo userInfo = this.userProvider.get();
        OaPropetyAllotEntity entity = this.oaPropetyAllotService.getInfo(id);
        if (entity != null) {
            String[] split;
            oaPropetyAllotUpForm.setPropetyDepartment(entity.getPropetyDepartment());
            OaPropetyAllotEntity subentity = (OaPropetyAllotEntity)JsonUtil.getJsonToBean((Object)((Object)oaPropetyAllotUpForm), OaPropetyAllotEntity.class);
            subentity.setPropetyDepartmentName(this.baseDataUtil.comSelectValue(entity.getPropetyDepartment(), "1"));
            subentity.setCallOutDeptName(this.baseDataUtil.comSelectValue(entity.getCallOutDept(), "1"));
            subentity.setCallOutDeptLeaderName(this.baseDataUtil.userSelectValues(entity.getCallOutDeptLeader()));
            subentity.setOldUserName(this.baseDataUtil.userSelectValue(entity.getOldUser()));
            subentity.setPropetyDepartmentTree(this.organizeService.getInfo(entity.getPropetyDepartment()).getOrganizeIdTree());
            if (StringUtils.isNotEmpty((String)subentity.getPropetyDepartmentTree()) && (split = subentity.getPropetyDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
                subentity.setPropetyDepartmentTreeName(this.baseDataUtil.comSelectValues(subentity.getPropetyDepartmentTree()));
                subentity.setPropetyDepartmentOne(split[0]);
                subentity.setPropetyDepartmentOneName(this.baseDataUtil.comSelectValues(subentity.getPropetyDepartmentOne()));
                subentity.setPropetyDepartment(split[split.length - 1]);
                subentity.setPropetyDepartmentName(this.baseDataUtil.comSelectValues(subentity.getPropetyDepartment()));
            }
            subentity.setPropetyId(entity.getPropetyId());
            subentity.setPropetyDate(entity.getPropetyDate());
            this.oaPropetyAllotService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oaPropetyAllotUpForm.getTaskId(), (String)flowEngineId, (String)oaPropetyAllotUpForm.getTemplateId(), (String)id, (Object)((Object)oaPropetyAllotUpForm), (Integer)oaPropetyAllotUpForm.getStatus(), (String)oaPropetyAllotUpForm.getPropetyName());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaPropetyAllotEntity entity = this.oaPropetyAllotService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaPropetyAllotService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

