/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.entity.OaRecordAccessoryEntity;
import com.bringspring.oa.entity.OaRecordBorrowEntity;
import com.bringspring.oa.entity.OaRecordEntity;
import com.bringspring.oa.entity.OaRecordSubitemEntity;
import com.bringspring.oa.mapper.OaRecordBorrowMapper;
import com.bringspring.oa.model.oaRecord.OaRecordBorrowFileVO;
import com.bringspring.oa.model.oaRecord.OaRecordPagination;
import com.bringspring.oa.model.oarecordborrow.OaRecordPastVo;
import com.bringspring.oa.service.OaRecordAccessoryService;
import com.bringspring.oa.service.OaRecordService;
import com.bringspring.oa.service.OaRecordSubitemService;
import com.bringspring.system.base.exception.WorkFlowException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"oa_record_accessory"}, value="oa")
@RequestMapping(value={"/api/oa/OaRecordAccessory"})
public class OaRecordAccessoryController {
    private static final Logger log = LoggerFactory.getLogger(OaRecordAccessoryController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaRecordAccessoryService oaRecordAccessoryService;
    @Autowired
    private OaRecordBorrowMapper oaRecordBorrowMapper;
    @Autowired
    private OaRecordSubitemService oaRecordSubitemService;
    @Autowired
    private OaRecordService oaRecordService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaRecordPagination oaRecordPagination) throws IOException {
        List<OaRecordAccessoryEntity> list = this.oaRecordAccessoryService.getList(oaRecordPagination);
        List listVO = JsonUtil.getJsonToList(list, OaRecordPastVo.class);
        for (OaRecordPastVo oaRecordPastVo : listVO) {
            OaRecordSubitemEntity subitemServiceInfo = this.oaRecordSubitemService.getInfo(oaRecordPastVo.getRecordId());
            if (ObjectUtil.isNotEmpty((Object)subitemServiceInfo)) {
                oaRecordPastVo.setProcureCode(subitemServiceInfo.getProcureCode());
                OaRecordEntity info = this.oaRecordService.getInfo(subitemServiceInfo.getRecordId());
                oaRecordPastVo.setRecordName(info.getRecordName());
            }
            boolean before = oaRecordPastVo.getPastDate().isBefore(LocalDateTime.now());
            oaRecordPastVo.setState(before);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaRecordPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @NotCheckLogin
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaRecordPastVo vo) throws DataException, WorkFlowException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaRecordBorrowEntity::getPrimaryId, (Object)"597769304586322181");
        List borrowEntities = this.oaRecordBorrowMapper.selectList((Wrapper)queryWrapper);
        for (OaRecordBorrowEntity entity : borrowEntities) {
            OaRecordAccessoryEntity oaRecordAccessoryEntity = new OaRecordAccessoryEntity();
            oaRecordAccessoryEntity.setId(RandomUtil.uuId());
            oaRecordAccessoryEntity.setPastDate(LocalDateTime.now().plusDays(3L));
            oaRecordAccessoryEntity.setPastType(0);
            oaRecordAccessoryEntity.setAccessory(this.oaRecordSubitemService.getInfo(entity.getSubitemId()).getAccessory());
            oaRecordAccessoryEntity.setFileName(entity.getFileName());
            oaRecordAccessoryEntity.setRecordId(entity.getSubitemId());
            this.oaRecordAccessoryService.create(oaRecordAccessoryEntity);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u538b\u7f29\u6587\u4ef6\u5939\u5e76\u4e0b\u8f7d")
    @PostMapping(value={"/toZip"})
    public ActionResult toZip(@RequestBody OaRecordBorrowFileVO vo) {
        DownloadVO allDocumentByParentId = this.oaRecordAccessoryService.toZipByIds(vo);
        return ActionResult.success((Object)allDocumentByParentId);
    }
}

