/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaSupplierApplyEntity;
import com.bringspring.oa.model.oaSupplierApply.OaSupplierApplyCrForm;
import com.bringspring.oa.model.oaSupplierApply.OaSupplierApplyInfoVO;
import com.bringspring.oa.model.oaSupplierApply.OaSupplierApplyListVO;
import com.bringspring.oa.model.oaSupplierApply.OaSupplierApplyPagination;
import com.bringspring.oa.model.oaSupplierApply.OaSupplierApplyPaginationExportModel;
import com.bringspring.oa.model.oaSupplierApply.OaSupplierApplyUpForm;
import com.bringspring.oa.model.oaattachment.OaAttachmentCrForm;
import com.bringspring.oa.model.oaattachment.OaAttachmentUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaSupplierApplyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f9b\u5e94\u5546\u5165\u56f4\u7533\u8bf7"}, value="example")
@RequestMapping(value={"/api/example/OaSupplierApply"})
public class OaSupplierApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaSupplierApplyController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaSupplierApplyService oaSupplierApplyService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaSupplierApplyPagination oaSupplierApplyPagination) throws IOException {
        List<OaSupplierApplyEntity> list = this.oaSupplierApplyService.getList(oaSupplierApplyPagination);
        for (OaSupplierApplyEntity oaSupplierApplyEntity : list) {
            oaSupplierApplyEntity.setApplyId(this.baseDataUtil.userSelectValue(oaSupplierApplyEntity.getApplyId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaSupplierApplyListVO.class);
        for (OaSupplierApplyListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaSupplierApplyPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @RepeatSubmit
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaSupplierApplyCrForm oaSupplierApplyCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "572704721794513669";
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            oaSupplierApplyCrForm.setApplyId(userInfo.getUserId());
            oaSupplierApplyCrForm.setApplyTime(DateUtil.getNow());
            oaSupplierApplyCrForm.setSupplierCode(this.baseDataUtil.getBillNumber("supplierApplyCode", Boolean.valueOf(false)));
            OaSupplierApplyEntity entity = (OaSupplierApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaSupplierApplyCrForm), OaSupplierApplyEntity.class);
            entity.setId(mainId);
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setCreatorTime(new Date());
            entity.setCompanyId(userInfo.getOrganizeId());
            List<OaAttachmentCrForm> licenseList = oaSupplierApplyCrForm.getLicenseList();
            licenseList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType("license");
            });
            List licenseEntityList = JsonUtil.getJsonToList(licenseList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(licenseEntityList);
            List<OaAttachmentCrForm> honestList = oaSupplierApplyCrForm.getHonestList();
            honestList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType("honest");
            });
            List honestEntityList = JsonUtil.getJsonToList(honestList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(honestEntityList);
            List<OaAttachmentCrForm> otherList = oaSupplierApplyCrForm.getOtherList();
            otherList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType("other");
            });
            List otherEntityList = JsonUtil.getJsonToList(otherList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(otherEntityList);
            List<OaAttachmentCrForm> agencyList = oaSupplierApplyCrForm.getAgencyList();
            agencyList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType("agencyList");
            });
            List agencyEntityList = JsonUtil.getJsonToList(agencyList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(agencyEntityList);
            List<OaAttachmentCrForm> environmentDiplomaList = oaSupplierApplyCrForm.getEnvironmentDiplomaList();
            environmentDiplomaList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType("environmentDiplomaList");
            });
            List environmentDiplomaEntityList = JsonUtil.getJsonToList(environmentDiplomaList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(environmentDiplomaEntityList);
            this.oaSupplierApplyService.save(entity);
            String flowTitle = entity.getSupplierName();
            FlowUtil.saveOrSubmit((String)oaSupplierApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaSupplierApplyCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaSupplierApplyCrForm), (Integer)oaSupplierApplyCrForm.getStatus(), (String)flowTitle);
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaSupplierApplyInfoVO> info(@PathVariable(value="id") String id) {
        OaSupplierApplyEntity entity = this.oaSupplierApplyService.getInfo(id);
        OaSupplierApplyInfoVO vo = (OaSupplierApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaSupplierApplyInfoVO.class);
        vo.setApplyId(this.baseDataUtil.userSelectValue(vo.getApplyId()));
        if (vo.getApplyTime() != null) {
            vo.setApplyTime(vo.getApplyTime());
        }
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaSupplierApplyUpForm oaSupplierApplyUpForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "572704721794513669";
            OaSupplierApplyEntity entity = this.oaSupplierApplyService.getInfo(id);
            if (entity != null) {
                OaSupplierApplyEntity subentity = (OaSupplierApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaSupplierApplyUpForm), OaSupplierApplyEntity.class);
                subentity.setApplyId(entity.getApplyId());
                subentity.setApplyTime(entity.getApplyTime());
                this.oaAttachmentService.deleteByContractId(id);
                List<OaAttachmentUpForm> licenseList = oaSupplierApplyUpForm.getLicenseList();
                licenseList.stream().forEach(attach -> {
                    attach.setContractId(id);
                    attach.setFileType("license");
                });
                List licenseEntityList = JsonUtil.getJsonToList(licenseList, OaAttachmentEntity.class);
                this.oaAttachmentService.saveBatch(licenseEntityList);
                List<OaAttachmentUpForm> honestList = oaSupplierApplyUpForm.getHonestList();
                honestList.stream().forEach(attach -> {
                    attach.setContractId(id);
                    attach.setFileType("honest");
                });
                List honestEntityList = JsonUtil.getJsonToList(honestList, OaAttachmentEntity.class);
                this.oaAttachmentService.saveBatch(honestEntityList);
                List<OaAttachmentUpForm> otherList = oaSupplierApplyUpForm.getOtherList();
                otherList.stream().forEach(attach -> {
                    attach.setContractId(id);
                    attach.setFileType("other");
                });
                List otherEntityList = JsonUtil.getJsonToList(otherList, OaAttachmentEntity.class);
                this.oaAttachmentService.saveBatch(otherEntityList);
                List<OaAttachmentUpForm> agencyList = oaSupplierApplyUpForm.getAgencyList();
                agencyList.stream().forEach(attach -> {
                    attach.setContractId(id);
                    attach.setFileType("agencyList");
                });
                List agencyEntityList = JsonUtil.getJsonToList(agencyList, OaAttachmentEntity.class);
                this.oaAttachmentService.saveBatch(agencyEntityList);
                List<OaAttachmentUpForm> environmentDiplomaList = oaSupplierApplyUpForm.getEnvironmentDiplomaList();
                environmentDiplomaList.stream().forEach(attach -> {
                    attach.setContractId(id);
                    attach.setFileType("environmentDiplomaList");
                });
                List environmentDiplomaEntityList = JsonUtil.getJsonToList(environmentDiplomaList, OaAttachmentEntity.class);
                this.oaAttachmentService.saveBatch(environmentDiplomaEntityList);
                this.oaSupplierApplyService.updateForm(id, oaSupplierApplyUpForm);
                String flowTitle = subentity.getSupplierName();
                FlowUtil.saveOrSubmit((String)oaSupplierApplyUpForm.getTaskId(), (String)flowEngineId, (String)oaSupplierApplyUpForm.getTemplateId(), (String)id, (Object)((Object)oaSupplierApplyUpForm), (Integer)oaSupplierApplyUpForm.getStatus(), (String)flowTitle);
                return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaSupplierApplyEntity entity = this.oaSupplierApplyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaSupplierApplyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaSupplierApplyPaginationExportModel oaSupplierApplyPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)oaSupplierApplyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaSupplierApplyPagination oaSupplierApplyPagination = (OaSupplierApplyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaSupplierApplyPaginationExportModel), OaSupplierApplyPagination.class));
        List<OaSupplierApplyEntity> list = this.oaSupplierApplyService.getTypeList(oaSupplierApplyPagination, oaSupplierApplyPaginationExportModel.getDataType());
        for (OaSupplierApplyEntity oaSupplierApplyEntity : list) {
            oaSupplierApplyEntity.setApplyId(this.baseDataUtil.userSelectValue(oaSupplierApplyEntity.getApplyId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaSupplierApplyListVO.class);
        for (OaSupplierApplyListVO oaSupplierApplyListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)oaSupplierApplyPaginationExportModel.getSelectKey()) ? oaSupplierApplyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block60: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "applyId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"applyId"));
                        continue block60;
                    }
                    case "applyTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65f6\u95f4", (Object)"applyTime"));
                        continue block60;
                    }
                    case "supplierCode": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u7f16\u53f7", (Object)"supplierCode"));
                        continue block60;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)"supplierName"));
                        continue block60;
                    }
                    case "registerCapital": {
                        entitys.add(new ExcelExportEntity("\u6ce8\u518c\u8d44\u672c", (Object)"registerCapital"));
                        continue block60;
                    }
                    case "establishDate": {
                        entitys.add(new ExcelExportEntity("\u6210\u7acb\u65e5\u671f", (Object)"establishDate"));
                        continue block60;
                    }
                    case "insureNumber": {
                        entitys.add(new ExcelExportEntity("\u53c2\u4fdd\u4eba\u6570", (Object)"insureNumber"));
                        continue block60;
                    }
                    case "paidCaptial": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u7f34\u8d44\u672c", (Object)"paidCaptial"));
                        continue block60;
                    }
                    case "businessScope": {
                        entitys.add(new ExcelExportEntity("\u8425\u4e1a\u8303\u56f4", (Object)"businessScope"));
                        continue block60;
                    }
                    case "legalPerson": {
                        entitys.add(new ExcelExportEntity("\u6cd5\u5b9a\u4ee3\u8868\u4eba", (Object)"legalPerson"));
                        continue block60;
                    }
                    case "socialCode": {
                        entitys.add(new ExcelExportEntity("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801", (Object)"socialCode"));
                        continue block60;
                    }
                    case "isTaxpayer": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4e3a\u4e00\u822c\u7eb3\u7a0e\u4eba", (Object)"isTaxpayer"));
                        continue block60;
                    }
                    case "isDishonestyRisk": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u6709\u5931\u4fe1\u98ce\u9669", (Object)"isDishonestyRisk"));
                        continue block60;
                    }
                    case "bankAccount": {
                        entitys.add(new ExcelExportEntity("\u5f00\u6237\u884c\u8d26\u53f7", (Object)"bankAccount"));
                        continue block60;
                    }
                    case "baseBank": {
                        entitys.add(new ExcelExportEntity("\u57fa\u672c\u6237\u5f00\u6237\u884c", (Object)"baseBank"));
                        continue block60;
                    }
                    case "linkPosition": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u804c\u4f4d", (Object)"linkPosition"));
                        continue block60;
                    }
                    case "linkMan": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"linkMan"));
                        continue block60;
                    }
                    case "linkTelphone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u7535\u8bdd", (Object)"linkTelphone"));
                        continue block60;
                    }
                    case "isEnvironmentDiploma": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u62e5\u6709\u73af\u4fdd\u8bc1\u4e66", (Object)"isEnvironmentDiploma"));
                        continue block60;
                    }
                    case "isAgentAptitude": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u62e5\u6709\u4ee3\u7406\u8d44\u8d28", (Object)"isAgentAptitude"));
                        continue block60;
                    }
                    case "isSignProtocol": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u7b7e\u8ba2\u534f\u8bae", (Object)"isSignProtocol"));
                        continue block60;
                    }
                    case "isSignLetter": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u7b7e\u8ba2\u5c65\u7ea6\u62c5\u4fdd\u51fd", (Object)"isSignLetter"));
                        continue block60;
                    }
                    case "supplierResult": {
                        entitys.add(new ExcelExportEntity("\u5165\u56f4\u8bc4\u4ef7\u7ed3\u679c", (Object)"supplierResult"));
                        continue block60;
                    }
                    case "procureAmount": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u989d\u91d1\u989d", (Object)"procureAmount"));
                        continue block60;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

