/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.entity.OaWarehouseOutEntity;
import com.bringspring.oa.model.oawarehouseout.OaWarehouseOutCrForm;
import com.bringspring.oa.model.oawarehouseout.OaWarehouseOutInfoVO;
import com.bringspring.oa.model.oawarehouseout.OaWarehouseOutListVO;
import com.bringspring.oa.model.oawarehouseout.OaWarehouseOutPagination;
import com.bringspring.oa.model.oawarehouseout.OaWarehouseOutPaginationExportModel;
import com.bringspring.oa.model.oawarehouseout.OaWarehouseOutUpForm;
import com.bringspring.oa.service.OaWarehouseOutService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u89c6\u7ff0\u51fa\u5e93\u6d41\u7a0b"}, value="oa")
@RequestMapping(value={"/api/oa/OaWarehouseOut"})
public class OaWarehouseOutController {
    private static final Logger log = LoggerFactory.getLogger(OaWarehouseOutController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaWarehouseOutService oaWarehouseOutService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaWarehouseOutPagination oaWarehouseOutPagination) throws IOException {
        List<OaWarehouseOutEntity> list = this.oaWarehouseOutService.getList(oaWarehouseOutPagination);
        for (OaWarehouseOutEntity oaWarehouseOutEntity : list) {
            oaWarehouseOutEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaWarehouseOutEntity.getCreatorUserId()));
            oaWarehouseOutEntity.setBussinessName(this.baseDataUtil.userSelectValues(oaWarehouseOutEntity.getBussinessName()));
            oaWarehouseOutEntity.setBelongDept(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getBelongDept(), "ShWarehouseOutDept"));
            oaWarehouseOutEntity.setBussinessArea(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getBussinessArea(), "ShWarehouseOutArea"));
            oaWarehouseOutEntity.setApprovedBy(this.baseDataUtil.userSelectValues(oaWarehouseOutEntity.getApprovedBy()));
            oaWarehouseOutEntity.setIsBackMoney(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getIsBackMoney(), "whether"));
            oaWarehouseOutEntity.setIsBackContract(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getIsBackContract(), "whether"));
            oaWarehouseOutEntity.setProductType(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getProductType(), "ShWarehouseOutProductType"));
            oaWarehouseOutEntity.setContractType(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getContractType(), "contractType"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaWarehouseOutListVO.class);
        for (OaWarehouseOutListVO oaWarehouseOutListVO : listVO) {
        }
        for (OaWarehouseOutListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaWarehouseOutPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaWarehouseOutCrForm oaWarehouseOutCrForm = (OaWarehouseOutCrForm)JsonUtil.getJsonToBean(crData, OaWarehouseOutCrForm.class);
        String visualId = "676386711109911877";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaWarehouseOutCrForm.setCreatorUserId(userInfo.getUserId());
        oaWarehouseOutCrForm.setCreatorTime(DateUtil.getNow());
        OaWarehouseOutEntity entity = (OaWarehouseOutEntity)JsonUtil.getJsonToBean((Object)oaWarehouseOutCrForm, OaWarehouseOutEntity.class);
        entity.setId(mainId);
        this.oaWarehouseOutService.save(entity);
        FlowUtil.saveOrSubmit((String)oaWarehouseOutCrForm.getTaskId(), (String)oaWarehouseOutCrForm.getFlowId(), (String)oaWarehouseOutCrForm.getTemplateId(), (String)mainId, (Object)oaWarehouseOutCrForm, (Integer)oaWarehouseOutCrForm.getStatus(), (String)(oaWarehouseOutCrForm.getCustomerName() + "-" + oaWarehouseOutCrForm.getProjectName()));
        if (FlowTaskStatusEnum.Handle.getCode().equals(oaWarehouseOutCrForm.getStatus())) {
            return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
        }
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaWarehouseOutPaginationExportModel oaWarehouseOutPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaWarehouseOutPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaWarehouseOutPagination oaWarehouseOutPagination = (OaWarehouseOutPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaWarehouseOutPaginationExportModel), OaWarehouseOutPagination.class));
        List<OaWarehouseOutEntity> list = this.oaWarehouseOutService.getTypeList(oaWarehouseOutPagination, oaWarehouseOutPaginationExportModel.getDataType());
        for (OaWarehouseOutEntity oaWarehouseOutEntity : list) {
            oaWarehouseOutEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaWarehouseOutEntity.getCreatorUserId()));
            oaWarehouseOutEntity.setBussinessName(this.baseDataUtil.userSelectValues(oaWarehouseOutEntity.getBussinessName()));
            oaWarehouseOutEntity.setBelongDept(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getBelongDept(), "ShWarehouseOutDept"));
            oaWarehouseOutEntity.setBussinessArea(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getBussinessArea(), "ShWarehouseOutArea"));
            oaWarehouseOutEntity.setApprovedBy(this.baseDataUtil.userSelectValues(oaWarehouseOutEntity.getApprovedBy()));
            oaWarehouseOutEntity.setIsBackMoney(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getIsBackMoney(), "whether"));
            oaWarehouseOutEntity.setIsBackContract(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getIsBackContract(), "whether"));
            oaWarehouseOutEntity.setProductType(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getProductType(), "ShWarehouseOutProductType"));
            oaWarehouseOutEntity.setContractType(this.baseDataUtil.getDictName(oaWarehouseOutEntity.getContractType(), "contractType"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaWarehouseOutListVO.class);
        for (OaWarehouseOutListVO oaWarehouseOutListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaWarehouseOutPaginationExportModel.getSelectKey()) ? oaWarehouseOutPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block48: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block48;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block48;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u7532\u65b9\u540d\u79f0", (Object)"customerName"));
                        continue block48;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block48;
                    }
                    case "bussinessName": {
                        entitys.add(new ExcelExportEntity("\u5546\u52a1", (Object)"bussinessName"));
                        continue block48;
                    }
                    case "belongDept": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u90e8\u95e8", (Object)"belongDept"));
                        continue block48;
                    }
                    case "bussinessArea": {
                        entitys.add(new ExcelExportEntity("\u533a\u57df", (Object)"bussinessArea"));
                        continue block48;
                    }
                    case "deliveryDate": {
                        entitys.add(new ExcelExportEntity("\u53d1\u8d27\u65e5\u671f", (Object)"deliveryDate"));
                        continue block48;
                    }
                    case "approvedBy": {
                        entitys.add(new ExcelExportEntity("\u533a\u57df\u8d1f\u8d23\u4eba", (Object)"approvedBy"));
                        continue block48;
                    }
                    case "isBackMoney": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u56de\u6b3e", (Object)"isBackMoney"));
                        continue block48;
                    }
                    case "isBackContract": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u662f\u5426\u8fd4\u56de", (Object)"isBackContract"));
                        continue block48;
                    }
                    case "productType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u7c7b\u578b", (Object)"productType"));
                        continue block48;
                    }
                    case "contractType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractType"));
                        continue block48;
                    }
                    case "attachmentsOut": {
                        entitys.add(new ExcelExportEntity("\u51fa\u5e93\u5355", (Object)"attachmentsOut"));
                        continue block48;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block48;
                    }
                    case "attachmentsProduct": {
                        entitys.add(new ExcelExportEntity("\u65b0\u4ea7\u54c1\u5bfc\u5165", (Object)"attachmentsProduct"));
                        continue block48;
                    }
                    case "attachmentsInquiry": {
                        entitys.add(new ExcelExportEntity("\u8be2\u4ef7\u5355", (Object)"attachmentsInquiry"));
                        continue block48;
                    }
                    case "attachmentsContract": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c", (Object)"attachmentsContract"));
                        continue block48;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaWarehouseOutInfoVO> info(@PathVariable(value="id") String id) {
        OaWarehouseOutEntity entity = this.oaWarehouseOutService.getInfo(id);
        OaWarehouseOutInfoVO vo = (OaWarehouseOutInfoVO)JsonUtil.getJsonToBean((Object)entity, OaWarehouseOutInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaWarehouseOutUpForm oaWarehouseOutUpForm = (OaWarehouseOutUpForm)JsonUtil.getJsonToBean(upData, OaWarehouseOutUpForm.class);
        String visualId = "676386711109911877";
        UserInfo userInfo = this.userProvider.get();
        OaWarehouseOutEntity entity = this.oaWarehouseOutService.getInfo(id);
        if (entity != null) {
            OaWarehouseOutEntity subentity = (OaWarehouseOutEntity)JsonUtil.getJsonToBean((Object)oaWarehouseOutUpForm, OaWarehouseOutEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.oaWarehouseOutService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oaWarehouseOutUpForm.getTaskId(), (String)oaWarehouseOutUpForm.getFlowId(), (String)oaWarehouseOutUpForm.getTemplateId(), (String)id, (Object)oaWarehouseOutUpForm, (Integer)oaWarehouseOutUpForm.getStatus(), (String)(oaWarehouseOutUpForm.getCustomerName() + "-" + oaWarehouseOutUpForm.getProjectName()));
            if (FlowTaskStatusEnum.Handle.getCode().equals(oaWarehouseOutUpForm.getStatus())) {
                return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaWarehouseOutEntity entity = this.oaWarehouseOutService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaWarehouseOutService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

