/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.entity.OaCdSignLetterEntity;
import com.bringspring.oa.entity.OacdsigapplicationEntity;
import com.bringspring.oa.model.oacdsigapplication.OaCdSignLetterModel;
import com.bringspring.oa.model.oacdsigapplication.OacdsigapplicationCrForm;
import com.bringspring.oa.model.oacdsigapplication.OacdsigapplicationInfoVO;
import com.bringspring.oa.model.oacdsigapplication.OacdsigapplicationListVO;
import com.bringspring.oa.model.oacdsigapplication.OacdsigapplicationPagination;
import com.bringspring.oa.model.oacdsigapplication.OacdsigapplicationUpForm;
import com.bringspring.oa.service.OaCdSignApplicationService;
import com.bringspring.oa.service.OaCdSignLetterService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u884c\u653f\u7b7e\u5448"}, value="example")
@RequestMapping(value={"/api/cd/Oacdsigapplication"})
public class OacdsigapplicationController {
    private static final Logger log = LoggerFactory.getLogger(OacdsigapplicationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaCdSignApplicationService oaCdSignApplicationService;
    @Autowired
    private OaCdSignLetterService oaCdSignLetterService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OacdsigapplicationPagination oacdsigapplicationPagination) throws IOException {
        List<OacdsigapplicationEntity> list = this.oaCdSignApplicationService.getList(oacdsigapplicationPagination);
        for (OacdsigapplicationEntity oacdsigapplicationEntity : list) {
            oacdsigapplicationEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oacdsigapplicationEntity.getCreatorUserId()));
            oacdsigapplicationEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(oacdsigapplicationEntity.getLastModifyUserId()));
            oacdsigapplicationEntity.setCreatorDept(this.baseDataUtil.comSelectValue(oacdsigapplicationEntity.getCreatorDept(), "last"));
            oacdsigapplicationEntity.setIsCeo(this.baseDataUtil.switchSelectValue(oacdsigapplicationEntity.getIsCeo(), "\u5f00", "\u5173"));
            oacdsigapplicationEntity.setOaUploads(this.baseDataUtil.getFileNameInJson(oacdsigapplicationEntity.getOaUploads()));
        }
        List listVO = JsonUtil.getJsonToList(list, OacdsigapplicationListVO.class);
        for (OacdsigapplicationListVO vo : listVO) {
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setOaTypeName(this.baseDataUtil.getDictName(vo.getOaType(), "SignApplication2"));
            List<OaCdSignLetterEntity> letterList = this.oaCdSignApplicationService.GetOaCdSignLetterList(vo.getId());
            vo.setOaCdSignLetterList(JsonUtil.getJsonToList(letterList, OaCdSignLetterModel.class));
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oacdsigapplicationPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        List<String> userList;
        List<String> departmentList;
        OacdsigapplicationCrForm oacdsigapplicationCrForm = (OacdsigapplicationCrForm)((Object)JsonUtil.getJsonToBean(crData, OacdsigapplicationCrForm.class));
        String flowEngineId = "501393514001597445";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oacdsigapplicationCrForm.setCreatorTime(DateUtil.getNow());
        oacdsigapplicationCrForm.setCreatorUserId(userInfo.getUserId());
        if (!oacdsigapplicationCrForm.getOaType().equals("lczd")) {
            oacdsigapplicationCrForm.setCreatorDept(StringUtils.isEmpty((String)userInfo.getDepartmentId()) ? userInfo.getOrganizeId() : userInfo.getDepartmentId());
        }
        oacdsigapplicationCrForm.setFormId(this.baseDataUtil.getBillNumber("OaCdSignApplication", Boolean.valueOf(false)));
        oacdsigapplicationCrForm.setWhetherMultiple("0");
        if (oacdsigapplicationCrForm.getOaType().equals("lczd")) {
            OrganizeEntity info = this.organizeService.getInfo(oacdsigapplicationCrForm.getCreatorDept());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                oacdsigapplicationCrForm.setDepartmentHead(info.getManagerId());
            }
            if (ObjectUtil.isNotEmpty(oacdsigapplicationCrForm.getMultipleDepartment())) {
                ArrayList<String> multiDepartmentHead = new ArrayList<String>();
                for (String str : oacdsigapplicationCrForm.getMultipleDepartment()) {
                    OrganizeEntity organizeServiceInfo = this.organizeService.getInfo(str);
                    if (!ObjectUtil.isNotEmpty((Object)organizeServiceInfo) || !StringUtils.isNotEmpty((String)organizeServiceInfo.getManagerId())) continue;
                    multiDepartmentHead.add(organizeServiceInfo.getManagerId());
                }
                multiDepartmentHead.remove(oacdsigapplicationCrForm.getDepartmentHead());
                oacdsigapplicationCrForm.setMultipleDepartmentHead(JsonUtil.getObjectToString(multiDepartmentHead));
                oacdsigapplicationCrForm.setWhetherMultiple("1");
            }
        }
        if (StringUtils.isNotEmpty((String)oacdsigapplicationCrForm.getSendingRangeDept()) && CollectionUtil.isNotEmpty(departmentList = Arrays.asList(oacdsigapplicationCrForm.getSendingRangeDept().replace("\"", "").replace("[", "").replace("]", "").split(",")))) {
            oacdsigapplicationCrForm.setSendingRangeDept(String.join((CharSequence)",", departmentList));
        }
        if (StringUtils.isNotEmpty((String)oacdsigapplicationCrForm.getSendingRangeUser()) && CollectionUtil.isNotEmpty(userList = Arrays.asList(oacdsigapplicationCrForm.getSendingRangeUser().replace("\"", "").replace("[", "").replace("]", "").split(",")))) {
            oacdsigapplicationCrForm.setSendingRangeUser(String.join((CharSequence)",", userList));
        }
        OacdsigapplicationEntity entity = (OacdsigapplicationEntity)JsonUtil.getJsonToBean((Object)((Object)oacdsigapplicationCrForm), OacdsigapplicationEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.oaCdSignApplicationService.save(entity);
        oacdsigapplicationCrForm.setDepartmentHead(entity.getDepartmentHead());
        List OaCdSignLetterList = JsonUtil.getJsonToList(oacdsigapplicationCrForm.getOaCdSignLetterList(), OaCdSignLetterEntity.class);
        for (OaCdSignLetterEntity entitys : OaCdSignLetterList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setParentId(entity.getId());
            this.oaCdSignLetterService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)oacdsigapplicationCrForm.getTaskId(), (String)flowEngineId, (String)oacdsigapplicationCrForm.getTemplateId(), (String)mainId, (Object)((Object)oacdsigapplicationCrForm), (Integer)oacdsigapplicationCrForm.getStatus(), (String)oacdsigapplicationCrForm.getApplicationTitle());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OacdsigapplicationInfoVO> info(@PathVariable(value="id") String id) {
        System.out.println("===========================================>");
        OacdsigapplicationEntity entity = this.oaCdSignApplicationService.getInfo(id);
        OacdsigapplicationInfoVO vo = (OacdsigapplicationInfoVO)JsonUtil.getJsonToBean((Object)entity, OacdsigapplicationInfoVO.class);
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setDepartmentHead(entity.getDepartmentHead());
        vo.setDepartmentHeadName(this.baseDataUtil.userSelectValue(vo.getDepartmentHead()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        vo.setCreatorDept(this.baseDataUtil.comSelectValue(vo.getCreatorDept(), "last"));
        vo.setOaTypeName(this.baseDataUtil.getDictName(vo.getOaType(), "513972314862257413"));
        vo.setSendingRangeTypeName(this.baseDataUtil.getDictName(vo.getSendingRangeType(), "sendingRangeType"));
        if (StringUtils.isNotEmpty((String)vo.getSendingRangeUser())) {
            vo.setSendingRangeUserName(this.baseDataUtil.userSelectValues(vo.getSendingRangeUser()));
        }
        if (StringUtils.isNotEmpty((String)vo.getSendingRangeDept())) {
            vo.setSendingRangeDeptName(this.baseDataUtil.comSelectValues(vo.getSendingRangeDept()));
        }
        List<OaCdSignLetterEntity> OaCdSignLetterList = this.oaCdSignApplicationService.GetOaCdSignLetterList(id);
        for (OaCdSignLetterEntity oaCdSignLetterEntity : OaCdSignLetterList) {
        }
        vo.setOaCdSignLetterList(JsonUtil.getJsonToList(OaCdSignLetterList, OaCdSignLetterModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OacdsigapplicationUpForm oacdsigapplicationUpForm = (OacdsigapplicationUpForm)((Object)JsonUtil.getJsonToBean(upData, OacdsigapplicationUpForm.class));
        String flowEngineId = "501393514001597445";
        UserInfo userInfo = this.userProvider.get();
        OacdsigapplicationEntity entity = this.oaCdSignApplicationService.getInfo(id);
        if (entity != null) {
            List<String> userList;
            List<String> departmentList;
            oacdsigapplicationUpForm.setLastModifyUserId(userInfo.getUserId());
            oacdsigapplicationUpForm.setLastModifyTime(DateUtil.getNow());
            oacdsigapplicationUpForm.setCreatorDept(entity.getCreatorDept());
            oacdsigapplicationUpForm.setDepartmentHead(entity.getDepartmentHead());
            if (StringUtils.isNotEmpty((String)oacdsigapplicationUpForm.getSendingRangeDept()) && CollectionUtil.isNotEmpty(departmentList = Arrays.asList(oacdsigapplicationUpForm.getSendingRangeDept().replace("\"", "").replace("[", "").replace("]", "").split(",")))) {
                oacdsigapplicationUpForm.setSendingRangeDept(String.join((CharSequence)",", departmentList));
            }
            if (StringUtils.isNotEmpty((String)oacdsigapplicationUpForm.getSendingRangeUser()) && CollectionUtil.isNotEmpty(userList = Arrays.asList(oacdsigapplicationUpForm.getSendingRangeUser().replace("\"", "").replace("[", "").replace("]", "").split(",")))) {
                oacdsigapplicationUpForm.setSendingRangeUser(String.join((CharSequence)",", userList));
            }
            OacdsigapplicationEntity subentity = (OacdsigapplicationEntity)JsonUtil.getJsonToBean((Object)((Object)oacdsigapplicationUpForm), OacdsigapplicationEntity.class);
            subentity.setCreatorTime(entity.getCreatorTime());
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setWhetherMultiple("0");
            subentity.setMultipleDepartmentHead("[]");
            subentity.setCompanyId(userInfo.getOrganizeId());
            oacdsigapplicationUpForm.setWhetherMultiple("0");
            if (entity.getOaType().equals("lczd")) {
                if (ObjectUtil.isNotEmpty(oacdsigapplicationUpForm.getMultipleDepartment())) {
                    ArrayList<String> multiDepartmentHead = new ArrayList<String>();
                    for (String str : oacdsigapplicationUpForm.getMultipleDepartment()) {
                        OrganizeEntity organizeServiceInfo = this.organizeService.getInfo(str);
                        if (!ObjectUtil.isNotEmpty((Object)organizeServiceInfo) || !StringUtils.isNotEmpty((String)organizeServiceInfo.getManagerId())) continue;
                        multiDepartmentHead.add(organizeServiceInfo.getManagerId());
                    }
                    multiDepartmentHead.remove(entity.getDepartmentHead());
                    subentity.setMultipleDepartmentHead(JsonUtil.getObjectToString(multiDepartmentHead));
                    oacdsigapplicationUpForm.setMultipleDepartmentHead(JsonUtil.getObjectToString(multiDepartmentHead));
                    subentity.setWhetherMultiple("1");
                    oacdsigapplicationUpForm.setWhetherMultiple("1");
                }
                subentity.setDepartmentHead(entity.getDepartmentHead());
            }
            this.oaCdSignApplicationService.update(id, subentity);
            QueryWrapper OaCdSignLetterqueryWrapper = new QueryWrapper();
            OaCdSignLetterqueryWrapper.lambda().eq(OaCdSignLetterEntity::getParentId, (Object)entity.getId());
            this.oaCdSignLetterService.remove((Wrapper)OaCdSignLetterqueryWrapper);
            List OaCdSignLetterList = JsonUtil.getJsonToList(oacdsigapplicationUpForm.getOaCdSignLetterList(), OaCdSignLetterEntity.class);
            for (OaCdSignLetterEntity entitys : OaCdSignLetterList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(entity.getId());
                this.oaCdSignLetterService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)oacdsigapplicationUpForm.getTaskId(), (String)flowEngineId, (String)oacdsigapplicationUpForm.getTemplateId(), (String)id, (Object)((Object)oacdsigapplicationUpForm), (Integer)oacdsigapplicationUpForm.getStatus(), (String)oacdsigapplicationUpForm.getApplicationTitle());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OacdsigapplicationEntity entity = this.oaCdSignApplicationService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaCdSignApplicationService.delete(entity);
            QueryWrapper queryWrapperOaCdSignLetter = new QueryWrapper();
            queryWrapperOaCdSignLetter.lambda().eq(OaCdSignLetterEntity::getParentId, (Object)entity.getId());
            this.oaCdSignLetterService.remove((Wrapper)queryWrapperOaCdSignLetter);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getMaxLetter/{officeType}"})
    public ActionResult getMaxLetter(@PathVariable(value="officeType") String officeType) {
        HashMap<String, Object> temp = new HashMap<String, Object>();
        Integer year = Calendar.getInstance().get(1);
        if (officeType == null || officeType.equals("999")) {
            String maxLetter = "\u8363\u79d1\u79d1\u6280\u51fd\u3014" + year + "\u3015";
            List<OaCdSignLetterEntity> list = this.oaCdSignLetterService.getAllList(maxLetter);
            String maxSize = list.size() + "";
            if (list.size() > 0) {
                OaCdSignLetterEntity maxOne = list.get(0);
                if (maxOne != null && StringUtils.isNotEmpty((String)maxOne.getLetterNumber())) {
                    maxSize = maxOne.getLetterNumber().replaceAll(maxLetter, "").replace("\u53f7", "");
                    maxLetter = "\u8363\u79d1\u79d1\u6280\u51fd\u3014" + year + "\u3015" + String.format("%02d", Integer.parseInt(maxSize) + 1) + "\u53f7";
                } else {
                    maxLetter = "\u8363\u79d1\u79d1\u6280\u51fd\u3014" + year + "\u301501\u53f7";
                }
            } else {
                maxLetter = "\u8363\u79d1\u79d1\u6280\u51fd\u3014" + year + "\u301501\u53f7";
            }
            temp.put("maxLetter", maxLetter);
            temp.put("maxSize", maxSize);
        } else {
            String maxLetter = this.getLetterWord(officeType) + "\u3014" + year + "\u3015";
            List<OacdsigapplicationEntity> list = this.oaCdSignApplicationService.getAllList(maxLetter);
            maxLetter = list.size() > 0 ? maxLetter + String.format("%02d", list.size() + 1) + "\u53f7" : maxLetter + "01\u53f7";
            temp.put("maxLetter", maxLetter);
            temp.put("maxSize", 1);
        }
        return ActionResult.success(temp);
    }

    private String getLetterWord(String keyWord) {
        String res = "";
        DictionaryDataEntity swapInfo = this.dictionaryDataService.getSwapInfo(keyWord, "507575181611373061");
        if (!ObjectUtil.isEmpty((Object)swapInfo)) {
            res = swapInfo.getFullName();
        }
        return res;
    }

    @PostMapping(value={"/letterList"})
    public ActionResult LetterList(@RequestBody OacdsigapplicationPagination oacdsigapplicationPagination) throws IOException {
        oacdsigapplicationPagination.setEnableMark("2");
        oacdsigapplicationPagination.setOaType("8");
        List<OacdsigapplicationEntity> list = this.oaCdSignApplicationService.getList(oacdsigapplicationPagination);
        for (OacdsigapplicationEntity oacdsigapplicationEntity : list) {
            oacdsigapplicationEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oacdsigapplicationEntity.getCreatorUserId()));
            oacdsigapplicationEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(oacdsigapplicationEntity.getLastModifyUserId()));
            oacdsigapplicationEntity.setCreatorDept(this.baseDataUtil.comSelectValue(oacdsigapplicationEntity.getCreatorDept(), "last"));
            oacdsigapplicationEntity.setIsCeo(this.baseDataUtil.switchSelectValue(oacdsigapplicationEntity.getIsCeo(), "\u5f00", "\u5173"));
            oacdsigapplicationEntity.setOaUploads(this.baseDataUtil.getFileNameInJson(oacdsigapplicationEntity.getOaUploads()));
        }
        List listVO = JsonUtil.getJsonToList(list, OacdsigapplicationListVO.class);
        for (OacdsigapplicationListVO oacdsigapplicationListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oacdsigapplicationPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }
}

