/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkContractVerifyEntity;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractVerifyService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.oa.entity.RkContractInternalTransactionEntity;
import com.bringspring.oa.model.rkContractInternalTransaction.RkContractInternalTransactionCrForm;
import com.bringspring.oa.model.rkContractInternalTransaction.RkContractInternalTransactionInfoVO;
import com.bringspring.oa.model.rkContractInternalTransaction.RkContractInternalTransactionListVO;
import com.bringspring.oa.model.rkContractInternalTransaction.RkContractInternalTransactionPagination;
import com.bringspring.oa.model.rkContractInternalTransaction.RkContractInternalTransactionPaginationExportModel;
import com.bringspring.oa.model.rkContractInternalTransaction.RkContractInternalTransactionUpForm;
import com.bringspring.oa.service.RkContractInternalTransactionService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5206\u5b50\u516c\u53f8\u5185\u90e8\u5f80\u6765\u5408\u540c"}, value="oa")
@RequestMapping(value={"/api/oa/RkContractInternalTransaction"})
public class RkContractInternalTransactionController {
    private static final Logger log = LoggerFactory.getLogger(RkContractInternalTransactionController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractInternalTransactionService rkContractInternalTransactionService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkContractVerifyService rkContractVerifyService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private ServiceAllUtil serviceAllUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractInternalTransactionPagination RkContractInternalTransactionPagination2) throws IOException {
        List<RkContractInternalTransactionEntity> list = this.rkContractInternalTransactionService.getList(RkContractInternalTransactionPagination2);
        List listVO = JsonUtil.getJsonToList(list, RkContractInternalTransactionListVO.class);
        for (RkContractInternalTransactionListVO vo : listVO) {
            String contractCustomer;
            vo.setApplyUser(this.baseDataUtil.userSelectValues(vo.getApplyUserId()));
            vo.setContractCustomerName(this.baseDataUtil.getDictName(vo.getContractCustomer(), "ContractInternalTransactionSignSubject"));
            vo.setContractCompanyName(this.baseDataUtil.getDictName(vo.getContractCompany(), "ContractInternalTransactionSignSubject"));
            vo.setMountTypeName(this.baseDataUtil.getDictName(vo.getMountType(), "internalContractMountType"));
            vo.setServiceDeptName(this.baseDataUtil.comSelectValue(vo.getServiceDept(), "1"));
            if (ObjectUtil.isNotEmpty((Object)vo.getContractSaler())) {
                vo.setContractSalerName(this.serviceAllUtil.getUserInfo(vo.getContractSaler()).getRealName());
            }
            if (!StringUtils.isNotEmpty((String)(contractCustomer = vo.getContractCustomerName()))) continue;
            List<String> names = Arrays.asList(contractCustomer.split(","));
            List ids = CollectionUtil.list((boolean)false);
            for (String name : names) {
                CrmCustomerEntity crmCustomerEntity = this.crmCustomerService.getInfoByFullName(name);
                if (!ObjectUtil.isNotEmpty((Object)crmCustomerEntity)) continue;
                ids.add(crmCustomerEntity.getId());
            }
            vo.setPartyAs(ids.stream().collect(Collectors.joining(",")));
        }
        for (RkContractInternalTransactionListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)RkContractInternalTransactionPagination2), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        RkContractInternalTransactionCrForm RkContractInternalTransactionCrForm2 = (RkContractInternalTransactionCrForm)JsonUtil.getJsonToBean(crData, RkContractInternalTransactionCrForm.class);
        String visualId = "607909831784819909";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkContractInternalTransactionEntity entity = (RkContractInternalTransactionEntity)JsonUtil.getJsonToBean((Object)RkContractInternalTransactionCrForm2, RkContractInternalTransactionEntity.class);
        entity.setId(mainId);
        this.rkContractInternalTransactionService.save(entity);
        FlowUtil.saveOrSubmit((String)RkContractInternalTransactionCrForm2.getTaskId(), (String)visualId, (String)RkContractInternalTransactionCrForm2.getTemplateId(), (String)mainId, (Object)RkContractInternalTransactionCrForm2, (Integer)RkContractInternalTransactionCrForm2.getStatus(), (String)"");
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkContractInternalTransactionPaginationExportModel RkContractInternalTransactionPaginationExportModel2) throws IOException {
        if (StringUtils.isEmpty((String)RkContractInternalTransactionPaginationExportModel2.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractInternalTransactionPagination RkContractInternalTransactionPagination2 = (RkContractInternalTransactionPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)RkContractInternalTransactionPaginationExportModel2), RkContractInternalTransactionPagination.class));
        List<RkContractInternalTransactionEntity> list = this.rkContractInternalTransactionService.getTypeList(RkContractInternalTransactionPagination2, RkContractInternalTransactionPaginationExportModel2.getDataType());
        for (RkContractInternalTransactionEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractInternalTransactionListVO.class);
        for (RkContractInternalTransactionListVO rkContractInternalTransactionListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)RkContractInternalTransactionPaginationExportModel2.getSelectKey()) ? RkContractInternalTransactionPaginationExportModel2.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block20: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"creatorUserId"));
                        continue block20;
                    }
                    case "creatorDeptId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u90e8\u95e8", (Object)"creatorDeptId"));
                        continue block20;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65e5\u671f", (Object)"creatorTime"));
                        continue block20;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block20;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractInternalTransactionInfoVO> info(@PathVariable(value="id") String id) {
        RkContractInternalTransactionEntity entity = this.rkContractInternalTransactionService.getInfo(id);
        RkContractInternalTransactionInfoVO vo = (RkContractInternalTransactionInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractInternalTransactionInfoVO.class);
        vo.setApplyUserId(this.baseDataUtil.userSelectValues(vo.getApplyUserId()));
        vo.setContractCustomerName(this.baseDataUtil.getDictName(vo.getContractCustomer(), "ContractInternalTransactionSignSubject"));
        vo.setContractCompanyName(this.baseDataUtil.getDictName(vo.getContractCompany(), "ContractInternalTransactionSignSubject"));
        vo.setMountTypeName(this.baseDataUtil.getDictName(vo.getMountType(), "internalContractMountType"));
        vo.setServiceDeptName(this.baseDataUtil.comSelectValue(vo.getServiceDept(), "1"));
        vo.setServiceUserName(this.baseDataUtil.userSelectValues(vo.getServiceUser()));
        if (StrUtil.isNotEmpty((CharSequence)vo.getContractSealTypeName())) {
            List sealType = JsonUtil.getJsonToList((String)vo.getContractSealType(), String.class);
            vo.setContractSealTypeName(sealType.stream().collect(Collectors.joining(",")));
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detailinfo/{id}"})
    public ActionResult<RkContractInternalTransactionInfoVO> detailinfo(@PathVariable(value="id") String id) {
        RkContractInternalTransactionEntity entity = this.rkContractInternalTransactionService.getInfo(id);
        RkContractInternalTransactionInfoVO vo = (RkContractInternalTransactionInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractInternalTransactionInfoVO.class);
        vo.setContractCustomerName(this.baseDataUtil.getDictName(vo.getContractCustomer(), "ContractInternalTransactionSignSubject"));
        vo.setContractCompanyName(this.baseDataUtil.getDictName(vo.getContractCompany(), "ContractInternalTransactionSignSubject"));
        vo.setMountTypeName(this.baseDataUtil.getDictName(vo.getMountType(), "internalContractMountType"));
        vo.setServiceDeptName(this.baseDataUtil.comSelectValue(vo.getServiceDept(), "1"));
        vo.setServiceUserName(this.baseDataUtil.userSelectValues(vo.getServiceUser()));
        if (StrUtil.isNotEmpty((CharSequence)vo.getContractSealTypeName())) {
            List sealType = JsonUtil.getJsonToList((String)vo.getContractSealType(), String.class);
            vo.setContractSealTypeName(sealType.stream().collect(Collectors.joining(",")));
        }
        QueryWrapper rkContractEntityQueryWrapper1 = new QueryWrapper();
        rkContractEntityQueryWrapper1.lambda().eq(RkContractEntity::getInternalContractId, (Object)id);
        List rkContractList = this.rkContractService.list((Wrapper)rkContractEntityQueryWrapper1);
        if (CollectionUtil.isNotEmpty((Collection)rkContractList)) {
            RkContractEntity entity1 = (RkContractEntity)rkContractList.get(0);
            vo.setContractCode(entity1.getContractCode());
            vo.setContractName(entity1.getContractName());
            vo.setContractMount(entity1.getContractAmount());
            vo.setContractLevel(entity1.getContractLevel());
            vo.setContractType(this.baseDataUtil.getDictName(entity1.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            vo.setContractSignDate(entity1.getSignDate());
            vo.setContractSaler(this.baseDataUtil.userSelectValue(entity1.getSalerId()));
            vo.setContractDept(entity1.getDepartmentTreeName());
            vo.setContractSaleArea(entity1.getRegionName());
            if (ObjectUtil.isNotEmpty((Object)entity1.getStartContractTime())) {
                ArrayList<String> excuteDate = new ArrayList<String>();
                excuteDate.add(String.valueOf(entity1.getStartContractTime().getTime()));
                excuteDate.add(String.valueOf(entity1.getEndContractTime().getTime()));
                vo.setContractExcuteDate(JsonUtil.getObjectToString(excuteDate));
            }
            vo.setContractTax(entity1.getContractTaxRate());
            vo.setContractPayMethod(entity1.getPaymentMethod());
            vo.setContractBuyOrSale("XS");
        } else {
            QueryWrapper rkContractEntityQueryWrapper = new QueryWrapper();
            rkContractEntityQueryWrapper.lambda().eq(RkContractVerifyEntity::getInternalContractId, (Object)id);
            List rkContractVerifyList = this.rkContractVerifyService.list((Wrapper)rkContractEntityQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)rkContractVerifyList)) {
                RkContractVerifyEntity entity1 = (RkContractVerifyEntity)rkContractVerifyList.get(0);
                vo.setContractCode(entity1.getContractCode());
                vo.setContractName(entity1.getContractName());
                vo.setContractMount(entity1.getContractAmount());
                vo.setContractLevel(entity1.getContractLevel());
                vo.setContractType(this.baseDataUtil.getDictName(entity1.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
                vo.setContractSignDate(entity1.getSignDate());
                vo.setContractSaler(this.baseDataUtil.userSelectValue(entity1.getSalerId()));
                vo.setContractDept(entity1.getDepartmentTreeName());
                vo.setContractSaleArea(entity1.getRegionName());
                if (ObjectUtil.isNotEmpty((Object)entity1.getStartContractTime())) {
                    ArrayList<String> excuteDate = new ArrayList<String>();
                    excuteDate.add(String.valueOf(entity1.getStartContractTime().getTime()));
                    excuteDate.add(String.valueOf(entity1.getEndContractTime().getTime()));
                    vo.setContractExcuteDate(JsonUtil.getObjectToString(excuteDate));
                }
                vo.setContractTax(entity1.getContractTaxRate());
                vo.setContractPayMethod(entity1.getPaymentMethod());
                vo.setContractBuyOrSale("XS");
                List attachmentEntityList = this.attachmentService.getListByContractIdAndFileType(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
                List attachmentList = JsonUtil.getJsonToList((Object)attachmentEntityList, RkAttachmentCrForm.class);
                if (CollectionUtil.isNotEmpty((Collection)attachmentList)) {
                    vo.setContractText(attachmentList.toString());
                }
            } else {
                QueryWrapper rkContractProcureEntityQueryWrapper = new QueryWrapper();
                rkContractProcureEntityQueryWrapper.lambda().eq(RkContractProcureEntity::getInternalContractId, (Object)id);
                List rkContractProcureList = this.rkContractProcureService.list((Wrapper)rkContractProcureEntityQueryWrapper);
                if (CollectionUtil.isNotEmpty((Collection)rkContractProcureList)) {
                    RkContractProcureEntity entity1 = (RkContractProcureEntity)rkContractProcureList.get(0);
                    vo.setContractCode(entity1.getProcureCode());
                    vo.setContractName(entity1.getProcureName());
                    vo.setContractMount(entity1.getProcureAmount());
                    vo.setContractPayMethod(entity1.getPaymentMethod());
                    vo.setContractBuyOrSale("CG");
                    vo.setContractText(entity1.getAttachmentList().toString());
                }
            }
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        RkContractInternalTransactionUpForm RkContractInternalTransactionUpForm2 = (RkContractInternalTransactionUpForm)JsonUtil.getJsonToBean(upData, RkContractInternalTransactionUpForm.class);
        String visualId = "607909831784819909";
        UserInfo userInfo = this.userProvider.get();
        RkContractInternalTransactionEntity entity = this.rkContractInternalTransactionService.getInfo(id);
        if (entity != null) {
            RkContractInternalTransactionEntity subentity = (RkContractInternalTransactionEntity)JsonUtil.getJsonToBean((Object)RkContractInternalTransactionUpForm2, RkContractInternalTransactionEntity.class);
            this.rkContractInternalTransactionService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)RkContractInternalTransactionUpForm2.getTaskId(), (String)visualId, (String)RkContractInternalTransactionUpForm2.getTemplateId(), (String)id, (Object)RkContractInternalTransactionUpForm2, (Integer)RkContractInternalTransactionUpForm2.getStatus(), (String)"");
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkContractInternalTransactionEntity entity = this.rkContractInternalTransactionService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.rkContractInternalTransactionService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

