/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.model.oafile.FileImportReturnVO;
import com.bringspring.contract.model.oafile.FileImportVO;
import com.bringspring.contract.model.rkattachment.RkAttachmentUpForm;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Records;
import com.bringspring.oa.entity.OaFileRecordEntity;
import com.bringspring.oa.mapper.OaFileRecordMapper;
import com.bringspring.oa.model.oafilerecord.OaFileRecordPagination;
import com.bringspring.oa.model.oafilerecord.OaFileRecordUpForm;
import com.bringspring.oa.service.OaFileRecordService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaFileRecordServiceImpl
extends ServiceImpl<OaFileRecordMapper, OaFileRecordEntity>
implements OaFileRecordService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public List<OaFileRecordEntity> getList(OaFileRecordPagination oaFileRecordPagination) {
        Object oaFileRecordObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaFileRecordNum = 0;
        QueryWrapper oaFileRecordQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaFileRecordObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaFileRecordQueryWrapper, oaFileRecordPagination.getMenuId(), "oaFileRecord"));
            if (ObjectUtil.isEmpty((Object)oaFileRecordObj)) {
                return new ArrayList<OaFileRecordEntity>();
            }
            oaFileRecordQueryWrapper = (QueryWrapper)oaFileRecordObj;
            ++oaFileRecordNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaFileRecordObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaFileRecordQueryWrapper, oaFileRecordPagination.getMenuId(), "oaFileRecord"));
            if (ObjectUtil.isEmpty((Object)oaFileRecordObj)) {
                return new ArrayList<OaFileRecordEntity>();
            }
            oaFileRecordQueryWrapper = (QueryWrapper)oaFileRecordObj;
            ++oaFileRecordNum;
        }
        if (StringUtils.isNotEmpty((String)oaFileRecordPagination.getFileCode())) {
            ++oaFileRecordNum;
            oaFileRecordQueryWrapper.lambda().like(OaFileRecordEntity::getFileCode, (Object)oaFileRecordPagination.getFileCode());
        }
        if (StringUtils.isNotEmpty((String)oaFileRecordPagination.getChoseType())) {
            ++oaFileRecordNum;
            oaFileRecordQueryWrapper.lambda().eq(OaFileRecordEntity::getChoseType, (Object)oaFileRecordPagination.getChoseType());
        }
        if (StringUtils.isNotEmpty((String)oaFileRecordPagination.getFileName())) {
            ++oaFileRecordNum;
            oaFileRecordQueryWrapper.lambda().like(OaFileRecordEntity::getFileName, (Object)oaFileRecordPagination.getFileName());
        }
        if (StringUtils.isNotEmpty((String)oaFileRecordPagination.getRecordStatus())) {
            ++oaFileRecordNum;
            oaFileRecordQueryWrapper.lambda().eq(OaFileRecordEntity::getRecordStatus, (Object)oaFileRecordPagination.getRecordStatus());
        }
        if (AllIdList.size() > 0) {
            oaFileRecordQueryWrapper.lambda().in(OaFileRecordEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaFileRecordPagination.getSidx())) {
            oaFileRecordQueryWrapper.lambda().orderByDesc(OaFileRecordEntity::getFileDate);
        } else {
            try {
                String sidx = oaFileRecordPagination.getSidx();
                OaFileRecordEntity oaFileRecordEntity = new OaFileRecordEntity();
                Field declaredField = oaFileRecordEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaFileRecordQueryWrapper = "asc".equals(oaFileRecordPagination.getSort().toLowerCase()) ? (QueryWrapper)oaFileRecordQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaFileRecordQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(oaFileRecordPagination.getCurrentPage(), oaFileRecordPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)oaFileRecordQueryWrapper);
            return oaFileRecordPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return oaFileRecordPagination.setData(list, list.size());
    }

    @Override
    public List<OaFileRecordEntity> getTypeList(OaFileRecordPagination oaFileRecordPagination, String dataType) {
        Object oaFileRecordObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaFileRecordNum = 0;
        QueryWrapper oaFileRecordQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaFileRecordObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaFileRecordQueryWrapper, oaFileRecordPagination.getMenuId(), "oaFileRecord"));
            if (ObjectUtil.isEmpty((Object)oaFileRecordObj)) {
                return new ArrayList<OaFileRecordEntity>();
            }
            oaFileRecordQueryWrapper = (QueryWrapper)oaFileRecordObj;
            ++oaFileRecordNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaFileRecordObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaFileRecordQueryWrapper, oaFileRecordPagination.getMenuId(), "oaFileRecord"));
            if (ObjectUtil.isEmpty((Object)oaFileRecordObj)) {
                return new ArrayList<OaFileRecordEntity>();
            }
            oaFileRecordQueryWrapper = (QueryWrapper)oaFileRecordObj;
            ++oaFileRecordNum;
        }
        if (StringUtils.isNotEmpty((String)oaFileRecordPagination.getFileCode())) {
            ++oaFileRecordNum;
            oaFileRecordQueryWrapper.lambda().like(OaFileRecordEntity::getFileCode, (Object)oaFileRecordPagination.getFileCode());
        }
        if (StringUtils.isNotEmpty((String)oaFileRecordPagination.getChoseType())) {
            ++oaFileRecordNum;
            oaFileRecordQueryWrapper.lambda().eq(OaFileRecordEntity::getChoseType, (Object)oaFileRecordPagination.getChoseType());
        }
        if (StringUtils.isNotEmpty((String)oaFileRecordPagination.getFileName())) {
            ++oaFileRecordNum;
            oaFileRecordQueryWrapper.lambda().like(OaFileRecordEntity::getFileName, (Object)oaFileRecordPagination.getFileName());
        }
        if (StringUtils.isNotEmpty((String)oaFileRecordPagination.getRecordStatus())) {
            ++oaFileRecordNum;
            oaFileRecordQueryWrapper.lambda().like(OaFileRecordEntity::getRecordStatus, (Object)oaFileRecordPagination.getRecordStatus());
        }
        if (AllIdList.size() > 0) {
            oaFileRecordQueryWrapper.lambda().in(OaFileRecordEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaFileRecordPagination.getSidx())) {
            oaFileRecordQueryWrapper.lambda().orderByDesc(OaFileRecordEntity::getFileDate);
        } else {
            try {
                String sidx = oaFileRecordPagination.getSidx();
                OaFileRecordEntity oaFileRecordEntity = new OaFileRecordEntity();
                Field declaredField = oaFileRecordEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaFileRecordQueryWrapper = "asc".equals(oaFileRecordPagination.getSort().toLowerCase()) ? (QueryWrapper)oaFileRecordQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaFileRecordQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(oaFileRecordPagination.getCurrentPage(), oaFileRecordPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)oaFileRecordQueryWrapper);
                return oaFileRecordPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return oaFileRecordPagination.setData(list, list.size());
        }
        return this.list((Wrapper)oaFileRecordQueryWrapper);
    }

    @Override
    public boolean updateFile(String id, OaFileRecordUpForm oaFileRecordUpForm) {
        if (CollectionUtil.isNotEmpty(oaFileRecordUpForm.getAttachmentList())) {
            this.rkAttachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
            List<RkAttachmentUpForm> attachmentList = oaFileRecordUpForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(id);
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
            this.rkAttachmentService.saveBatch((Collection)attachmentEntityList);
        }
        OaFileRecordEntity entity = (OaFileRecordEntity)JsonUtil.getJsonToBean((Object)oaFileRecordUpForm, OaFileRecordEntity.class);
        entity.setChoseTypeName(this.baseDataUtil.getDictName(entity.getChoseType(), Records.CHOSE_TYPE_DICT));
        entity.setRecordPatternName(this.baseDataUtil.getDictName(entity.getRecordPattern(), Records.RECORD_PATTERN_DICT));
        entity.setRecordStatusName(this.baseDataUtil.getDictName(entity.getRecordStatus(), Records.RECORD_STATUS_DICT));
        entity.setSecrecyLevelName(this.baseDataUtil.getDictName(entity.getSecrecyLevel(), Records.SECRECY_LEVEL_DICT));
        entity.setRelationTypeName(this.baseDataUtil.getDictName(entity.getRelationType(), Records.RELATION_TYPE_DICT));
        entity.setIsEdit(1);
        return this.updateById(entity);
    }

    @Override
    public OaFileRecordEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaFileRecordEntity::getId, (Object)id);
        return (OaFileRecordEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaFileRecordEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaFileRecordEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public Map<String, Object> importPreview(List<FileImportVO> fileImportList) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < fileImportList.size(); ++i) {
            Map dataRowMap = new HashMap();
            FileImportVO fileImportVO = fileImportList.get(i);
            dataRowMap = (Map)JsonUtil.getJsonToBean((Object)fileImportVO, Map.class);
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= fileImportList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", fileImportList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u7c7b\u578b");
        map.put(2, "\u5458\u5de5\u7f16\u7801");
        map.put(3, "\u5f52\u6863\u7c7b\u578b");
        map.put(4, "\u6863\u6848\u540d\u79f0");
        map.put(5, "\u4efd\u6570");
        map.put(6, "\u5f62\u6001");
        map.put(7, "\u4fdd\u5bc6\u7ea7\u522b");
        map.put(8, "\u5f52\u6863\u7f16\u7801");
        map.put(9, "\u5f52\u6863\u540d\u79f0");
        map.put(10, "\u5f52\u6863\u4f4d\u7f6e");
        map.put(11, "\u6863\u6848\u7f16\u7801");
        return (String)map.get(key);
    }

    @Override
    public FileImportReturnVO importData(List<FileImportVO> dataList) {
        UserInfo userInfo = this.userProvider.get();
        String companyId = userInfo.getOrganizeId();
        List errorList = CollectionUtil.list((boolean)false);
        boolean sum = false;
        int errNum = 0;
        List errorMsgList = CollectionUtil.list((boolean)false);
        for (FileImportVO fileImportVO : dataList) {
            if (!CollectionUtil.isNotEmpty((Collection)errorMsgList)) continue;
            fileImportVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
            fileImportVO.setErrMsgList(errorMsgList);
            errorMsgList = CollectionUtil.list((boolean)false);
            errorList.add(fileImportVO);
        }
        FileImportReturnVO vo = new FileImportReturnVO();
        vo.setSnum(dataList.size());
        vo.setFnum(errNum);
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, FileImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @Override
    public List<OaFileRecordEntity> getListByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaFileRecordEntity::getRecordCode, (Object)code);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void delete(OaFileRecordEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

