/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectAcceptEntity;
import com.bringspring.contract.entity.RkProjectTrendsEntity;
import com.bringspring.contract.model.rkcontractproject.OaAcceptModel;
import com.bringspring.contract.service.OaAcceptService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectAcceptService;
import com.bringspring.contract.service.RkProjectTrendsService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.ProjectConfirmIncomeStatus;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.contract.utils.ProjectTrendsEnum;
import com.bringspring.oa.entity.OaAcceptRemainWorkEntity;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectAcceptApplyEntity;
import com.bringspring.oa.mapper.OaProjectAcceptApplyMapper;
import com.bringspring.oa.model.oaprojectacceptapply.OaProjectAcceptApplyCrForm;
import com.bringspring.oa.model.oaprojectacceptapply.OaProjectAcceptApplyUpForm;
import com.bringspring.oa.service.OaAcceptRemainWorkService;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectAcceptApplyService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaProjectAcceptApplyServiceImpl
extends ServiceImpl<OaProjectAcceptApplyMapper, OaProjectAcceptApplyEntity>
implements OaProjectAcceptApplyService,
OaAcceptService {
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkProjectAcceptService rkProjectAcceptService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkProjectTrendsService rkProjectTrendsService;
    @Autowired
    private OaAcceptRemainWorkService oaAcceptRemainWorkService;
    @Autowired
    private UserService userService;

    @Override
    public OaProjectAcceptApplyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectAcceptApplyEntity::getId, (Object)id);
        return (OaProjectAcceptApplyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaProjectAcceptApplyEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaProjectAcceptApplyEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OaProjectAcceptApplyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    @DSTransactional
    public void saveAcceptApply(OaProjectAcceptApplyCrForm crForm) {
        List<OaAttachmentEntity> projectScreenshotList;
        List<OaAttachmentEntity> remarkAttachmentList;
        UserInfo userInfo = this.userProvider.get();
        OaProjectAcceptApplyEntity entity = (OaProjectAcceptApplyEntity)JsonUtil.getJsonToBean((Object)((Object)crForm), OaProjectAcceptApplyEntity.class);
        entity.setId(crForm.getMainId());
        entity.setCompanyId(userInfo.getOrganizeId());
        this.save(entity);
        if (CollectionUtil.isNotEmpty(crForm.getAttachmentList())) {
            List oaAttachmentEntityList = JsonUtil.getJsonToList(crForm.getAttachmentList(), OaAttachmentEntity.class);
            for (OaAttachmentEntity entitys : oaAttachmentEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setObjId(entity.getId());
                entitys.setFileType(AttachmentTypeEnum.PROJECT_ACCEPT_TYPE.getType());
                this.oaAttachmentService.save(entitys);
            }
        }
        if (CollectionUtil.isNotEmpty(remarkAttachmentList = crForm.getRemarkAttachmentList())) {
            remarkAttachmentList.stream().forEach(remark -> {
                remark.setContractId(entity.getId());
                remark.setFileType(AttachmentTypeEnum.PROJECT_ACCEPT_TYPE.getType());
            });
            List remarkList = JsonUtil.getJsonToList(remarkAttachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(remarkList);
        }
        if (CollectionUtil.isNotEmpty(projectScreenshotList = crForm.getProjectScreenshotList())) {
            projectScreenshotList.stream().forEach(screen -> {
                screen.setContractId(entity.getId());
                screen.setFileType("picture");
            });
            List screenShotList = JsonUtil.getJsonToList(projectScreenshotList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(screenShotList);
        }
    }

    @Override
    public void saveAcceptApply(String id, OaProjectAcceptApplyUpForm crForm) {
        OaProjectAcceptApplyEntity entity = (OaProjectAcceptApplyEntity)JsonUtil.getJsonToBean((Object)((Object)crForm), OaProjectAcceptApplyEntity.class);
        entity.setId(id);
        List<OaAcceptRemainWorkEntity> acceptRemainWorkList = crForm.getAcceptRemainWorkList();
        List<OaAcceptRemainWorkEntity> existList = this.oaAcceptRemainWorkService.listByAcceptId(id);
        if (CollectionUtil.isNotEmpty(existList)) {
            this.oaAcceptRemainWorkService.removeBatchByIds(existList);
        }
        acceptRemainWorkList.stream().forEach(remain -> {
            remain.setId(RandomUtil.uuId());
            remain.setAcceptId(id);
            remain.setCreatorTime(new Date());
            remain.setCreatorUserId(this.userProvider.get().getUserId());
        });
        this.oaAcceptRemainWorkService.saveBatch(acceptRemainWorkList);
        this.oaAttachmentService.deleteByObjId(entity.getId());
        List oaAttachmentEntityList = JsonUtil.getJsonToList(crForm.getAttachmentList(), OaAttachmentEntity.class);
        for (OaAttachmentEntity entitys : oaAttachmentEntityList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setObjId(entity.getId());
            entitys.setFileType(AttachmentTypeEnum.PROJECT_ACCEPT_TYPE.getType());
            this.oaAttachmentService.save(entitys);
        }
        this.oaAttachmentService.deleteByContractId(entity.getId());
        List<OaAttachmentEntity> remarkAttachmentList = crForm.getRemarkAttachmentList();
        remarkAttachmentList.stream().forEach(remark -> {
            remark.setContractId(entity.getId());
            remark.setFileType(AttachmentTypeEnum.PROJECT_ACCEPT_TYPE.getType());
        });
        List remarkList = JsonUtil.getJsonToList(remarkAttachmentList, OaAttachmentEntity.class);
        this.oaAttachmentService.saveBatch(remarkList);
        this.oaAttachmentService.deleteByContractId(entity.getId(), "picture");
        List<OaAttachmentEntity> projectScreenshotList = crForm.getProjectScreenshotList();
        projectScreenshotList.stream().forEach(screen -> {
            screen.setContractId(entity.getId());
            screen.setFileType("picture");
        });
        List screenShotList = JsonUtil.getJsonToList(projectScreenshotList, OaAttachmentEntity.class);
        this.oaAttachmentService.saveBatch(screenShotList);
    }

    @Override
    public List<OaProjectAcceptApplyEntity> getByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectAcceptApplyEntity::getProjectId, (Object)projectId);
        return this.list((Wrapper)queryWrapper);
    }

    public OaAcceptModel getInfoById(String acceptId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectAcceptApplyEntity::getId, (Object)acceptId);
        OaProjectAcceptApplyEntity entity = (OaProjectAcceptApplyEntity)this.getOne((Wrapper)queryWrapper);
        OaAcceptModel oaAcceptModel = (OaAcceptModel)JsonUtil.getJsonToBean((Object)entity, OaAcceptModel.class);
        return oaAcceptModel;
    }

    @Override
    public long countByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectAcceptApplyEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    @FlowCallBackMethod(fullName="\u9879\u76ee\u9a8c\u6536\u7533\u8bf7")
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel flowModel) {
        UserInfo userInfo = this.userProvider.get();
        OaProjectAcceptApplyEntity info = this.getInfo(id);
        if (ObjectUtil.isNotNull((Object)info)) {
            RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)info.getProjectId()));
            projectEntity.setAcceptApplyId(id);
            RkProjectTrendsEntity trendsEntity = new RkProjectTrendsEntity();
            trendsEntity.setCustomerId(projectEntity.getCustomerId());
            trendsEntity.setProjectId(projectEntity.getId());
            trendsEntity.setContractId(projectEntity.getContractId());
            trendsEntity.setId(RandomUtil.uuId());
            if (enableMark == 1) {
                trendsEntity.setNodeType(ProjectTrendsEnum.ACCEPTED_APPLY.getNode());
                trendsEntity.setNodeDesc(userInfo.getUserName() + "\u53d1\u8d77   \u9879\u76ee\u9a8c\u6536\u7533\u8bf7");
                trendsEntity.setDescription(info.getDescription());
                this.rkProjectTrendsService.save((Object)trendsEntity);
                projectEntity.setState(ProjectStateEnum.toBeAccepted_state.getState());
            }
            if (enableMark == 3 || enableMark == 5) {
                if (ObjectUtil.isNotNull((Object)projectEntity)) {
                    projectEntity.setState(ProjectStateEnum.inOperation_state.getState());
                }
                trendsEntity.setNodeType(ProjectTrendsEnum.ACCEPTED_APPLY.getNode());
                if (enableMark == 3) {
                    trendsEntity.setNodeDesc(userInfo.getUserName() + "\u64a4\u56de\u4e86\u9879\u76ee\u9a8c\u6536\u7533\u8bf7");
                }
                if (enableMark == 5) {
                    trendsEntity.setNodeDesc(userInfo.getUserName() + "\u62d2\u7edd\u4e86\u9879\u76ee\u9a8c\u6536\u7533\u8bf7");
                }
                this.rkProjectTrendsService.save((Object)trendsEntity);
            }
            if (enableMark == 2) {
                projectEntity.setState(ProjectStateEnum.accepted.getState());
                projectEntity.setIsAcceptance(Integer.valueOf(1));
                projectEntity.setAcceptedBy(info.getAcceptedBy());
                projectEntity.setAcceptanceTime(info.getAcceptedTime());
                projectEntity.setConfirmIncomeStatus(ProjectConfirmIncomeStatus.TO_BE_CONFIRMED.getStatus());
                projectEntity.setAllConfirmIncome(BigDecimal.ZERO);
                RkProjectAcceptEntity jsonToBean = (RkProjectAcceptEntity)JsonUtil.getJsonToBean((Object)info, RkProjectAcceptEntity.class);
                jsonToBean.setApprovedTime(DateUtil.getNowDate());
                this.rkProjectAcceptService.save((Object)jsonToBean);
                List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
                if (CollectionUtil.isNotEmpty(oaAttachmentEntityList)) {
                    List jsonToList = JsonUtil.getJsonToList(oaAttachmentEntityList, RkAttachmentEntity.class);
                    for (RkAttachmentEntity entity : jsonToList) {
                        entity.setProjectId(info.getProjectId());
                    }
                    this.rkAttachmentService.saveBatch((Collection)jsonToList);
                    projectEntity.setIsUploadAcceptFile(Integer.valueOf(1));
                }
                trendsEntity.setCreatorUserId(info.getCreatorUserId());
                trendsEntity.setNodeType(ProjectTrendsEnum.ACCEPTED_AUDIT.getNode());
                UserEntity userEntity = this.userService.getInfo(trendsEntity.getCreatorUserId());
                String userName = ObjectUtil.isNull((Object)userEntity) ? "" : userEntity.getRealName();
                trendsEntity.setNodeDesc(userName + "\u53d1\u8d77\u7684\u9a8c\u6536\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7");
                this.rkProjectTrendsService.save((Object)trendsEntity);
            }
            this.rkContractProjectService.updateById((Object)projectEntity);
        }
        return false;
    }
}

