/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectAuthorizationBussEntity;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectAuthorizationBussService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectAuthorizationEntity;
import com.bringspring.oa.mapper.OaProjectAuthorizationMapper;
import com.bringspring.oa.model.oaProjectAuthorization.OaProjectAuthorizationListVO;
import com.bringspring.oa.model.oaProjectAuthorization.OaProjectAuthorizationPagination;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectAuthorizationService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaProjectAuthorizationServiceImpl
extends ServiceImpl<OaProjectAuthorizationMapper, OaProjectAuthorizationEntity>
implements OaProjectAuthorizationService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OaProjectAuthorizationMapper oaProjectAuthorizationMapper;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkProjectAuthorizationBussService rkProjectAuthorizationBussService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkAttachmentService rkAttachmentService;

    @Override
    public List<OaProjectAuthorizationEntity> getList(OaProjectAuthorizationPagination OaProjectAuthorizationPagination2) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean rkProjectAuthorizationNum = false;
        QueryWrapper rkProjectAuthorizationQueryWrapper = this.appendWrapper(OaProjectAuthorizationPagination2);
        if (AllIdList.size() > 0) {
            rkProjectAuthorizationQueryWrapper.lambda().in(OaProjectAuthorizationEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)OaProjectAuthorizationPagination2.getSidx())) {
            rkProjectAuthorizationQueryWrapper.lambda().orderByDesc(OaProjectAuthorizationEntity::getAuthorizedDays);
        } else {
            try {
                String sidx = OaProjectAuthorizationPagination2.getSidx();
                OaProjectAuthorizationEntity OaProjectAuthorizationEntity2 = new OaProjectAuthorizationEntity();
                Field declaredField = OaProjectAuthorizationEntity2.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProjectAuthorizationQueryWrapper = "asc".equals(OaProjectAuthorizationPagination2.getSort().toLowerCase()) ? (QueryWrapper)rkProjectAuthorizationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProjectAuthorizationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(OaProjectAuthorizationPagination2.getCurrentPage(), OaProjectAuthorizationPagination2.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkProjectAuthorizationQueryWrapper);
            return OaProjectAuthorizationPagination2.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return OaProjectAuthorizationPagination2.setData(list, list.size());
    }

    @Override
    public List<OaProjectAuthorizationEntity> getTypeList(OaProjectAuthorizationPagination OaProjectAuthorizationPagination2, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean rkProjectAuthorizationNum = false;
        QueryWrapper rkProjectAuthorizationQueryWrapper = this.appendWrapper(OaProjectAuthorizationPagination2);
        if (AllIdList.size() > 0) {
            rkProjectAuthorizationQueryWrapper.lambda().in(OaProjectAuthorizationEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)OaProjectAuthorizationPagination2.getSidx())) {
            rkProjectAuthorizationQueryWrapper.lambda().orderByDesc(OaProjectAuthorizationEntity::getAuthorizedDays);
        } else {
            try {
                String sidx = OaProjectAuthorizationPagination2.getSidx();
                OaProjectAuthorizationEntity OaProjectAuthorizationEntity2 = new OaProjectAuthorizationEntity();
                Field declaredField = OaProjectAuthorizationEntity2.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProjectAuthorizationQueryWrapper = "asc".equals(OaProjectAuthorizationPagination2.getSort().toLowerCase()) ? (QueryWrapper)rkProjectAuthorizationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProjectAuthorizationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(OaProjectAuthorizationPagination2.getCurrentPage(), OaProjectAuthorizationPagination2.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkProjectAuthorizationQueryWrapper);
                return OaProjectAuthorizationPagination2.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return OaProjectAuthorizationPagination2.setData(list, list.size());
        }
        return this.list((Wrapper)rkProjectAuthorizationQueryWrapper);
    }

    @Override
    public OaProjectAuthorizationEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectAuthorizationEntity::getId, (Object)id);
        return (OaProjectAuthorizationEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaProjectAuthorizationEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaProjectAuthorizationEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public List<Map<String, Object>> countByAuthorizationResult(OaProjectAuthorizationPagination OaProjectAuthorizationPagination2) {
        QueryWrapper<OaProjectAuthorizationEntity> queryWrapper = this.appendWrapper(OaProjectAuthorizationPagination2);
        if (Objects.isNull(queryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        queryWrapper.select(new String[]{"count(*) as count,authorized_result as state"});
        queryWrapper.groupBy((Object)"authorized_result");
        List listMaps = this.listMaps((Wrapper)queryWrapper);
        return listMaps;
    }

    @Override
    public OaProjectAuthorizationListVO getOaProjectAuthorizationListVOInfoByProjectId(String projectId) {
        OaProjectAuthorizationListVO authorization = new OaProjectAuthorizationListVO();
        if (!StringUtils.isNotEmpty((String)projectId)) {
            return authorization;
        }
        authorization.setProductId(projectId);
        RkContractProjectEntity project = this.rkContractProjectService.getInfo(projectId);
        authorization = this.setProjectInfo(project, authorization);
        authorization = this.setAuthorizationOtherInfo(authorization);
        return authorization;
    }

    @Override
    public OaProjectAuthorizationListVO getOaProjectAuthorizationListVOInfoById(String id) {
        OaProjectAuthorizationEntity entity = this.getInfo(id);
        if (ObjectUtil.isEmpty((Object)entity)) {
            return null;
        }
        OaProjectAuthorizationListVO authorization = (OaProjectAuthorizationListVO)JsonUtil.getJsonToBean((Object)entity, OaProjectAuthorizationListVO.class);
        if (StringUtils.isNotEmpty((String)authorization.getProjectId())) {
            RkContractProjectEntity project = this.rkContractProjectService.getInfo(authorization.getProjectId());
            authorization = this.setProjectInfo(project, authorization);
        }
        authorization = this.setAuthorizationOtherInfo(authorization);
        return authorization;
    }

    @Override
    public List<OaProjectAuthorizationEntity> getByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectAuthorizationEntity::getProjectId, (Object)projectId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @FlowCallBackMethod(fullName="\u9879\u76ee\u6388\u6743\u7533\u8bf7")
    @DSTransactional
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel flowModel) {
        OaProjectAuthorizationEntity byId = this.getInfo(id);
        if (ObjectUtil.isNull((Object)byId)) {
            return false;
        }
        if (enableMark == 2) {
            RkContractProjectEntity info = this.rkContractProjectService.getInfo(byId.getProjectId());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                info.setAuthorizationApplyId("");
                this.rkContractProjectService.updateById((Object)info);
            }
            RkProjectAuthorizationBussEntity jsonToBean = (RkProjectAuthorizationBussEntity)JsonUtil.getJsonToBean((Object)byId, RkProjectAuthorizationBussEntity.class);
            this.rkProjectAuthorizationBussService.save((Object)jsonToBean);
            List<OaAttachmentEntity> oaAttachmentEntities = this.oaAttachmentService.listByBussinessObjId(byId.getId());
            if (CollectionUtil.isNotEmpty(oaAttachmentEntities)) {
                List jsonToList = JsonUtil.getJsonToList(oaAttachmentEntities, RkAttachmentEntity.class);
                for (RkAttachmentEntity entity : jsonToList) {
                    entity.setProjectId(info.getId());
                    entity.setFileType(AttachmentTypeEnum.PROJECT_AUTHORIZATION_TYPE.getType());
                }
                this.rkAttachmentService.saveBatch((Collection)jsonToList);
            }
        }
        return true;
    }

    @Override
    public long countByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectAuthorizationEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public List<OaProjectAuthorizationEntity> selectAuthorizationByDate(OaProjectAuthorizationPagination OaProjectAuthorizationPagination2) {
        List<OaProjectAuthorizationEntity> list = this.oaProjectAuthorizationMapper.selectAuthorizationByDate(OaProjectAuthorizationPagination2);
        return list;
    }

    @Override
    public OaProjectAuthorizationEntity getOaProjectAuthorizationEntityInfo(OaProjectAuthorizationEntity authorization) {
        RkContractProjectEntity project;
        UserInfo userInfo = this.userProvider.get();
        authorization.setCompanyId(userInfo.getOrganizeId());
        authorization.setDeptId(userInfo.getDepartmentId());
        authorization.setCreatorUserId(userInfo.getUserId());
        authorization.setEnabledMark(1);
        authorization.setAuthorizedResult(0);
        if (StringUtils.isNotEmpty((String)authorization.getProjectId()) && ObjectUtil.isNotEmpty((Object)(project = this.rkContractProjectService.getInfo(authorization.getProjectId())))) {
            authorization.setProjectName(project.getProjectName());
            authorization.setCustomerId(project.getCustomerId());
            authorization.setRegionalHead(project.getRegionalHead());
            RkContractEntity contract = this.rkContractService.getInfo(project.getContractId());
            if (ObjectUtil.isNotEmpty((Object)contract)) {
                authorization.setAgentId(contract.getAgentId());
                authorization.setContractId(project.getContractId());
            }
        }
        return authorization;
    }

    public OaProjectAuthorizationListVO setAuthorizationOtherInfo(OaProjectAuthorizationListVO authorization) {
        CrmCustomerEntity customer;
        RkAgentEntity agent;
        OrganizeEntity organize;
        CrmProductCategoryEntity aa;
        if (StringUtils.isNotEmpty((String)authorization.getCreatorUserId())) {
            authorization.setCreatorUserName(this.baseDataUtil.userSelectValue(authorization.getCreatorUserId()));
        }
        if (StringUtils.isNotEmpty((String)authorization.getProjectHeader())) {
            authorization.setProjectHeader(this.baseDataUtil.userSelectValue(authorization.getProjectHeader()));
        }
        if (StringUtils.isNotEmpty((String)authorization.getProductCategory()) && ObjectUtil.isNotEmpty((Object)(aa = this.crmProductCategoryService.getInfo(authorization.getProductCategory())))) {
            authorization.setProductCategoryName(aa.getName());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(CrmProductEntity::getCategoryId, (Object)authorization.getProductCategory());
            List productList = this.crmProductService.list((Wrapper)queryWrapper);
            authorization.setProductList(productList);
        }
        if (StringUtils.isNotEmpty((String)authorization.getProductId()) && ObjectUtil.isNotEmpty((Object)(aa = this.crmProductService.getInfo(authorization.getProductId())))) {
            authorization.setProductName(aa.getProductName());
            authorization.setProductVersion(aa.getProductVersion());
            authorization.setProductCustomizationCode(aa.getCustomizationCode());
        }
        if (StringUtils.isNotEmpty((String)authorization.getDeptId()) && ObjectUtil.isNotEmpty((Object)(organize = this.organizeService.getInfo(authorization.getDeptId()))) && organize.getId().equals(authorization.getDeptId())) {
            authorization.setDeptName(organize.getFullName());
        }
        if (StringUtils.isNotEmpty((String)authorization.getAgentId()) && ObjectUtil.isNotEmpty((Object)(agent = this.rkAgentService.getInfo(authorization.getAgentId()))) && agent.getId().equals(authorization.getAgentId())) {
            authorization.setAgentName(agent.getName());
        }
        if (StringUtils.isNotEmpty((String)authorization.getCustomerId()) && ObjectUtil.isNotEmpty((Object)(customer = this.crmCustomerService.getInfo(authorization.getCustomerId()))) && customer.getId().equals(authorization.getCustomerId())) {
            authorization.setCustomerName(customer.getName());
        }
        if (StringUtil.isEmpty((String)authorization.getAgentName())) {
            authorization.setAgentName(authorization.getCustomerName());
        }
        return authorization;
    }

    public OaProjectAuthorizationListVO setProjectInfo(RkContractProjectEntity project, OaProjectAuthorizationListVO authorization) {
        if (ObjectUtil.isNotEmpty((Object)project)) {
            CrmCustomerEntity crmCustomer;
            authorization.setProjectName(project.getProjectName());
            authorization.setProjectCode(project.getProjectCode());
            authorization.setProjectHeader(project.getProjectHeader());
            authorization.setProjectAmount(project.getProjectAmount());
            authorization.setProjectRatio(project.getProjectRatio());
            authorization.setReceivedAmount(project.getReceivedAmount());
            authorization.setReceivedRatio(project.getReceivedRatio());
            authorization.setSalerName(project.getSalerName());
            authorization.setReceivedState(project.getReceivedState());
            authorization.setPublicKeyA(project.getPublicKeyA());
            authorization.setPublicKeyB(project.getPublicKeyB());
            authorization.setLastEnddate(project.getActualEndDate());
            authorization.setLastAuthorizedDays(project.getActualDays());
            RkContractEntity rkContract = this.rkContractService.getInfo(project.getContractId());
            if (ObjectUtil.isNotEmpty((Object)rkContract)) {
                authorization.setContractDepartment(rkContract.getDepartmentName());
                authorization.setContractRegion(this.baseDataUtil.getDictName(rkContract.getRegionName()));
                authorization.setAgentName(rkContract.getAgentName());
                RkAgentEntity rkAgentEntity = this.rkAgentService.getInfo(rkContract.getAgentId());
                if (ObjectUtil.isNotEmpty((Object)rkAgentEntity)) {
                    authorization.setAgentName(rkAgentEntity.getName());
                }
            }
            if (ObjectUtil.isNotEmpty((Object)(crmCustomer = this.crmCustomerService.getInfo(project.getCustomerId())))) {
                authorization.setCustomerAddress(this.baseDataUtil.provinceData(crmCustomer.getAddress()));
                authorization.setCustomerType(this.baseDataUtil.getDictName(crmCustomer.getClassification(), "classification"));
            }
            if (StrUtil.isBlank((CharSequence)authorization.getAgentName())) {
                authorization.setAgentName(authorization.getCustomerName());
            }
        }
        return authorization;
    }

    @Override
    public List<OaProjectAuthorizationListVO> setAllNameById(List<OaProjectAuthorizationListVO> listVO) {
        if (ObjectUtil.isEmpty(listVO)) {
            return listVO;
        }
        List projectList = this.rkContractProjectService.getListByCompanyId(null);
        List agentList = this.rkAgentService.list();
        List custList = this.crmCustomerService.list();
        List userList = this.userService.list();
        List organizeList = this.organizeService.list();
        List productList = this.crmProductService.list();
        List productCategoryList = this.crmProductCategoryService.list();
        List allCompanyList = this.organizeService.getAllCompanyList("");
        block0: for (OaProjectAuthorizationListVO authorization : listVO) {
            for (RkContractProjectEntity project : projectList) {
                if (!project.getId().equals(authorization.getProjectId())) continue;
                authorization = this.setProjectInfo(project, authorization);
                break;
            }
            for (OrganizeEntity company : allCompanyList) {
                if (!StringUtils.isNotEmpty((String)authorization.getCompanyId()) || !company.getId().equals(authorization.getCompanyId())) continue;
                authorization.setCompanyName(company.getFullName());
                break;
            }
            block3: for (CrmProductEntity product : productList) {
                if (!StrUtil.isNotEmpty((CharSequence)authorization.getProductId()) || !ObjectUtil.isNotEmpty((Object)product) || !product.getId().equals(authorization.getProductId())) continue;
                authorization.setProductName(product.getProductName());
                authorization.setProductVersion(product.getProductVersion());
                if (!StrUtil.isNotEmpty((CharSequence)authorization.getProductCategory())) break;
                for (CrmProductCategoryEntity productCategory : productCategoryList) {
                    if (!ObjectUtil.isNotEmpty((Object)productCategory) || !productCategory.getId().equals(authorization.getProductCategory())) continue;
                    authorization.setProductCategory(productCategory.getName());
                    break block3;
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)authorization.getAgentId())) {
                for (RkAgentEntity agent : agentList) {
                    if (!agent.getId().equals(authorization.getAgentId())) continue;
                    authorization.setAgentName(agent.getName());
                    break;
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)authorization.getCustomerId())) {
                for (CrmCustomerEntity cust : custList) {
                    if (!cust.getId().equals(authorization.getCustomerId())) continue;
                    authorization.setCustomerName(cust.getName());
                    break;
                }
            }
            if (StringUtil.isEmpty((String)authorization.getAgentName())) {
                authorization.setAgentName(authorization.getCustomerName());
            }
            for (UserEntity ur : userList) {
                if (StrUtil.isNotEmpty((CharSequence)authorization.getCreatorUserId()) && ObjectUtil.isNotEmpty((Object)ur) && ur.getId().equals(authorization.getCreatorUserId())) {
                    authorization.setCreatorUserId(ur.getRealName());
                }
                if (StrUtil.isNotEmpty((CharSequence)authorization.getProjectHeader()) && ObjectUtil.isNotEmpty((Object)ur) && ur.getId().equals(authorization.getProjectHeader())) {
                    authorization.setProjectHeader(ur.getRealName());
                }
                if (!StrUtil.isNotEmpty((CharSequence)authorization.getAuthorizedUser()) || !ObjectUtil.isNotEmpty((Object)ur) || !ur.getId().equals(authorization.getAuthorizedUser())) continue;
                authorization.setAuthorizedUser(ur.getRealName());
            }
            for (OrganizeEntity dept : organizeList) {
                if (!StrUtil.isNotEmpty((CharSequence)authorization.getDeptId()) || !ObjectUtil.isNotEmpty((Object)dept) || !dept.getId().equals(authorization.getDeptId())) continue;
                authorization.setDeptId(dept.getFullName());
                continue block0;
            }
        }
        return listVO;
    }

    @Override
    public void delete(OaProjectAuthorizationEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    private QueryWrapper<OaProjectAuthorizationEntity> appendWrapper(OaProjectAuthorizationPagination OaProjectAuthorizationPagination2) {
        Object rkContractProjectObj;
        String userId = this.userProvider.get().getUserId();
        int rkProjectAuthorizationNum = 0;
        QueryWrapper rkProjectAuthorizationQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProjectObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProjectAuthorizationQueryWrapper, OaProjectAuthorizationPagination2.getMenuId(), "rk_project_authorization"));
            if (ObjectUtil.isEmpty((Object)rkContractProjectObj)) {
                return null;
            }
            rkProjectAuthorizationQueryWrapper = (QueryWrapper)rkContractProjectObj;
            ++rkProjectAuthorizationNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProjectObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProjectAuthorizationQueryWrapper, OaProjectAuthorizationPagination2.getMenuId(), "rk_project_authorization"));
            if (ObjectUtil.isEmpty((Object)rkContractProjectObj)) {
                return null;
            }
            rkProjectAuthorizationQueryWrapper = (QueryWrapper)rkContractProjectObj;
            ++rkProjectAuthorizationNum;
        }
        rkProjectAuthorizationQueryWrapper.lambda().eq(OaProjectAuthorizationEntity::getEnabledMark, (Object)1);
        if (StringUtil.isNotEmpty((String)OaProjectAuthorizationPagination2.getAgentId())) {
            ++rkProjectAuthorizationNum;
            rkProjectAuthorizationQueryWrapper.lambda().eq(OaProjectAuthorizationEntity::getAgentId, (Object)OaProjectAuthorizationPagination2.getAgentId());
        }
        if (StringUtil.isNotEmpty((String)OaProjectAuthorizationPagination2.getCustomerId())) {
            ++rkProjectAuthorizationNum;
            rkProjectAuthorizationQueryWrapper.lambda().eq(OaProjectAuthorizationEntity::getCustomerId, (Object)OaProjectAuthorizationPagination2.getCustomerId());
        }
        if (StringUtil.isNotEmpty((String)OaProjectAuthorizationPagination2.getProjectId())) {
            ++rkProjectAuthorizationNum;
            rkProjectAuthorizationQueryWrapper.lambda().eq(OaProjectAuthorizationEntity::getProjectId, (Object)OaProjectAuthorizationPagination2.getProjectId());
        }
        if (StringUtil.isNotEmpty((String)OaProjectAuthorizationPagination2.getDeptId())) {
            ++rkProjectAuthorizationNum;
            rkProjectAuthorizationQueryWrapper.lambda().eq(OaProjectAuthorizationEntity::getDeptId, (Object)OaProjectAuthorizationPagination2.getDeptId());
        }
        if (StringUtil.isNotEmpty((String)OaProjectAuthorizationPagination2.getCreatorUserId())) {
            ++rkProjectAuthorizationNum;
            rkProjectAuthorizationQueryWrapper.lambda().eq(OaProjectAuthorizationEntity::getCreatorUserId, (Object)OaProjectAuthorizationPagination2.getCreatorUserId());
        }
        if (StringUtil.isNotEmpty((String)OaProjectAuthorizationPagination2.getAuthorizedType())) {
            ++rkProjectAuthorizationNum;
            rkProjectAuthorizationQueryWrapper.lambda().eq(OaProjectAuthorizationEntity::getAuthorizedType, (Object)OaProjectAuthorizationPagination2.getAuthorizedType());
        }
        if (ObjectUtil.isNotEmpty((Object)OaProjectAuthorizationPagination2.getAuthorizedResult())) {
            ++rkProjectAuthorizationNum;
            rkProjectAuthorizationQueryWrapper.lambda().eq(OaProjectAuthorizationEntity::getAuthorizedResult, (Object)OaProjectAuthorizationPagination2.getAuthorizedResult());
        }
        if (StrUtil.isNotEmpty((CharSequence)OaProjectAuthorizationPagination2.getProjectName())) {
            ++rkProjectAuthorizationNum;
            rkProjectAuthorizationQueryWrapper.lambda().like(OaProjectAuthorizationEntity::getProjectName, (Object)OaProjectAuthorizationPagination2.getProjectName());
        }
        return rkProjectAuthorizationQueryWrapper;
    }
}

