/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectPlanEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectPlanService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectPlanChangeApplyEntity;
import com.bringspring.oa.mapper.OaProjectPlanChangeApplyMapper;
import com.bringspring.oa.model.oaprojectplanchangeapply.OaProjectPlanChangeApplyCrForm;
import com.bringspring.oa.model.oaprojectplanchangeapply.OaProjectPlanChangeApplyUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectPlanChangeApplyService;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaProjectPlanChangeApplyServiceImpl
extends ServiceImpl<OaProjectPlanChangeApplyMapper, OaProjectPlanChangeApplyEntity>
implements OaProjectPlanChangeApplyService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkProjectPlanService rkProjectPlanService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private RkContractProjectService rkContractProjectService;

    @Override
    public OaProjectPlanChangeApplyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectPlanChangeApplyEntity::getId, (Object)id);
        return (OaProjectPlanChangeApplyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaProjectPlanChangeApplyEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaProjectPlanChangeApplyEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OaProjectPlanChangeApplyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    @DSTransactional
    public void createApply(OaProjectPlanChangeApplyCrForm oaProjectPlanChangeApplyCrForm) {
        String mainId = oaProjectPlanChangeApplyCrForm.getMainId();
        OaProjectPlanChangeApplyEntity entity = (OaProjectPlanChangeApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaProjectPlanChangeApplyCrForm), OaProjectPlanChangeApplyEntity.class);
        entity.setId(mainId);
        this.save(entity);
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)oaProjectPlanChangeApplyCrForm.getProjectId()));
        byId.setChangePlanApplyId(mainId);
        this.rkContractProjectService.updateById((Object)byId);
        if (CollectionUtil.isNotEmpty(oaProjectPlanChangeApplyCrForm.getAttachmentList())) {
            List oaAttachmentEntityList = JsonUtil.getJsonToList(oaProjectPlanChangeApplyCrForm.getAttachmentList(), OaAttachmentEntity.class);
            for (OaAttachmentEntity entitys : oaAttachmentEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setObjId(entity.getId());
                entitys.setFileType(AttachmentTypeEnum.PROJECT_PLAN_TYPE.getType());
                this.oaAttachmentService.save(entitys);
            }
        }
    }

    @Override
    public long countByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectPlanChangeApplyEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public List<OaProjectPlanChangeApplyEntity> getByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectPlanChangeApplyEntity::getProjectId, (Object)projectId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void updateApply(OaProjectPlanChangeApplyUpForm oaProjectPlanChangeApplyUpForm) {
        OaProjectPlanChangeApplyEntity subentity = (OaProjectPlanChangeApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaProjectPlanChangeApplyUpForm), OaProjectPlanChangeApplyEntity.class);
        this.update(oaProjectPlanChangeApplyUpForm.getId(), subentity);
        this.oaAttachmentService.deleteByObjId(oaProjectPlanChangeApplyUpForm.getId());
        if (CollectionUtil.isNotEmpty(oaProjectPlanChangeApplyUpForm.getAttachmentList())) {
            List oaAttachmentEntityList = JsonUtil.getJsonToList(oaProjectPlanChangeApplyUpForm.getAttachmentList(), OaAttachmentEntity.class);
            for (OaAttachmentEntity entitys : oaAttachmentEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setObjId(oaProjectPlanChangeApplyUpForm.getId());
                entitys.setFileType(AttachmentTypeEnum.PROJECT_PLAN_TYPE.getType());
                this.oaAttachmentService.save(entitys);
            }
        }
    }

    @Override
    @FlowCallBackMethod(fullName="\u9879\u76ee\u8ba1\u5212\u53d8\u66f4\u7533\u8bf7")
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel flowModel) {
        OaProjectPlanChangeApplyEntity byId = (OaProjectPlanChangeApplyEntity)this.getById((Serializable)((Object)id));
        if (ObjectUtil.isNull((Object)byId)) {
            return false;
        }
        RkProjectPlanEntity planEntity = (RkProjectPlanEntity)this.rkProjectPlanService.getById((Serializable)((Object)byId.getPlanId()));
        if (ObjectUtil.isNull((Object)planEntity)) {
            return false;
        }
        if (enableMark == 2) {
            planEntity.setPlanStartTime(byId.getChangeStartTime());
            planEntity.setPlanEndTime(byId.getChangeEndTime());
            planEntity.setPlanAcceptanceTime(byId.getChangeAcceptanceTime());
            this.rkProjectPlanService.updateById((Object)planEntity);
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractProjectEntity::getChangePlanApplyId, null)).eq(RkContractProjectEntity::getId, (Object)byId.getProjectId());
            this.rkContractProjectService.update((Wrapper)updateWrapper);
            List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
            if (CollectionUtil.isNotEmpty(oaAttachmentEntityList)) {
                List jsonToList = JsonUtil.getJsonToList(oaAttachmentEntityList, RkAttachmentEntity.class);
                jsonToList.stream().forEach(att -> {
                    att.setObjId(id);
                    att.setProjectId(byId.getProjectId());
                });
                this.rkAttachmentService.saveBatch((Collection)jsonToList);
            }
        }
        return false;
    }
}

