/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.oa.entity.OaRecordAccessoryEntity;
import com.bringspring.oa.mapper.OaRecordAccessoryMapper;
import com.bringspring.oa.model.oaRecord.OaRecordBorrowFileVO;
import com.bringspring.oa.model.oaRecord.OaRecordPagination;
import com.bringspring.oa.service.OaRecordAccessoryService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaRecordAccessoryServiceImpl
extends ServiceImpl<OaRecordAccessoryMapper, OaRecordAccessoryEntity>
implements OaRecordAccessoryService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    public static String temporaryZip = "temporaryZip" + File.separator;

    @Override
    public void create(OaRecordAccessoryEntity entity) {
        this.save(entity);
    }

    @Override
    public List<OaRecordAccessoryEntity> getList(OaRecordPagination oaRecordPagination) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaRecordAccessoryEntity::getCreatorUserId, (Object)userInfo.getUserId());
        queryWrapper.lambda().orderByDesc(OaRecordAccessoryEntity::getCreatorTime);
        if (StringUtils.isNotEmpty((String)oaRecordPagination.getKeyword())) {
            queryWrapper.lambda().like(OaRecordAccessoryEntity::getFileName, (Object)oaRecordPagination.getKeyword());
        }
        Page page = new Page(oaRecordPagination.getCurrentPage(), oaRecordPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return oaRecordPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public DownloadVO toZipByIds(OaRecordBorrowFileVO vo) {
        if (CollectionUtil.isEmpty(vo.getIds())) {
            return new DownloadVO();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OaRecordAccessoryEntity::getId, vo.getIds());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return new DownloadVO();
        }
        ArrayList attachmentList = new ArrayList();
        for (OaRecordAccessoryEntity entity : list) {
            JSONArray jsonToJsonArray = JsonUtil.getJsonToJsonArray((String)entity.getAccessory());
            List rkAttachmentEntity = JsonUtil.getJsonToList((Object)jsonToJsonArray, RkAttachmentEntity.class);
            attachmentList.addAll(rkAttachmentEntity);
        }
        UserInfo userInfo = this.userProvider.get();
        String fromPath = this.configValueUtil.getWebAnnexFilePath();
        String toPath = this.configValueUtil.getDocumentFilePath() + temporaryZip;
        String uuid = DateUtil.daFormat((Date)new Date()) + "_" + RandomUtil.uuId();
        String fileTypeName = "\u6863\u6848\u9644\u4ef6" + DateUtil.dateNow((String)"yyyyMMdd") + uuid + "\u6587\u4ef6";
        for (RkAttachmentEntity attachmentEntity : attachmentList) {
            boolean b = FileUtil.copyFile((String)(fromPath + attachmentEntity.getSecondFilePath() + attachmentEntity.getFileId()), (String)(toPath + fileTypeName + File.separator), (String)attachmentEntity.getName());
            if (b) continue;
            return new DownloadVO();
        }
        String zipPath = toPath + fileTypeName + ".zip";
        if (new File(zipPath).exists()) {
            new File(zipPath).delete();
        }
        String outPath = toPath + fileTypeName + File.separator;
        FileUtil.toZip((String)zipPath, (boolean)true, (String[])new String[]{outPath + File.separator});
        String fileName = userInfo.getId() + "#" + fileTypeName + ".zip#documentZip#";
        DownloadVO downloadVO = DownloadVO.builder().name(fileTypeName + ".zip").url(UploaderUtil.uploaderFile((String)fileName)).build();
        return downloadVO;
    }
}

