/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractInvoiceDetailEntity;
import com.bringspring.contract.entity.RkContractInvoiceEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.service.RkContractInvoiceDetailService;
import com.bringspring.contract.service.RkContractInvoiceService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaSaleEnterEntity;
import com.bringspring.oa.entity.OaSaleEnterProjectDetailEntity;
import com.bringspring.oa.entity.OaSaleEnterProjectEntity;
import com.bringspring.oa.entity.OaSaleInvoiceDetailEntity;
import com.bringspring.oa.entity.OaSaleInvoiceEntity;
import com.bringspring.oa.entity.OaSaleInvoiceMulEntity;
import com.bringspring.oa.entity.OaSaleInvoiceProjectEntity;
import com.bringspring.oa.entity.OaSaleInvoiceProjectReturnEntity;
import com.bringspring.oa.mapper.OaSaleInvoiceMapper;
import com.bringspring.oa.model.oaattachment.OaAttachmentUpForm;
import com.bringspring.oa.model.oasaleinvoice.EnterInvoiceDetailModel;
import com.bringspring.oa.model.oasaleinvoice.EnterInvoiceModel;
import com.bringspring.oa.model.oasaleinvoice.OaSaleInvoicePagination;
import com.bringspring.oa.model.oasaleinvoice.OaSaleInvoiceUpForm;
import com.bringspring.oa.model.oasaleinvoice.SaleInvoiceProjectModel;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaSaleEnterProjectDetailService;
import com.bringspring.oa.service.OaSaleEnterProjectService;
import com.bringspring.oa.service.OaSaleEnterService;
import com.bringspring.oa.service.OaSaleInvoiceDetailService;
import com.bringspring.oa.service.OaSaleInvoiceProjectReturnService;
import com.bringspring.oa.service.OaSaleInvoiceProjectService;
import com.bringspring.oa.service.OaSaleInvoiceService;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaSaleInvoiceServiceImpl
extends ServiceImpl<OaSaleInvoiceMapper, OaSaleInvoiceEntity>
implements OaSaleInvoiceService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private OaSaleInvoiceDetailService oaSaleInvoiceDetailService;
    @Autowired
    private OaSaleInvoiceProjectService oaSaleInvoiceProjectService;
    @Autowired
    private OaSaleEnterService oaSaleEnterService;
    @Autowired
    private OaSaleEnterProjectService oaSaleEnterProjectService;
    @Autowired
    private OaSaleEnterProjectDetailService oaSaleEnterProjectDetailService;
    @Autowired
    private RkContractInvoiceService rkContractInvoiceService;
    @Autowired
    private RkContractInvoiceDetailService rkContractInvoiceDetailService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private OaSaleInvoiceProjectReturnService oaSaleInvoiceProjectReturnService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;
    @Autowired
    private ServiceAllUtil serviceUtil;

    @Override
    public List<OaSaleInvoiceEntity> getList(OaSaleInvoicePagination oaSaleInvoicePagination) {
        List contractIdList;
        List contractEntityList;
        QueryWrapper rkContractQueryWrapper;
        Object oaSaleInvoiceObj;
        UserInfo userInfo = this.userProvider.get();
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaSaleInvoiceNum = 0;
        QueryWrapper oaSaleInvoiceQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaSaleInvoiceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaSaleInvoiceQueryWrapper, oaSaleInvoicePagination.getMenuId(), "oa_sale_invoice"));
            if (ObjectUtil.isEmpty((Object)oaSaleInvoiceObj)) {
                return new ArrayList<OaSaleInvoiceEntity>();
            }
            oaSaleInvoiceQueryWrapper = (QueryWrapper)oaSaleInvoiceObj;
            ++oaSaleInvoiceNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaSaleInvoiceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaSaleInvoiceQueryWrapper, oaSaleInvoicePagination.getMenuId(), "oa_sale_invoice"));
            if (ObjectUtil.isEmpty((Object)oaSaleInvoiceObj)) {
                return new ArrayList<OaSaleInvoiceEntity>();
            }
            oaSaleInvoiceQueryWrapper = (QueryWrapper)oaSaleInvoiceObj;
            ++oaSaleInvoiceNum;
        }
        if (ObjectUtil.isNotEmpty((Object)oaSaleInvoicePagination.getContractName())) {
            ++oaSaleInvoiceNum;
            rkContractQueryWrapper = new QueryWrapper();
            rkContractQueryWrapper.lambda().like(RkContractEntity::getContractName, (Object)oaSaleInvoicePagination.getContractName());
            contractEntityList = this.rkContractService.list((Wrapper)rkContractQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)contractEntityList)) {
                contractIdList = contractEntityList.stream().map(contract -> contract.getId()).collect(Collectors.toList());
                oaSaleInvoiceQueryWrapper.lambda().in(OaSaleInvoiceEntity::getContractId, contractIdList);
            } else {
                return new ArrayList<OaSaleInvoiceEntity>();
            }
        }
        if (ObjectUtil.isNotEmpty((Object)oaSaleInvoicePagination.getContractCode())) {
            ++oaSaleInvoiceNum;
            rkContractQueryWrapper = new QueryWrapper();
            rkContractQueryWrapper.lambda().like(RkContractEntity::getContractCode, (Object)oaSaleInvoicePagination.getContractCode());
            contractEntityList = this.rkContractService.list((Wrapper)rkContractQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)contractEntityList)) {
                contractIdList = contractEntityList.stream().map(contract -> contract.getId()).collect(Collectors.toList());
                oaSaleInvoiceQueryWrapper.lambda().in(OaSaleInvoiceEntity::getContractId, contractIdList);
            } else {
                return new ArrayList<OaSaleInvoiceEntity>();
            }
        }
        if (ObjectUtil.isNotEmpty((Object)oaSaleInvoicePagination.getContractId())) {
            ++oaSaleInvoiceNum;
            oaSaleInvoiceQueryWrapper.lambda().eq(OaSaleInvoiceEntity::getContractId, (Object)oaSaleInvoicePagination.getContractId());
        }
        if (ObjectUtil.isNotEmpty((Object)oaSaleInvoicePagination.getProjectId())) {
            ++oaSaleInvoiceNum;
            oaSaleInvoiceQueryWrapper.lambda().eq(OaSaleInvoiceEntity::getProjectId, (Object)oaSaleInvoicePagination.getProjectId());
        }
        if (ObjectUtil.isNotEmpty(oaSaleInvoicePagination.getStateList())) {
            ++oaSaleInvoiceNum;
            oaSaleInvoiceQueryWrapper.lambda().in(OaSaleInvoiceEntity::getEnableMark, oaSaleInvoicePagination.getStateList());
        }
        if (ObjectUtil.isNotEmpty((Object)oaSaleInvoicePagination.getProjectName())) {
            ++oaSaleInvoiceNum;
            QueryWrapper rkContractProjectQueryWrapper = new QueryWrapper();
            rkContractProjectQueryWrapper.lambda().like(RkContractProjectEntity::getProjectName, (Object)oaSaleInvoicePagination.getProjectName());
            List projectEntityList = this.rkContractProjectService.list((Wrapper)rkContractProjectQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)projectEntityList)) {
                List projectIdList = projectEntityList.stream().map(project -> project.getId()).collect(Collectors.toList());
                oaSaleInvoiceQueryWrapper.lambda().in(OaSaleInvoiceEntity::getProjectId, projectIdList);
            } else {
                return new ArrayList<OaSaleInvoiceEntity>();
            }
        }
        oaSaleInvoiceQueryWrapper.lambda().orderByDesc(OaSaleInvoiceEntity::getCreatorTime);
        if (AllIdList.size() > 0) {
            oaSaleInvoiceQueryWrapper.lambda().in(OaSaleInvoiceEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaSaleInvoicePagination.getSidx())) {
            oaSaleInvoiceQueryWrapper.lambda().orderByDesc(OaSaleInvoiceEntity::getId);
        } else {
            try {
                String sidx = oaSaleInvoicePagination.getSidx();
                OaSaleInvoiceEntity oaSaleInvoiceEntity = new OaSaleInvoiceEntity();
                Field declaredField = oaSaleInvoiceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaSaleInvoiceQueryWrapper = "asc".equals(oaSaleInvoicePagination.getSort().toLowerCase()) ? (QueryWrapper)oaSaleInvoiceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaSaleInvoiceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(oaSaleInvoicePagination.getCurrentPage(), oaSaleInvoicePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)oaSaleInvoiceQueryWrapper);
            return oaSaleInvoicePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return oaSaleInvoicePagination.setData(list, list.size());
    }

    @Override
    public List<OaSaleInvoiceEntity> getTypeList(OaSaleInvoicePagination oaSaleInvoicePagination, String dataType) {
        Object oaSaleInvoiceObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaSaleInvoiceNum = 0;
        QueryWrapper oaSaleInvoiceQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaSaleInvoiceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaSaleInvoiceQueryWrapper, oaSaleInvoicePagination.getMenuId(), "oa_sale_invoice"));
            if (ObjectUtil.isEmpty((Object)oaSaleInvoiceObj)) {
                return new ArrayList<OaSaleInvoiceEntity>();
            }
            oaSaleInvoiceQueryWrapper = (QueryWrapper)oaSaleInvoiceObj;
            ++oaSaleInvoiceNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaSaleInvoiceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaSaleInvoiceQueryWrapper, oaSaleInvoicePagination.getMenuId(), "oa_sale_invoice"));
            if (ObjectUtil.isEmpty((Object)oaSaleInvoiceObj)) {
                return new ArrayList<OaSaleInvoiceEntity>();
            }
            oaSaleInvoiceQueryWrapper = (QueryWrapper)oaSaleInvoiceObj;
            ++oaSaleInvoiceNum;
        }
        if (StringUtils.isNotEmpty((String)oaSaleInvoicePagination.getContractName())) {
            ++oaSaleInvoiceNum;
        }
        if (StringUtils.isNotEmpty((String)oaSaleInvoicePagination.getProjectName())) {
            ++oaSaleInvoiceNum;
        }
        if (ObjectUtil.isNotEmpty((Object)oaSaleInvoicePagination.getContractId())) {
            ++oaSaleInvoiceNum;
            oaSaleInvoiceQueryWrapper.lambda().eq(OaSaleInvoiceEntity::getContractId, (Object)oaSaleInvoicePagination.getContractId());
        }
        if (ObjectUtil.isNotEmpty((Object)oaSaleInvoicePagination.getProjectId())) {
            ++oaSaleInvoiceNum;
            oaSaleInvoiceQueryWrapper.lambda().eq(OaSaleInvoiceEntity::getProjectId, (Object)oaSaleInvoicePagination.getProjectId());
        }
        if (ObjectUtil.isNotEmpty(oaSaleInvoicePagination.getStateList())) {
            ++oaSaleInvoiceNum;
            oaSaleInvoiceQueryWrapper.lambda().in(OaSaleInvoiceEntity::getEnableMark, oaSaleInvoicePagination.getStateList());
        }
        if (AllIdList.size() > 0) {
            oaSaleInvoiceQueryWrapper.lambda().in(OaSaleInvoiceEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaSaleInvoicePagination.getSidx())) {
            oaSaleInvoiceQueryWrapper.lambda().orderByDesc(OaSaleInvoiceEntity::getId);
        } else {
            try {
                String sidx = oaSaleInvoicePagination.getSidx();
                OaSaleInvoiceEntity oaSaleInvoiceEntity = new OaSaleInvoiceEntity();
                Field declaredField = oaSaleInvoiceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaSaleInvoiceQueryWrapper = "asc".equals(oaSaleInvoicePagination.getSort().toLowerCase()) ? (QueryWrapper)oaSaleInvoiceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaSaleInvoiceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(oaSaleInvoicePagination.getCurrentPage(), oaSaleInvoicePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)oaSaleInvoiceQueryWrapper);
                return oaSaleInvoicePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return oaSaleInvoicePagination.setData(list, list.size());
        }
        return this.list((Wrapper)oaSaleInvoiceQueryWrapper);
    }

    @Override
    public OaSaleInvoiceEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaSaleInvoiceEntity::getId, (Object)id);
        return (OaSaleInvoiceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaSaleInvoiceEntity entity) {
        this.save(entity);
    }

    @Override
    public HashMap enterInvoice(EnterInvoiceModel enterInvoiceModel) {
        HashMap map = MapUtil.newHashMap();
        UserInfo userInfo = this.userProvider.get();
        OaSaleInvoiceEntity saleInvoiceInfo = (OaSaleInvoiceEntity)this.getById((Serializable)((Object)enterInvoiceModel.getId()));
        RkContractInvoiceEntity contractInvoiceEntity = (RkContractInvoiceEntity)JsonUtil.getJsonToBean((Object)enterInvoiceModel, RkContractInvoiceEntity.class);
        contractInvoiceEntity.setId(RandomUtil.uuId());
        RkContractEntity byId = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)enterInvoiceModel.getContractId()));
        contractInvoiceEntity.setHandledBy(saleInvoiceInfo.getCreatorUserId());
        contractInvoiceEntity.setCompanyId(userInfo.getOrganizeId());
        contractInvoiceEntity.setAgentId(byId.getAgentId());
        contractInvoiceEntity.setCustomerId(byId.getCustomerId());
        contractInvoiceEntity.setSalerId(byId.getSalerId());
        contractInvoiceEntity.setSalerName(ObjectUtil.isNotEmpty((Object)byId.getSalerId()) ? this.baseDataUtil.getDictName(byId.getSalerId()) : "");
        contractInvoiceEntity.setState("issued");
        DictionaryTypeEntity invoiceRate = this.dictionaryTypeService.getInfoByEnCode("invoiceRate");
        List dicList = this.dictionaryDataService.getDicList(invoiceRate.getId());
        dicList.stream().forEach(dict -> {
            if (dict.getFullName().equals(enterInvoiceModel.getTaxRate())) {
                contractInvoiceEntity.setRate(dict.getId());
            }
        });
        DictionaryTypeEntity invoiceType = this.dictionaryTypeService.getInfoByEnCode("invoiceType");
        List dicList1 = this.dictionaryDataService.getDicList(invoiceType.getId());
        dicList1.stream().forEach(dict -> {
            if (dict.getFullName().equals(enterInvoiceModel.getInvoiceType())) {
                contractInvoiceEntity.setInvoiceType(dict.getId());
            }
        });
        List<EnterInvoiceDetailModel> detailInvoiceList = enterInvoiceModel.getEnterInvoiceList();
        BigDecimal totalInvoiceAmount = detailInvoiceList.stream().filter(t -> ObjectUtil.isEmpty((Object)t.getId())).map(EnterInvoiceDetailModel::getInvoiceAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalTaxAmount = detailInvoiceList.stream().filter(t -> ObjectUtil.isEmpty((Object)t.getId())).map(EnterInvoiceDetailModel::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmountExcludingTax = detailInvoiceList.stream().filter(t -> ObjectUtil.isEmpty((Object)t.getId())).map(EnterInvoiceDetailModel::getAmountExcludingTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        contractInvoiceEntity.setInvoiceAmount(totalInvoiceAmount);
        contractInvoiceEntity.setTaxAmount(totalTaxAmount);
        contractInvoiceEntity.setAmountExcludingTax(totalAmountExcludingTax);
        contractInvoiceEntity.setIsReceiver(Integer.valueOf(0));
        contractInvoiceEntity.setCreatorTime(new Date());
        contractInvoiceEntity.setCreatorUserId(userInfo.getUserId());
        contractInvoiceEntity.setEnabledMark(Integer.valueOf(1));
        this.rkContractInvoiceService.save((Object)contractInvoiceEntity);
        List<EnterInvoiceDetailModel> enterInvoiceList = enterInvoiceModel.getEnterInvoiceList();
        enterInvoiceList.stream().forEach(enter -> {
            RkContractInvoiceDetailEntity jsonToBean = (RkContractInvoiceDetailEntity)JsonUtil.getJsonToBean((Object)enter, RkContractInvoiceDetailEntity.class);
            if (ObjectUtil.isEmpty((Object)jsonToBean.getId())) {
                jsonToBean.setId(RandomUtil.uuId());
                jsonToBean.setInvoiceId(contractInvoiceEntity.getId());
                jsonToBean.setCompanyId(userInfo.getOrganizeId());
                jsonToBean.setAgentId(byId.getAgentId());
                jsonToBean.setInvoiceDate(new Date());
                jsonToBean.setCustomerId(byId.getCustomerId());
                jsonToBean.setContractId(byId.getId());
                jsonToBean.setCreatorTime(new Date());
                jsonToBean.setCreatorUserId(userInfo.getUserId());
                jsonToBean.setSource("1");
                this.rkContractInvoiceDetailService.save((Object)jsonToBean);
            }
        });
        List<SaleInvoiceProjectModel> projectList = enterInvoiceModel.getProjectList();
        projectList.stream().forEach(project -> {
            RkContractProjectEntity projectInfo = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)project.getProjectId()));
            if (ObjectUtil.isEmpty((Object)projectInfo.getInvoiceAmount())) {
                projectInfo.setInvoiceAmount(BigDecimal.ZERO);
            }
            projectInfo.setInvoiceAmount(projectInfo.getInvoiceAmount().add(project.getApplyInvoiceAmount()));
            this.rkContractProjectService.updateById((Object)projectInfo);
            RkContractEntity contractInfo = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)enterInvoiceModel.getContractId()));
            if (ObjectUtil.isEmpty((Object)contractInfo.getInvoiceAmount())) {
                contractInfo.setInvoiceAmount(BigDecimal.ZERO);
            }
            contractInfo.setInvoiceAmount(contractInfo.getInvoiceAmount().add(project.getApplyInvoiceAmount()));
            this.rkContractService.updateById((Object)contractInfo);
        });
        OaSaleEnterEntity oaSaleEnterEntity = (OaSaleEnterEntity)JsonUtil.getJsonToBean((Object)enterInvoiceModel, OaSaleEnterEntity.class);
        oaSaleEnterEntity.setInvoiceId(enterInvoiceModel.getId());
        oaSaleEnterEntity.setId(RandomUtil.uuId());
        oaSaleEnterEntity.setCompanyId(userInfo.getOrganizeId());
        oaSaleEnterEntity.setCreatorUserId(userInfo.getUserId());
        oaSaleEnterEntity.setCreatorTime(new Date());
        this.oaSaleEnterService.save(oaSaleEnterEntity);
        List oaSaleProjectList = JsonUtil.getJsonToList(projectList, OaSaleEnterProjectEntity.class);
        oaSaleProjectList.stream().forEach(saleProject -> {
            saleProject.setCompanyId(userInfo.getOrganizeId());
            if (ObjectUtil.isEmpty((Object)saleProject.getId())) {
                saleProject.setId(RandomUtil.uuId());
                saleProject.setInvoiceId(oaSaleEnterEntity.getInvoiceId());
                saleProject.setInvoiceAmount(saleProject.getInvoiceAmount().add(saleProject.getApplyInvoiceAmount()));
                saleProject.setContractId(oaSaleEnterEntity.getContractId());
                saleProject.setCreatorUserId(userInfo.getUserId());
                saleProject.setCreatorTime(new Date());
            } else {
                saleProject.setContractId(oaSaleEnterEntity.getContractId());
                saleProject.setInvoiceAmount(saleProject.getInvoiceAmount().add(saleProject.getApplyInvoiceAmount()));
            }
        });
        this.oaSaleEnterProjectService.saveOrUpdateBatch(oaSaleProjectList);
        List oaSaleProjectDetailList = JsonUtil.getJsonToList(enterInvoiceList, OaSaleEnterProjectDetailEntity.class);
        oaSaleProjectDetailList.stream().forEach(projectDetail -> {
            if (ObjectUtil.isEmpty((Object)projectDetail.getId())) {
                projectDetail.setId(RandomUtil.uuId());
                projectDetail.setInvoiceId(oaSaleEnterEntity.getInvoiceId());
                projectDetail.setCompanyId(userInfo.getOrganizeId());
                projectDetail.setCreatorUserId(userInfo.getUserId());
                projectDetail.setCreatorTime(new Date());
                projectDetail.setEnableMark("1");
            }
        });
        this.oaSaleEnterProjectDetailService.saveOrUpdateBatch(oaSaleProjectDetailList);
        OaSaleInvoiceEntity oaSaleInvoiceEntity = this.getInfo(oaSaleEnterEntity.getInvoiceId());
        List<OaSaleEnterProjectEntity> enterProjectList = this.oaSaleEnterProjectService.listByInvoiceId(oaSaleInvoiceEntity.getId());
        if (CollectionUtil.isNotEmpty(enterProjectList)) {
            enterProjectList.stream().forEach(project -> {
                if (project.getApplyInvoiceAmount().compareTo(BigDecimal.ZERO) != 0) {
                    if (enterProjectList.size() > 1) {
                        if (ObjectUtil.isEmpty((Object)oaSaleInvoiceEntity.getActualInvoiceAmount())) {
                            oaSaleInvoiceEntity.setActualInvoiceAmount(BigDecimal.ZERO);
                        }
                        oaSaleInvoiceEntity.setActualInvoiceAmount(oaSaleInvoiceEntity.getActualInvoiceAmount().add(project.getInvoiceAmount()));
                        this.updateById(oaSaleInvoiceEntity);
                    } else {
                        oaSaleInvoiceEntity.setActualInvoiceAmount(project.getInvoiceAmount());
                        this.updateById(oaSaleInvoiceEntity);
                    }
                }
            });
        }
        return map;
    }

    @Override
    public boolean update(String id, OaSaleInvoiceEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public boolean updateForm(String id, OaSaleInvoiceUpForm oaSaleInvoiceUpForm) {
        UserInfo userInfo = this.userProvider.get();
        this.oaAttachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
        List<OaAttachmentUpForm> attachmentList = oaSaleInvoiceUpForm.getAttachmentList();
        attachmentList.stream().forEach(attach -> {
            attach.setContractId(id);
            attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
        });
        List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, OaAttachmentEntity.class);
        this.oaAttachmentService.saveBatch(attachmentEntityList);
        Boolean aBoolean = this.oaSaleInvoiceProjectReturnService.deleteByInvoiceId(id);
        this.oaSaleInvoiceProjectService.deleteByInvoiceId(id);
        List<OaSaleInvoiceProjectEntity> projectList = oaSaleInvoiceUpForm.getProjectList();
        if (CollectionUtil.isNotEmpty(projectList)) {
            projectList.stream().forEach(project -> {
                project.setId(RandomUtil.uuId());
                project.setCompanyId(userInfo.getOrganizeId());
                project.setInvoiceId(id);
                project.setPaymentTypeName(this.baseDataUtil.getDictName(project.getPaymentType(), "paymentType"));
                project.setCreatorUserId(userInfo.getUserId());
                project.setCreatorTime(new Date());
                List<OaSaleInvoiceProjectReturnEntity> returnPlanList = project.getReturnPlanList();
                returnPlanList.stream().forEach(plan -> {
                    if (ObjectUtil.isEmpty((Object)plan.getReturnPlanId())) {
                        plan.setReturnPlanId(plan.getId());
                    }
                    plan.setId(RandomUtil.uuId());
                    plan.setCompanyId(userInfo.getOrganizeId());
                    plan.setInvoiceId(id);
                    plan.setLastModifyTime(new Date());
                    plan.setLastModifyUserId(userInfo.getUserId());
                    if (ObjectUtil.isNotEmpty((Object)plan.getReturnPlanId()) && oaSaleInvoiceUpForm.getEnableMark().equals("1")) {
                        RkContractReturnPlanEntity returnPlanEntity = (RkContractReturnPlanEntity)this.rkContractReturnPlanService.getById((Serializable)((Object)plan.getReturnPlanId()));
                        returnPlanEntity.setFreezeInvoicingAmount(returnPlanEntity.getFreezeInvoicingAmount().add(plan.getFreezeInvoicingAmount()));
                        if (ObjectUtil.isEmpty((Object)returnPlanEntity.getRemainingInvoicedAmount())) {
                            returnPlanEntity.setRemainingInvoicedAmount(returnPlanEntity.getReceivableAmount());
                        }
                        returnPlanEntity.setRemainingInvoicedAmount(returnPlanEntity.getRemainingInvoicedAmount().subtract(plan.getFreezeInvoicingAmount()));
                        this.rkContractReturnPlanService.updateById((Object)returnPlanEntity);
                    }
                });
                this.oaSaleInvoiceProjectReturnService.saveBatch(returnPlanList);
            });
        }
        if (CollectionUtil.isNotEmpty(oaSaleInvoiceUpForm.getInvoiceDetailList())) {
            List<OaSaleInvoiceDetailEntity> invoiceDetailList = oaSaleInvoiceUpForm.getInvoiceDetailList();
            this.oaSaleInvoiceDetailService.deleteByInvoiceId(id);
            List jsonToList = JsonUtil.getJsonToList(invoiceDetailList, OaSaleInvoiceDetailEntity.class);
            jsonToList.stream().forEach(detail -> {
                detail.setId(RandomUtil.uuId());
                detail.setCompanyId(userInfo.getOrganizeId());
                detail.setInvoiceId(id);
                detail.setInvoiceTaxName(this.baseDataUtil.getDictName(detail.getInvoiceTax(), "contractRate"));
                detail.setCreatorUserId(userInfo.getUserId());
                detail.setCreatorTime(new Date());
            });
            this.oaSaleInvoiceDetailService.saveOrUpdateBatch(jsonToList);
        }
        this.oaSaleInvoiceProjectService.saveBatch(projectList);
        OaSaleInvoiceEntity entity = (OaSaleInvoiceEntity)JsonUtil.getJsonToBean((Object)((Object)oaSaleInvoiceUpForm), OaSaleInvoiceEntity.class);
        entity.setTaxRateName(this.baseDataUtil.getDictName(entity.getTaxRate(), "contractRate"));
        entity.setInvoiceTypeName(this.baseDataUtil.getDictName(entity.getInvoiceType(), "invoiceRegister"));
        entity.setPaymentTypeName(this.baseDataUtil.getDictName(entity.getPaymentType(), "paymentType"));
        entity.setCustomerQualificationName(this.baseDataUtil.getDictName(entity.getCustomerQualification(), "customerQualification"));
        RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)entity.getContractId()));
        UserEntity sealer = this.serviceUtil.getUserInfo(contractEntity.getSalerId());
        if (ObjectUtil.isNotEmpty((Object)sealer) && ObjectUtil.isNotEmpty((Object)sealer.getManagerId())) {
            entity.setProjectSealer(sealer.getManagerId());
            entity.setProjectSealerName(this.baseDataUtil.userSelectValue(entity.getProjectSealer()));
        }
        return this.updateById(entity);
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        List<OaSaleInvoiceProjectReturnEntity> returnPlanList;
        RkContractEntity contractEntity;
        UserInfo userInfo = this.userProvider.get();
        OaSaleInvoiceEntity entity = this.getInfo(id);
        entity.setEnableMark(String.valueOf(enableMark));
        if (enableMark == 1 && ObjectUtil.isNotEmpty((Object)(contractEntity = this.rkContractService.getInfo(entity.getContractId())))) {
            contractEntity.setSaleInvoiceAmount(entity.getApplyInvoiceAmount().add(contractEntity.getSaleInvoiceAmount()));
            this.rkContractService.updateById((Object)contractEntity);
        }
        if (enableMark == 4) {
            List<OaSaleInvoiceDetailEntity> detailEntityList = this.oaSaleInvoiceDetailService.listByInvoiceId(id);
            List oldIdList = detailEntityList.stream().map(OaSaleInvoiceDetailEntity::getId).collect(Collectors.toList());
            Object invoiceDetailList = model.getFormData().get("invoiceDetailList");
            List jsonToList = JsonUtil.getJsonToList(invoiceDetailList, OaSaleInvoiceDetailEntity.class);
            List newIdList = jsonToList.stream().map(OaSaleInvoiceDetailEntity::getId).collect(Collectors.toList());
            List needRemoveIdList = oldIdList.stream().filter(x -> !newIdList.contains(x)).collect(Collectors.toList());
            if (needRemoveIdList.size() > 0) {
                this.oaSaleInvoiceDetailService.removeBatchByIds(needRemoveIdList);
            }
            jsonToList.stream().forEach(invoice -> {
                if (ObjectUtil.isEmpty((Object)invoice.getInvoiceId())) {
                    invoice.setId(RandomUtil.uuId());
                    invoice.setCompanyId(userInfo.getOrganizeId());
                    invoice.setInvoiceId(id);
                    invoice.setCreatorUserId(userInfo.getUserId());
                    invoice.setCreatorTime(new Date());
                }
            });
            BigDecimal temp = jsonToList.stream().map(detail -> detail.getTotalPriceTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setApplyInvoiceAmount(temp);
            this.updateById(entity);
            this.oaSaleInvoiceDetailService.saveOrUpdateBatch(jsonToList);
        }
        if (enableMark == 5 && model.getRejectAgreeStep().equals("0") || enableMark == 3) {
            RkContractEntity contractEntity2;
            returnPlanList = this.oaSaleInvoiceProjectReturnService.listByInvoiceId(entity.getId());
            if (CollectionUtil.isNotEmpty(returnPlanList)) {
                returnPlanList.stream().forEach(plan -> {
                    RkContractReturnPlanEntity returnPlanEntity = (RkContractReturnPlanEntity)this.rkContractReturnPlanService.getById((Serializable)((Object)plan.getReturnPlanId()));
                    if (ObjectUtil.isNotEmpty((Object)returnPlanEntity)) {
                        returnPlanEntity.setFreezeInvoicingAmount(returnPlanEntity.getFreezeInvoicingAmount().subtract(plan.getFreezeInvoicingAmount()));
                        returnPlanEntity.setRemainingInvoicedAmount(returnPlanEntity.getRemainingInvoicedAmount().add(plan.getFreezeInvoicingAmount()));
                        this.rkContractReturnPlanService.updateById((Object)returnPlanEntity);
                    }
                });
            }
            if (ObjectUtil.isNotEmpty((Object)(contractEntity2 = this.rkContractService.getInfo(entity.getContractId())))) {
                contractEntity2.setSaleInvoiceAmount(contractEntity2.getSaleInvoiceAmount().subtract(entity.getApplyInvoiceAmount()));
                this.rkContractService.updateById((Object)contractEntity2);
            }
        }
        if (enableMark == 2) {
            returnPlanList = this.oaSaleInvoiceProjectReturnService.listByInvoiceId(entity.getId());
            if (CollectionUtil.isNotEmpty(returnPlanList)) {
                returnPlanList.stream().forEach(plan -> {
                    RkContractReturnPlanEntity returnPlanEntity = (RkContractReturnPlanEntity)this.rkContractReturnPlanService.getById((Serializable)((Object)plan.getReturnPlanId()));
                    returnPlanEntity.setInvoiceAmount(returnPlanEntity.getInvoiceAmount().add(plan.getFreezeInvoicingAmount()));
                    returnPlanEntity.setFreezeInvoicingAmount(returnPlanEntity.getFreezeInvoicingAmount().subtract(plan.getFreezeInvoicingAmount()));
                    this.rkContractReturnPlanService.updateById((Object)returnPlanEntity);
                });
            }
            Object mulObject = model.getFormData().get("oaSaleInvoiceMulList");
            List mulList = JsonUtil.getJsonToList(mulObject, OaSaleInvoiceMulEntity.class);
            if (entity.getApplyInvoiceAmount().compareTo(BigDecimal.ZERO) < 0 && CollectionUtil.isNotEmpty((Collection)mulList)) {
                for (OaSaleInvoiceMulEntity mul : mulList) {
                    OaSaleInvoiceEntity oaSaleInvoiceEntity = this.getInfo(mul.getInvoiceId());
                    if (!ObjectUtil.isNotEmpty((Object)oaSaleInvoiceEntity)) continue;
                    oaSaleInvoiceEntity.setEnableMark("-2");
                    this.updateById(oaSaleInvoiceEntity);
                }
            }
        }
        return false;
    }

    @Override
    public void delete(OaSaleInvoiceEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

