/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.plugins.DynamicSourceGeneratorInterface;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaSupplierApplyEntity;
import com.bringspring.oa.mapper.OaSupplierApplyMapper;
import com.bringspring.oa.model.oaSupplierApply.OaSupplierApplyPagination;
import com.bringspring.oa.model.oaSupplierApply.OaSupplierApplyUpForm;
import com.bringspring.oa.model.oaattachment.OaAttachmentUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaSupplierApplyService;
import com.bringspring.supplier.entity.SupplierEntity;
import com.bringspring.supplier.service.SupplierService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaSupplierApplyServiceImpl
extends ServiceImpl<OaSupplierApplyMapper, OaSupplierApplyEntity>
implements OaSupplierApplyService,
DynamicSourceGeneratorInterface {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SupplierService supplierService;

    @Override
    public List<OaSupplierApplyEntity> getList(OaSupplierApplyPagination oaSupplierApplyPagination) {
        Object oaSupplierApplyObj;
        QueryWrapper erpSupplierApplyQueryWrapper = new QueryWrapper();
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int erpSupplierApplyNum = 0;
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        QueryWrapper oaSupplierApplyEntityQueryWrapper = new QueryWrapper();
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaSupplierApplyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(erpSupplierApplyQueryWrapper, oaSupplierApplyPagination.getMenuId(), "oa_supplier_apply"));
            if (ObjectUtil.isEmpty((Object)oaSupplierApplyObj)) {
                return new ArrayList<OaSupplierApplyEntity>();
            }
            oaSupplierApplyEntityQueryWrapper = (QueryWrapper)oaSupplierApplyObj;
            ++erpSupplierApplyNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaSupplierApplyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(erpSupplierApplyQueryWrapper, oaSupplierApplyPagination.getMenuId(), "oa_supplier_apply"));
            if (ObjectUtil.isEmpty((Object)oaSupplierApplyObj)) {
                return new ArrayList<OaSupplierApplyEntity>();
            }
            oaSupplierApplyEntityQueryWrapper = (QueryWrapper)oaSupplierApplyObj;
            ++erpSupplierApplyNum;
        }
        if (StringUtil.isNotEmpty((String)oaSupplierApplyPagination.getSupplierName())) {
            ++erpSupplierApplyNum;
            erpSupplierApplyQueryWrapper.lambda().like(OaSupplierApplyEntity::getSupplierName, (Object)oaSupplierApplyPagination.getSupplierName());
        }
        if (StringUtil.isNotEmpty((String)oaSupplierApplyPagination.getSupplierCode())) {
            ++erpSupplierApplyNum;
            erpSupplierApplyQueryWrapper.lambda().like(OaSupplierApplyEntity::getSupplierCode, (Object)oaSupplierApplyPagination.getSupplierCode());
        }
        if (StringUtil.isNotEmpty((String)oaSupplierApplyPagination.getCompanyId())) {
            ++erpSupplierApplyNum;
            erpSupplierApplyQueryWrapper.lambda().like(OaSupplierApplyEntity::getCompanyId, (Object)oaSupplierApplyPagination.getCompanyId());
        }
        if (StringUtil.isNotEmpty((String)oaSupplierApplyPagination.getSocialCode())) {
            ++erpSupplierApplyNum;
            erpSupplierApplyQueryWrapper.lambda().like(OaSupplierApplyEntity::getSocialCode, (Object)oaSupplierApplyPagination.getSocialCode());
        }
        if (AllIdList.size() > 0) {
            erpSupplierApplyQueryWrapper.lambda().in(OaSupplierApplyEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)oaSupplierApplyPagination.getSidx())) {
            erpSupplierApplyQueryWrapper.lambda().orderByDesc(OaSupplierApplyEntity::getId);
        } else {
            try {
                String sidx = oaSupplierApplyPagination.getSidx();
                OaSupplierApplyEntity oaSupplierApplyEntity = new OaSupplierApplyEntity();
                Field declaredField = oaSupplierApplyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                erpSupplierApplyQueryWrapper = "asc".equals(oaSupplierApplyPagination.getSort().toLowerCase()) ? (QueryWrapper)erpSupplierApplyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)erpSupplierApplyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(oaSupplierApplyPagination.getCurrentPage(), oaSupplierApplyPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)erpSupplierApplyQueryWrapper);
            return oaSupplierApplyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return oaSupplierApplyPagination.setData(list, list.size());
    }

    @Override
    public List<OaSupplierApplyEntity> getTypeList(OaSupplierApplyPagination oaSupplierApplyPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int erpSupplierApplyNum = 0;
        QueryWrapper erpSupplierApplyQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)oaSupplierApplyPagination.getSupplierName())) {
            ++erpSupplierApplyNum;
            erpSupplierApplyQueryWrapper.lambda().like(OaSupplierApplyEntity::getSupplierName, (Object)oaSupplierApplyPagination.getSupplierName());
        }
        if (StringUtil.isNotEmpty((String)oaSupplierApplyPagination.getSupplierCode())) {
            ++erpSupplierApplyNum;
            erpSupplierApplyQueryWrapper.lambda().like(OaSupplierApplyEntity::getSupplierCode, (Object)oaSupplierApplyPagination.getSupplierCode());
        }
        if (StringUtil.isNotEmpty((String)oaSupplierApplyPagination.getSocialCode())) {
            ++erpSupplierApplyNum;
            erpSupplierApplyQueryWrapper.lambda().like(OaSupplierApplyEntity::getSocialCode, (Object)oaSupplierApplyPagination.getSocialCode());
        }
        if (AllIdList.size() > 0) {
            erpSupplierApplyQueryWrapper.lambda().in(OaSupplierApplyEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)oaSupplierApplyPagination.getSidx())) {
            erpSupplierApplyQueryWrapper.lambda().orderByDesc(OaSupplierApplyEntity::getId);
        } else {
            try {
                String sidx = oaSupplierApplyPagination.getSidx();
                OaSupplierApplyEntity oaSupplierApplyEntity = new OaSupplierApplyEntity();
                Field declaredField = oaSupplierApplyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                erpSupplierApplyQueryWrapper = "asc".equals(oaSupplierApplyPagination.getSort().toLowerCase()) ? (QueryWrapper)erpSupplierApplyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)erpSupplierApplyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(oaSupplierApplyPagination.getCurrentPage(), oaSupplierApplyPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)erpSupplierApplyQueryWrapper);
                return oaSupplierApplyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return oaSupplierApplyPagination.setData(list, list.size());
        }
        return this.list((Wrapper)erpSupplierApplyQueryWrapper);
    }

    @Override
    public OaSupplierApplyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaSupplierApplyEntity::getId, (Object)id);
        return (OaSupplierApplyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaSupplierApplyEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaSupplierApplyEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        return this.updateById(entity);
    }

    @Override
    public boolean updateForm(String id, OaSupplierApplyUpForm oaSupplierApplyUpForm) {
        this.oaAttachmentService.deleteByContractId(id, "license");
        this.oaAttachmentService.deleteByContractId(id, "honest");
        this.oaAttachmentService.deleteByContractId(id, "other");
        List<OaAttachmentUpForm> licenseList = oaSupplierApplyUpForm.getLicenseList();
        licenseList.stream().forEach(attach -> {
            attach.setContractId(id);
            attach.setFileType("license");
        });
        List licenseEntityList = JsonUtil.getJsonToList(licenseList, OaAttachmentEntity.class);
        this.oaAttachmentService.saveBatch(licenseEntityList);
        List<OaAttachmentUpForm> honestList = oaSupplierApplyUpForm.getHonestList();
        honestList.stream().forEach(attach -> {
            attach.setContractId(id);
            attach.setFileType("honest");
        });
        List honestEntityList = JsonUtil.getJsonToList(honestList, OaAttachmentEntity.class);
        this.oaAttachmentService.saveBatch(honestEntityList);
        List<OaAttachmentUpForm> otherList = oaSupplierApplyUpForm.getOtherList();
        otherList.stream().forEach(attach -> {
            attach.setContractId(id);
            attach.setFileType("other");
        });
        List otherEntityList = JsonUtil.getJsonToList(otherList, OaAttachmentEntity.class);
        this.oaAttachmentService.saveBatch(otherEntityList);
        OaSupplierApplyEntity entity = (OaSupplierApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaSupplierApplyUpForm), OaSupplierApplyEntity.class);
        return this.updateById(entity);
    }

    @Override
    public void delete(OaSupplierApplyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    public DataSourceModel getDataSource() {
        return null;
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel flowModel) {
        OaSupplierApplyEntity entity = this.getInfo(id);
        OaSupplierApplyUpForm oaSupplierApplyUpForm = (OaSupplierApplyUpForm)((Object)JsonUtil.getJsonToBean((Object)flowModel.getFormData(), OaSupplierApplyUpForm.class));
        if (enableMark == 2 && StrUtil.equals((CharSequence)"1", (CharSequence)oaSupplierApplyUpForm.getIsNew())) {
            SupplierEntity supplier = this.CoverSupplier(oaSupplierApplyUpForm);
            supplier.setCompanyId(entity.getCompanyId());
            supplier.setCreatorTime(entity.getCreatorTime());
            supplier.setCreatorUserId(entity.getCreatorUserId());
            supplier.setSupplierUserId(entity.getCreatorUserId());
            supplier.setSupplierState(Integer.valueOf(1));
            supplier.setEnabledMark("complete");
            supplier.setOperatingState(Integer.valueOf(1));
            supplier.setSupplierUseState("1");
            this.supplierService.saveOrUpdate((Object)supplier);
        }
        if (StringUtils.isNotEmpty((String)oaSupplierApplyUpForm.getSupplierResult())) {
            entity.setSupplierResult(oaSupplierApplyUpForm.getSupplierResult());
            return this.update(id, entity);
        }
        return true;
    }

    private SupplierEntity CoverSupplier(OaSupplierApplyUpForm oaSupplierApplyUpForm) {
        SupplierEntity supplier = (SupplierEntity)JsonUtil.getJsonToBean((Object)((Object)oaSupplierApplyUpForm), SupplierEntity.class);
        supplier.setSupplierName(oaSupplierApplyUpForm.getSupplierName());
        supplier.setCode(oaSupplierApplyUpForm.getSupplierCode());
        supplier.setRegisteredCapital(oaSupplierApplyUpForm.getRegisterCapital());
        if (ObjectUtil.isNotEmpty((Object)oaSupplierApplyUpForm.getEstablishDate())) {
            supplier.setDateOincorporation((Date)DateUtil.date((long)oaSupplierApplyUpForm.getEstablishDate()));
        }
        supplier.setHaveNumberOfInsured("Y");
        supplier.setNumberOfInsured(oaSupplierApplyUpForm.getInsureNumber());
        if (ObjectUtil.isNotEmpty((Object)oaSupplierApplyUpForm.getPaidCaptial())) {
            supplier.setHavePaidInCapital("Y");
            supplier.setPaidInCapital(new BigDecimal(oaSupplierApplyUpForm.getPaidCaptial()));
        }
        supplier.setCorporate(oaSupplierApplyUpForm.getLegalPerson());
        supplier.setUnifiedSocialCreditCode(oaSupplierApplyUpForm.getSocialCode());
        supplier.setSupplierTaxpayer(StrUtil.equals((CharSequence)oaSupplierApplyUpForm.getIsTaxpayer(), (CharSequence)"1") ? "S" : "F");
        supplier.setRiskOfDishonesty(StrUtil.equals((CharSequence)oaSupplierApplyUpForm.getIsDishonestyRisk(), (CharSequence)"1") ? "S" : "F");
        supplier.setBusinessScope(oaSupplierApplyUpForm.getBusinessScope());
        supplier.setSupplierAccount(oaSupplierApplyUpForm.getBankAccount());
        supplier.setSupplierBank(oaSupplierApplyUpForm.getBaseBank());
        supplier.setSupplierContacts(oaSupplierApplyUpForm.getLinkMan());
        supplier.setSupplierJob(oaSupplierApplyUpForm.getLinkPosition());
        supplier.setTelephone(oaSupplierApplyUpForm.getLinkTelphone());
        if (CollectionUtil.isNotEmpty(oaSupplierApplyUpForm.getLicenseList())) {
            supplier.setBusinessLicenseUrl(JsonUtil.getObjectToString(oaSupplierApplyUpForm.getLicenseList()));
        } else {
            supplier.setBusinessLicenseUrl("[]");
        }
        if (CollectionUtil.isNotEmpty(oaSupplierApplyUpForm.getHonestList())) {
            supplier.setLetterCommitmentIntegrity(JsonUtil.getObjectToString(oaSupplierApplyUpForm.getHonestList()));
        } else {
            supplier.setLetterCommitmentIntegrity("[]");
        }
        if (CollectionUtil.isNotEmpty(oaSupplierApplyUpForm.getOtherList())) {
            supplier.setOtherUrl(JsonUtil.getObjectToString(oaSupplierApplyUpForm.getOtherList()));
        } else {
            supplier.setOtherUrl("[]");
        }
        supplier.setHaveAgencyQualification(StrUtil.equals((CharSequence)oaSupplierApplyUpForm.getIsAgentAptitude(), (CharSequence)"1") ? "S" : "F");
        if (CollectionUtil.isNotEmpty(oaSupplierApplyUpForm.getAgencyList())) {
            supplier.setAgencyQualificationUrl(JsonUtil.getObjectToString(oaSupplierApplyUpForm.getAgencyList()));
        } else {
            supplier.setAgencyQualificationUrl("[]");
        }
        supplier.setHaveEnvironmentalCertification(StrUtil.equals((CharSequence)oaSupplierApplyUpForm.getIsEnvironmentDiploma(), (CharSequence)"1") ? "S" : "F");
        if (CollectionUtil.isNotEmpty(oaSupplierApplyUpForm.getEnvironmentDiplomaList())) {
            supplier.setEnvironmentalCertification(JsonUtil.getObjectToString(oaSupplierApplyUpForm.getEnvironmentDiplomaList()));
        } else {
            supplier.setEnvironmentalCertification("[]");
        }
        return supplier;
    }
}

