/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.quotation.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.quotation.entity.OaSaleQuotationEntity;
import com.bringspring.quotation.entity.OaSaleQuotationModuleEntity;
import com.bringspring.quotation.entity.OaSaleQuotationProductEntity;
import com.bringspring.quotation.entity.OaSaleQuotationProfitApplyEntity;
import com.bringspring.quotation.entity.SaleQuotationTemplateEntity;
import com.bringspring.quotation.entity.SaleQuotationTemplateModuleEntity;
import com.bringspring.quotation.model.oasalequotation.OaSaleQuotationCrForm;
import com.bringspring.quotation.model.oasalequotation.OaSaleQuotationInfoVO;
import com.bringspring.quotation.model.oasalequotation.OaSaleQuotationListVO;
import com.bringspring.quotation.model.oasalequotation.OaSaleQuotationPagination;
import com.bringspring.quotation.model.oasalequotation.OaSaleQuotationUpForm;
import com.bringspring.quotation.model.oasalequotationmodule.OaSaleQuotationModel;
import com.bringspring.quotation.model.oasalequotationmodule.OaSaleQuotationTemplateModel;
import com.bringspring.quotation.model.salequotation.SaleQuotationCrForm;
import com.bringspring.quotation.service.OaSaleQuotationModuleService;
import com.bringspring.quotation.service.OaSaleQuotationProductService;
import com.bringspring.quotation.service.OaSaleQuotationProfitApplyService;
import com.bringspring.quotation.service.OaSaleQuotationService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.quotation.service.SaleQuotationTemplateService;
import com.bringspring.quotation.utils.QuotationConstants;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\uff08\u5546\u673a\uff09\u62a5\u4ef7"}, value="quotation")
@RequestMapping(value={"/api/quotation/OaSaleQuotation"})
public class OaSaleQuotationController {
    private static final Logger log = LoggerFactory.getLogger(OaSaleQuotationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private OaSaleQuotationService oaSaleQuotationService;
    @Autowired
    private OaSaleQuotationProfitApplyService profitApplyService;
    @Autowired
    private OaSaleQuotationModuleService oaSaleQuotationModuleService;
    @Autowired
    private OaSaleQuotationProductService oaSaleQuotationProductService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private SaleQuotationTemplateService saleQuotationTemplateService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaSaleQuotationPagination oaSaleQuotationPagination) throws IOException {
        List<OaSaleQuotationEntity> listByProductId;
        if (!StrUtil.isBlank((CharSequence)oaSaleQuotationPagination.getProductId()) && ObjectUtil.isNotEmpty(listByProductId = this.oaSaleQuotationService.getListByProductId(oaSaleQuotationPagination.getProductId()))) {
            List<String> stringList = listByProductId.stream().map(OaSaleQuotationEntity::getId).collect(Collectors.toList());
            oaSaleQuotationPagination.setQuotationIds(stringList);
        }
        List<OaSaleQuotationEntity> list = this.oaSaleQuotationService.getList(oaSaleQuotationPagination);
        List listVO = JsonUtil.getJsonToList(list, OaSaleQuotationListVO.class);
        for (OaSaleQuotationListVO oaSaleQuotationVO : listVO) {
            OaSaleQuotationProfitApplyEntity profitApplyServiceInfo;
            oaSaleQuotationVO.setQuotationUser(this.baseDataUtil.userSelectValues(oaSaleQuotationVO.getQuotationUser()));
            if (!StrUtil.isBlank((CharSequence)oaSaleQuotationVO.getOpportunityId())) {
                RkProjectReportingEntity rkProjectReportingEntity = this.rkProjectReportingService.getInfo(oaSaleQuotationVO.getOpportunityId());
                oaSaleQuotationVO.setOpportunityId(ObjectUtil.isNotEmpty((Object)rkProjectReportingEntity) ? rkProjectReportingEntity.getReportingProject() : "");
            }
            if (!StrUtil.isBlank((CharSequence)oaSaleQuotationVO.getCustomerId())) {
                CrmCustomerEntity crmCustomerEntity = this.crmCustomerService.getInfo(oaSaleQuotationVO.getCustomerId());
                oaSaleQuotationVO.setCustomerName(ObjectUtil.isNotEmpty((Object)crmCustomerEntity) ? crmCustomerEntity.getName() : "");
            }
            if (StrUtil.isBlank((CharSequence)oaSaleQuotationVO.getQuotationProfitId()) || StrUtil.isBlank((CharSequence)(profitApplyServiceInfo = this.profitApplyService.getInfo(oaSaleQuotationVO.getQuotationProfitId())).getCustomerId())) continue;
            CrmCustomerEntity crmCustomerEntity = this.crmCustomerService.getInfo(oaSaleQuotationVO.getCustomerId());
            String customerName = ObjectUtil.isNotEmpty((Object)crmCustomerEntity) ? crmCustomerEntity.getName() : "";
            oaSaleQuotationVO.setQuotationProfitName(StrUtil.isBlank((CharSequence)profitApplyServiceInfo.getSerialNumber()) ? customerName + " - " + this.baseDataUtil.userSelectValue(profitApplyServiceInfo.getSaleId()) : profitApplyServiceInfo.getSerialNumber() + " - " + this.baseDataUtil.userSelectValue(profitApplyServiceInfo.getSaleId()));
        }
        for (OaSaleQuotationListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaSaleQuotationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException {
        RkProjectReportingEntity reporting;
        Optional<OaSaleQuotationModuleEntity> discountList;
        List OaSaleQuotationModuleListHardAndSoft;
        List OaSaleQuotationModuleList;
        UserEntity userEntity;
        OaSaleQuotationCrForm oaSaleQuotationCrForm = (OaSaleQuotationCrForm)((Object)JsonUtil.getJsonToBean(crData, OaSaleQuotationCrForm.class));
        String flowEngineId = "606755325634178117";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OaSaleQuotationEntity entity = (OaSaleQuotationEntity)JsonUtil.getJsonToBean((Object)((Object)oaSaleQuotationCrForm), OaSaleQuotationEntity.class);
        entity.setId(mainId);
        entity.setCreatorCompanyId(userInfo.getOrganizeId());
        if (StrUtil.isNotEmpty((CharSequence)entity.getQuotationUser()) && null != (userEntity = this.userService.getInfo(entity.getQuotationUser()))) {
            OrganizeEntity organizeEntity = this.organizeService.getInfo(userEntity.getOrganizeId());
            entity.setQuotationCompanyId(null != organizeEntity ? organizeEntity.getOrganizeId() : "");
        }
        String quotationManager = "";
        try {
            quotationManager = this.baseDataUtil.getBillNumber("quotationManager", Boolean.valueOf(false));
            entity.setSerialNumber(quotationManager);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u5355\u636e\u53f7\u5931\u8d25\uff1a" + e.getMessage());
        }
        List saleQuotationTemplateModelList = JsonUtil.getJsonToList(oaSaleQuotationCrForm.getSaleQuotationTemplateModelList(), OaSaleQuotationProductEntity.class);
        if (ObjectUtil.isNotEmpty((Object)saleQuotationTemplateModelList)) {
            for (Object entitys : saleQuotationTemplateModelList) {
                ((OaSaleQuotationProductEntity)entitys).setId(RandomUtil.uuId());
                ((OaSaleQuotationProductEntity)entitys).setQuotationId(entity.getId());
                ((OaSaleQuotationProductEntity)entitys).setCompanyId(entity.getCompanyId());
                ((OaSaleQuotationProductEntity)entitys).setCreatorCompanyId(entity.getCreatorCompanyId());
                ((OaSaleQuotationProductEntity)entitys).setQuotationCompanyId(entity.getQuotationCompanyId());
                this.oaSaleQuotationProductService.save(entitys);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(OaSaleQuotationModuleList = JsonUtil.getJsonToList(oaSaleQuotationCrForm.getOasalequotationList(), OaSaleQuotationModuleEntity.class)))) {
            for (OaSaleQuotationModuleEntity entitys : OaSaleQuotationModuleList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setQuotationId(entity.getId());
                entitys.setCompanyId(entity.getCompanyId());
                entitys.setCreatorCompanyId(entity.getCreatorCompanyId());
                entitys.setQuotationCompanyId(entity.getQuotationCompanyId());
                this.oaSaleQuotationModuleService.save(entitys);
            }
        }
        entity.setLessDiscount("1");
        if (CollectionUtil.isNotEmpty((Collection)OaSaleQuotationModuleList) && CollectionUtil.isNotEmpty(OaSaleQuotationModuleListHardAndSoft = OaSaleQuotationModuleList.stream().filter(a -> a.getProductType().equals("soft") || a.getProductType().equals("hard")).collect(Collectors.toList())) && ObjectUtil.isNotEmpty(discountList = OaSaleQuotationModuleListHardAndSoft.stream().filter(a -> StrUtil.isNotEmpty((CharSequence)a.getDiscount())).min((p1, p2) -> Float.compare(Float.parseFloat(p1.getDiscount()), Float.parseFloat(p2.getDiscount())))) && discountList.isPresent()) {
            entity.setLessDiscount(discountList.get().getDiscount());
        }
        if (StringUtils.isNotEmpty((String)entity.getOpportunityId()) && null != (reporting = this.rkProjectReportingService.getInfo(entity.getOpportunityId()))) {
            entity.setOpportunityName(reporting.getReportingProject());
        }
        this.oaSaleQuotationService.save(entity);
        BeanUtils.copyProperties((Object)entity, (Object)((Object)oaSaleQuotationCrForm));
        SaleQuotationCrForm quotationCrForm = (SaleQuotationCrForm)JsonUtil.getJsonToBean((Object)((Object)oaSaleQuotationCrForm), SaleQuotationCrForm.class);
        quotationCrForm.setState(String.valueOf(oaSaleQuotationCrForm.getStatus()));
        quotationCrForm.setSerialNumber(quotationManager);
        this.saleQuotationService.create(quotationCrForm, mainId);
        try {
            FlowUtil.saveOrSubmit((String)oaSaleQuotationCrForm.getTaskId(), (String)flowEngineId, (String)oaSaleQuotationCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaSaleQuotationCrForm), (Integer)oaSaleQuotationCrForm.getStatus(), (String)oaSaleQuotationCrForm.getOpportunityName());
        }
        catch (WorkFlowException e) {
            e.printStackTrace();
        }
        if (oaSaleQuotationCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaSaleQuotationInfoVO> info(@PathVariable(value="id") String id) {
        List<OaSaleQuotationEntity> listByOpportunity;
        CrmCustomerEntity customer;
        OaSaleQuotationProfitApplyEntity profitApplyServiceInfo;
        OaSaleQuotationEntity entity = this.oaSaleQuotationService.getInfo(id);
        OaSaleQuotationInfoVO vo = (OaSaleQuotationInfoVO)JsonUtil.getJsonToBean((Object)entity, OaSaleQuotationInfoVO.class);
        if (!StrUtil.isBlank((CharSequence)vo.getQuotationProfitId()) && !StrUtil.isBlank((CharSequence)(profitApplyServiceInfo = this.profitApplyService.getInfo(vo.getQuotationProfitId())).getCustomerId())) {
            CrmCustomerEntity crmCustomerEntity = this.crmCustomerService.getInfo(profitApplyServiceInfo.getCustomerId());
            String customerName = ObjectUtil.isNotEmpty((Object)crmCustomerEntity) ? crmCustomerEntity.getName() : "";
            vo.setQuotationProfitName(StrUtil.isBlank((CharSequence)profitApplyServiceInfo.getSerialNumber()) ? customerName + " - " + this.baseDataUtil.userSelectValue(profitApplyServiceInfo.getSaleId()) : profitApplyServiceInfo.getSerialNumber() + " - " + this.baseDataUtil.userSelectValue(profitApplyServiceInfo.getSaleId()));
        }
        vo.setProductName(this.crmProductService.getNameByIds(vo.getProductId()));
        vo.setProductTypeName(this.crmProductCategoryService.getNameByIds(vo.getProductType()));
        if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(vo.getCustomerId()))) {
            vo.setCustomerName(customer.getName());
        }
        if (ObjectUtil.isNotEmpty(listByOpportunity = this.oaSaleQuotationService.getListByOpportunity(vo.getOpportunityId())) && listByOpportunity.size() > 1) {
            vo.setHistoryQuotationFlag(true);
        }
        List<OaSaleQuotationModuleEntity> moduleEntityList = this.oaSaleQuotationService.GetOaSaleQuotationModuleList(id);
        List modelList = JsonUtil.getJsonToList(moduleEntityList, OaSaleQuotationModel.class);
        List<OaSaleQuotationProductEntity> productQuotationList = this.oaSaleQuotationService.getOaSaleProductQuotationList(id);
        List quotationTemplateModels1 = JsonUtil.getJsonToList(productQuotationList, OaSaleQuotationTemplateModel.class);
        ArrayList<OaSaleQuotationModel> softList = new ArrayList<OaSaleQuotationModel>();
        ArrayList<OaSaleQuotationModel> hardList = new ArrayList<OaSaleQuotationModel>();
        ArrayList<OaSaleQuotationModel> guaranteeList = new ArrayList<OaSaleQuotationModel>();
        ArrayList<OaSaleQuotationModel> customizationList = new ArrayList<OaSaleQuotationModel>();
        ArrayList<OaSaleQuotationModel> thirdList = new ArrayList<OaSaleQuotationModel>();
        ArrayList<OaSaleQuotationModel> otherList = new ArrayList<OaSaleQuotationModel>();
        if (ObjectUtil.isNotEmpty(moduleEntityList)) {
            SaleQuotationTemplateEntity quotationTemplateEntity = null;
            CrmProductCategoryEntity productCategory = null;
            for (OaSaleQuotationModel moduleEntity : modelList) {
                if (StringUtil.isNotEmpty((String)moduleEntity.getQuotationTemplateId()) && null != (quotationTemplateEntity = this.saleQuotationTemplateService.getInfo(moduleEntity.getQuotationTemplateId()))) {
                    moduleEntity.setTemplateName(quotationTemplateEntity.getTemplateName());
                }
                moduleEntity.setUnitName(this.baseDataUtil.getDictName(moduleEntity.getProductUnit(), "quotationModuleUnit"));
                if (StrUtil.isNotEmpty((CharSequence)moduleEntity.getProductCategoryId()) && null != (productCategory = this.crmProductCategoryService.getInfo(moduleEntity.getProductCategoryId()))) {
                    moduleEntity.setProductCategoryName(productCategory.getName());
                }
                if (moduleEntity.getProductType().equals(QuotationConstants.MODULE_SOFT)) {
                    softList.add(moduleEntity);
                }
                if (moduleEntity.getProductType().equals(QuotationConstants.MODULE_HARD)) {
                    hardList.add(moduleEntity);
                }
                if (moduleEntity.getProductType().equals(QuotationConstants.MODULE_GUARANTEE)) {
                    guaranteeList.add(moduleEntity);
                }
                if (moduleEntity.getProductType().equals(QuotationConstants.MODULE_CUSTOMIZATION)) {
                    customizationList.add(moduleEntity);
                }
                if (moduleEntity.getProductType().equals(QuotationConstants.MODULE_THIRD)) {
                    thirdList.add(moduleEntity);
                }
                if (!moduleEntity.getProductType().equals(QuotationConstants.MODULE_OTHER)) continue;
                otherList.add(moduleEntity);
            }
            List<OaSaleQuotationProductEntity> listByQuotationId = this.oaSaleQuotationProductService.getListByQuotationId(entity.getId());
            List quotationTemplateModels = JsonUtil.getJsonToList(listByQuotationId, OaSaleQuotationTemplateModel.class);
            vo.setSaleQuotationTemplateModelList(quotationTemplateModels);
        }
        vo.setQuotationListSoft(softList);
        vo.setQuotationListHard(hardList);
        vo.setQuotationListCustomization(customizationList);
        vo.setQuotationListGuarantee(guaranteeList);
        vo.setThirdList(thirdList);
        vo.setOtherList(otherList);
        vo.setSaleQuotationTemplateModelList(quotationTemplateModels1);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/opportunityId/{opportunityId}"})
    public ActionResult getListByOpportunity(@PathVariable(value="opportunityId") String opportunityId) {
        List<OaSaleQuotationEntity> listByOpportunity = this.oaSaleQuotationService.getListByOpportunity(opportunityId);
        return ActionResult.success(listByOpportunity);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException {
        OaSaleQuotationUpForm oaSaleQuotationUpForm = (OaSaleQuotationUpForm)((Object)JsonUtil.getJsonToBean(upData, OaSaleQuotationUpForm.class));
        String flowEngineId = "606755325634178117";
        OaSaleQuotationEntity entity = this.oaSaleQuotationService.getInfo(id);
        if (entity != null) {
            boolean flag = this.oaSaleQuotationService.updateSubData(entity, oaSaleQuotationUpForm);
            try {
                FlowUtil.saveOrSubmit((String)oaSaleQuotationUpForm.getTaskId(), (String)flowEngineId, (String)oaSaleQuotationUpForm.getTemplateId(), (String)id, (Object)((Object)oaSaleQuotationUpForm), (Integer)oaSaleQuotationUpForm.getStatus(), (String)oaSaleQuotationUpForm.getOpportunityName());
            }
            catch (WorkFlowException e) {
                e.printStackTrace();
            }
            if (oaSaleQuotationUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaSaleQuotationEntity entity = this.oaSaleQuotationService.getInfo(id);
        List<OaSaleQuotationProfitApplyEntity> profitListByQuotationId = this.profitApplyService.getProfitListByQuotationId(id);
        if (!profitListByQuotationId.isEmpty()) {
            return ActionResult.success((String)"prohibitDelete");
        }
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaSaleQuotationService.deleteSubTable(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getQuotationTemplateModule"})
    @DSTransactional
    public ActionResult getQuotationTemplateModule(@RequestBody @Valid Map<String, Object> crData) throws DataException {
        Object quotationTemplate = crData.get("quotationTemplate");
        List saleQuotationTemplateEntities = JsonUtil.getJsonToList((Object)quotationTemplate, SaleQuotationTemplateEntity.class);
        List<String> stringList = saleQuotationTemplateEntities.stream().map(SaleQuotationTemplateEntity::getId).collect(Collectors.toList());
        List<SaleQuotationTemplateModuleEntity> byTemplateId = this.oaSaleQuotationService.getListByTemplateId(stringList);
        return ActionResult.success(byTemplateId);
    }
}

