/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.LoginForm;
import com.bringspring.common.model.login.LoginVO;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.DownUtil;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.ServletUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oauth.model.LoginModel;
import com.bringspring.oauth.model.PcUserVO;
import com.bringspring.oauth.service.LoginService;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.base.model.systemconfig.QyChatModel;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.service.SynThirdQyService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.endpoint.TokenEndpoint;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u767b\u9646\u6570\u636e"}, value="oauth")
@RestController
@RequestMapping(value={"/api/oauth"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private TokenEndpoint tokenEndpoint;
    @Autowired
    private LoginService loginService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SynThirdQyService synThirdQyService;

    @ApiOperation(value="\u767b\u9646")
    @PostMapping(value={"/LoginBak"}, consumes={"application/x-www-form-urlencoded"})
    public ActionResult<LoginVO> LoginBak(Principal principal, @RequestParam Map<String, String> parameters) throws LoginException {
        OAuth2AccessToken oAuth2AccessToken;
        String timestamp;
        UserInfo userInfo = new UserInfo();
        LoginForm loginForm = (LoginForm)JsonUtil.getJsonToBean(parameters, LoginForm.class);
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            userInfo = this.loginService.checkTenant(loginForm);
            DataSourceContextHolder.setDatasource((String)userInfo.getTenantId(), (String)userInfo.getTenantDbConnectionString());
        }
        BaseSystemInfo sysConfigInfo = this.sysConfigService.getSysInfo();
        String origin = parameters.get("origin");
        if (!"code".equals(origin) && Objects.nonNull(sysConfigInfo) && "1".equals(String.valueOf(sysConfigInfo.getEnableVerificationCode())) && (StringUtil.isEmpty((String)(timestamp = String.valueOf(this.redisUtil.getString(loginForm.getTimestamp())))) || !loginForm.getCode().equalsIgnoreCase(timestamp))) {
            return ActionResult.fail((String)MsgCode.LOG104.get());
        }
        UserEntity entity = this.loginService.isExistUser(loginForm.getAccount().trim(), userInfo, sysConfigInfo);
        userInfo = this.loginService.userInfo(userInfo, entity, sysConfigInfo);
        parameters.put("username", JsonUtil.getObjectToString((Object)entity));
        parameters.put("userInfo", JsonUtil.getObjectToString((Object)userInfo));
        parameters.put("systemInfo", JsonUtil.getObjectToString((Object)sysConfigInfo));
        try {
            oAuth2AccessToken = (OAuth2AccessToken)this.tokenEndpoint.postAccessToken(principal, parameters).getBody();
        }
        catch (Exception e) {
            Integer errorsNumber;
            if (!"admin".equals(entity.getId()) && (errorsNumber = sysConfigInfo.getPasswordErrorsNumber()) != null && errorsNumber > 2) {
                Integer errorCount = entity.getLogErrorCount() != null ? entity.getLogErrorCount() + 1 : 1;
                entity.setLogErrorCount(errorCount);
                if (errorCount >= errorsNumber) {
                    entity.setEnabledMark(Integer.valueOf(2));
                    Integer lockType = sysConfigInfo.getLockType();
                    if (Objects.nonNull(lockType) && lockType == 2) {
                        Integer lockTime = sysConfigInfo.getLockTime();
                        Date date = new Date(System.currentTimeMillis() + (long)(lockTime * 60 * 1000));
                        entity.setUnlockTime(date);
                    }
                }
                this.userService.updateById((Object)entity);
            }
            e.printStackTrace();
            throw new LoginException(MsgCode.LOG101.get());
        }
        this.userProvider.add(userInfo);
        entity.setLogErrorCount(Integer.valueOf(0));
        entity.setUnlockTime(null);
        entity.setPrevLogIp(IpUtil.getIpAddr());
        entity.setPrevLogTime(DateUtil.getNowDate());
        entity.setLastLogIp(IpUtil.getIpAddr());
        entity.setLastLogTime(DateUtil.getNowDate());
        entity.setLogSuccessCount(Integer.valueOf(entity.getLogSuccessCount() != null ? entity.getLogSuccessCount() + 1 : 1));
        this.userService.updateById((Object)entity);
        LoginVO loginVO = new LoginVO();
        loginVO.setToken(oAuth2AccessToken.getTokenType() + " " + oAuth2AccessToken.getValue());
        loginVO.setTheme(entity.getTheme() == null ? "classic" : entity.getTheme());
        return ActionResult.success((Object)loginVO);
    }

    @ApiOperation(value="\u767b\u9646")
    @PostMapping(value={"/Login"}, consumes={"application/x-www-form-urlencoded"})
    public ActionResult<LoginVO> Login(Principal principal, @RequestParam Map<String, String> parameters) throws LoginException {
        OAuth2AccessToken oAuth2AccessToken;
        try {
            oAuth2AccessToken = (OAuth2AccessToken)this.tokenEndpoint.postAccessToken(principal, parameters).getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException(MsgCode.LOG101.get());
        }
        LoginVO loginVO = new LoginVO();
        loginVO.setToken(oAuth2AccessToken.getTokenType() + " " + oAuth2AccessToken.getValue());
        return ActionResult.success((Object)loginVO);
    }

    @ApiOperation(value="\u9501\u5c4f\u89e3\u9501\u767b\u5f55")
    @PostMapping(value={"/LockScreen"})
    public ActionResult lockScreen(@RequestBody LoginForm loginForm) throws LoginException {
        UserEntity userEntity = this.userService.getUserEntity(loginForm.getAccount());
        if (!Md5Util.getStringMd5((String)(loginForm.getPassword().toLowerCase() + userEntity.getSecretkey().toLowerCase())).equals(userEntity.getPassword())) {
            throw new LoginException(MsgCode.LOG101.get());
        }
        return ActionResult.success((String)MsgCode.SU017.get());
    }

    @ApiOperation(value="\u9000\u51fa")
    @GetMapping(value={"/Logout"})
    public ActionResult logout() {
        if (ObjectUtil.isNotEmpty((Object)this.userProvider.get())) {
            if (Objects.nonNull(this.sysConfigService.getSysInfo()) && "1".equals(String.valueOf(this.sysConfigService.getSysInfo().getSingleLogin()))) {
                this.userProvider.removeCurrent();
            } else {
                String id = this.userProvider.get().getId();
                this.redisUtil.remove(id);
            }
        }
        return ActionResult.success((String)MsgCode.LOG002.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f")
    @GetMapping(value={"/CurrentUser"})
    public ActionResult<PcUserVO> currentUser(String type) throws LoginException {
        PcUserVO pcUserVO = this.loginService.getCurrentUser(type);
        if (pcUserVO == null) {
            throw new LoginException(MsgCode.LOG001.get());
        }
        return ActionResult.success((Object)pcUserVO);
    }

    @NoDataSourceBind
    @ApiOperation(value="\u56fe\u5f62\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/ImageCode/{codeLength}/{timestamp}"})
    public void imageCode(@PathVariable(value="codeLength") Integer codeLength, @PathVariable(value="timestamp") String timestamp) {
        DownUtil.downCode((Integer)codeLength);
        this.redisUtil.insert(timestamp, ServletUtil.getSession().getAttribute("RANDOMCODEKEY"), 300L);
    }

    @NoDataSourceBind
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/getConfig/{account}"})
    public ActionResult check(@PathVariable(value="account") String account) throws LoginException {
        BaseSystemInfo sysConfigInfo;
        LoginModel loginModel = new LoginModel();
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            LoginForm loginForm = new LoginForm();
            loginForm.setAccount(account);
            UserInfo userInfo = this.loginService.checkTenant(loginForm);
            DataSourceContextHolder.setDatasource((String)userInfo.getTenantId(), (String)userInfo.getTenantDbConnectionString());
        }
        if (Objects.nonNull(sysConfigInfo = this.sysConfigService.getSysInfo()) && "1".equals(String.valueOf(sysConfigInfo.getEnableVerificationCode()))) {
            loginModel.setEnableVerificationCode(1);
            Integer verificationCodeNumber = sysConfigInfo.getVerificationCodeNumber();
            loginModel.setVerificationCodeNumber(verificationCodeNumber == null ? 4 : verificationCodeNumber);
            return ActionResult.success((Object)loginModel);
        }
        loginModel.setEnableVerificationCode(0);
        return ActionResult.success((Object)loginModel);
    }

    @NoDataSourceBind
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/getQyhConfig"})
    public ActionResult getQyhConfig() throws LoginException {
        QyChatModel qyChatInfo = this.sysConfigService.getQyChatInfo();
        return ActionResult.success((Object)qyChatInfo);
    }
}

