/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.method.detail;

import com.bringspring.oauth.config.MyRoleHierarchy;
import com.bringspring.oauth.config.detail.MoreMethodUserDetailService;
import com.bringspring.oauth.method.detail.UserExtend;
import com.bringspring.oauth.service.LoginService;
import com.bringspring.system.permission.entity.UserEntity;
import java.util.ArrayList;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserDetailsServiceImpl
implements MoreMethodUserDetailService {
    @Autowired
    private LoginService loginService;

    public UserExtend loadUserByUsername(String username) throws UsernameNotFoundException {
        UserEntity userEntity = this.loginService.isExistUser(username);
        ArrayList<SimpleGrantedAuthority> list = new ArrayList<SimpleGrantedAuthority>();
        if (Objects.equals(1, userEntity.getIsAdministrator())) {
            list.add(MyRoleHierarchy.adminAuth);
        }
        UserExtend user = new UserExtend(userEntity.getAccount(), userEntity.getSecretkey(), userEntity.getPassword(), list);
        return user;
    }

    @Override
    public UserDetails loadUserByWeComCode(String code) {
        String username = this.loginService.getAccountByWeComCode(code);
        UserEntity userEntity = this.loginService.isExistUser(username);
        ArrayList<SimpleGrantedAuthority> list = new ArrayList<SimpleGrantedAuthority>();
        if (Objects.equals(1, userEntity.getIsAdministrator())) {
            list.add(MyRoleHierarchy.adminAuth);
        }
        User user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }
}

