/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.service.impl;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.model.TenantVO;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.LoginForm;
import com.bringspring.common.model.login.MenuTreeVO;
import com.bringspring.common.model.login.PermissionModel;
import com.bringspring.common.model.login.PermissionVO;
import com.bringspring.common.model.login.UserCommonInfoVO;
import com.bringspring.common.model.login.UserMenuModel;
import com.bringspring.common.model.login.UserPositionVO;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.ServletUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.common.util.wxutil.HttpUtil;
import com.bringspring.oauth.model.PcUserVO;
import com.bringspring.oauth.service.LoginService;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.base.model.module.ModuleModel;
import com.bringspring.system.base.model.systemconfig.SystemInfo;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.Props;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.service.SynThirdQyService;
import com.bringspring.system.message.util.SynQyWebChatUtil;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeVO;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visualdev.portal.model.PortalSelectModel;
import com.bringspring.visualdev.portal.service.PortalService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    protected Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private Props props;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private PortalService portalService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private SynThirdQyService synThirdQyService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private Executor threadPoolExecutor;

    @Override
    public UserInfo checkTenant(LoginForm loginForm) throws LoginException {
        UserInfo userInfo = new UserInfo();
        String tenantId = "";
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            String[] tenantAccount = loginForm.getAccount().split("\\@");
            tenantId = tenantAccount.length == 1 ? loginForm.getAccount() : tenantAccount[0];
            loginForm.setAccount(tenantAccount.length == 1 ? "admin" : tenantAccount[1]);
            if (tenantAccount.length > 2 || tenantId.length() > 11) {
                throw new LoginException(MsgCode.LOG102.get());
            }
            JSONObject object = this.props.getPortUrl().contains("https") ? HttpUtil.httpRequest((String)(this.props.getPortUrl() + tenantId), (String)"GET", null) : HttpUtil.httpRequest((String)(this.props.getPortUrl() + tenantId), (String)"GET", null);
            if (object == null || "500".equals(object.get((Object)"code").toString())) {
                throw new LoginException(MsgCode.LOG105.get());
            }
            if ("400".equals(object.getString("code"))) {
                throw new LoginException(object.getString("msg"));
            }
            Map resulList = JsonUtil.stringToMap((String)object.getString("data"));
            String name = null;
            if (resulList.get("java") != null) {
                name = String.valueOf(resulList.get("java"));
            } else {
                TenantVO vo = (TenantVO)JsonUtil.getJsonToBean((Object)resulList, TenantVO.class);
                List linkList = vo.getLinkList();
                if (linkList != null && linkList.size() > 0) {
                    name = "true";
                    this.redisUtil.insert(tenantId, (Object)JsonUtil.getObjectToString((Object)linkList), -1L);
                } else {
                    name = vo.getDbName();
                }
            }
            userInfo.setTenantId(tenantId);
            userInfo.setTenantDbConnectionString(name);
            DataSourceContextHolder.setDatasource((String)tenantId, (String)name);
        }
        return userInfo;
    }

    @Override
    public UserInfo userInfo(UserInfo userInfo, UserEntity userEntity, BaseSystemInfo sysConfigInfo) throws LoginException {
        userInfo.setIsAdministrator(Boolean.valueOf(BooleanUtil.toBoolean((String)String.valueOf(userEntity.getIsAdministrator()))));
        userInfo.setUserId(userEntity.getId());
        userInfo.setUserAccount(userEntity.getAccount());
        userInfo.setUserName(userEntity.getRealName());
        userInfo.setUserIcon(userEntity.getHeadIcon());
        userInfo.setOrganizeId(userEntity.getOrganizeId());
        userInfo.setPortalId(userEntity.getPortalId());
        userInfo.setIsAdministrator(Boolean.valueOf(BooleanUtil.toBoolean((String)String.valueOf(userEntity.getIsAdministrator()))));
        String time = sysConfigInfo.getTokenTimeout();
        Integer minu = Integer.valueOf(time);
        userInfo.setOverdueTime(DateUtil.dateAddMinutes(null, (int)minu));
        userInfo.setTokenTimeout(minu);
        userInfo.setLoginTime(DateUtil.getmmNow());
        userInfo.setLoginPlatForm(ServletUtil.getUserAgent());
        userInfo.setPrevLoginTime(userEntity.getPrevLogTime());
        userInfo.setPrevLoginIpAddress(userEntity.getPrevLogIp());
        userInfo.setPrevLoginIpAddressName(IpUtil.getIpCity((String)userEntity.getPrevLogIp()));
        String token = RandomUtil.uuId();
        userInfo.setId(this.cacheKeyUtil.getLoginToken(userInfo.getTenantId()) + token);
        return userInfo;
    }

    private UserCommonInfoVO data(UserInfo userInfo) {
        UserEntity info;
        List list = this.organizeService.getList();
        UserEntity userEntity = this.userService.getInfo(userInfo.getUserId());
        userEntity = userEntity != null ? userEntity : new UserEntity();
        userInfo.setManagerId(userInfo.getManagerId());
        boolean b = userInfo.getIsAdministrator();
        this.userInfo(userInfo, userInfo.getUserId(), b, userEntity);
        userInfo.setSubOrganizeIds(this.getSubOrganizeIds(list, userInfo.getOrganizeId(), b));
        List subordinateIdsList = this.userService.getListByManagerId(userInfo.getUserId(), null).stream().map(UserEntity::getId).collect(Collectors.toList());
        userInfo.setSubordinateIds(subordinateIdsList);
        userInfo.setLoginTime(DateUtil.getmmNow());
        userInfo.setLoginPlatForm(ServletUtil.getUserAgent());
        this.redisUtil.insert(userInfo.getId(), (Object)userInfo, DateUtil.getTime((Date)userInfo.getOverdueTime()) - DateUtil.getTime((Date)new Date()));
        BaseSystemInfo baseSystemInfo = this.sysConfigService.getSysInfo();
        UserCommonInfoVO infoVO = (UserCommonInfoVO)JsonUtil.getJsonToBean(this.userInfo(userInfo, baseSystemInfo), UserCommonInfoVO.class);
        infoVO.setRoleIds(userInfo.getRoleIds());
        StringBuilder roleName = new StringBuilder();
        for (RoleEntity entity : this.roleService.getListByIds(userInfo.getRoleIds())) {
            roleName.append("," + entity.getFullName());
        }
        if (roleName.length() > 0) {
            infoVO.setRoleName(roleName.toString().replaceFirst(",", ""));
        }
        if ((info = this.userService.getInfo(userEntity.getManagerId())) != null) {
            infoVO.setManager(info.getRealName() + "/" + info.getAccount());
        }
        infoVO.setMobilePhone(userEntity.getMobilePhone());
        infoVO.setEmail(userEntity.getEmail());
        infoVO.setBirthday(userEntity.getBirthday() != null ? Long.valueOf(userEntity.getBirthday().getTime()) : null);
        infoVO.setUserName(userEntity.getRealName());
        OrganizeEntity organizeEntity = this.organizeService.getInfo(userInfo.getDepartmentId());
        String organizeName = null;
        String departmentId = null;
        String departmentName = null;
        if (organizeEntity != null) {
            organizeName = organizeEntity.getFullName();
            if (StringUtil.isNotEmpty((String)organizeEntity.getOrganizeIdTree())) {
                String[] split = organizeEntity.getOrganizeIdTree().split(",");
                departmentId = split.length > 0 ? split[split.length - 1] : "";
                departmentName = this.organizeService.getFullNameByOrgIdTree(organizeEntity.getOrganizeIdTree(), "/");
            }
        }
        infoVO.setOrganizeName(organizeName);
        infoVO.setDepartmentId(departmentId);
        infoVO.setDepartmentName(departmentName);
        return infoVO;
    }

    public void getOrganizeName(List<OrganizeEntity> OrganizeList, String organizeId) throws Exception {
        List OrganizeList2 = OrganizeList.stream().filter(t -> organizeId.equals(t.getId())).collect(Collectors.toList());
        if (OrganizeList2.size() > 0) {
            for (OrganizeEntity organizeEntity : OrganizeList2) {
                if (!organizeEntity.getParentId().equals("-1")) continue;
                throw new Exception(JSON.toJSONString((Object)organizeEntity));
            }
            for (OrganizeEntity orgSub : OrganizeList2) {
                this.getOrganizeName(OrganizeList, orgSub.getParentId());
            }
        }
    }

    @Override
    public UserEntity isExistUser(String account, UserInfo userInfo, BaseSystemInfo sysConfigInfo) throws LoginException {
        Integer lockMark;
        List<String> ipList;
        UserEntity userEntity = this.userService.getUserEntity(account);
        if (userEntity == null) {
            throw new LoginException(MsgCode.LOG003.get());
        }
        if ((!"admin".equals(userEntity.getId()) || userEntity.getIsAdministrator() != 1) && StringUtil.isEmpty((String)userEntity.getOrganizeId())) {
            throw new LoginException(MsgCode.LOG004.get());
        }
        if (userEntity.getIsAdministrator() == 0) {
            if (userEntity.getEnabledMark() == null) {
                throw new LoginException(MsgCode.LOG005.get());
            }
            if (userEntity.getEnabledMark() == 0) {
                throw new LoginException(MsgCode.LOG006.get());
            }
        }
        if (userEntity.getDeleteMark() != null && userEntity.getDeleteMark() == 1) {
            throw new LoginException(MsgCode.LOG007.get());
        }
        String ipAddr = IpUtil.getIpAddr();
        userInfo.setLoginIpAddress(IpUtil.getIpAddr());
        if (!"admin".equals(userEntity.getId()) && "1".equals(sysConfigInfo.getWhitelistSwitch()) && !(ipList = Arrays.asList(sysConfigInfo.getWhitelistIp().split(","))).contains(ipAddr)) {
            throw new LoginException(MsgCode.LOG010.get());
        }
        if (userEntity.getIsAdministrator() != 1) {
            if (userEntity.getIsAdministrator() == 0) {
                List userAllRole = this.roleService.getListByUserId(userEntity.getId());
                boolean permissionFlag = false;
                for (RoleEntity role : userAllRole) {
                    if (role == null || role.getEnabledMark() == null || role.getEnabledMark() == 0) continue;
                    permissionFlag = true;
                    break;
                }
                if (!permissionFlag) {
                    throw new LoginException(MsgCode.LOG011.get());
                }
            } else {
                throw new LoginException(MsgCode.LOG011.get());
            }
        }
        if (Objects.nonNull(lockMark = userEntity.getEnabledMark()) && lockMark == 2) {
            Date unlockTime = userEntity.getUnlockTime();
            if (Objects.isNull(unlockTime)) {
                throw new LoginException(MsgCode.LOG012.get());
            }
            long millis = System.currentTimeMillis();
            if (unlockTime.getTime() > millis) {
                int time = (int)((unlockTime.getTime() - millis) / 60000L);
                throw new LoginException(MsgCode.LOG013.get().replace("{time}", Integer.toString(time + 1)));
            }
        }
        return userEntity;
    }

    @Override
    public UserEntity isExistUser(String account) throws LoginException {
        Integer lockMark;
        List<String> ipList;
        BaseSystemInfo sysConfigInfo = this.sysConfigService.getSysInfo();
        UserEntity userEntity = this.userService.getUserEntity(account);
        if (userEntity == null) {
            throw new LoginException(MsgCode.LOG003.get());
        }
        if ((!"admin".equals(userEntity.getId()) || userEntity.getIsAdministrator() != 1) && StringUtil.isEmpty((String)userEntity.getOrganizeId())) {
            throw new LoginException(MsgCode.LOG004.get());
        }
        if (userEntity.getIsAdministrator() == 0) {
            if (userEntity.getEnabledMark() == null) {
                throw new LoginException(MsgCode.LOG005.get());
            }
            if (userEntity.getEnabledMark() == 0) {
                throw new LoginException(MsgCode.LOG006.get());
            }
        }
        if (userEntity.getDeleteMark() != null && userEntity.getDeleteMark() == 1) {
            throw new LoginException(MsgCode.LOG007.get());
        }
        String ipAddr = IpUtil.getIpAddr();
        if (!"admin".equals(userEntity.getId()) && "1".equals(sysConfigInfo.getWhitelistSwitch()) && !(ipList = Arrays.asList(sysConfigInfo.getWhitelistIp().split(","))).contains(ipAddr)) {
            throw new LoginException(MsgCode.LOG010.get());
        }
        if (userEntity.getIsAdministrator() != 1) {
            if (userEntity.getIsAdministrator() == 0) {
                List userAllRole = this.roleService.getListByUserId(userEntity.getId());
                boolean permissionFlag = false;
                for (RoleEntity role : userAllRole) {
                    if (role == null || role.getEnabledMark() == null || role.getEnabledMark() == 0) continue;
                    permissionFlag = true;
                    break;
                }
                if (!permissionFlag) {
                    throw new LoginException(MsgCode.LOG011.get());
                }
            } else {
                throw new LoginException(MsgCode.LOG011.get());
            }
        }
        if (Objects.nonNull(lockMark = userEntity.getEnabledMark()) && lockMark == 2) {
            Date unlockTime = userEntity.getUnlockTime();
            if (Objects.isNull(unlockTime)) {
                throw new LoginException(MsgCode.LOG012.get());
            }
            long millis = System.currentTimeMillis();
            if (unlockTime.getTime() > millis) {
                int time = (int)((unlockTime.getTime() - millis) / 60000L);
                throw new LoginException(MsgCode.LOG013.get().replace("{time}", Integer.toString(time + 1)));
            }
        }
        return userEntity;
    }

    @Override
    public UserInfo loginProcess(UserEntity userEntity) throws LoginException {
        UserInfo userInfo = new UserInfo();
        BaseSystemInfo systemInfo = this.sysConfigService.getSysInfo();
        userInfo = this.userInfo(userInfo, userEntity, systemInfo);
        if ("1".equals(String.valueOf(systemInfo.getSingleLogin()))) {
            this.userProvider.removeWebSocket(userInfo);
        }
        this.userProvider.add(userInfo);
        userEntity.setLogErrorCount(Integer.valueOf(0));
        userEntity.setUnlockTime(null);
        userEntity.setPrevLogIp(IpUtil.getIpAddr());
        userEntity.setPrevLogTime(DateUtil.getNowDate());
        userEntity.setLastLogIp(IpUtil.getIpAddr());
        userEntity.setLastLogTime(DateUtil.getNowDate());
        userEntity.setLogSuccessCount(Integer.valueOf(userEntity.getLogSuccessCount() != null ? userEntity.getLogSuccessCount() + 1 : 1));
        this.userService.updateById((Object)userEntity);
        return userInfo;
    }

    @Override
    public PcUserVO getCurrentUser(String type) {
        UserEntity info;
        UserInfo userInfo = this.userProvider.get();
        UserCommonInfoVO infoVO = this.data(userInfo);
        AuthorizeVO authorizeModel = this.authorizeService.getAuthorize(false);
        List moduleList = authorizeModel.getModuleList();
        List menuList = null;
        menuList = StringUtil.isEmpty((String)type) ? moduleList.stream().filter(t -> "Web".equals(t.getCategory())).sorted(Comparator.comparing(ModuleModel::getSortCode)).collect(Collectors.toList()) : moduleList.stream().filter(t -> "App".equals(t.getCategory())).sorted(Comparator.comparing(ModuleModel::getSortCode)).collect(Collectors.toList());
        Boolean flag = false;
        List menu = JsonUtil.getJsonToList(menuList, UserMenuModel.class);
        List menus = TreeDotUtils.convertListToTreeDot((List)menu, (String)"-1");
        List list = JsonUtil.getJsonToList((Object)menus, MenuTreeVO.class);
        List<String> posiList = Arrays.asList(userInfo.getPositionIds());
        List positionList = this.positionService.getPositionName(posiList);
        ArrayList<UserPositionVO> positionVO = new ArrayList<UserPositionVO>();
        for (Object positionEntity : positionList) {
            UserPositionVO userPositionVO = new UserPositionVO();
            userPositionVO.setName(positionEntity.getFullName());
            userPositionVO.setId(positionEntity.getId());
            positionVO.add(userPositionVO);
        }
        ArrayList<PermissionModel> models = new ArrayList<PermissionModel>();
        for (ModuleModel moduleModel : menuList) {
            PermissionModel model = new PermissionModel();
            model.setModelId(moduleModel.getId());
            model.setModuleName(moduleModel.getFullName());
            List buttonModels = authorizeModel.getButtonList().stream().filter(t -> moduleModel.getId().equals(t.getModuleId())).collect(Collectors.toList());
            List columnModels = authorizeModel.getColumnList().stream().filter(t -> moduleModel.getId().equals(t.getModuleId())).collect(Collectors.toList());
            List resourceModels = authorizeModel.getResourceList().stream().filter(t -> moduleModel.getId().equals(t.getModuleId())).collect(Collectors.toList());
            List moduleFormModels = authorizeModel.getFormsList().stream().filter(t -> moduleModel.getId().equals(t.getModuleId())).collect(Collectors.toList());
            model.setButton(JsonUtil.getJsonToList(buttonModels, PermissionVO.class));
            model.setColumn(JsonUtil.getJsonToList(columnModels, PermissionVO.class));
            model.setResource(JsonUtil.getJsonToList(resourceModels, PermissionVO.class));
            model.setForm(JsonUtil.getJsonToList(moduleFormModels, PermissionVO.class));
            if (moduleModel.getType() == 1) continue;
            models.add(model);
        }
        if (this.configValueUtil.getEnablePreAuth().booleanValue()) {
            this.initSecurityAuthorities(authorizeModel, userInfo);
        }
        if (StringUtil.isEmpty((String)(info = this.userService.getInfo(userInfo.getUserId())).getPortalId())) {
            List portalList = this.portalService.getList("1");
            if (portalList.size() > 0) {
                infoVO.setPortalId(((PortalSelectModel)portalList.get(0)).getId());
            }
        } else {
            infoVO.setPortalId(info.getPortalId());
        }
        infoVO.setPositionIds(positionVO);
        BaseSystemInfo sysInfo = this.sysConfigService.getSysInfo();
        SystemInfo jsonToBean = (SystemInfo)JsonUtil.getJsonToBean((Object)sysInfo, SystemInfo.class);
        PcUserVO userVO = new PcUserVO(list, models, infoVO, jsonToBean);
        userVO.setPermissionList(models);
        userVO.getUserInfo().setHeadIcon(UploaderUtil.uploaderImg((String)userInfo.getUserIcon()));
        return userVO;
    }

    @Override
    public String getAccountByWeComCode(String code) throws LoginException {
        BaseSystemInfo config = this.synThirdQyService.getQyhConfig();
        String corpId = config.getQyhCorpId();
        String corpSecret = config.getQyhCorpSecret();
        String access_token = "";
        UserInfo userTenantInfo = new UserInfo();
        UserEntity userEntity = new UserEntity();
        try {
            JSONObject tokenObject = SynQyWebChatUtil.getAccessToken((String)corpId, (String)corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                throw new LoginException("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1access_token\u5931\u8d25\uff01Result:" + tokenObject.toJSONString());
            }
            access_token = tokenObject.getString("access_token");
            JSONObject rstObj = SynQyWebChatUtil.getUserId((String)access_token, (String)code);
            String linkedcorpAgentString = String.valueOf(rstObj.get((Object)"userid"));
            if (StringUtil.isEmpty((String)linkedcorpAgentString)) {
                throw new LoginException("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u5f53\u524d\u767b\u5f55\u8d26\u6237\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01Result:" + rstObj.toJSONString());
            }
            SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoByThirdObjId("1", "2", linkedcorpAgentString);
            if (ObjectUtil.isEmpty((Object)synThirdInfoEntity)) {
                JSONObject weComUser = SynQyWebChatUtil.getLinkedcorpUserInfoById((String)access_token, (String)linkedcorpAgentString);
                Map map = JsonUtil.stringToMap((String)String.valueOf(weComUser.get((Object)"userinfo")));
                if (!StringUtil.isNull(map.get("name"))) {
                    String realName = String.valueOf(map.get("name")).replaceAll("[^\u4e00-\u9fa5]", "");
                    userEntity.setRealName(realName);
                }
                if (!StringUtil.isNull(map.get("english_name"))) {
                    userEntity.setAccount(String.valueOf(map.get("english_name")));
                }
                if (!StringUtil.isNull(map.get("alias"))) {
                    userEntity.setQuickQuery(String.valueOf(map.get("alias")));
                }
                if (!StringUtil.isNull(map.get("lias"))) {
                    userEntity.setNickName(String.valueOf(map.get("lias")));
                }
                if (!StringUtil.isNull(map.get("userid"))) {
                    userEntity.setAccount(String.valueOf(map.get("userid")));
                }
                String department1 = null;
                if (!StringUtil.isNull(map.get("department"))) {
                    JSONArray depts = (JSONArray)map.get("department");
                    String deptId = "";
                    if (depts.size() > 0) {
                        deptId = department1 = String.valueOf(depts.getString(0));
                        String[] deptSplit = department1.split("/");
                        if (deptSplit.length > 1) {
                            deptId = deptSplit[1];
                        }
                    }
                    userEntity.setOrganizeId(deptId);
                }
                if (!StringUtil.isNull(map.get("mobile"))) {
                    userEntity.setMobilePhone(String.valueOf(map.get("mobile")));
                }
                if (!StringUtil.isNull(map.get("email"))) {
                    userEntity.setEmail(String.valueOf(map.get("email")));
                }
                if (!StringUtil.isNull(map.get("address"))) {
                    userEntity.setPostalAddress(String.valueOf(map.get("address")));
                }
                if (!StringUtil.isNull(map.get("gender")) && !"0".equals(String.valueOf(map.get("gender")))) {
                    userEntity.setGender(Integer.valueOf(Integer.parseInt(String.valueOf(map.get("gender")))));
                } else {
                    userEntity.setGender(Integer.valueOf(3));
                }
                if (!StringUtil.isNull(map.get("direct_leader"))) {
                    userEntity.setManagerId(String.valueOf(map.get("direct_leader")).replaceAll("\\[", "").replaceAll("]", ""));
                }
                if (!StringUtil.isNull(map.get("position"))) {
                    userEntity.setPositionId(String.valueOf(map.get("position")));
                }
                userEntity.setHeadIcon("001.png");
                userEntity.setEnabledMark(Integer.valueOf(1));
                List listByEnCode = this.roleService.getListByEnCode("SimpleUser");
                userEntity.setRoleId(((RoleEntity)listByEnCode.get(0)).getId());
                Boolean user = this.userService.createUser(userEntity);
                UserEntity finalUserEntity = userEntity;
                this.threadPoolExecutor.execute(() -> {
                    try {
                        this.synThirdQyService.saveSynThirdInfoEntity("add", null, Integer.valueOf(Integer.parseInt("1")), Integer.valueOf(Integer.parseInt("2")), finalUserEntity.getId(), linkedcorpAgentString, SynThirdConsts.SYN_STATE_OK, "\u4f01\u4e1a\u5fae\u4fe1\u767b\u9646\u65f6\u540c\u6b65\u4f01\u4e1a\u7528\u6237\u4fe1\u606f");
                    }
                    catch (Exception e) {
                        this.log.error("\u6dfb\u52a0\u7528\u6237\u4e4b\u540e\u540c\u6b65\u5931\u8d25\u5230\u4f01\u4e1a\u5fae\u4fe1\u6216\u9489\u9489\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                });
            } else {
                userEntity = this.userService.getInfo(synThirdInfoEntity.getSystemObjectId());
            }
            if (ObjectUtil.isEmpty((Object)userEntity)) {
                throw new LoginException("\u4f01\u4e1a\u5fae\u4fe1\u672a\u5173\u8054\u5230\u7528\u6237\uff01");
            }
            return userEntity.getAccount();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException(e.getMessage());
        }
    }

    private void initSecurityAuthorities(AuthorizeVO authorizeModel, UserInfo userInfo) {
        HashSet<String> authorityList = new HashSet<String>();
        Map<String, ModuleModel> moduleModelMap = authorizeModel.getModuleList().stream().filter(m -> {
            authorityList.add(m.getEnCode());
            return true;
        }).collect(Collectors.toMap(m -> m.getId(), m -> m));
        for (ModuleModel moduleModel : authorizeModel.getModuleList()) {
            String permissionKey = moduleModel.getEnCode();
            authorityList.add(permissionKey);
        }
        authorizeModel.getButtonList().stream().forEach(t -> {
            ModuleModel m = (ModuleModel)moduleModelMap.get(t.getModuleId());
            if (m != null) {
                authorityList.add(m.getEnCode() + "::" + t.getEnCode());
            }
        });
        authorizeModel.getColumnList().stream().forEach(t -> {
            ModuleModel m = (ModuleModel)moduleModelMap.get(t.getModuleId());
            if (m != null) {
                authorityList.add(m.getEnCode() + "::" + t.getEnCode());
            }
        });
        authorizeModel.getFormsList().stream().forEach(t -> {
            ModuleModel m = (ModuleModel)moduleModelMap.get(t.getModuleId());
            if (m != null) {
                authorityList.add(m.getEnCode() + "::" + t.getEnCode());
            }
        });
        String authorityKey = "authorize_:" + this.cacheKeyUtil.getUserAuthorize() + "authority_" + (userInfo.getIsAdministrator() != false ? "admin" : userInfo.getUserAccount());
        this.redisUtil.remove(authorityKey);
        this.redisUtil.insert(authorityKey, authorityList, 172800L);
        if (userInfo.getRoleIds() != null && !userInfo.getRoleIds().isEmpty() || userInfo.getIsAdministrator().booleanValue()) {
            String rolesKey = "authorize_:" + this.cacheKeyUtil.getUserAuthorize() + "role_" + (userInfo.getIsAdministrator() != false ? "admin" : userInfo.getUserAccount());
            List roles = userInfo.getIsAdministrator() != false ? this.roleService.getList() : this.roleService.getListByIds(userInfo.getRoleIds());
            Set roleAuthorityList = roles.stream().filter(r -> r.getEnabledMark().equals(1)).map(r -> "ROLE_" + r.getEnCode()).collect(Collectors.toSet());
            this.redisUtil.remove(rolesKey);
            this.redisUtil.insert(rolesKey, roleAuthorityList, 172800L);
        }
    }

    private String[] getRoleId(String userId, boolean isAdmin) {
        List data = this.userRelationService.getListByUserId(userId);
        if (!isAdmin) {
            data = data.stream().filter(m -> "Role".equals(m.getObjectType())).collect(Collectors.toList());
        }
        List<String> list = data.stream().map(t -> t.getObjectId()).collect(Collectors.toList());
        return list.toArray(new String[list.size()]);
    }

    private String[] getSubOrganizeIds(List<OrganizeEntity> data, String organizeId, boolean isAdmin) {
        if (!isAdmin) {
            data = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere((String)organizeId, data), OrganizeEntity.class);
        }
        List<String> list = data.stream().map(t -> t.getId()).collect(Collectors.toList());
        return list.toArray(new String[list.size()]);
    }

    private String[] getPositionId(String userId, boolean isAdmin) {
        List data = this.userRelationService.getListByUserId(userId);
        List<String> list = data.stream().filter(m -> "Position".equals(m.getObjectType())).map(t -> t.getObjectId()).collect(Collectors.toList());
        return list.toArray(new String[list.size()]);
    }

    private void userInfo(UserInfo userInfo, String userId, boolean isAdmin, UserEntity userEntity) {
        List data = this.userRelationService.getListByUserIdAndObjType(userId, "Organize");
        String organizeId = "";
        String departmentId = "";
        List<Object> roleId = new ArrayList();
        if (!this.organizeRelationService.checkBasePermission(userEntity.getId(), userEntity.getOrganizeId()).booleanValue()) {
            if (data.size() > 0) {
                departmentId = this.organizeRelationService.autoGetMajorOrganizeId(userId, data.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList()), userEntity.getOrganizeId());
            }
        } else {
            departmentId = userEntity.getOrganizeId();
            if (isAdmin) {
                roleId = data.stream().map(t -> t.getObjectId()).collect(Collectors.toList());
            }
        }
        OrganizeEntity companyListById = this.organizeService.getCompanyListById(departmentId);
        organizeId = companyListById.getId();
        List listByObjectId = this.userRelationService.getListByUserId(userInfo.getUserId(), "Role");
        List collect = listByObjectId.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        for (String roleIds : collect) {
            RoleEntity info = this.roleService.getInfo(roleIds);
            if (info != null && "1".equals(String.valueOf(info.getGlobalMark()))) {
                roleId.add(info.getId());
                continue;
            }
            Boolean exist = this.organizeRelationService.existByRoleIdAndOrgId(roleIds, organizeId);
            if (!exist.booleanValue()) continue;
            roleId.add(roleIds);
        }
        List positionList = data.stream().filter(m -> "Position".equals(m.getObjectType())).map(t -> t.getObjectId()).collect(Collectors.toList());
        LinkedHashSet id = new LinkedHashSet();
        String[] position = StringUtil.isNotEmpty((String)userEntity.getPositionId()) ? userEntity.getPositionId().split(",") : new String[]{};
        List positions = positionList.stream().filter(t -> Arrays.asList(position).contains(t)).collect(Collectors.toList());
        id.addAll(positions);
        id.addAll(positionList);
        String[] positionId = id.toArray(new String[id.size()]);
        userInfo.setOrganizeId(organizeId);
        userInfo.setDepartmentId(departmentId);
        userInfo.setRoleIds(roleId);
        userInfo.setPositionIds(positionId);
        String positionId1 = this.organizeRelationService.autoGetMajorPositionId(userId, organizeId, userEntity.getPositionId());
        userEntity.setPositionId(positionId1);
        this.userService.updateById((Object)userEntity);
    }

    private Map<String, Object> userInfo(UserInfo userInfo, BaseSystemInfo systemInfo) {
        HashMap<String, Object> dictionary = new HashMap<String, Object>(16);
        dictionary.put("userId", userInfo.getUserId());
        dictionary.put("userAccount", userInfo.getUserAccount());
        dictionary.put("userName", userInfo.getUserName());
        dictionary.put("icon", userInfo.getUserIcon());
        dictionary.put("portalId", userInfo.getPortalId());
        dictionary.put("gender", userInfo.getUserGender());
        dictionary.put("organizeId", userInfo.getOrganizeId());
        dictionary.put("prevLogin", systemInfo.getLastLoginTimeSwitch() == 1 ? 1 : 0);
        dictionary.put("prevLoginTime", userInfo.getPrevLoginTime());
        dictionary.put("prevLoginIPAddress", userInfo.getPrevLoginIpAddress());
        dictionary.put("prevLoginIPAddressName", userInfo.getPrevLoginIpAddressName());
        dictionary.put("serviceDirectory", this.configValueUtil.getServiceDirectoryPath());
        dictionary.put("webDirectory", this.configValueUtil.getCodeAreasName());
        return dictionary;
    }
}

