/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.util;

import com.bringspring.common.util.StringUtil;
import com.bringspring.oauth.util.MatrixToImageWriter;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class HttpUtils {
    public static HttpResponse doGet(String host, String path, String method, Map<String, String> headers, Map<String, String> querys) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        HttpGet request = new HttpGet(HttpUtils.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, Map<String, String> bodys) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        HttpPost request = new HttpPost(HttpUtils.buildUrl(host, path, querys));
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
        if (bodys != null) {
            ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
            for (String key : bodys.keySet()) {
                nameValuePairList.add(new BasicNameValuePair(key, bodys.get(key)));
            }
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(nameValuePairList, "utf-8");
            urlEncodedFormEntity.setContentType("application/x-www-form-urlencoded; charset=UTF-8");
            request.setEntity((HttpEntity)urlEncodedFormEntity);
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, String body) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        HttpPost request = new HttpPost(HttpUtils.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (StringUtil.isNotEmpty((String)body)) {
            request.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, byte[] body) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        HttpPost request = new HttpPost(HttpUtils.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (body != null) {
            request.setEntity((HttpEntity)new ByteArrayEntity(body));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doPut(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, String body) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        HttpPut request = new HttpPut(HttpUtils.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (StringUtil.isNotEmpty((String)body)) {
            request.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doPut(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, byte[] body) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        HttpPut request = new HttpPut(HttpUtils.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (body != null) {
            request.setEntity((HttpEntity)new ByteArrayEntity(body));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doDelete(String host, String path, String method, Map<String, String> headers, Map<String, String> querys) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        HttpDelete request = new HttpDelete(HttpUtils.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    private static String buildUrl(String host, String path, Map<String, String> querys) throws UnsupportedEncodingException {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(host);
        if (!StringUtil.isNotEmpty((String)path)) {
            sbUrl.append(path);
        }
        if (null != querys) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, String> query : querys.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                if (StringUtil.isNotEmpty((String)query.getKey()) && !StringUtil.isNotEmpty((String)query.getValue())) {
                    sbQuery.append(query.getValue());
                }
                if (StringUtil.isNotEmpty((String)query.getKey())) continue;
                sbQuery.append(query.getKey());
                if (StringUtil.isNotEmpty((String)query.getValue())) continue;
                sbQuery.append("=");
                sbQuery.append(URLEncoder.encode(query.getValue(), "utf-8"));
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append((CharSequence)sbQuery);
            }
        }
        return sbUrl.toString();
    }

    private static HttpClient wrapClient(String host) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        if (host.startsWith("https://")) {
            HttpUtils.sslClient((HttpClient)httpClient);
        }
        return httpClient;
    }

    private static void sslClient(HttpClient httpClient) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = httpClient.getConnectionManager();
            SchemeRegistry registry = ccm.getSchemeRegistry();
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getUrlLength(String urlStr) {
        Integer integer = 0;
        URL url = null;
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            url = new URL(urlStr);
            is = url.openStream();
            isr = new InputStreamReader(is, "utf-8");
            br = new BufferedReader(isr);
            char[] c = new char[10240];
            while (br.read(c) != -1) {
                String ss = new String(c);
                sb.append(ss);
            }
            integer = sb.toString().length();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return integer;
    }

    public static void main(String[] args) throws Exception {
        String text = "https://open.work.weixin.qq.com/wwopen/sso/qrConnect?";
        String accessToken = "y9OIygxwT3t-lBdBWFa9XlJU1l4Hs0ey0SsPo7_b8H6zy179bDACXs0EoQgW8kGF_aqNVTki_WduTUb5xh8dTBLmdu13XHdTnoz9VcqSu_CSLN8fXeGRZnhjKxh0BE3pj0rf1SapcNjgKuIGrMnrQbMHWFhA2TGp8-XTReP-IKwm0IJscDVyLc8imSUZEmpQzWZ3h3YPgmNCR_Qpx9IrhA";
        String appid = "wwc0366cea7d993696";
        String agentid = "agentid";
        String redirect_uri = "myapp.com:3000";
        int width = 400;
        int height = 400;
        String format = "jpg";
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        File outputFile = new File("D:\\\u9080\u8bf7\u4e8c\u7ef4\u7801" + File.separator + "20210013.jpg");
        MatrixToImageWriter.writeToFile(bitMatrix, format, outputFile, "\u626b\u63cf\u6ce8\u518c");
    }
}

