/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.config.jwt;

import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oauth.service.LoginService;
import com.bringspring.system.base.service.LogService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.permission.entity.UserEntity;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenEnhancer
implements TokenEnhancer {
    @Autowired
    private LogService logService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private LoginService loginService;

    public OAuth2AccessToken enhance(OAuth2AccessToken oAuth2AccessToken, OAuth2Authentication oAuth2Authentication) {
        String account = oAuth2Authentication.getPrincipal().toString();
        UserEntity existUser = this.loginService.isExistUser(account);
        BaseSystemInfo systemInfo = this.sysConfigService.getSysInfo();
        UserInfo userInfo = this.loginService.loginProcess(existUser);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("token", userInfo.getId());
        map.put("singleLogin", systemInfo.getSingleLogin());
        this.logService.writeLogAsync(userInfo.getUserId(), userInfo.getUserName() + "/" + userInfo.getUserAccount(), "\u767b\u5f55\u6210\u529f");
        ((DefaultOAuth2AccessToken)oAuth2AccessToken).setAdditionalInformation(map);
        return oAuth2AccessToken;
    }
}

