/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.method.password.granter;

import com.bringspring.oauth.method.password.token.AccountPasswordAuthenticationToken;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class AccountPasswordAbstractTokenGranter
extends AbstractTokenGranter {
    private static final String GRANT_TYPE = "account";
    private final AuthenticationManager authenticationManager;

    public AccountPasswordAbstractTokenGranter(AuthenticationManager authenticationManager, AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, OAuth2RequestFactory requestFactory) {
        super(tokenServices, clientDetailsService, requestFactory, GRANT_TYPE);
        this.authenticationManager = authenticationManager;
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        Map requestParameters = tokenRequest.getRequestParameters();
        String account = (String)requestParameters.get(GRANT_TYPE);
        String password = (String)requestParameters.get("password");
        AccountPasswordAuthenticationToken authenticationToken = new AccountPasswordAuthenticationToken(account, password);
        authenticationToken.setDetails(requestParameters);
        this.authenticationManager.authenticate((Authentication)authenticationToken);
        OAuth2Request oAuth2Request = this.getRequestFactory().createOAuth2Request(client, tokenRequest);
        return new OAuth2Authentication(oAuth2Request, (Authentication)authenticationToken);
    }
}

