package com.bringspring.oauth.config.password;

import com.bringspring.common.util.Md5Util;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

/**
 * 使用MD5加密
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @author RKKJ开发平台组
 * @date 2021/3/16
 */
@Component
public class MyPasswordEncoder implements PasswordEncoder {
    @Override
    public String encode(CharSequence charSequence) {
        return Md5Util.getStringMd5((String)charSequence);
    }
    @Override
    public boolean matches(CharSequence rawEncoder, String encoder) {
        //验证客户端，客户端采用MD5方式加密
        return encoder.equals(Md5Util.getStringMd5((String)rawEncoder));
    }
}
