package com.bringspring.oauth.method.detail;

import com.bringspring.oauth.config.MyRoleHierarchy;
import com.bringspring.oauth.config.detail.MoreMethodUserDetailService;
import com.bringspring.oauth.service.LoginService;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.exception.PermissionException;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

/**
 *  多种登录方式执行实际登录
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @author RKKJ开发平台组
 * @date 2021/3/16
 */
@Service
public class UserDetailsServiceImpl implements MoreMethodUserDetailService {

    @Autowired
    private LoginService loginService;

    @SneakyThrows
    @Override
    public UserExtend loadUserByUsername(String username) throws UsernameNotFoundException{
        if(username.endsWith("@admin")){
            /**
             * 模拟用户账户
             */
            UserEntity userEntity = loginService.isExistUser("admin");

            Collection<SimpleGrantedAuthority> list = new ArrayList();
            UserExtend user = new UserExtend(userEntity.getAccount(),userEntity.getSecretkey(), userEntity.getPassword(), list);
            return user;
        }else{
            /**
             * 验证用户是否可以使用
             */
            UserEntity userEntity = loginService.isExistUser(username);

            Collection<SimpleGrantedAuthority> list = new ArrayList();
            //管理员
            if(Objects.equals(1, userEntity.getIsAdministrator())){
                //鉴权动态获取权限时判断是否管理员 MyRoleHierachy
                list.add(MyRoleHierarchy.adminAuth);
            }
            UserExtend user = new UserExtend(userEntity.getAccount(),userEntity.getSecretkey(), userEntity.getPassword(), list);
            return user;
        }
    }

    /**
     * 第一步、使用授权码找到对应用户
     * 第二步、验证用户是否能登录
     * 第三步、执行登录过程处理
     * @param code
     * @return
     * @throws Exception
     */
    @Override
    public UserDetails loadUserByWeComCode(String code,String cropId) throws Exception {
        /**
         * 根据企业微信授权码code获取用户名
         */
        String username= loginService.getAccountByWeComCode(code, cropId);
        /**
         * 验证用户是否可以使用
         */
        UserEntity userEntity = loginService.isExistUser(username);
        Collection<SimpleGrantedAuthority> list = new ArrayList<>();
        //管理员
        if(Objects.equals(1, userEntity.getIsAdministrator())){
            //鉴权动态获取权限时判断是否管理员 MyRoleHierachy
            list.add(MyRoleHierarchy.adminAuth);
        }
        UserDetails user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }

    /**
     * 第一步、使用授权码找到对应用户
     * 第二步、验证用户是否能登录
     * 第三步、执行登录过程处理
     * @param code
     * @return
     * @throws Exception
     */
    @Override
    public UserDetails loadUserByWeComCode(String code, String cropId, Integer agentId) throws Exception {
        /**
         * 根据企业微信授权码code获取用户名
         */
        String username= loginService.getAccountByWeComCode(code, cropId, agentId);
        /**
         * 验证用户是否可以使用
         */
        UserEntity userEntity = loginService.isExistUser(username);
        Collection<SimpleGrantedAuthority> list = new ArrayList<>();
        //管理员
        if(Objects.equals(1, userEntity.getIsAdministrator())){
            //鉴权动态获取权限时判断是否管理员 MyRoleHierachy
            list.add(MyRoleHierarchy.adminAuth);
        }
        UserDetails user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }

    @Override
    public UserDetails loadUserByDingCode(String code)throws Exception  {
        /**
         * 根据企业微信授权码code获取用户名
         */
        String username= loginService.getAccountByDingCode(code);
        /**
         * 验证用户是否可以使用
         */
        UserEntity userEntity = loginService.isExistUser(username);
        Collection<SimpleGrantedAuthority> list = new ArrayList<>();
        //管理员
        if(Objects.equals(1, userEntity.getIsAdministrator())){
            //鉴权动态获取权限时判断是否管理员 MyRoleHierachy
            list.add(MyRoleHierarchy.adminAuth);
        }
        UserDetails user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }

    @Override
    public UserDetails loadUserByDingCodeH5(String code)throws Exception  {
        /**
         * 根据企业微信授权码code获取用户名
         */
        String username= loginService.getAccountByDingCodeH5(code);
        /**
         * 验证用户是否可以使用
         */
        UserEntity userEntity = loginService.isExistUser(username);
        Collection<SimpleGrantedAuthority> list = new ArrayList<>();
        //管理员
        if(Objects.equals(1, userEntity.getIsAdministrator())){
            //鉴权动态获取权限时判断是否管理员 MyRoleHierachy
            list.add(MyRoleHierarchy.adminAuth);
        }
        UserDetails user = new User(userEntity.getAccount(), userEntity.getPassword(), list);
        return user;
    }
}
